/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\r\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004\u001a4\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u001a4\u0010\u0015\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u00a8\u0006\u0016"}, d2={"getPathsToTransfer", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "removeTransferredRoots", "", "module", "Lcom/intellij/openapi/module/Module;", "removeTransferredRootsFromModulesWithInheritedSdk", "project", "Lcom/intellij/openapi/project/Project;", "removeTransferredRootsFromModulesWithSdk", "setPathsToTransfer", "roots", "transferRoots", "transferRootsToModulesWithInheritedSdk", "transferRootsToModulesWithSdk", "updateRootsForModulesWithInheritedSdk", "action", "Lkotlin/Function2;", "updateRootsForModulesWithSdk", "intellij.python.community.impl"})
public final class PyTransferredSdkRootsKt {
    public static final void transferRootsToModulesWithSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        PyTransferredSdkRootsKt.updateRootsForModulesWithSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)transferRootsToModulesWithSdk.1.INSTANCE));
    }

    public static final void removeTransferredRootsFromModulesWithSdk(@NotNull Project project, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        PyTransferredSdkRootsKt.updateRootsForModulesWithSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)removeTransferredRootsFromModulesWithSdk.1.INSTANCE));
    }

    public static final void transferRootsToModulesWithInheritedSdk(@NotNull Project project, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)transferRootsToModulesWithInheritedSdk.1.INSTANCE));
    }

    public static final void removeTransferredRootsFromModulesWithInheritedSdk(@NotNull Project project, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PyTransferredSdkRootsKt.updateRootsForModulesWithInheritedSdk(project, sdk2, (Function2<? super Module, ? super Sdk, Unit>)((Function2)removeTransferredRootsFromModulesWithInheritedSdk.1.INSTANCE));
    }

    @NotNull
    public static final Set<VirtualFile> getPathsToTransfer(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        PythonSdkAdditionalData pythonSdkAdditionalData = sdkAdditionalData instanceof PythonSdkAdditionalData ? (PythonSdkAdditionalData)sdkAdditionalData : null;
        Set set = pythonSdkAdditionalData != null ? pythonSdkAdditionalData.getPathsToTransfer() : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public static final void setPathsToTransfer(@NotNull Sdk sdk2, @NotNull Set<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(roots, sdk2){
            final /* synthetic */ Set<VirtualFile> $roots;
            final /* synthetic */ Sdk $sdk;
            {
                this.$roots = $roots;
                this.$sdk = $sdk;
                super(0);
            }

            public final void invoke() {
                if (!((Collection)this.$roots).isEmpty() || !((Collection)PyTransferredSdkRootsKt.getPathsToTransfer(this.$sdk)).isEmpty()) {
                    PySdkExtKt.getOrCreateAdditionalData(this.$sdk).setPathsToTransferFromVirtualFiles(this.$roots);
                }
            }
        }), (int)1, null);
    }

    public static final void transferRoots(@NotNull Module module, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (sdk2 != null && Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(module), (Object)sdk2)) {
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(module, sdk2){
                final /* synthetic */ Module $module;
                final /* synthetic */ Sdk $sdk;
                {
                    this.$module = $module;
                    this.$sdk = $sdk;
                    super(0);
                }

                public final void invoke() {
                    PyUtil.addSourceRoots(this.$module, (Collection<VirtualFile>)PyTransferredSdkRootsKt.getPathsToTransfer(this.$sdk));
                }
            }), (int)1, null);
        }
    }

    public static final void removeTransferredRoots(@NotNull Module module, @Nullable Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (sdk2 != null && Intrinsics.areEqual((Object)PySdkExtKt.getPythonSdk(module), (Object)sdk2)) {
            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(module, sdk2){
                final /* synthetic */ Module $module;
                final /* synthetic */ Sdk $sdk;
                {
                    this.$module = $module;
                    this.$sdk = $sdk;
                    super(0);
                }

                public final void invoke() {
                    PyUtil.removeSourceRoots(this.$module, (Collection<VirtualFile>)PyTransferredSdkRootsKt.getPathsToTransfer(this.$sdk));
                }
            }), (int)1, null);
        }
    }

    private static final void updateRootsForModulesWithSdk(Project project, Sdk sdk2, Function2<? super Module, ? super Sdk, Unit> action) {
        if (sdk2 == null) {
            return;
        }
        for (Module module : (Module[])ActionsKt.runReadAction((Function0)((Function0)new Function0<Module[]>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Module[] invoke() {
                return ModuleManager.Companion.getInstance(this.$project).getModules();
            }
        }))) {
            action.invoke((Object)module, (Object)sdk2);
        }
    }

    private static final void updateRootsForModulesWithInheritedSdk(Project project, Sdk sdk2, Function2<? super Module, ? super Sdk, Unit> action) {
        if (sdk2 == null) {
            return;
        }
        for (Module module : (Module[])ActionsKt.runReadAction((Function0)((Function0)new Function0<Module[]>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Module[] invoke() {
                return ModuleManager.Companion.getInstance(this.$project).getModules();
            }
        }))) {
            if (!ModuleRootManager.getInstance((Module)module).isSdkInherited()) continue;
            action.invoke((Object)module, (Object)sdk2);
        }
    }
}

