/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \n2\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/sdk/PythonHeadlessSdkUpdater;", "Lcom/intellij/openapi/startup/StartupActivity;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "scheduleTasks", "waitForTasks", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPythonHeadlessSdkUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonHeadlessSdkUpdater.kt\ncom/jetbrains/python/sdk/PythonHeadlessSdkUpdater\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,50:1\n1855#2,2:51\n1747#2,3:53\n10#3:56\n*S KotlinDebug\n*F\n+ 1 PythonHeadlessSdkUpdater.kt\ncom/jetbrains/python/sdk/PythonHeadlessSdkUpdater\n*L\n32#1:51,2\n43#1:53,3\n17#1:56\n*E\n"})
public final class PythonHeadlessSdkUpdater
implements StartupActivity,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    private static final long DELAY;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        if (!application.isHeadlessEnvironment()) {
            return;
        }
        this.scheduleTasks(project);
        this.waitForTasks(project);
    }

    private final void scheduleTasks(Project project) {
        Set<Sdk> set = PythonSdkUpdater.getPythonSdks(project);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getPythonSdks(project)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sdk sdk2 = (Sdk)element$iv;
            boolean bl = false;
            LOG.info("Scheduling update: " + sdk2.getHomePath());
            PythonSdkUpdater.scheduleUpdate(sdk2, project);
        }
    }

    private final void waitForTasks(Project project) {
        String string = PyBundle.message("sdk.gen.updating.interpreter", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"sdk.gen.updating.interpreter\")");
        String title = string;
        long start = System.currentTimeMillis();
        LOG.info("Waiting for " + title + " tasks...");
        while (true) {
            boolean bl;
            block4: {
                Set<Sdk> set = PythonSdkUpdater.getPythonSdks(project);
                Intrinsics.checkNotNullExpressionValue(set, (String)"getPythonSdks(project)");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Sdk it = (Sdk)element$iv;
                        boolean bl2 = false;
                        if (!PythonSdkUpdater.isUpdateScheduled(it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) break;
            Thread.sleep(DELAY);
        }
        String string2 = StringUtil.formatDuration((long)(System.currentTimeMillis() - start));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatDuration(System.currentTimeMillis() - start)");
        String duration = string2;
        LOG.info("Completed waiting for " + title + " tasks in " + duration);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PythonHeadlessSdkUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        DELAY = TimeUnit.SECONDS.toMillis(10L);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/sdk/PythonHeadlessSdkUpdater$Companion;", "", "()V", "DELAY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

