/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Ntifs;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinioctlUtil;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0003*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"IO_REPARSE_TAG_APPEXECLINK", "", "storeMarker", "", "userAppxFolder", "Ljava/io/File;", "appxProduct", "getAppxProduct", "(Ljava/io/File;)Ljava/lang/String;", "getAppxFiles", "", "expectedProduct", "filePattern", "Lkotlin/text/Regex;", "getAppxTag", "path", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nWinAppxTools.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WinAppxTools.kt\ncom/jetbrains/python/sdk/flavors/WinAppxToolsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,143:1\n6442#2:144\n1603#3,9:145\n1855#3:154\n1856#3:157\n1612#3:158\n1#4:155\n1#4:156\n467#5,7:159\n*S KotlinDebug\n*F\n+ 1 WinAppxTools.kt\ncom/jetbrains/python/sdk/flavors/WinAppxToolsKt\n*L\n44#1:144\n45#1:145,9\n45#1:154\n45#1:157\n45#1:158\n45#1:156\n47#1:159,7\n*E\n"})
public final class WinAppxToolsKt {
    @NotNull
    private static final String storeMarker = "DesktopAppInstaller";
    @Nullable
    private static final File userAppxFolder;
    private static final long IO_REPARSE_TAG_APPEXECLINK = 2147483675L;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<File> getAppxFiles(@NotNull String expectedProduct, @NotNull Regex filePattern) {
        Collection collection;
        File[] fileArray;
        Intrinsics.checkNotNullParameter((Object)expectedProduct, (String)"expectedProduct");
        Intrinsics.checkNotNullParameter((Object)filePattern, (String)"filePattern");
        File file = userAppxFolder;
        if (file != null && (fileArray = file.listFiles((arg_0, arg_1) -> WinAppxToolsKt.getAppxFiles$lambda$0(filePattern, arg_0, arg_1))) != null) {
            void $this$sortedBy$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$sortedBy2 = false;
            List list = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    File it = (File)a;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    Comparable comparable = (Comparable)((Object)FilesKt.getNameWithoutExtension((File)it));
                    it = (File)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)FilesKt.getNameWithoutExtension((File)it))));
                }
            });
            if (list != null) {
                Map $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable $i$f$sortedBy2 = list;
                boolean $i$f$mapNotNull = false;
                Collection collection2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    File file2 = (File)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                    if (WinAppxToolsKt.getAppxProduct(file2) != null) {
                        String product;
                        boolean bl3 = false;
                        pair = new Pair((Object)product, (Object)file2);
                    } else {
                        pair = null;
                    }
                    if (pair == null) continue;
                    Pair it$iv$iv = pair;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Map map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                if (map != null) {
                    void $this$filterKeys$iv;
                    $this$mapNotNullTo$iv$iv = map;
                    boolean $i$f$filterKeys = false;
                    LinkedHashMap result$iv = new LinkedHashMap();
                    for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                        String it = (String)entry$iv.getKey();
                        boolean bl = false;
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)expectedProduct, (boolean)false, (int)2, null)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    collection2 = ((Map)result$iv).values();
                    if (collection2 != null) {
                        collection = collection2;
                        return collection;
                    }
                }
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    @Nullable
    public static final String getAppxProduct(@NotNull File $this$appxProduct) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$appxProduct, (String)"<this>");
        File file = $this$appxProduct.getParentFile();
        if (!(file != null ? file.equals(userAppxFolder) : false)) {
            return null;
        }
        String string2 = $this$appxProduct.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"absolutePath");
        String string3 = WinAppxToolsKt.getAppxTag(string2);
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string = !StringsKt.contains$default((CharSequence)it, (CharSequence)storeMarker, (boolean)false, (int)2, null) ? it : null;
        } else {
            string = null;
        }
        return string;
    }

    private static final String getAppxTag(String path2) {
        if (!SystemInfo.isWin10OrNewer) {
            return null;
        }
        Kernel32 kernel = Kernel32.INSTANCE;
        Logger logger = Logger.getInstance(Kernel32.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(Kernel32::class.java)");
        Logger logger2 = logger;
        WinNT.HANDLE file = kernel.CreateFile(path2, Integer.MIN_VALUE, 1, null, 3, 0x200000, null);
        if (Intrinsics.areEqual((Object)file, (Object)Kernel32.INVALID_HANDLE_VALUE)) {
            logger2.warn("Invalid handle for " + path2);
            return null;
        }
        Ntifs.REPARSE_DATA_BUFFER buffer = new Ntifs.REPARSE_DATA_BUFFER();
        IntByReference bytesRead = new IntByReference();
        if (!kernel.DeviceIoControl(file, WinioctlUtil.FSCTL_GET_REPARSE_POINT, null, 0, buffer.getPointer(), buffer.size(), bytesRead, null)) {
            logger2.warn("DeviceIoControl error " + kernel.GetLastError());
            return null;
        }
        if (bytesRead.getValue() < 1) {
            logger2.warn("0 bytes read");
            return null;
        }
        buffer.read();
        if (buffer.ReparseTag != -2147483621) {
            logger2.warn("Wrong tag " + buffer.ReparseTag);
            return null;
        }
        CharBuffer charBuffer = Charsets.UTF_16LE.decode(ByteBuffer.wrap(buffer.u.genericReparseBuffer.DataBuffer));
        int from = 0;
        int to = 0;
        boolean startFound = false;
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"charBuffer");
        CharBuffer charBuffer2 = charBuffer;
        for (int i = 0; i < charBuffer2.length(); ++i) {
            boolean validChar;
            int i2 = i;
            char c = charBuffer2.charAt(i);
            boolean bl = validChar = Character.getType(c) != 15;
            if (validChar && !startFound) {
                from = i2;
                startFound = true;
            }
            if (validChar || !startFound) continue;
            to = i2;
            break;
        }
        return ((Object)((CharSequence)charBuffer).subSequence(from, to)).toString();
    }

    private static final boolean getAppxFiles$lambda$0(Regex $filePattern, File file, String name2) {
        Intrinsics.checkNotNullParameter((Object)$filePattern, (String)"$filePattern");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
        return $filePattern.matches((CharSequence)name2);
    }

    static {
        File file;
        if (!SystemInfo.isWin10OrNewer) {
            file = null;
        } else {
            String string = System.getenv("LOCALAPPDATA");
            if (string != null) {
                String localappdata = string;
                boolean bl = false;
                File appsPath = new File(localappdata, "Microsoft//WindowsApps");
                file = appsPath.exists() ? appsPath : null;
            } else {
                file = null;
            }
        }
        userAppxFolder = file;
    }
}

