/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.testing.PyPsiLocationWithFixedClass;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u0018*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0018B#\b\u0005\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u0004\u0018\u00010\b2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J>\u0010\f\u001a\u001c\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b\u0018\u00010\u0011j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0016\u001a\u00020\u0017R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/testing/AbstractPythonTestRunConfiguration;", "T", "Lcom/jetbrains/python/run/AbstractPythonRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "requiredPackage", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "checkConfiguration", "", "getTestSpec", "location", "Lcom/intellij/execution/Location;", "failedTest", "Lcom/intellij/execution/testframework/AbstractTestProxy;", "Ljava/util/function/Function;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/value/TargetEnvironmentFunction;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "isFrameworkInstalled", "", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nAbstractPythonTestRunConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPythonTestRunConfiguration.kt\ncom/jetbrains/python/testing/AbstractPythonTestRunConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n1549#2:109\n1620#2,3:110\n288#2,2:114\n10#3:113\n*S KotlinDebug\n*F\n+ 1 AbstractPythonTestRunConfiguration.kt\ncom/jetbrains/python/testing/AbstractPythonTestRunConfiguration\n*L\n72#1:109\n72#1:110,3\n97#1:114,2\n93#1:113\n*E\n"})
public abstract class AbstractPythonTestRunConfiguration<T extends AbstractPythonTestRunConfiguration<T>>
extends AbstractPythonRunConfiguration<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String requiredPackage;
    @NotNull
    protected static final String TEST_NAME_PARTS_SPLITTER = "::";

    @JvmOverloads
    protected AbstractPythonTestRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @Nullable String requiredPackage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(project, factory);
        this.requiredPackage = requiredPackage;
    }

    public /* synthetic */ AbstractPythonTestRunConfiguration(Project project, ConfigurationFactory configurationFactory, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(project, configurationFactory, string);
    }

    @Nullable
    public String getTestSpec(@NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        Intrinsics.checkNotNullParameter(location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)failedTest, (String)"failedTest");
        PsiElement element = location.getPsiElement();
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (location instanceof PyPsiLocationWithFixedClass) {
            pyClass = ((PyPsiLocationWithFixedClass)location).getFixedClass();
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        VirtualFile virtualFile = location.getVirtualFile();
        if (virtualFile != null) {
            Object path2 = virtualFile.getCanonicalPath();
            if (pyClass != null) {
                path2 = (String)path2 + TEST_NAME_PARTS_SPLITTER + pyClass.getName();
            }
            if (pyFunction != null) {
                path2 = (String)path2 + TEST_NAME_PARTS_SPLITTER + pyFunction.getName();
            }
            return path2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Function<TargetEnvironment, String> getTestSpec(@NotNull TargetEnvironmentRequest request, @NotNull Location<?> location, @NotNull AbstractTestProxy failedTest) {
        Function function;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)failedTest, (String)"failedTest");
        PsiElement element = location.getPsiElement();
        Object pyClass = null;
        pyClass = PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (location instanceof PyPsiLocationWithFixedClass) {
            pyClass = ((PyPsiLocationWithFixedClass)location).getFixedClass();
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        VirtualFile virtualFile = location.getVirtualFile();
        Object object = virtualFile;
        if (object != null && (object = object.getCanonicalPath()) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object localPath = object;
            boolean bl = false;
            Path path2 = Path.of((String)localPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(localPath)");
            Function targetPath = TargetEnvironmentFunctions.targetPath((Path)path2);
            Object object2 = new String[2];
            PyClass pyClass2 = (PyClass)pyClass;
            object2[0] = pyClass2 != null ? pyClass2.getName() : null;
            PyFunction pyFunction2 = pyFunction;
            object2[1] = pyFunction2 != null ? pyFunction2.getName() : null;
            object2 = CollectionsKt.listOfNotNull((Object[])object2);
            Collection collection = CollectionsKt.listOf((Object)targetPath);
            boolean $i$f$map = false;
            void var14_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(TargetEnvironmentFunctions.constant((Object)p0));
            }
            function = TargetEnvironmentFunctions.joinToStringFunction$default((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv)), (CharSequence)TEST_NAME_PARTS_SPLITTER, null, (int)2, null);
        } else {
            function = null;
        }
        return function;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (this.requiredPackage != null && !this.isFrameworkInstalled()) {
            Object[] objectArray = new Object[]{this.requiredPackage};
            throw new RuntimeConfigurationWarning(PyBundle.message("runcfg.testing.no.test.framework", objectArray));
        }
    }

    public final boolean isFrameworkInstalled() {
        PyPackage pyPackage;
        Sdk sdk2 = this.getSdk();
        if (sdk2 == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(AbstractPythonRunConfiguration.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.warn("Failed to detect test framework: SDK is null");
            return false;
        }
        String string = this.requiredPackage;
        if (string == null) {
            return true;
        }
        String requiredPackage = string;
        List<PyPackage> list = PyPackageManager.getInstance(sdk2).getPackages();
        if (list != null) {
            Object v3;
            block5: {
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PyPackage it = (PyPackage)((Object)element$iv);
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)requiredPackage)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            pyPackage = v3;
        } else {
            pyPackage = null;
        }
        return pyPackage != null;
    }

    @JvmOverloads
    protected AbstractPythonTestRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this(project, factory, null, 4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/python/testing/AbstractPythonTestRunConfiguration$Companion;", "", "()V", "TEST_NAME_PARTS_SPLITTER", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

