/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest.run.docutils;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rest.RestFileType;
import com.jetbrains.rest.run.RestRunConfiguration;
import com.jetbrains.rest.run.RestRunConfigurationType;
import com.jetbrains.rest.run.docutils.DocutilsRunConfiguration;
import org.jetbrains.annotations.NotNull;

public class DocutilsConfigurationProducer
extends LazyRunConfigurationProducer<RestRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = RestRunConfigurationType.getInstance().DOCUTILS_FACTORY;
        if (configurationFactory == null) {
            DocutilsConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull RestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile parent;
        if (configuration == null) {
            DocutilsConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            DocutilsConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            DocutilsConfigurationProducer.$$$reportNull$$$0(3);
        }
        assert (configuration instanceof DocutilsRunConfiguration);
        PsiFile script = ((PsiElement)sourceElement.get()).getContainingFile();
        if (script == null || script.getFileType() != RestFileType.INSTANCE) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)script);
        VirtualFile vFile = script.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        configuration.setInputFile(vFile.getPath());
        configuration.setName(script.getName());
        Object outputPath = vFile.getPath();
        int index = ((String)outputPath).lastIndexOf(46);
        if (index > 0) {
            outputPath = ((String)outputPath).substring(0, index);
        }
        outputPath = (String)outputPath + ".html";
        VirtualFile outputFile = LocalFileSystem.getInstance().findFileByPath((String)outputPath);
        if (outputFile == null) {
            configuration.setOutputFile((String)outputPath);
            configuration.setOpenInBrowser(true);
        }
        if (configuration.getTask().isEmpty()) {
            configuration.setTask("rst2html");
        }
        if ((parent = vFile.getParent()) != null) {
            configuration.setWorkingDirectory(parent.getPath());
        }
        configuration.setName(configuration.suggestedName());
        if (module != null) {
            configuration.setUseModuleSdk(true);
            configuration.setModule(module);
        }
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull RestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement element;
        if (configuration == null) {
            DocutilsConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            DocutilsConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((element = context.getPsiLocation()) == null) {
            return false;
        }
        PsiFile script = element.getContainingFile();
        if (script == null) {
            return false;
        }
        VirtualFile vFile = script.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        String path2 = vFile.getPath();
        String scriptName = configuration.getInputFile();
        return FileUtil.toSystemIndependentName((String)scriptName).equals(FileUtil.toSystemIndependentName((String)path2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rest/run/docutils/DocutilsConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rest/run/docutils/DocutilsConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

