/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.jql;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.jira.jql.JqlElementTypes;
import com.intellij.tasks.jira.jql.JqlTokenTypes;
import org.jetbrains.annotations.NotNull;

public class JqlParser
implements PsiParser {
    private static final Logger LOG = Logger.getInstance(JqlParser.class);

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        if (!builder.eof()) {
            this.parseQuery(builder);
            while (!builder.eof()) {
                builder.error(TaskBundle.message((String)"parsing.error.illegal.query.part", (Object[])new Object[0]));
                builder.advanceLexer();
            }
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            JqlParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private boolean parseQuery(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        this.parseORClause(builder);
        if (builder.getTokenType() == JqlTokenTypes.ORDER_KEYWORD) {
            this.parseOrderBy(builder);
        }
        marker.done(JqlElementTypes.QUERY);
        return true;
    }

    private boolean parseORClause(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseANDClause(builder)) {
            marker.drop();
            return false;
        }
        while (this.advanceIfMatches(builder, JqlTokenTypes.OR_OPERATORS)) {
            if (!this.parseANDClause(builder)) {
                builder.error(TaskBundle.message((String)"parsing.error.expecting.clause", (Object[])new Object[0]));
            }
            marker.done(JqlElementTypes.OR_CLAUSE);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean parseANDClause(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseNOTClause(builder)) {
            marker.drop();
            return false;
        }
        while (this.advanceIfMatches(builder, JqlTokenTypes.AND_OPERATORS)) {
            if (!this.parseNOTClause(builder)) {
                builder.error(TaskBundle.message((String)"parsing.error.expecting.clause", (Object[])new Object[0]));
            }
            marker.done(JqlElementTypes.AND_CLAUSE);
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean parseNOTClause(PsiBuilder builder) {
        if (JqlTokenTypes.NOT_OPERATORS.contains(builder.getTokenType())) {
            PsiBuilder.Marker marker = builder.mark();
            builder.advanceLexer();
            if (!this.parseNOTClause(builder)) {
                builder.error(TaskBundle.message((String)"parsing.error.expecting.clause", (Object[])new Object[0]));
            }
            marker.done(JqlElementTypes.NOT_CLAUSE);
            return true;
        }
        if (builder.getTokenType() == JqlTokenTypes.LPAR) {
            return this.parseSubClause(builder);
        }
        return this.parseTerminalClause(builder);
    }

    private boolean parseSubClause(PsiBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == JqlTokenTypes.LPAR);
        PsiBuilder.Marker marker = builder.mark();
        if (!this.advanceIfMatches(builder, JqlTokenTypes.LPAR)) {
            marker.drop();
            return false;
        }
        this.parseORClause(builder);
        if (!this.advanceIfMatches(builder, JqlTokenTypes.RPAR)) {
            builder.error(TaskBundle.message((String)"parsing.error.expecting", (Object[])new Object[0]));
        }
        marker.done(JqlElementTypes.SUB_CLAUSE);
        return true;
    }

    private boolean parseTerminalClause(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseFieldName(builder)) {
            marker.drop();
            return false;
        }
        if (this.advanceIfMatches(builder, JqlTokenTypes.IS_KEYWORD)) {
            this.advanceIfMatches(builder, JqlTokenTypes.NOT_KEYWORD);
            this.parseOperand(builder);
        } else if (this.advanceIfMatches(builder, JqlTokenTypes.SIMPLE_OPERATORS) || this.advanceIfMatches(builder, JqlTokenTypes.IN_KEYWORD)) {
            this.parseOperand(builder);
        } else if (this.advanceIfMatches(builder, JqlTokenTypes.NOT_KEYWORD)) {
            if (!this.advanceIfMatches(builder, JqlTokenTypes.IN_KEYWORD)) {
                builder.error(TaskBundle.message((String)"parsing.error.expecting.in", (Object[])new Object[0]));
            }
            this.parseOperand(builder);
        } else {
            if (builder.getTokenType() == JqlTokenTypes.WAS_KEYWORD) {
                this.parseWASClause(builder);
                marker.done(JqlElementTypes.WAS_CLAUSE);
                return true;
            }
            if (builder.getTokenType() == JqlTokenTypes.CHANGED_KEYWORD) {
                this.parseCHANGEDClause(builder);
                marker.done(JqlElementTypes.CHANGED_CLAUSE);
                return true;
            }
            builder.error(TaskBundle.message((String)"parsing.error.expecting.operator", (Object[])new Object[0]));
        }
        marker.done(JqlElementTypes.SIMPLE_CLAUSE);
        return true;
    }

    private void parseCHANGEDClause(PsiBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == JqlTokenTypes.CHANGED_KEYWORD);
        if (!this.advanceIfMatches(builder, JqlTokenTypes.CHANGED_KEYWORD)) {
            return;
        }
        while (JqlTokenTypes.HISTORY_PREDICATES.contains(builder.getTokenType())) {
            this.parseHistoryPredicate(builder);
        }
    }

    private void parseWASClause(PsiBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == JqlTokenTypes.WAS_KEYWORD);
        if (!this.advanceIfMatches(builder, JqlTokenTypes.WAS_KEYWORD)) {
            return;
        }
        this.advanceIfMatches(builder, JqlTokenTypes.NOT_KEYWORD);
        this.advanceIfMatches(builder, JqlTokenTypes.IN_KEYWORD);
        this.parseOperand(builder);
        while (JqlTokenTypes.HISTORY_PREDICATES.contains(builder.getTokenType())) {
            this.parseHistoryPredicate(builder);
        }
    }

    private void parseHistoryPredicate(PsiBuilder builder) {
        LOG.assertTrue(JqlTokenTypes.HISTORY_PREDICATES.contains(builder.getTokenType()));
        PsiBuilder.Marker marker = builder.mark();
        if (!this.advanceIfMatches(builder, JqlTokenTypes.HISTORY_PREDICATES)) {
            marker.drop();
            return;
        }
        this.parseOperand(builder);
        marker.done(JqlElementTypes.HISTORY_PREDICATE);
    }

    private boolean parseOperand(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        boolean parsed = true;
        if (builder.getTokenType() == JqlTokenTypes.LPAR) {
            marker.drop();
            parsed = this.parseList(builder);
        } else if (this.advanceIfMatches(builder, JqlTokenTypes.EMPTY_VALUES)) {
            marker.done(JqlElementTypes.EMPTY);
        } else if (this.advanceIfMatches(builder, JqlTokenTypes.LITERALS)) {
            if (builder.getTokenType() == JqlTokenTypes.LPAR) {
                marker.done(JqlElementTypes.IDENTIFIER);
                marker = marker.precede();
                this.parseArgumentList(builder);
                marker.done(JqlElementTypes.FUNCTION_CALL);
            } else {
                marker.done(JqlElementTypes.LITERAL);
            }
        } else {
            marker.drop();
            parsed = false;
        }
        if (!parsed) {
            builder.error(TaskBundle.message((String)"parsing.error.expecting.either.literal.list.or.function.call", (Object[])new Object[0]));
        }
        return parsed;
    }

    private boolean parseList(PsiBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == JqlTokenTypes.LPAR);
        PsiBuilder.Marker marker = builder.mark();
        if (!this.advanceIfMatches(builder, JqlTokenTypes.LPAR)) {
            marker.drop();
            return false;
        }
        if (this.parseOperand(builder)) {
            while (this.advanceIfMatches(builder, JqlTokenTypes.COMMA) && this.parseOperand(builder)) {
            }
        }
        if (!this.advanceIfMatches(builder, JqlTokenTypes.RPAR)) {
            builder.error(TaskBundle.message((String)"parsing.error.expecting", (Object[])new Object[0]));
        }
        marker.done(JqlElementTypes.LIST);
        return true;
    }

    private boolean parseFieldName(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.advanceIfMatches(builder, JqlTokenTypes.VALID_FIELD_NAMES)) {
            builder.error(TaskBundle.message((String)"parsing.error.expecting.field.name", (Object[])new Object[0]));
            marker.drop();
            return false;
        }
        marker.done(JqlElementTypes.IDENTIFIER);
        return true;
    }

    private void parseArgumentList(PsiBuilder builder) {
        LOG.assertTrue(builder.getTokenType() == JqlTokenTypes.LPAR);
        PsiBuilder.Marker marker = builder.mark();
        if (!this.advanceIfMatches(builder, JqlTokenTypes.LPAR)) {
            marker.drop();
            return;
        }
        if (this.advanceIfMatches(builder, JqlTokenTypes.RPAR)) {
            marker.done(JqlElementTypes.ARGUMENT_LIST);
            return;
        }
        PsiBuilder.Marker argument = builder.mark();
        if (!this.advanceIfMatches(builder, JqlTokenTypes.VALID_ARGUMENTS)) {
            builder.error(TaskBundle.message((String)"parsing.error.expecting.argument", (Object[])new Object[0]));
            argument.drop();
        } else {
            argument.done(JqlElementTypes.LITERAL);
            while (this.advanceIfMatches(builder, JqlTokenTypes.COMMA)) {
                argument = builder.mark();
                if (!this.advanceIfMatches(builder, JqlTokenTypes.VALID_ARGUMENTS)) {
                    marker.drop();
                    builder.error(TaskBundle.message((String)"parsing.error.expecting.argument", (Object[])new Object[0]));
                    break;
                }
                argument.done(JqlElementTypes.LITERAL);
            }
        }
        if (!this.advanceIfMatches(builder, JqlTokenTypes.RPAR)) {
            builder.error(TaskBundle.message((String)"parsing.error.expecting", (Object[])new Object[0]));
        }
        marker.done(JqlElementTypes.ARGUMENT_LIST);
    }

    private void parseOrderBy(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.advanceIfMatches(builder, JqlTokenTypes.ORDER_KEYWORD)) {
            marker.drop();
            return;
        }
        if (!this.advanceIfMatches(builder, JqlTokenTypes.BY_KEYWORD)) {
            builder.error(TaskBundle.message((String)"parsing.error.expecting.by", (Object[])new Object[0]));
            marker.done(JqlElementTypes.ORDER_BY);
            return;
        }
        if (this.parseSortKey(builder)) {
            while (this.advanceIfMatches(builder, JqlTokenTypes.COMMA) && this.parseSortKey(builder)) {
            }
        }
        marker.done(JqlElementTypes.ORDER_BY);
    }

    private boolean parseSortKey(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        if (!this.parseFieldName(builder)) {
            marker.drop();
            return false;
        }
        this.advanceIfMatches(builder, JqlTokenTypes.SORT_ORDERS);
        marker.done(JqlElementTypes.SORT_KEY);
        return true;
    }

    private boolean advanceIfMatches(PsiBuilder builder, IElementType type) {
        if (builder.getTokenType() == type) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    private boolean advanceIfMatches(PsiBuilder builder, TokenSet set) {
        if (set.contains(builder.getTokenType())) {
            builder.advanceLexer();
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/jql/JqlParser", "parse"));
    }
}

