/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.utils.io;

import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.NioPathUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\b\u001a&\u0010\u0005\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\b\u001a\n\u0010\n\u001a\u00020\u0006*\u00020\u0001\u001a\u0012\u0010\n\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f*\u00020\u0001H\u0007\u00a8\u0006\r"}, d2={"createDirectory", "Ljava/nio/file/Path;", "relativePath", "", "createFile", "deleteChildrenRecursively", "", "predicate", "Lkotlin/Function1;", "", "deleteRecursively", "getChildren", "", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nNioPathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NioPathUtil.kt\ncom/intellij/testFramework/utils/io/NioPathUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1855#2,2:63\n*S KotlinDebug\n*F\n+ 1 NioPathUtil.kt\ncom/intellij/testFramework/utils/io/NioPathUtilKt\n*L\n51#1:63,2\n*E\n"})
public final class NioPathUtilKt {
    @Deprecated(message="Use stdlib function", replaceWith=@ReplaceWith(expression="listDirectoryEntries()", imports={"kotlin.io.path.listDirectoryEntries"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final List<Path> getChildren(@NotNull Path $this$getChildren) {
        Intrinsics.checkNotNullParameter((Object)$this$getChildren, (String)"<this>");
        return PathsKt.listDirectoryEntries$default((Path)$this$getChildren, null, (int)1, null);
    }

    @NotNull
    public static final Path createFile(@NotNull Path $this$createFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($this$createFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("File already exists: " + $this$createFile);
        }
        return NioPathUtil.findOrCreateFile((Path)$this$createFile);
    }

    @NotNull
    public static final Path createDirectory(@NotNull Path $this$createDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"<this>");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($this$createDirectory, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new IOException("Directory already exists: " + $this$createDirectory);
        }
        return NioPathUtil.findOrCreateDirectory((Path)$this$createDirectory);
    }

    @NotNull
    public static final Path createFile(@NotNull Path $this$createFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return NioPathUtilKt.createFile(NioPathUtil.getResolvedPath((Path)$this$createFile, (String)relativePath));
    }

    @NotNull
    public static final Path createDirectory(@NotNull Path $this$createDirectory, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return NioPathUtilKt.createDirectory(NioPathUtil.getResolvedPath((Path)$this$createDirectory, (String)relativePath));
    }

    public static final void deleteRecursively(@NotNull Path $this$deleteRecursively) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        NioFiles.deleteRecursively((Path)$this$deleteRecursively);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteChildrenRecursively(@NotNull Path $this$deleteChildrenRecursively, @NotNull Function1<? super Path, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteChildrenRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        DirectoryStream.Filter<Path> filter = arg_0 -> NioPathUtilKt.deleteChildrenRecursively$lambda$0(predicate, arg_0);
        Closeable closeable = Files.newDirectoryStream($this$deleteChildrenRecursively, filter);
        Throwable throwable = null;
        try {
            DirectoryStream stream = (DirectoryStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            Iterable $this$forEach$iv = stream;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                NioPathUtilKt.deleteRecursively(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final void deleteRecursively(@NotNull Path $this$deleteRecursively, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        NioPathUtilKt.deleteRecursively(NioPathUtil.getResolvedPath((Path)$this$deleteRecursively, (String)relativePath));
    }

    public static final void deleteChildrenRecursively(@NotNull Path $this$deleteChildrenRecursively, @NotNull String relativePath, @NotNull Function1<? super Path, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteChildrenRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        NioPathUtilKt.deleteChildrenRecursively(NioPathUtil.getResolvedPath((Path)$this$deleteChildrenRecursively, (String)relativePath), predicate);
    }

    private static final boolean deleteChildrenRecursively$lambda$0(Function1 $tmp0, Path p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)p0);
    }
}

