/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.settingsSync.FileState;
import com.intellij.settingsSync.FileStateKt;
import com.intellij.settingsSync.GitSettingsLog;
import com.intellij.settingsSync.GitSettingsLogKt;
import com.intellij.settingsSync.SettingsLog;
import com.intellij.settingsSync.SettingsProvider;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSnapshotKt;
import com.intellij.settingsSync.SettingsSnapshotZipSerializer;
import com.intellij.settingsSync.SettingsSyncLocalSettings;
import com.intellij.settingsSync.plugins.SettingsSyncPluginsState;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 u2\u00020\u00012\u00020\u0002:\u0003tuvBA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001eH\u0016J\u0018\u0010+\u001a\u00020$2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001eH\u0016J \u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001eH\u0002J*\u0010.\u001a\u00020$2\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001e2\b\b\u0002\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020\fH\u0016J$\u00102\u001a\u00020$2\u0006\u0010*\u001a\u00020\u001e2\n\b\u0002\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u000200H\u0002J\b\u00106\u001a\u00020$H\u0002J\b\u00107\u001a\u00020$H\u0002J\u0018\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u000200H\u0002J\b\u0010;\u001a\u00020$H\u0016J\u001a\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020=H\u0002J\"\u0010@\u001a\u0004\u0018\u00010\u001e2\u0006\u0010A\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020=H\u0002J\u0018\u0010B\u001a\u00020'2\u0006\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001eH\u0016J\u0010\u0010C\u001a\u00020=2\u0006\u0010D\u001a\u00020\u000fH\u0002J\b\u0010E\u001a\u00020'H\u0016J\u0010\u0010F\u001a\u0002042\u0006\u00102\u001a\u00020=H\u0002J\u0018\u0010G\u001a\u00020\u001e2\u0006\u0010H\u001a\u00020\u001e2\u0006\u0010I\u001a\u00020=H\u0002J\b\u0010J\u001a\u00020'H\u0016J\u001a\u0010K\u001a\u0004\u0018\u00010=2\u0006\u0010L\u001a\u00020\u001e2\u0006\u0010M\u001a\u00020\u000fH\u0002J\b\u0010N\u001a\u00020'H\u0016J\u0010\u0010O\u001a\u00020P2\u0006\u0010D\u001a\u00020\u000fH\u0002J\b\u0010Q\u001a\u00020$H\u0002J\b\u0010R\u001a\u00020$H\u0016J\b\u0010S\u001a\u00020$H\u0016J&\u0010T\u001a\u00020$2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001e0V2\u0006\u0010W\u001a\u00020=2\u0006\u0010X\u001a\u00020=H\u0002J \u0010Y\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020\u001e2\u0006\u0010Z\u001a\u00020=2\u0006\u0010[\u001a\u00020=H\u0002J8\u0010\\\u001a\u00020\u001e\"\b\b\u0000\u0010]*\u00020^2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002H]0`2\u0006\u0010a\u001a\u00020\u001e2\u0006\u0010Z\u001a\u00020=2\u0006\u0010[\u001a\u00020=H\u0002J\n\u0010b\u001a\u0004\u0018\u00010cH\u0002J\u0018\u0010d\u001a\u00020$2\u0006\u00102\u001a\u00020=2\u0006\u00103\u001a\u000204H\u0002J\u0010\u0010e\u001a\u00020$2\u0006\u0010f\u001a\u00020'H\u0016J\u0010\u0010g\u001a\u00020$2\u0006\u0010f\u001a\u00020'H\u0016J\u0010\u0010h\u001a\u00020$2\u0006\u0010f\u001a\u00020'H\u0016Jp\u0010i\u001a\u00020\u001e\"\u0004\b\u0000\u0010]2\u0006\u0010a\u001a\u00020\u001e2\u0006\u0010Z\u001a\u00020=2\u0006\u0010[\u001a\u00020=2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u0002H]\u0012\u0004\u0012\u00020\u001e0\u000b2\u0012\u0010k\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002H]0\u000b2 \u0010l\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u0001H]\u0012\u0004\u0012\u0002H]\u0012\u0004\u0012\u0002H]\u0012\u0004\u0012\u0002H]0mH\u0002J\u0018\u0010n\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010o\u001a\u00020'H\u0002J\u0018\u0010p\u001a\u00020$2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020\u0004H\u0002R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\"\u00a8\u0006w"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog;", "Lcom/intellij/settingsSync/SettingsLog;", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "rootConfigPath", "parentDisposable", "userDataProvider", "Lkotlin/Function0;", "Lcom/intellij/ui/JBAccountInfoService$JBAData;", "initialSnapshotProvider", "Lkotlin/Function1;", "Lcom/intellij/settingsSync/SettingsSnapshot;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "cloud", "Lorg/eclipse/jgit/lib/Ref;", "getCloud", "()Lorg/eclipse/jgit/lib/Ref;", "git", "Lorg/eclipse/jgit/api/Git;", "ide", "getIde", "json", "Lkotlinx/serialization/json/Json;", "master", "getMaster", "pluginsFile", "repository", "Lorg/eclipse/jgit/lib/Repository;", "short", "", "Lorg/eclipse/jgit/lib/ObjectId;", "getShort", "(Lorg/eclipse/jgit/lib/ObjectId;)Ljava/lang/String;", "(Lorg/eclipse/jgit/lib/Ref;)Ljava/lang/String;", "abortMerge", "", "addInitialCommit", "advanceMaster", "Lcom/intellij/settingsSync/SettingsLog$Position;", "applyCloudState", "snapshot", "message", "applyIdeState", "applySnapshotAndCommit", "refName", "applyState", "warnAboutEmptySnapshot", "", "collectCurrentSnapshot", "commit", "dateCreated", "Ljava/time/Instant;", "allowEmpty", "configureJGit", "copyExistingSettings", "createBranchIfNeeded", "name", "newRepository", "dispose", "findMergeBase", "Lorg/eclipse/jgit/revwalk/RevCommit;", "commit1", "commit2", "findMergeBaseContent", "pluginJson", "forceWriteToMaster", "getBranchTip", "ref", "getCloudPosition", "getDate", "getFileContentInBranch", "file", "branchTip", "getIdePosition", "getLatestCommitForFile", "filePath", "branch", "getMasterPosition", "getPosition", "Lcom/intellij/settingsSync/GitSettingsLog$BranchPosition;", "initRepository", "initialize", "logExistingSettings", "mergeFilesOneByOne", "conflictingFiles", "", "ideTip", "cloudTip", "mergePluginJson", "ideBranchTip", "cloudBranchTip", "mergeSettingsProviderFile", "T", "", "settingsProvider", "Lcom/intellij/settingsSync/SettingsProvider;", "relativePath", "readPluginsState", "Lcom/intellij/settingsSync/plugins/SettingsSyncPluginsState;", "recordCreationDate", "setCloudPosition", "position", "setIdePosition", "setMasterPosition", "smartMergeFile", "serializer", "deserializer", "merger", "Lkotlin/Function3;", "updateBranchPosition", "targetPosition", "writeFileStateContent", "fileState", "Lcom/intellij/settingsSync/FileState;", "fileToWrite", "BranchPosition", "Companion", "MockGpgSigner", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nGitSettingsLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSettingsLog.kt\ncom/intellij/settingsSync/GitSettingsLog\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,565:1\n113#2:566\n1137#3,3:567\n1137#3,3:570\n96#4:573\n1#5:574\n10#6:575\n*S KotlinDebug\n*F\n+ 1 GitSettingsLog.kt\ncom/intellij/settingsSync/GitSettingsLog\n*L\n170#1:566\n260#1:567,3\n268#1:570,3\n278#1:573\n534#1:575\n*E\n"})
public final class GitSettingsLog
implements SettingsLog,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path settingsSyncStorage;
    @NotNull
    private final Path rootConfigPath;
    @NotNull
    private final Function0<JBAccountInfoService.JBAData> userDataProvider;
    @NotNull
    private final Function1<SettingsSnapshot, SettingsSnapshot> initialSnapshotProvider;
    private Repository repository;
    private Git git;
    @NotNull
    private final Path pluginsFile;
    @NotNull
    private final Json json;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String MASTER_REF_NAME = "master";
    @NotNull
    public static final String IDE_REF_NAME = "ide";
    @NotNull
    public static final String CLOUD_REF_NAME = "cloud";
    @NotNull
    public static final String PLUGINS_FILE = "plugins.json";
    @NotNull
    public static final String METAINFO_FOLDER = ".metainfo";
    @NotNull
    public static final String DATE_PREFIX = "date: ";
    private static final Pattern DATE_PATTERN;

    public GitSettingsLog(@NotNull Path settingsSyncStorage, @NotNull Path rootConfigPath, @NotNull Disposable parentDisposable, @NotNull Function0<JBAccountInfoService.JBAData> userDataProvider, @NotNull Function1<? super SettingsSnapshot, SettingsSnapshot> initialSnapshotProvider) {
        Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
        Intrinsics.checkNotNullParameter((Object)rootConfigPath, (String)"rootConfigPath");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(userDataProvider, (String)"userDataProvider");
        Intrinsics.checkNotNullParameter(initialSnapshotProvider, (String)"initialSnapshotProvider");
        this.settingsSyncStorage = settingsSyncStorage;
        this.rootConfigPath = rootConfigPath;
        this.userDataProvider = userDataProvider;
        this.initialSnapshotProvider = initialSnapshotProvider;
        Path path = this.settingsSyncStorage.resolve(METAINFO_FOLDER);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
        Path path2 = path.resolve(PLUGINS_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
        this.pluginsFile = path2;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    private final Ref getMaster() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        Ref ref = repository.findRef(MASTER_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    private final Ref getIde() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        Ref ref = repository.findRef(IDE_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    private final Ref getCloud() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        Ref ref = repository.findRef(CLOUD_REF_NAME);
        Intrinsics.checkNotNull((Object)ref);
        return ref;
    }

    @Override
    public void initialize() {
        this.configureJGit();
        this.initRepository();
    }

    private final void initRepository() {
        Repository repository;
        boolean newRepository;
        Path path = this.settingsSyncStorage.resolve(".git");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"settingsSyncStorage.resolve(\".git\")");
        Path dotGit = path;
        Repository repository2 = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(dotGit.toFile())).setAutonomous(true)).readEnvironment()).build();
        Intrinsics.checkNotNullExpressionValue((Object)repository2, (String)"FileRepositoryBuilder().\u2026readEnvironment().build()");
        this.repository = repository2;
        Repository repository3 = this.repository;
        if (repository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository3 = null;
        }
        this.git = new Git(repository3);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl = newRepository = !Files.exists(dotGit, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (newRepository) {
            LOG.info("Initializing new Git repository for Settings Sync at " + this.settingsSyncStorage);
            Repository repository4 = this.repository;
            if (repository4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository4 = null;
            }
            repository4.create();
            Repository repository5 = this.repository;
            if (repository5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository5 = null;
            }
            this.addInitialCommit(repository5);
        }
        if ((repository = this.repository) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        if (!GitSettingsLogKt.headCommitExists(repository)) {
            Repository repository6 = this.repository;
            if (repository6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository6 = null;
            }
            this.addInitialCommit(repository6);
        }
        this.createBranchIfNeeded(MASTER_REF_NAME, newRepository);
        this.createBranchIfNeeded(CLOUD_REF_NAME, newRepository);
        this.createBranchIfNeeded(IDE_REF_NAME, newRepository);
    }

    private final void configureJGit() {
        GpgSigner.setDefault(new MockGpgSigner());
    }

    @Override
    public void logExistingSettings() {
        this.copyExistingSettings();
    }

    private final void createBranchIfNeeded(String name, boolean newRepository) {
        Ref ref;
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        if ((ref = repository.findRef(name)) == null) {
            Git git;
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository2 = null;
            }
            RevCommit head = GitSettingsLogKt.headCommit(repository2);
            if (!newRepository) {
                ObjectId objectId = head.toObjectId();
                Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"head.toObjectId()");
                LOG.warn("Ref with name " + name + " not found in existing repository. Recreating at position of HEAD@" + this.getShort(objectId));
            }
            if ((git = this.git) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git = null;
            }
            git.branchCreate().setName(name).setStartPoint(head).call();
        }
    }

    private final void copyExistingSettings() {
        LOG.info("Copying existing settings from " + this.rootConfigPath + " to " + this.settingsSyncStorage);
        SettingsSnapshot snapshot = (SettingsSnapshot)this.initialSnapshotProvider.invoke((Object)this.collectCurrentSnapshot());
        this.applyState(IDE_REF_NAME, snapshot, "Copy current configs", false);
    }

    private final void addInitialCommit(Repository repository) {
        Path path = this.settingsSyncStorage.resolve(".gitignore");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"settingsSyncStorage.resolve(\".gitignore\")");
        Path gitignore = PathKt.createFile((Path)path);
        PathKt.write$default((Path)gitignore, (CharSequence)"event-log-metadata\njdbc-drivers\nssl\nport\nport.lock\nupdatedBrokenPlugins.db\n", null, (boolean)false, (int)6, null);
        Git git = new Git(repository);
        git.add().addFilepattern(".gitignore").call();
        GitSettingsLog.commit$default(this, "Initial", null, false, 2, null);
    }

    @Override
    public void applyIdeState(@NotNull SettingsSnapshot snapshot, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitSettingsLog.applyState$default(this, IDE_REF_NAME, snapshot, message, false, 8, null);
    }

    @Override
    public void applyCloudState(@NotNull SettingsSnapshot snapshot, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitSettingsLog.applyState$default(this, CLOUD_REF_NAME, snapshot, message, false, 8, null);
    }

    @Override
    @NotNull
    public SettingsLog.Position forceWriteToMaster(@NotNull SettingsSnapshot snapshot, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        GitSettingsLog.applyState$default(this, MASTER_REF_NAME, snapshot, message, false, 8, null);
        return this.getMasterPosition();
    }

    private final void applyState(String refName, SettingsSnapshot snapshot, String message, boolean warnAboutEmptySnapshot) {
        if (snapshot.isEmpty()) {
            if (warnAboutEmptySnapshot) {
                LOG.error("Empty snapshot, requested to apply on branch '" + refName + "' with message '" + message + "'");
            }
            return;
        }
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.checkout().setName(refName).call();
        this.applySnapshotAndCommit(refName, snapshot, message);
    }

    static /* synthetic */ void applyState$default(GitSettingsLog gitSettingsLog, String string, SettingsSnapshot settingsSnapshot, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        gitSettingsLog.applyState(string, settingsSnapshot, string2, bl);
    }

    private final void applySnapshotAndCommit(String refName, SettingsSnapshot snapshot, String message) {
        Object object;
        Path file;
        LOG.info("Applying settings changes to branch " + refName + ": " + CollectionsKt.joinToString$default((Iterable)snapshot.getFileStates(), null, null, null, (int)5, null, (Function1)applySnapshotAndCommit.1.INSTANCE, (int)23, null));
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        AddCommand addCommand = git.add();
        for (FileState fileState : snapshot.getFileStates()) {
            file = this.settingsSyncStorage.resolve(fileState.getFile());
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            this.writeFileStateContent(fileState, file);
            addCommand.addFilepattern(fileState.getFile());
        }
        for (FileState fileState : snapshot.getAdditionalFiles()) {
            file = this.settingsSyncStorage.resolve(METAINFO_FOLDER).resolve(fileState.getFile());
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            this.writeFileStateContent(fileState, file);
            addCommand.addFilepattern(".metainfo/" + fileState.getFile());
        }
        if (snapshot.getPlugins() != null) {
            SettingsSyncPluginsState sortedState = new SettingsSyncPluginsState(MapsKt.toSortedMap(snapshot.getPlugins().getPlugins()));
            StringFormat $this$encodeToString$iv = (StringFormat)this.json;
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)SettingsSyncPluginsState.Companion.serializer(), (Object)sortedState);
            PathKt.write$default((Path)this.pluginsFile, (CharSequence)string, null, (boolean)false, (int)6, null);
            addCommand.addFilepattern(".metainfo/plugins.json");
        }
        for (Map.Entry entry : SettingsSnapshotZipSerializer.INSTANCE.serializeSettingsProviders$intellij_settingsSync(snapshot.getSettingsFromProviders()).entrySet()) {
            String relativePath = (String)entry.getKey();
            String content = (String)entry.getValue();
            Path path = this.settingsSyncStorage.resolve(METAINFO_FOLDER).resolve(relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"settingsSyncStorage.reso\u2026ER).resolve(relativePath)");
            PathKt.write$default((Path)path, (CharSequence)content, null, (boolean)false, (int)6, null);
            addCommand.addFilepattern(".metainfo/" + relativePath);
        }
        addCommand.call();
        SettingsSnapshot.AppInfo info = snapshot.getMetaInfo().getAppInfo();
        if (info != null) {
            String thisOrThat = Intrinsics.areEqual((Object)info.getApplicationId(), (Object)SettingsSyncLocalSettings.Companion.getInstance().getApplicationId()) ? "[this]" : "[other]";
            object = "\n\n" + StringsKt.trimIndent((String)("\n        id:     " + thisOrThat + " " + info.getApplicationId() + "\n        build:  " + info.getBuildNumber() + "\n        user:   " + info.getUserName() + "\n        host:   " + info.getHostName() + "\n        config: " + info.getConfigFolder() + "\n      "));
        } else {
            object = "";
        }
        String string = object;
        this.commit(message + string, snapshot.getMetaInfo().getDateCreated(), false);
    }

    private final void writeFileStateContent(FileState fileState, Path fileToWrite) {
        FileState fileState2 = fileState;
        if (fileState2 instanceof FileState.Modified) {
            PathKt.write$default((Path)fileToWrite, (byte[])((FileState.Modified)fileState).getContent(), (int)0, (int)0, (int)6, null);
        } else if (fileState2 instanceof FileState.Deleted) {
            PathKt.write$default((Path)fileToWrite, (CharSequence)"DELETED", null, (boolean)false, (int)6, null);
        }
    }

    private final void commit(String message, Instant dateCreated, boolean allowEmpty) {
        try {
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git = null;
            }
            CommitCommand commitData = git.commit().setMessage(message).setAllowEmpty(allowEmpty).setNoVerify(true).setSign(false);
            JBAccountInfoService.JBAData jBAData = (JBAccountInfoService.JBAData)this.userDataProvider.invoke();
            if (jBAData != null) {
                String string;
                JBAccountInfoService.JBAData it = jBAData;
                boolean bl = false;
                String string2 = it.loginName;
                if (string2 == null) {
                    string2 = "";
                }
                if ((string = it.email) == null) {
                    string = "<>";
                }
                PersonIdent personIdent = new PersonIdent(string2, string);
                commitData.setAuthor(personIdent);
                commitData.setCommitter(personIdent);
            }
            RevCommit commit = commitData.call();
            if (dateCreated != null) {
                Intrinsics.checkNotNullExpressionValue((Object)commit, (String)"commit");
                this.recordCreationDate(commit, dateCreated);
            }
        }
        catch (EmptyCommitException e) {
            LOG.info("No actual changes in the settings");
        }
    }

    static /* synthetic */ void commit$default(GitSettingsLog gitSettingsLog, String string, Instant instant, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            instant = null;
        }
        gitSettingsLog.commit(string, instant, bl);
    }

    private final void recordCreationDate(RevCommit commit, Instant dateCreated) {
        Git git;
        Instant date;
        if (dateCreated.compareTo(Instant.now()) <= 0) {
            v0 = dateCreated;
        } else {
            LOG.error("Date of the snapshot happens in future: " + dateCreated);
            v0 = date = Instant.now();
        }
        if ((git = this.git) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.notesAdd().setMessage(DATE_PREFIX + date.toEpochMilli()).setObjectId(commit).call();
    }

    public void dispose() {
        if (this.repository != null) {
            Repository repository = this.repository;
            if (repository == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository = null;
            }
            repository.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SettingsSnapshot collectCurrentSnapshot() {
        void $this$mapTo$iv;
        Sequence it;
        Collection collection;
        void $this$mapTo$iv2;
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.checkout().setName(MASTER_REF_NAME).setForced(true).call();
        Instant lastModifiedDate = this.getDate(this.getBranchTip(this.getMaster()));
        File file = this.settingsSyncStorage.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"settingsSyncStorage.toFile()");
        Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file).onEnter((Function1)collectCurrentSnapshot.settingFiles.1.INSTANCE)), (Function1)collectCurrentSnapshot.settingFiles.2.INSTANCE);
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            File file2 = (File)item$iv;
            collection = destination$iv;
            boolean bl = false;
            Path path = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
            collection.add(FileStateKt.getFileStateFromFileWithDeletedMarker(path, this.settingsSyncStorage));
        }
        HashSet settingFiles2 = (HashSet)destination$iv;
        Path metaInfoFolder = this.settingsSyncStorage.resolve(METAINFO_FOLDER);
        Intrinsics.checkNotNullExpressionValue((Object)metaInfoFolder, (String)"metaInfoFolder");
        Pair<Map<String, Object>, Set<Path>> pair = SettingsSnapshotZipSerializer.INSTANCE.deserializeSettingsProviders$intellij_settingsSync(metaInfoFolder);
        Map settingsFromProviders = (Map)pair.component1();
        Set filesFromProviders = (Set)pair.component2();
        File file3 = metaInfoFolder.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"metaInfoFolder.toFile()");
        it = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file3)), (Function1)((Function1)new Function1<File, Boolean>((Set<? extends Path>)filesFromProviders){
            final /* synthetic */ Set<Path> $filesFromProviders;
            {
                this.$filesFromProviders = $filesFromProviders;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isFile() && !Intrinsics.areEqual((Object)it.getName(), (Object)"plugins.json") && !this.$filesFromProviders.contains(it.toPath());
            }
        }));
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            File file4 = (File)item$iv;
            collection = destination$iv2;
            boolean bl = false;
            Path path = it2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.toPath()");
            collection.add(FileStateKt.getFileStateFromFileWithDeletedMarker(path, metaInfoFolder));
        }
        HashSet additionalFiles2 = (HashSet)destination$iv2;
        SettingsSyncPluginsState pluginsState = this.readPluginsState();
        return new SettingsSnapshot(new SettingsSnapshot.MetaInfo(lastModifiedDate, SettingsSnapshotKt.getLocalApplicationInfo(), false, 4, null), settingFiles2, pluginsState, settingsFromProviders, additionalFiles2);
    }

    /*
     * WARNING - void declaration
     */
    private final SettingsSyncPluginsState readPluginsState() {
        try {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(this.pluginsFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                void this_$iv;
                Json json2 = this.json;
                String string$iv = PathKt.readText((Path)this.pluginsFile);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (SettingsSyncPluginsState)this_$iv.decodeFromString((DeserializationStrategy)SettingsSyncPluginsState.Companion.serializer(), string$iv);
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't parse " + this.pluginsFile, (Throwable)e);
        }
        return null;
    }

    @Override
    @NotNull
    public SettingsLog.Position getIdePosition() {
        return this.getPosition(this.getIde());
    }

    @Override
    @NotNull
    public SettingsLog.Position getCloudPosition() {
        return this.getPosition(this.getCloud());
    }

    @Override
    @NotNull
    public SettingsLog.Position getMasterPosition() {
        return this.getPosition(this.getMaster());
    }

    private final BranchPosition getPosition(Ref ref) {
        String string = ref.getObjectId().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ref.objectId.name()");
        return new BranchPosition(string);
    }

    @Override
    public void setIdePosition(@NotNull SettingsLog.Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.updateBranchPosition(IDE_REF_NAME, position);
    }

    @Override
    public void setCloudPosition(@NotNull SettingsLog.Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.updateBranchPosition(CLOUD_REF_NAME, position);
    }

    @Override
    public void setMasterPosition(@NotNull SettingsLog.Position position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.updateBranchPosition(MASTER_REF_NAME, position);
    }

    private final Ref updateBranchPosition(String refName, SettingsLog.Position targetPosition) {
        RefUpdate refUpdate;
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        Ref ref = repository.findRef(refName);
        Intrinsics.checkNotNull((Object)ref);
        Ref ref2 = ref;
        ObjectId previousObjectId = ref2.getObjectId();
        Repository repository2 = this.repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository2 = null;
        }
        RefUpdate $this$updateBranchPosition_u24lambda_u243 = refUpdate = repository2.updateRef(ref2.getName());
        boolean bl = false;
        $this$updateBranchPosition_u24lambda_u243.setNewObjectId(ObjectId.fromString(targetPosition.getId()));
        $this$updateBranchPosition_u24lambda_u243.setForceUpdate(true);
        RefUpdate.Result result2 = refUpdate.update();
        String string = this.getShort(ref2);
        Intrinsics.checkNotNullExpressionValue((Object)previousObjectId, (String)"previousObjectId");
        LOG.info("Updated position of " + string + " from " + this.getShort(previousObjectId) + " to " + targetPosition + ": " + result2);
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
        Repository repository3 = this.repository;
        if (repository3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository3 = null;
        }
        Ref ref3 = repository3.findRef(ref2.getName());
        Intrinsics.checkNotNull((Object)ref3);
        return ref3;
    }

    @Override
    @NotNull
    public SettingsLog.Position advanceMaster() {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.checkout().setName(MASTER_REF_NAME).call();
        ObjectId objectId = this.getMaster().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"master.objectId");
        String string = this.getShort(objectId);
        ObjectId objectId2 = this.getIde().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId2, (String)"ide.objectId");
        String string2 = this.getShort(objectId2);
        ObjectId objectId3 = this.getCloud().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId3, (String)"cloud.objectId");
        LOG.info("Advancing master@" + string + ". Need merge of ide@" + string2 + " and cloud@" + this.getShort(objectId3));
        Git git2 = this.git;
        if (git2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git2 = null;
        }
        git2.reset().setRef(IDE_REF_NAME).setMode(ResetCommand.ResetType.HARD).call();
        Git git3 = this.git;
        if (git3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git3 = null;
        }
        MergeResult mergeResult = git3.merge().include(this.getCloud()).call();
        ObjectId objectId4 = this.getMaster().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId4, (String)"master.objectId");
        String string3 = this.getShort(objectId4);
        ObjectId objectId5 = this.getCloud().getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)objectId5, (String)"cloud.objectId");
        LOG.info("Merge of master&ide@" + string3 + " with cloud@" + this.getShort(objectId5) + ": " + mergeResult);
        if (mergeResult.getMergeStatus() == MergeResult.MergeStatus.CONFLICTING) {
            Object v12;
            AddCommand addCommand;
            RevCommit cloudBranchTip;
            RevCommit ideBranchTip;
            List conflictingFiles;
            block8: {
                conflictingFiles = CollectionsKt.toMutableList((Collection)mergeResult.getConflicts().keySet());
                LOG.info("Merge of master&ide with cloud failed with conflicts in files: " + conflictingFiles);
                ideBranchTip = this.getBranchTip(this.getIde());
                cloudBranchTip = this.getBranchTip(this.getCloud());
                Git git4 = this.git;
                if (git4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                    git4 = null;
                }
                addCommand = git4.add();
                Iterable iterable = conflictingFiles;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)".metainfo/plugins.json")) continue;
                    v12 = t;
                    break block8;
                }
                v12 = null;
            }
            String pluginJsonPath = v12;
            if (pluginJsonPath != null) {
                String mergedContent = this.mergePluginJson(pluginJsonPath, ideBranchTip, cloudBranchTip);
                PathKt.write$default((Path)this.pluginsFile, (CharSequence)mergedContent, null, (boolean)false, (int)6, null);
                addCommand.addFilepattern(pluginJsonPath);
                ((Collection)conflictingFiles).remove(pluginJsonPath);
            }
            SettingsProvider.Companion.getSETTINGS_PROVIDER_EP().forEachExtensionSafe(arg_0 -> GitSettingsLog.advanceMaster$lambda$5(this, conflictingFiles, ideBranchTip, cloudBranchTip, addCommand, arg_0));
            this.mergeFilesOneByOne(conflictingFiles, ideBranchTip, cloudBranchTip);
            for (String file : conflictingFiles) {
                addCommand.addFilepattern(file);
            }
            addCommand.call();
            GitSettingsLog.commit$default(this, "Merge with conflicts", null, true, 2, null);
        }
        return this.getPosition(this.getMaster());
    }

    private final <T> String mergeSettingsProviderFile(SettingsProvider<T> settingsProvider, String relativePath, RevCommit ideBranchTip, RevCommit cloudBranchTip) {
        return this.smartMergeFile(relativePath, ideBranchTip, cloudBranchTip, (Function1)new Function1<T, String>(settingsProvider){
            final /* synthetic */ SettingsProvider<T> $settingsProvider;
            {
                this.$settingsProvider = $settingsProvider;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$settingsProvider.serialize(it);
            }
        }, (Function1)new Function1<String, T>(settingsProvider){
            final /* synthetic */ SettingsProvider<T> $settingsProvider;
            {
                this.$settingsProvider = $settingsProvider;
                super(1);
            }

            @NotNull
            public final T invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$settingsProvider.deserialize(it);
            }
        }, (Function3)new Function3<T, T, T, T>(settingsProvider){
            final /* synthetic */ SettingsProvider<T> $settingsProvider;
            {
                this.$settingsProvider = $settingsProvider;
                super(3);
            }

            @NotNull
            public final T invoke(@Nullable T base, @NotNull T cloud, @NotNull T ide) {
                Intrinsics.checkNotNullParameter(cloud, (String)"cloud");
                Intrinsics.checkNotNullParameter(ide, (String)"ide");
                return this.$settingsProvider.mergeStates(base, cloud, ide);
            }
        });
    }

    private final String mergePluginJson(String pluginJson, RevCommit ideBranchTip, RevCommit cloudBranchTip) {
        return this.smartMergeFile(pluginJson, ideBranchTip, cloudBranchTip, (Function1)new Function1<SettingsSyncPluginsState, String>(this){
            final /* synthetic */ GitSettingsLog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull SettingsSyncPluginsState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                StringFormat $this$encodeToString$iv = (StringFormat)GitSettingsLog.access$getJson$p(this.this$0);
                boolean $i$f$encodeToString = false;
                $this$encodeToString$iv.getSerializersModule();
                return $this$encodeToString$iv.encodeToString((SerializationStrategy)SettingsSyncPluginsState.Companion.serializer(), (Object)it);
            }
        }, (Function1)new Function1<String, SettingsSyncPluginsState>(this){
            final /* synthetic */ GitSettingsLog this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final SettingsSyncPluginsState invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Json this_$iv = GitSettingsLog.access$getJson$p(this.this$0);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (SettingsSyncPluginsState)this_$iv.decodeFromString((DeserializationStrategy)SettingsSyncPluginsState.Companion.serializer(), it);
            }
        }, mergePluginJson.3.INSTANCE);
    }

    private final <T> String smartMergeFile(String relativePath, RevCommit ideBranchTip, RevCommit cloudBranchTip, Function1<? super T, String> serializer2, Function1<? super String, ? extends T> deserializer, Function3<? super T, ? super T, ? super T, ? extends T> merger) {
        String ideContent = this.getFileContentInBranch(relativePath, ideBranchTip);
        Object ideState = deserializer.invoke((Object)ideContent);
        String cloudContent = this.getFileContentInBranch(relativePath, cloudBranchTip);
        Object cloudState = deserializer.invoke((Object)cloudContent);
        String mergeBaseContent = this.findMergeBaseContent(relativePath, ideBranchTip, cloudBranchTip);
        Object baseState = mergeBaseContent != null ? deserializer.invoke((Object)mergeBaseContent) : null;
        Object mergedState = merger.invoke(baseState, cloudState, ideState);
        return (String)serializer2.invoke(mergedState);
    }

    private final String findMergeBaseContent(String pluginJson, RevCommit commit1, RevCommit commit2) {
        RevCommit revCommit;
        try {
            revCommit = this.findMergeBase(commit1, commit2);
        }
        catch (Exception e) {
            LOG.warn("Couldn't find the merge base for " + pluginJson + " between " + commit1 + " and " + commit2, (Throwable)e);
            revCommit = null;
        }
        RevCommit mergeBase = revCommit;
        if (mergeBase == null) {
            return null;
        }
        return this.getFileContentInBranch(pluginJson, mergeBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RevCommit findMergeBase(RevCommit commit1, RevCommit commit2) {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        AutoCloseable autoCloseable = new RevWalk(repository);
        Throwable throwable = null;
        try {
            RevWalk walk = (RevWalk)autoCloseable;
            boolean bl = false;
            walk.setRevFilter(RevFilter.MERGE_BASE);
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository2 = null;
            }
            walk.markStart(repository2.parseCommit(commit1.toObjectId()));
            Repository repository3 = this.repository;
            if (repository3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository3 = null;
            }
            walk.markStart(repository3.parseCommit(commit2.toObjectId()));
            RevCommit revCommit = walk.next();
            return revCommit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFileContentInBranch(String file, RevCommit branchTip) {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        AutoCloseable autoCloseable = TreeWalk.forPath(repository, file, branchTip.getTree());
        Throwable throwable = null;
        try {
            String string;
            TreeWalk treeWalk = (TreeWalk)autoCloseable;
            boolean bl = false;
            ObjectId blobId = treeWalk.getObjectId(0);
            Repository repository2 = this.repository;
            if (repository2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                repository2 = null;
            }
            AutoCloseable autoCloseable2 = repository2.newObjectReader();
            Throwable throwable2 = null;
            try {
                ObjectReader objectReader = (ObjectReader)autoCloseable2;
                boolean bl2 = false;
                ObjectLoader objectLoader = objectReader.open(blobId);
                byte[] byArray = objectLoader.getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"objectLoader.bytes");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                string = new String(byArray2, charset2);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            String string2 = string;
            return string2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void mergeFilesOneByOne(Collection<String> conflictingFiles, RevCommit ideTip, RevCommit cloudTip) {
        if (conflictingFiles.isEmpty()) {
            return;
        }
        Instant ideTipDate = this.getDate(ideTip);
        Instant cloudTipDate = this.getDate(cloudTip);
        for (String file : conflictingFiles) {
            String string;
            Instant cloudDateForFile;
            RevCommit cloudTipForFile;
            RevCommit ideTipForFile;
            RevCommit revCommit = ideTipForFile = this.getLatestCommitForFile(file, this.getIde());
            Instant ideDateForFile = revCommit != null ? this.getDate(revCommit) : ideTipDate;
            RevCommit revCommit2 = cloudTipForFile = this.getLatestCommitForFile(file, this.getCloud());
            Instant instant = cloudDateForFile = revCommit2 != null ? this.getDate(revCommit2) : cloudTipDate;
            if (ideDateForFile.compareTo(cloudDateForFile) >= 0) {
                Object object = ideTipForFile;
                if (object == null || (object = this.getShort((ObjectId)object)) == null) {
                    object = this.getShort(ideTip);
                }
                LOG.info("File " + file + " was modified later in 'ide' in " + (String)object);
                string = this.getFileContentInBranch(file, ideTip);
            } else {
                Object object = cloudTipForFile;
                if (object == null || (object = this.getShort((ObjectId)object)) == null) {
                    object = this.getShort(cloudTip);
                }
                LOG.info("File " + file + " was modified later in 'cloud' in " + (String)object);
                string = this.getFileContentInBranch(file, cloudTip);
            }
            String content = string;
            Path path = this.settingsSyncStorage.resolve(file);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"settingsSyncStorage.resolve(file)");
            PathKt.write$default((Path)path, (CharSequence)content, null, (boolean)false, (int)6, null);
        }
    }

    private final RevCommit getLatestCommitForFile(String filePath, Ref branch) {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        Object object = git.log().add(branch.getObjectId()).setMaxCount(1).addPath(filePath).call();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"git.log()\n      .add(bra\u2026h(filePath)\n      .call()");
        RevCommit commit = (RevCommit)CollectionsKt.firstOrNull((Iterable)object);
        if (commit == null) {
            LOG.warn("Could not find latest commit for file " + filePath + " in branch " + branch);
        }
        return commit;
    }

    private final RevCommit getBranchTip(Ref ref) {
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        Object object = git.log().add(ref.getObjectId()).setMaxCount(1).call();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"git.log().add(ref.objectId).setMaxCount(1).call()");
        Object object2 = CollectionsKt.first((Iterable)object);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"git.log().add(ref.object\u2026axCount(1).call().first()");
        return (RevCommit)object2;
    }

    private final Instant getDate(RevCommit commit) {
        try {
            Note noteObject;
            Git git = this.git;
            if (git == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"git");
                git = null;
            }
            if ((noteObject = git.notesShow().setObjectId(commit).call()) != null) {
                Repository repository = this.repository;
                if (repository == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                    repository = null;
                }
                byte[] byArray = repository.open(noteObject.getData()).getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"repository.open(noteObject.data).bytes");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                String noteContent = new String(byArray2, charset2);
                Matcher matcher = DATE_PATTERN.matcher(noteContent);
                if (matcher.matches()) {
                    String date = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)date, (String)"date");
                    Instant instant = Instant.ofEpochMilli(Long.parseLong(date));
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(date.toLong())");
                    return instant;
                }
                LOG.warn("Note for commit " + commit + " doesn't match format: [" + noteContent + "]");
            } else if (commit.getParentCount() == 1) {
                LOG.warn("No note assigned to commit " + commit);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error reading a note assigned to commit " + commit, e);
        }
        Instant instant = Instant.ofEpochSecond(commit.getCommitTime());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(commit.commitTime.toLong())");
        return instant;
    }

    private final void abortMerge() {
        Repository repository = this.repository;
        if (repository == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository = null;
        }
        repository.writeMergeCommitMsg(null);
        Repository repository2 = this.repository;
        if (repository2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            repository2 = null;
        }
        repository2.writeMergeHeads(null);
        Git git = this.git;
        if (git == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"git");
            git = null;
        }
        git.reset().setMode(ResetCommand.ResetType.HARD).call();
    }

    private final String getShort(Ref $this$short) {
        String string = $this$short.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        return StringsKt.removePrefix((String)string, (CharSequence)"refs/heads/");
    }

    private final String getShort(ObjectId $this$short) {
        String string = $this$short.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        String string2 = string;
        int n = 0;
        int n2 = 8;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string3;
    }

    private static final void advanceMaster$lambda$5(GitSettingsLog this$0, List $conflictingFiles, RevCommit $ideBranchTip, RevCommit $cloudBranchTip, AddCommand $addCommand, SettingsProvider it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$conflictingFiles, (String)"$conflictingFiles");
        Intrinsics.checkNotNullParameter((Object)$ideBranchTip, (String)"$ideBranchTip");
        Intrinsics.checkNotNullParameter((Object)$cloudBranchTip, (String)"$cloudBranchTip");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String relativePath = ".metainfo/" + it.getId() + "/" + it.getFileName();
        Path file = this$0.settingsSyncStorage.resolve(relativePath);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && $conflictingFiles.contains(relativePath)) {
            String mergedContent = this$0.mergeSettingsProviderFile(it, relativePath, $ideBranchTip, $cloudBranchTip);
            PathKt.write$default((Path)file, (CharSequence)mergedContent, null, (boolean)false, (int)6, null);
            $addCommand.addFilepattern(relativePath);
            ((Collection)$conflictingFiles).remove(relativePath);
        }
    }

    public static final /* synthetic */ Json access$getJson$p(GitSettingsLog $this) {
        return $this.json;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitSettingsLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
        DATE_PATTERN = Pattern.compile("date: (\\d+)");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog$BranchPosition;", "Lcom/intellij/settingsSync/SettingsLog$Position;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.settingsSync"})
    private static final class BranchPosition
    implements SettingsLog.Position {
        @NotNull
        private final String id;

        public BranchPosition(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            String string = this.getId().substring(0, 8);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final BranchPosition copy(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new BranchPosition(id);
        }

        public static /* synthetic */ BranchPosition copy$default(BranchPosition branchPosition, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = branchPosition.id;
            }
            return branchPosition.copy(string);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BranchPosition)) {
                return false;
            }
            BranchPosition branchPosition = (BranchPosition)other;
            return Intrinsics.areEqual((Object)this.id, (Object)branchPosition.id);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog$Companion;", "", "()V", "CLOUD_REF_NAME", "", "DATE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getDATE_PATTERN", "()Ljava/util/regex/Pattern;", "DATE_PREFIX", "IDE_REF_NAME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "MASTER_REF_NAME", "METAINFO_FOLDER", "PLUGINS_FILE", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public final Pattern getDATE_PATTERN() {
            return DATE_PATTERN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J0\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/GitSettingsLog$MockGpgSigner;", "Lorg/eclipse/jgit/lib/GpgSigner;", "()V", "canLocateSigningKey", "", "gpgSigningKey", "", "committer", "Lorg/eclipse/jgit/lib/PersonIdent;", "credentialsProvider", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "sign", "", "commit", "Lorg/eclipse/jgit/lib/CommitBuilder;", "intellij.settingsSync"})
    public static final class MockGpgSigner
    extends GpgSigner {
        @Override
        public void sign(@Nullable CommitBuilder commit, @Nullable String gpgSigningKey, @Nullable PersonIdent committer, @Nullable CredentialsProvider credentialsProvider) {
        }

        @Override
        public boolean canLocateSigningKey(@Nullable String gpgSigningKey, @Nullable PersonIdent committer, @Nullable CredentialsProvider credentialsProvider) {
            return false;
        }
    }
}

