/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.main;

import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.rt.coverage.testDiscovery.instrumentation.OpenCloseFileTransformer;
import com.intellij.rt.coverage.testDiscovery.main.TestDiscoveryTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestDiscoveryPremain {
    public static final String INCLUDE_PATTERNS_VM_OP = "test.discovery.include.class.patterns";
    public static final String EXCLUDE_PATTERNS_VM_OP = "test.discovery.exclude.class.patterns";

    private void performPremain(Instrumentation instrumentation) throws Exception {
        System.out.println("---- IntelliJ IDEA Test Discovery ---- ");
        List<Pattern> include = TestDiscoveryPremain.patterns(INCLUDE_PATTERNS_VM_OP);
        List<Pattern> exclude = TestDiscoveryPremain.patterns(EXCLUDE_PATTERNS_VM_OP);
        TestDiscoveryProjectData projectData = TestDiscoveryProjectData.getProjectData();
        instrumentation.addTransformer(new TestDiscoveryTransformer(exclude, include));
        TestDiscoveryPremain.addOpenCloseTransformer(instrumentation);
    }

    private static void addOpenCloseTransformer(Instrumentation instrumentation) throws UnmodifiableClassException {
        if (!Boolean.parseBoolean(System.getProperty("test.discovery.track.files", "true"))) {
            System.out.println("Tracking for opened/closed files disabled by 'test.discovery.track.files' system property");
            return;
        }
        if (System.getProperty("test.discovery.affected.roots") == null) {
            System.out.println("Tracking for opened/closed files disabled due to undefined 'test.discovery.affected.roots' system property");
            return;
        }
        OpenCloseFileTransformer openCloseFileTransformer = new OpenCloseFileTransformer();
        instrumentation.addTransformer(openCloseFileTransformer, true);
        instrumentation.retransformClasses(openCloseFileTransformer.classesToTransform());
    }

    private static List<Pattern> patterns(String key) {
        String property = System.getProperty(key);
        if (property == null) {
            return Collections.emptyList();
        }
        System.out.println("Patterns from " + key);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(1);
        for (String s : property.split(";")) {
            try {
                patterns.add(Pattern.compile(s));
                System.out.println(s);
            }
            catch (PatternSyntaxException ex) {
                System.err.println("Problem occurred with pattern " + s);
                System.err.println(ex.getDescription());
                System.exit(1);
            }
        }
        return patterns;
    }

    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        new TestDiscoveryPremain().performPremain(instrumentation);
    }
}

