/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.data;

import com.intellij.diff.util.Side;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.dto.GitLabMergeRequestDraftNoteRestDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabNoteDTO;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B+\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "", "parentSha", "", "sha", "filePathBefore", "filePathAfter", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFilePathAfter", "()Ljava/lang/String;", "getFilePathBefore", "getParentSha", "getSha", "equals", "", "other", "hashCode", "", "Companion", "Image", "Text", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Image;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Text;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabNotePosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabNotePosition.kt\norg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,142:1\n10#2:143\n*S KotlinDebug\n*F\n+ 1 GitLabNotePosition.kt\norg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition\n*L\n56#1:143\n*E\n"})
public abstract class GitLabNotePosition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String parentSha;
    @NotNull
    private final String sha;
    @Nullable
    private final String filePathBefore;
    @Nullable
    private final String filePathAfter;
    @NotNull
    private static final Logger LOG;

    private GitLabNotePosition(String parentSha, String sha, String filePathBefore, String filePathAfter) {
        this.parentSha = parentSha;
        this.sha = sha;
        this.filePathBefore = filePathBefore;
        this.filePathAfter = filePathAfter;
    }

    @NotNull
    public final String getParentSha() {
        return this.parentSha;
    }

    @NotNull
    public final String getSha() {
        return this.sha;
    }

    @Nullable
    public final String getFilePathBefore() {
        return this.filePathBefore;
    }

    @Nullable
    public final String getFilePathAfter() {
        return this.filePathAfter;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.mergerequest.data.GitLabNotePosition");
        GitLabNotePosition cfr_ignored_0 = (GitLabNotePosition)other;
        if (!Intrinsics.areEqual((Object)this.parentSha, (Object)((GitLabNotePosition)other).parentSha)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sha, (Object)((GitLabNotePosition)other).sha)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.filePathBefore, (Object)((GitLabNotePosition)other).filePathBefore)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filePathAfter, (Object)((GitLabNotePosition)other).filePathAfter);
    }

    public int hashCode() {
        int result2 = this.parentSha.hashCode();
        result2 = 31 * result2 + this.sha.hashCode();
        String string = this.filePathBefore;
        result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
        String string2 = this.filePathAfter;
        result2 = 31 * result2 + (string2 != null ? string2.hashCode() : 0);
        return result2;
    }

    public /* synthetic */ GitLabNotePosition(String parentSha, String sha, String filePathBefore, String filePathAfter, DefaultConstructorMarker $constructor_marker) {
        this(parentSha, sha, filePathBefore, filePathAfter);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitLabNotePosition.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "from", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "position", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabMergeRequestDraftNoteRestDTO$Position;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabNoteDTO$Position;", "intellij.vcs.gitlab"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final GitLabNotePosition from(@NotNull GitLabNoteDTO.Position position2) {
            GitLabNotePosition gitLabNotePosition;
            Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
            if (position2.getDiffRefs().getBaseSha() == null) {
                LOG.warn("Missing merge base in note position: " + position2);
                return null;
            }
            String parentSha = position2.getDiffRefs().getBaseSha();
            String sha = position2.getDiffRefs().getHeadSha();
            if (Intrinsics.areEqual((Object)position2.getPositionType(), (Object)"text")) {
                Pair pair;
                if (position2.getOldLine() != null) {
                    pair = new Pair((Object)Side.LEFT, (Object)(position2.getOldLine() - 1));
                } else {
                    Integer n = position2.getNewLine();
                    Intrinsics.checkNotNull((Object)n);
                    pair = new Pair((Object)Side.RIGHT, (Object)(n - 1));
                }
                Pair location = pair;
                gitLabNotePosition = new Text(parentSha, sha, position2.getOldPath(), position2.getNewPath(), (Pair<? extends Side, Integer>)location);
            } else {
                gitLabNotePosition = new Image(parentSha, sha, position2.getOldPath(), position2.getNewPath());
            }
            return gitLabNotePosition;
        }

        @Nullable
        public final GitLabNotePosition from(@NotNull GitLabMergeRequestDraftNoteRestDTO.Position position2) {
            GitLabNotePosition gitLabNotePosition;
            Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
            if (position2.getBaseSha() == null) {
                LOG.warn("Missing merge base in note position: " + position2);
                return null;
            }
            String parentSha = position2.getBaseSha();
            String string = position2.getHeadSha();
            if (string == null) {
                return null;
            }
            String sha = string;
            if (Intrinsics.areEqual((Object)position2.getPositionType(), (Object)"text")) {
                Pair pair;
                if (position2.getOldLine() != null) {
                    pair = new Pair((Object)Side.LEFT, (Object)(position2.getOldLine() - 1));
                } else {
                    Integer n = position2.getNewLine();
                    Intrinsics.checkNotNull((Object)n);
                    pair = new Pair((Object)Side.RIGHT, (Object)(n - 1));
                }
                Pair location = pair;
                gitLabNotePosition = new Text(parentSha, sha, position2.getOldPath(), position2.getNewPath(), (Pair<? extends Side, Integer>)location);
            } else {
                gitLabNotePosition = new Image(parentSha, sha, position2.getOldPath(), position2.getNewPath());
            }
            return gitLabNotePosition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Image;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "parentSha", "", "sha", "filePathBefore", "filePathAfter", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "equals", "", "other", "", "intellij.vcs.gitlab"})
    public static final class Image
    extends GitLabNotePosition {
        public Image(@NotNull String parentSha, @NotNull String sha, @Nullable String filePathBefore, @Nullable String filePathAfter) {
            Intrinsics.checkNotNullParameter((Object)parentSha, (String)"parentSha");
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            super(parentSha, sha, filePathBefore, filePathAfter, null);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            return super.equals(other);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\nH\u0016R!\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u0002`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition$Text;", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "parentSha", "", "sha", "filePathBefore", "filePathAfter", "location", "Lkotlin/Pair;", "Lcom/intellij/diff/util/Side;", "", "Lcom/intellij/collaboration/ui/codereview/diff/DiffLineLocation;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/Pair;)V", "getLocation", "()Lkotlin/Pair;", "equals", "", "other", "", "hashCode", "intellij.vcs.gitlab"})
    public static final class Text
    extends GitLabNotePosition {
        @NotNull
        private final Pair<Side, Integer> location;

        public Text(@NotNull String parentSha, @NotNull String sha, @Nullable String filePathBefore, @Nullable String filePathAfter, @NotNull Pair<? extends Side, Integer> location) {
            Intrinsics.checkNotNullParameter((Object)parentSha, (String)"parentSha");
            Intrinsics.checkNotNullParameter((Object)sha, (String)"sha");
            Intrinsics.checkNotNullParameter(location, (String)"location");
            super(parentSha, sha, filePathBefore, filePathAfter, null);
            this.location = location;
        }

        @NotNull
        public final Pair<Side, Integer> getLocation() {
            return this.location;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            if (!super.equals(other)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.mergerequest.data.GitLabNotePosition.Text");
            Text cfr_ignored_0 = (Text)other;
            return Intrinsics.areEqual(this.location, ((Text)other).location);
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + this.location.hashCode();
            return result2;
        }
    }
}

