/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.timeline;

import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.collaboration.ui.ComponentListPanelFactory;
import com.intellij.collaboration.ui.HtmlEditorPaneUtilKt;
import com.intellij.collaboration.ui.codereview.CodeReviewChatItemUIUtil;
import com.intellij.collaboration.ui.codereview.comment.CommentInputActionsComponentFactory;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageComponentFactory;
import com.intellij.collaboration.ui.codereview.timeline.StatusMessageType;
import com.intellij.collaboration.ui.codereview.timeline.comment.CommentTextFieldFactory;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.text.html.StyleSheet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gitlab.api.dto.GitLabLabelRestDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabResourceLabelEventDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabResourceMilestoneEventDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabResourceStateEventDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.ui.details.GitLabMergeRequestViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineComponentFactory;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineComponentFactoryKt;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineController;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineDescriptionComponent;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineDiscussionComponentFactory;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineDiscussionViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineItem;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineItemViewModel;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineTitleComponent;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineUIUtil;
import org.jetbrains.plugins.gitlab.mergerequest.ui.timeline.GitLabMergeRequestTimelineViewModel;
import org.jetbrains.plugins.gitlab.ui.GitLabUIUtil;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteEditingViewModel;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteEditingViewModelKt;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteEditorComponentFactory;
import org.jetbrains.plugins.gitlab.ui.comment.NewGitLabNoteViewModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0015\u0010\u0014\u001a\u00020\u00152\u000b\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J.\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001a\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020%H\u0002J*\u0010&\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010(\u001a\u00020)H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineComponentFactory;", "", "()V", "noUlGapsStyleSheet", "Ljavax/swing/text/html/StyleSheet;", "getNoUlGapsStyleSheet", "()Ljavax/swing/text/html/StyleSheet;", "noUlGapsStyleSheet$delegate", "Lkotlin/Lazy;", "create", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "timelineVm", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineViewModel;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "createCommitsListPane", "Ljavax/swing/JEditorPane;", "commits", "", "Lcom/intellij/openapi/util/NlsSafe;", "createContent", "item", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$Immutable;", "createItemComponent", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItemViewModel;", "createLabeledEventContent", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$LabelEvent;", "createMilestonedEventContent", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$MilestoneEvent;", "createStateChangeContent", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$StateEvent;", "createSystemDiscussionContent", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$SystemNote;", "createNewNoteField", "iconsProvider", "editVm", "Lorg/jetbrains/plugins/gitlab/ui/comment/NewGitLabNoteViewModel;", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestTimelineComponentFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestTimelineComponentFactory.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineComponentFactory\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,235:1\n8#2:236\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestTimelineComponentFactory.kt\norg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineComponentFactory\n*L\n171#1:236\n*E\n"})
public final class GitLabMergeRequestTimelineComponentFactory {
    @NotNull
    public static final GitLabMergeRequestTimelineComponentFactory INSTANCE = new GitLabMergeRequestTimelineComponentFactory();
    @NotNull
    private static final Lazy noUlGapsStyleSheet$delegate = LazyKt.lazy((Function0)noUlGapsStyleSheet.2.INSTANCE);

    private GitLabMergeRequestTimelineComponentFactory() {
    }

    @NotNull
    public final JComponent create(@NotNull Project project, @NotNull CoroutineScope cs, @NotNull GitLabMergeRequestTimelineViewModel timelineVm, @NotNull IconsProvider<GitLabUserDTO> avatarIconsProvider) {
        JScrollPane jScrollPane;
        JPanel jPanel;
        JComponent jComponent;
        JComponent jComponent2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)timelineVm, (String)"timelineVm");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        AnAction anAction = ActionManager.getInstance().getAction("GitLab.Merge.Request.Timeline.Popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        JComponent it = GitLabMergeRequestTimelineTitleComponent.INSTANCE.create(cs, timelineVm);
        boolean bl = false;
        JComponent $this$create_u24lambda_u241 = jComponent2 = CollaborationToolsUIUtil.wrapWithLimitedSize$default((CollaborationToolsUIUtil)CollaborationToolsUIUtil.INSTANCE, (JComponent)it, (Integer)CodeReviewChatItemUIUtil.INSTANCE.getTEXT_CONTENT_WIDTH(), null, (int)4, null);
        boolean bl2 = false;
        $this$create_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)20, (int)16));
        JComponent titleComponent = jComponent2;
        JComponent descriptionComponent = GitLabMergeRequestTimelineDescriptionComponent.INSTANCE.createComponent(cs, timelineVm, avatarIconsProvider);
        JPanel content2 = ComponentListPanelFactory.createVertical$default((ComponentListPanelFactory)ComponentListPanelFactory.INSTANCE, (CoroutineScope)cs, (Flow)((Flow)timelineVm.getTimelineItems()), (Function1)((Function1)create.content.1.INSTANCE), (Function1)create.content.2.INSTANCE, (int)0, (Function2)((Function2)new Function2<CoroutineScope, GitLabMergeRequestTimelineItemViewModel, JComponent>(project, avatarIconsProvider){
            final /* synthetic */ Project $project;
            final /* synthetic */ IconsProvider<GitLabUserDTO> $avatarIconsProvider;
            {
                this.$project = $project;
                this.$avatarIconsProvider = $avatarIconsProvider;
                super(2);
            }

            @NotNull
            public final JComponent invoke(@NotNull CoroutineScope itemCs, @NotNull GitLabMergeRequestTimelineItemViewModel item) {
                Intrinsics.checkNotNullParameter((Object)itemCs, (String)"itemCs");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return GitLabMergeRequestTimelineComponentFactory.access$createItemComponent(GitLabMergeRequestTimelineComponentFactory.INSTANCE, this.$project, itemCs, this.$avatarIconsProvider, item);
            }
        }), (int)16, null);
        NewGitLabNoteViewModel newGitLabNoteViewModel = timelineVm.getNewNoteVm();
        if (newGitLabNoteViewModel != null) {
            NewGitLabNoteViewModel it2 = newGitLabNoteViewModel;
            boolean bl3 = false;
            jComponent = INSTANCE.createNewNoteField(cs, project, avatarIconsProvider, it2);
        } else {
            jComponent = null;
        }
        JComponent newNoteField = jComponent;
        JPanel $this$create_u24lambda_u243 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel((int)0);
        boolean bl4 = false;
        $this$create_u24lambda_u243.add(titleComponent);
        $this$create_u24lambda_u243.add(descriptionComponent);
        $this$create_u24lambda_u243.add(content2);
        if (newNoteField != null) {
            $this$create_u24lambda_u243.add(newNoteField);
        }
        JPanel timelinePanel = jPanel;
        GitLabMergeRequestTimelineController timelineController2 = new GitLabMergeRequestTimelineController(timelineVm){
            final /* synthetic */ GitLabMergeRequestTimelineViewModel $timelineVm;
            {
                this.$timelineVm = $timelineVm;
            }

            public boolean getShowEvents() {
                return (Boolean)this.$timelineVm.getShowEvents().getValue();
            }

            public void setShowEvents(boolean value) {
                this.$timelineVm.setShowEvents(value);
            }
        };
        PopupHandler.installPopupMenu((JComponent)timelinePanel, (ActionGroup)actionGroup, (String)"popup");
        DataManager.registerDataProvider((JComponent)timelinePanel, arg_0 -> GitLabMergeRequestTimelineComponentFactory.create$lambda$4(timelineVm, timelineController2, arg_0));
        JScrollPane $this$create_u24lambda_u246 = jScrollPane = ScrollPaneFactory.createScrollPane((Component)timelinePanel, (boolean)true);
        boolean bl5 = false;
        $this$create_u24lambda_u246.setHorizontalScrollBarPolicy(31);
        $this$create_u24lambda_u246.getViewport().setOpaque(false);
        $this$create_u24lambda_u246.setBackground((Color)JBColor.lazy(GitLabMergeRequestTimelineComponentFactory::create$lambda$6$lambda$5));
        JScrollPane it3 = jScrollPane;
        boolean bl6 = false;
        UiNotifyConnector.doWhenFirstShown((JComponent)it3, () -> GitLabMergeRequestTimelineComponentFactory.create$lambda$8$lambda$7(timelineVm));
        JScrollPane jScrollPane2 = jScrollPane;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane2, (String)"createScrollPane(timelin\u2026questLoad()\n      }\n    }");
        return jScrollPane2;
    }

    private final JComponent createNewNoteField(CoroutineScope $this$createNewNoteField, Project project, IconsProvider<GitLabUserDTO> iconsProvider, NewGitLabNoteViewModel editVm2) {
        JComponent jComponent;
        CoroutineScope noteCs = $this$createNewNoteField;
        GitLabNoteEditingViewModel gitLabNoteEditingViewModel = editVm2;
        String string = CollaborationToolsBundle.message((String)"review.comments.reply.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"review.comments.reply.action\")");
        StateFlow stateFlow = (StateFlow)StateFlowKt.MutableStateFlow((Object)GitLabNoteEditingViewModelKt.submitActionIn(gitLabNoteEditingViewModel, noteCs, string));
        Object[] objectArray = new Object[]{CommentInputActionsComponentFactory.INSTANCE.getSubmitShortcutText()};
        String string2 = CollaborationToolsBundle.message((String)"review.comments.reply.hint", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"review.comments\u2026ctory.submitShortcutText)");
        CommentInputActionsComponentFactory.Config actions2 = new CommentInputActionsComponentFactory.Config(stateFlow, null, null, null, (StateFlow)StateFlowKt.MutableStateFlow((Object)string2), 14, null);
        CodeReviewChatItemUIUtil.ComponentType itemType = CodeReviewChatItemUIUtil.ComponentType.FULL;
        CommentTextFieldFactory.IconConfig icon = CommentTextFieldFactory.IconConfig.Companion.of(itemType, iconsProvider, (Object)editVm2.getCurrentUser());
        JComponent $this$createNewNoteField_u24lambda_u249 = jComponent = GitLabNoteEditorComponentFactory.INSTANCE.create(project, noteCs, editVm2, actions2, icon);
        boolean bl = false;
        $this$createNewNoteField_u24lambda_u249.setBorder(JBUI.Borders.empty((Insets)itemType.getInputPaddingInsets()));
        return jComponent;
    }

    private final JComponent createItemComponent(Project project, CoroutineScope cs, IconsProvider<GitLabUserDTO> avatarIconsProvider, GitLabMergeRequestTimelineItemViewModel item) {
        JComponent jComponent;
        GitLabMergeRequestTimelineItemViewModel gitLabMergeRequestTimelineItemViewModel = item;
        if (gitLabMergeRequestTimelineItemViewModel instanceof GitLabMergeRequestTimelineItemViewModel.Immutable) {
            GitLabMergeRequestTimelineItem.Immutable immutatebleItem = ((GitLabMergeRequestTimelineItemViewModel.Immutable)item).getItem();
            JComponent content2 = this.createContent(immutatebleItem);
            jComponent = CodeReviewChatItemUIUtil.INSTANCE.build(CodeReviewChatItemUIUtil.ComponentType.FULL, (Function1)new Function1<Integer, Icon>(avatarIconsProvider, immutatebleItem){
                final /* synthetic */ IconsProvider<GitLabUserDTO> $avatarIconsProvider;
                final /* synthetic */ GitLabMergeRequestTimelineItem.Immutable $immutatebleItem;
                {
                    this.$avatarIconsProvider = $avatarIconsProvider;
                    this.$immutatebleItem = $immutatebleItem;
                    super(1);
                }

                @NotNull
                public final Icon invoke(int it) {
                    return this.$avatarIconsProvider.getIcon((Object)this.$immutatebleItem.getActor(), it);
                }
            }, content2, (Function1)new Function1<CodeReviewChatItemUIUtil.Builder, Unit>(immutatebleItem){
                final /* synthetic */ GitLabMergeRequestTimelineItem.Immutable $immutatebleItem;
                {
                    this.$immutatebleItem = $immutatebleItem;
                    super(1);
                }

                public final void invoke(@NotNull CodeReviewChatItemUIUtil.Builder $this$build) {
                    Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                    CodeReviewChatItemUIUtil.Builder.withHeader$default((CodeReviewChatItemUIUtil.Builder)$this$build, (JComponent)GitLabMergeRequestTimelineUIUtil.INSTANCE.createTitleTextPane(this.$immutatebleItem.getActor(), this.$immutatebleItem.getDate()), null, (int)2, null);
                }
            });
        } else if (gitLabMergeRequestTimelineItemViewModel instanceof GitLabMergeRequestTimelineDiscussionViewModel) {
            jComponent = GitLabMergeRequestTimelineDiscussionComponentFactory.INSTANCE.create(project, cs, avatarIconsProvider, (GitLabMergeRequestTimelineDiscussionViewModel)item);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    private final JComponent createContent(GitLabMergeRequestTimelineItem.Immutable item) {
        JComponent jComponent;
        GitLabMergeRequestTimelineItem.Immutable immutable = item;
        if (immutable instanceof GitLabMergeRequestTimelineItem.SystemNote) {
            jComponent = this.createSystemDiscussionContent((GitLabMergeRequestTimelineItem.SystemNote)item);
        } else if (immutable instanceof GitLabMergeRequestTimelineItem.LabelEvent) {
            jComponent = this.createLabeledEventContent((GitLabMergeRequestTimelineItem.LabelEvent)item);
        } else if (immutable instanceof GitLabMergeRequestTimelineItem.MilestoneEvent) {
            jComponent = this.createMilestonedEventContent((GitLabMergeRequestTimelineItem.MilestoneEvent)item);
        } else if (immutable instanceof GitLabMergeRequestTimelineItem.StateEvent) {
            jComponent = this.createStateChangeContent((GitLabMergeRequestTimelineItem.StateEvent)item);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    private final JComponent createSystemDiscussionContent(GitLabMergeRequestTimelineItem.SystemNote item) {
        String content2 = item.getContent();
        if (StringsKt.contains$default((CharSequence)content2, (CharSequence)"Compare with previous version", (boolean)false, (int)2, null)) {
            try {
                JPanel jPanel;
                List lines = StringsKt.lines((CharSequence)content2);
                String title = (String)lines.get(0);
                String commits = (String)lines.get(2);
                JPanel $this$createSystemDiscussionContent_u24lambda_u2410 = jPanel = CollaborationToolsUIUtilKt.VerticalListPanel$default((int)0, (int)1, null);
                boolean bl = false;
                $this$createSystemDiscussionContent_u24lambda_u2410.add(HtmlEditorPaneUtilKt.SimpleHtmlPane((String)title));
                $this$createSystemDiscussionContent_u24lambda_u2410.add(StatusMessageComponentFactory.create$default((StatusMessageComponentFactory)StatusMessageComponentFactory.INSTANCE, (JComponent)INSTANCE.createCommitsListPane(commits), null, (int)2, null));
                return jPanel;
            }
            catch (Exception e) {
                GitLabMergeRequestTimelineComponentFactory $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(GitLabMergeRequestTimelineComponentFactory.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
                logger.warn("Error occurred while parsing the note with added commits", (Throwable)e);
            }
        }
        return StatusMessageComponentFactory.create$default((StatusMessageComponentFactory)StatusMessageComponentFactory.INSTANCE, (JComponent)HtmlEditorPaneUtilKt.SimpleHtmlPane((String)GitLabUIUtil.INSTANCE.convertToHtml$intellij_vcs_gitlab(content2)), null, (int)2, null);
    }

    private final StyleSheet getNoUlGapsStyleSheet() {
        Lazy lazy = noUlGapsStyleSheet$delegate;
        return (StyleSheet)lazy.getValue();
    }

    private final JEditorPane createCommitsListPane(String commits) {
        JEditorPane jEditorPane;
        JEditorPane $this$createCommitsListPane_u24lambda_u2411 = jEditorPane = HtmlEditorPaneUtilKt.SimpleHtmlPane$default((StyleSheet)this.getNoUlGapsStyleSheet(), (boolean)false, null, null, (int)14, null);
        boolean bl = false;
        HtmlEditorPaneUtilKt.setHtmlBody((JEditorPane)$this$createCommitsListPane_u24lambda_u2411, (String)commits);
        return jEditorPane;
    }

    private final JComponent createLabeledEventContent(GitLabMergeRequestTimelineItem.LabelEvent item) {
        String text = switch (WhenMappings.$EnumSwitchMapping$0[item.getEvent().getActionEnum().ordinal()]) {
            case 1 -> {
                Object[] var4_2 = new Object[1];
                GitLabLabelRestDTO v0 = item.getEvent().getLabel();
                String v1 = v0 != null ? GitLabMergeRequestTimelineComponentFactoryKt.access$toHtml(v0) : null;
                if (v1 == null) {
                    v1 = "";
                }
                var4_2[0] = v1;
                yield GitLabBundle.message("merge.request.event.label.added", var4_2);
            }
            case 2 -> {
                Object[] var4_2 = new Object[1];
                GitLabLabelRestDTO v3 = item.getEvent().getLabel();
                String v4 = v3 != null ? GitLabMergeRequestTimelineComponentFactoryKt.access$toHtml(v3) : null;
                if (v4 == null) {
                    v4 = "";
                }
                var4_2[0] = v4;
                yield GitLabBundle.message("merge.request.event.label.removed", var4_2);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        JEditorPane textPane = HtmlEditorPaneUtilKt.SimpleHtmlPane((String)text);
        return StatusMessageComponentFactory.create$default((StatusMessageComponentFactory)StatusMessageComponentFactory.INSTANCE, (JComponent)textPane, null, (int)2, null);
    }

    private final JComponent createMilestonedEventContent(GitLabMergeRequestTimelineItem.MilestoneEvent item) {
        String text = switch (WhenMappings.$EnumSwitchMapping$1[item.getEvent().getActionEnum().ordinal()]) {
            case 1 -> {
                Object[] var4_2 = new Object[]{GitLabMergeRequestTimelineComponentFactoryKt.access$toHtml(item.getEvent().getMilestone())};
                yield GitLabBundle.message("merge.request.event.milestone.changed", var4_2);
            }
            case 2 -> {
                Object[] var4_2 = new Object[]{GitLabMergeRequestTimelineComponentFactoryKt.access$toHtml(item.getEvent().getMilestone())};
                yield GitLabBundle.message("merge.request.event.milestone.removed", var4_2);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        JEditorPane textPane = HtmlEditorPaneUtilKt.SimpleHtmlPane((String)text);
        return StatusMessageComponentFactory.create$default((StatusMessageComponentFactory)StatusMessageComponentFactory.INSTANCE, (JComponent)textPane, null, (int)2, null);
    }

    private final JComponent createStateChangeContent(GitLabMergeRequestTimelineItem.StateEvent item) {
        String text = switch (WhenMappings.$EnumSwitchMapping$2[item.getEvent().getStateEnum().ordinal()]) {
            case 1 -> GitLabBundle.message("merge.request.event.closed", new Object[0]);
            case 2 -> GitLabBundle.message("merge.request.event.reopened", new Object[0]);
            case 3 -> GitLabBundle.message("merge.request.event.merged", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        StatusMessageType type = switch (WhenMappings.$EnumSwitchMapping$2[item.getEvent().getStateEnum().ordinal()]) {
            case 1 -> StatusMessageType.SECONDARY_INFO;
            case 2 -> StatusMessageType.INFO;
            case 3 -> StatusMessageType.SUCCESS;
            default -> throw new NoWhenBranchMatchedException();
        };
        JEditorPane textPane = HtmlEditorPaneUtilKt.SimpleHtmlPane((String)text);
        return StatusMessageComponentFactory.INSTANCE.create((JComponent)textPane, type);
    }

    private static final Object create$lambda$4(GitLabMergeRequestTimelineViewModel $timelineVm, create.timelineController.1 $timelineController, String dataId) {
        Intrinsics.checkNotNullParameter((Object)$timelineVm, (String)"$timelineVm");
        Intrinsics.checkNotNullParameter((Object)$timelineController, (String)"$timelineController");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return GitLabMergeRequestViewModel.Companion.getDATA_KEY().is(dataId) ? $timelineVm : (GitLabMergeRequestTimelineController.Companion.getDATA_KEY().is(dataId) ? $timelineController : null);
    }

    private static final Color create$lambda$6$lambda$5() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getInstance().globalScheme");
        EditorColorsScheme scheme = editorColorsScheme;
        return scheme.getDefaultBackground();
    }

    private static final void create$lambda$8$lambda$7(GitLabMergeRequestTimelineViewModel $timelineVm) {
        Intrinsics.checkNotNullParameter((Object)$timelineVm, (String)"$timelineVm");
        $timelineVm.requestLoad();
    }

    public static final /* synthetic */ JComponent access$createItemComponent(GitLabMergeRequestTimelineComponentFactory $this, Project project, CoroutineScope cs, IconsProvider avatarIconsProvider, GitLabMergeRequestTimelineItemViewModel item) {
        return $this.createItemComponent(project, cs, (IconsProvider<GitLabUserDTO>)avatarIconsProvider, item);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[GitLabResourceLabelEventDTO.Action.values().length];
            try {
                nArray[GitLabResourceLabelEventDTO.Action.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabResourceLabelEventDTO.Action.REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GitLabResourceMilestoneEventDTO.Action.values().length];
            try {
                nArray[GitLabResourceMilestoneEventDTO.Action.ADD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabResourceMilestoneEventDTO.Action.REMOVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[GitLabResourceStateEventDTO.State.values().length];
            try {
                nArray[GitLabResourceStateEventDTO.State.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabResourceStateEventDTO.State.REOPENED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabResourceStateEventDTO.State.MERGED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

