/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PClipboard;
import org.jetbrains.projector.awt.PToolkitBase;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.image.PGraphics2D;
import org.jetbrains.projector.awt.image.PGraphicsEnvironment;
import org.jetbrains.projector.awt.image.PVolatileImage;
import org.jetbrains.projector.awt.peer.PDesktopPeer;
import org.jetbrains.projector.awt.peer.PMouseInfoPeer;
import org.jetbrains.projector.awt.peer.base.PComponentPeerBase;
import org.jetbrains.projector.common.misc.Do;
import org.jetbrains.projector.common.protocol.compress.MessageCompressor;
import org.jetbrains.projector.common.protocol.compress.MessageDecompressor;
import org.jetbrains.projector.common.protocol.data.CommonIntRectangle;
import org.jetbrains.projector.common.protocol.data.CommonRectangle;
import org.jetbrains.projector.common.protocol.data.CursorType;
import org.jetbrains.projector.common.protocol.data.FontDataHolder;
import org.jetbrains.projector.common.protocol.data.ImageData;
import org.jetbrains.projector.common.protocol.data.ImageId;
import org.jetbrains.projector.common.protocol.data.UserKeymap;
import org.jetbrains.projector.common.protocol.handshake.CompressionType;
import org.jetbrains.projector.common.protocol.handshake.ConstantKt;
import org.jetbrains.projector.common.protocol.handshake.DisplayDescription;
import org.jetbrains.projector.common.protocol.handshake.ProtocolType;
import org.jetbrains.projector.common.protocol.handshake.ToClientHandshakeFailureEvent;
import org.jetbrains.projector.common.protocol.handshake.ToClientHandshakeSuccessEvent;
import org.jetbrains.projector.common.protocol.handshake.ToServerHandshakeEvent;
import org.jetbrains.projector.common.protocol.toClient.Flush;
import org.jetbrains.projector.common.protocol.toClient.ServerBrowseUriEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerCaretInfoChangedEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerClipboardEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawCommandsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerImageDataReplyEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerMarkdownEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPingReplyEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowColorsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowSetChangedEvent;
import org.jetbrains.projector.common.protocol.toClient.ToClientMessageEncoder;
import org.jetbrains.projector.common.protocol.toClient.WindowClass;
import org.jetbrains.projector.common.protocol.toClient.WindowData;
import org.jetbrains.projector.common.protocol.toClient.WindowType;
import org.jetbrains.projector.common.protocol.toServer.ClientClipboardEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientDisplaySetChangeEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyPressEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientMouseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientNotificationEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientNotificationType;
import org.jetbrains.projector.common.protocol.toServer.ClientOpenLinkEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRawKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRequestImageDataEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRequestPingEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientResizeEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientSetKeymapEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWheelEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowCloseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowInterestEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowMoveEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowResizeEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowSetBoundsEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowsActivationEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowsDeactivationEvent;
import org.jetbrains.projector.common.protocol.toServer.ToServerMessageDecoder;
import org.jetbrains.projector.server.ProjectorServer;
import org.jetbrains.projector.server.core.ClientEventHandler;
import org.jetbrains.projector.server.core.ClientSettings;
import org.jetbrains.projector.server.core.ClientWrapper;
import org.jetbrains.projector.server.core.ClosedClientSettings;
import org.jetbrains.projector.server.core.ConnectedClientSettings;
import org.jetbrains.projector.server.core.ReadyClientSettings;
import org.jetbrains.projector.server.core.ServerTransport;
import org.jetbrains.projector.server.core.SetUpClientData;
import org.jetbrains.projector.server.core.SetUpClientSettings;
import org.jetbrains.projector.server.core.SupportedHandshakeClientSettings;
import org.jetbrains.projector.server.core.convert.toAwt.ClientEventExtensionsKt;
import org.jetbrains.projector.server.core.convert.toAwt.KeyKt;
import org.jetbrains.projector.server.core.convert.toAwt.MouseKt;
import org.jetbrains.projector.server.core.convert.toClient.ShiftKt;
import org.jetbrains.projector.server.core.convert.toClient.TransformKt;
import org.jetbrains.projector.server.core.ij.IdeColors;
import org.jetbrains.projector.server.core.ij.IjInjectorAgentInitializer;
import org.jetbrains.projector.server.core.ij.KeymapSetter;
import org.jetbrains.projector.server.core.ij.SettingsInitializer;
import org.jetbrains.projector.server.core.ij.md.PanelUpdater;
import org.jetbrains.projector.server.core.protocol.HandshakeTypesSelector;
import org.jetbrains.projector.server.core.protocol.KotlinxJsonToClientHandshakeEncoder;
import org.jetbrains.projector.server.core.protocol.KotlinxJsonToServerHandshakeDecoder;
import org.jetbrains.projector.server.core.util.AwtKt;
import org.jetbrains.projector.server.core.util.DistinctUpdatedOnscreenSurfacesKt;
import org.jetbrains.projector.server.core.util.HostAddressKt;
import org.jetbrains.projector.server.core.util.LaterInvokator;
import org.jetbrains.projector.server.core.websocket.WsTransportBuilder;
import org.jetbrains.projector.server.idea.CaretInfoUpdater;
import org.jetbrains.projector.server.idea.UpdatesConfigKt;
import org.jetbrains.projector.server.service.ProjectorAwtInitializer;
import org.jetbrains.projector.server.service.ProjectorDrawEventQueue;
import org.jetbrains.projector.server.service.ProjectorImageCacher;
import org.jetbrains.projector.server.util.ConfirmConnection;
import org.jetbrains.projector.server.util.ConvertKt;
import org.jetbrains.projector.server.util.FontCacher;
import org.jetbrains.projector.server.util.NetworkKt;
import org.jetbrains.projector.server.util.ServerMessagesKt;
import org.jetbrains.projector.server.util.WindowDrawInterestManagerImpl;
import org.jetbrains.projector.server.websocket.WebsocketServer;
import org.jetbrains.projector.util.loading.OptionKt;
import org.jetbrains.projector.util.loading.UseProjectorLoader;
import org.jetbrains.projector.util.loading.state.IdeState;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;
import sun.awt.AWTAccessor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@UseProjectorLoader
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 Z2\u00020\u0001:\u0001ZB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0018J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020 J\u0016\u0010-\u001a\u00020\u00052\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aH\u0002J \u0010/\u001a\u00020+2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J\b\u00107\u001a\u00020\"H\u0002J\u0006\u00108\u001a\u00020+J\u000e\u00109\u001a\u00020+2\u0006\u0010:\u001a\u000205J\u0019\u0010;\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001050<0<\u00a2\u0006\u0002\u0010=J\u0012\u0010>\u001a\u00020\u00052\b\u0010?\u001a\u0004\u0018\u00010\u0015H\u0002J\u0006\u0010@\u001a\u00020\u0005J\u0010\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020CH\u0002J\u0018\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020F2\u0006\u00104\u001a\u00020GH\u0002J\u000e\u0010H\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0018J\u0018\u0010I\u001a\u00020\u00052\u0006\u0010,\u001a\u00020 2\b\b\u0002\u0010J\u001a\u00020KJ\u0010\u0010L\u001a\u00020+2\u0006\u0010M\u001a\u00020NH\u0002J\u0016\u0010O\u001a\u00020+2\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0002J \u0010Q\u001a\u00020+2\u0006\u00100\u001a\u0002012\u0006\u0010R\u001a\u00020S2\u0006\u00104\u001a\u000205H\u0002J\u0006\u0010T\u001a\u00020+J\u0012\u0010U\u001a\u00020+2\b\b\u0002\u0010V\u001a\u00020KH\u0007J\u001e\u0010W\u001a\u00020+2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020K0\u001a2\u0006\u0010Y\u001a\u00020KH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\u00020\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0016\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lorg/jetbrains/projector/server/ProjectorServer;", "", "laterInvokator", "Lorg/jetbrains/projector/server/core/util/LaterInvokator;", "isAgent", "", "(Lorg/jetbrains/projector/server/core/util/LaterInvokator;Z)V", "caretInfoUpdater", "Lorg/jetbrains/projector/server/idea/CaretInfoUpdater;", "clientEventHandler", "Lorg/jetbrains/projector/server/core/ClientEventHandler;", "getClientEventHandler$annotations", "()V", "getClientEventHandler", "()Lorg/jetbrains/projector/server/core/ClientEventHandler;", "commonQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/projector/common/protocol/toClient/ServerEvent;", "ideaColors", "Lorg/jetbrains/projector/server/core/ij/IdeColors;", "lastClipboardEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerClipboardEvent;", "observers", "", "Ljava/beans/PropertyChangeListener;", "kotlin.jvm.PlatformType", "", "previousWindowEvents", "", "Lorg/jetbrains/projector/common/protocol/toClient/WindowData;", "transports", "", "Lorg/jetbrains/projector/server/core/ServerTransport;", "updateThread", "Ljava/lang/Thread;", "wasStarted", "getWasStarted", "()Z", "windowColorsEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowColorsEvent;", "addObserver", "listener", "addTransport", "", "transport", "areChangedWindows", "windowEvents", "checkHandshakeVersion", "conn", "Lorg/jetbrains/projector/server/core/ClientWrapper;", "connectedClientSettings", "Lorg/jetbrains/projector/server/core/ConnectedClientSettings;", "message", "", "createDataToSend", "createUpdateThread", "disconnectAll", "disconnectByIp", "ip", "getClientList", "", "()[[Ljava/lang/String;", "isClipboardChanged", "current", "isStopped", "notifyObservers", "event", "Ljava/beans/PropertyChangeEvent;", "processMessage", "clientSettings", "Lorg/jetbrains/projector/server/core/ReadyClientSettings;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientEvent;", "removeObserver", "removeTransport", "timeoutMs", "", "sendMacLocalConnectionWarning", "address", "Ljava/net/InetAddress;", "sendPictures", "dataToSend", "setUpClient", "supportedHandshakeClientSettings", "Lorg/jetbrains/projector/server/core/SupportedHandshakeClientSettings;", "start", "stop", "timeout", "updateWindowsState", "windowIds", "windowEventId", "Companion", "projector-server-common"})
public final class ProjectorServer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final LaterInvokator laterInvokator;
    private final boolean isAgent;
    @NotNull
    private final Set<ServerTransport> transports;
    private Thread updateThread;
    @NotNull
    private final ConcurrentLinkedQueue<ServerEvent> commonQueue;
    @NotNull
    private final CaretInfoUpdater caretInfoUpdater;
    @Nullable
    private ServerWindowColorsEvent windowColorsEvent;
    @NotNull
    private final IdeColors ideaColors;
    @NotNull
    private final ClientEventHandler clientEventHandler;
    private final List<PropertyChangeListener> observers;
    @Nullable
    private ServerClipboardEvent lastClipboardEvent;
    @NotNull
    private Set<WindowData> previousWindowEvents;
    @NotNull
    private static final Logger logger;
    @Nullable
    private static ProjectorServer lastStartedServer;
    @NotNull
    public static final String ENABLE_PROPERTY_NAME = "org.jetbrains.projector.server.enable";
    @NotNull
    private static final String HOST_PROPERTY_NAME_OLD = "org.jetbrains.projector.server.host";
    @NotNull
    public static final String HOST_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_HOST";
    @NotNull
    private static final String PORT_PROPERTY_NAME_OLD = "org.jetbrains.projector.server.port";
    @NotNull
    public static final String PORT_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_PORT";
    @NotNull
    private static final String DEFAULT_PORT = "8887";
    @NotNull
    public static final String TOKEN_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_HANDSHAKE_TOKEN";
    @NotNull
    public static final String RO_TOKEN_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_RO_HANDSHAKE_TOKEN";
    private static boolean ENABLE_BIG_COLLECTIONS_CHECKS;
    private static final int DEFAULT_BIG_COLLECTIONS_CHECKS_SIZE = 10000;
    private static int BIG_COLLECTIONS_CHECKS_START_SIZE;
    @NotNull
    public static final String ENABLE_AUTO_KEYMAP_SETTING = "ORG_JETBRAINS_PROJECTOR_SERVER_AUTO_KEYMAP";
    @NotNull
    public static final String MAC_KEYBOARD_MODIFIERS_MODE = "ORG_JETBRAINS_PROJECTOR_SERVER_MAC_KEYBOARD";
    @NotNull
    public static final String ENABLE_CONNECTION_CONFIRMATION = "ORG_JETBRAINS_PROJECTOR_SERVER_CONNECTION_CONFIRMATION";
    @NotNull
    private static final String DISABLE_IDEA_UPDATES_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_DISABLE_IDEA_UPDATES";

    private ProjectorServer(LaterInvokator laterInvokator, boolean isAgent) {
        this.laterInvokator = laterInvokator;
        this.isAgent = isAgent;
        ConcurrentHashMap.KeySetView keySetView = new ConcurrentHashMap().keySet(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"ConcurrentHashMap<Server\u2026ort, Unit>().keySet(Unit)");
        this.transports = keySetView;
        this.commonQueue = new ConcurrentLinkedQueue();
        this.caretInfoUpdater = new CaretInfoUpdater((Function1<? super ServerCaretInfoChangedEvent.CaretInfoChange, Unit>)((Function1)new Function1<ServerCaretInfoChangedEvent.CaretInfoChange, Unit>(this){
            final /* synthetic */ ProjectorServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ServerCaretInfoChangedEvent.CaretInfoChange caretInfo) {
                Intrinsics.checkNotNullParameter((Object)caretInfo, (String)"caretInfo");
                ProjectorServer.access$getCommonQueue$p(this.this$0).add(new ServerCaretInfoChangedEvent(caretInfo));
            }
        }));
        this.ideaColors = new IdeColors((Function1<? super ServerWindowColorsEvent.ColorsStorage, Unit>)((Function1)new Function1<ServerWindowColorsEvent.ColorsStorage, Unit>(this){
            final /* synthetic */ ProjectorServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ServerWindowColorsEvent.ColorsStorage colors) {
                Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
                ProjectorServer.access$setWindowColorsEvent$p(this.this$0, new ServerWindowColorsEvent(colors));
            }
        }));
        PanelUpdater.INSTANCE.setShowCallback((Function2<? super Integer, ? super Boolean, Unit>)((Function2)new Function2<Integer, Boolean, Unit>(){

            public final void invoke(int id, boolean show) {
                commonQueue.add(new ServerMarkdownEvent.ServerMarkdownShowEvent(id, show));
            }
        }));
        PanelUpdater.INSTANCE.setResizeCallback((Function2<? super Integer, ? super Dimension, Unit>)((Function2)new Function2<Integer, Dimension, Unit>(){

            public final void invoke(int id, @NotNull Dimension size) {
                Intrinsics.checkNotNullParameter((Object)size, (String)"size");
                commonQueue.add(new ServerMarkdownEvent.ServerMarkdownResizeEvent(id, org.jetbrains.projector.server.core.convert.toClient.ConvertKt.toCommonIntSize(size)));
            }
        }));
        PanelUpdater.INSTANCE.setMoveCallback((Function2<? super Integer, ? super Point, Unit>)((Function2)new Function2<Integer, Point, Unit>(){

            public final void invoke(int id, @NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                commonQueue.add(new ServerMarkdownEvent.ServerMarkdownMoveEvent(id, ShiftKt.shift(point, PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift())));
            }
        }));
        PanelUpdater.INSTANCE.setDisposeCallback((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(){

            public final void invoke(int id) {
                commonQueue.add(new ServerMarkdownEvent.ServerMarkdownDisposeEvent(id));
            }
        }));
        PanelUpdater.INSTANCE.setPlaceToWindowCallback((Function2<? super Integer, ? super Component, Unit>)((Function2)new Function2<Integer, Component, Unit>(){

            public final void invoke(int id, @Nullable Component rootComponent) {
                Component component = rootComponent;
                if (component != null) {
                    Component component2 = component;
                    ProjectorServer projectorServer = this;
                    Component it = component2;
                    boolean bl = false;
                    Object peer = AWTAccessor.getComponentAccessor().getPeer(it);
                    if (peer instanceof PComponentPeerBase) {
                        projectorServer.commonQueue.add(new ServerMarkdownEvent.ServerMarkdownPlaceToWindowEvent(id, ((PComponentPeerBase)peer).getPWindow().getId()));
                    }
                }
            }
        }));
        PanelUpdater.INSTANCE.setSetHtmlCallback((Function2<? super Integer, ? super String, Unit>)((Function2)new Function2<Integer, String, Unit>(){

            public final void invoke(int id, @NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                commonQueue.add(new ServerMarkdownEvent.ServerMarkdownSetHtmlEvent(id, html));
            }
        }));
        PanelUpdater.INSTANCE.setSetCssCallback((Function2<? super Integer, ? super String, Unit>)((Function2)new Function2<Integer, String, Unit>(){

            public final void invoke(int id, @NotNull String css) {
                Intrinsics.checkNotNullParameter((Object)css, (String)"css");
                commonQueue.add(new ServerMarkdownEvent.ServerMarkdownSetCssEvent(id, css));
            }
        }));
        PanelUpdater.INSTANCE.setScrollCallback((Function2<? super Integer, ? super Integer, Unit>)((Function2)new Function2<Integer, Integer, Unit>(){

            public final void invoke(int id, int offset) {
                commonQueue.add(new ServerMarkdownEvent.ServerMarkdownScrollEvent(id, offset));
            }
        }));
        PDesktopPeer.Companion.setBrowseUriCallback((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String link) {
                Intrinsics.checkNotNullParameter((Object)link, (String)"link");
                commonQueue.add(new ServerBrowseUriEvent(link));
            }
        }));
        this.clientEventHandler = new ClientEventHandler(this){
            final /* synthetic */ ProjectorServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClientConnectionEnded(@NotNull ClientWrapper connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                ClientSettings clientSettings = connection.getSettings();
                double connectionTime = (double)(System.currentTimeMillis() - clientSettings.getConnectionMillis()) / 1000.0;
                Logger.DefaultImpls.info$default(ProjectorServer.access$getLogger$cp(), null, (Function0)new Function0<String>(clientSettings, connectionTime){
                    final /* synthetic */ ClientSettings $clientSettings;
                    final /* synthetic */ double $connectionTime;
                    {
                        this.$clientSettings = $clientSettings;
                        this.$connectionTime = $connectionTime;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$clientSettings.getAddress() + " disconnected, was connected for " + MathKt.roundToLong((double)this.$connectionTime) + " s.";
                    }
                }, 1, null);
            }

            @NotNull
            public ClientSettings getInitialClientState(@Nullable String address) {
                return new ConnectedClientSettings(System.currentTimeMillis(), address);
            }

            public void onClientConnected(@NotNull ClientWrapper connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            }

            /*
             * WARNING - void declaration
             */
            public void handleMessage(@NotNull ClientWrapper wrapper, @NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Do do_ = Do.INSTANCE;
                ClientSettings clientSettings = wrapper.getSettings();
                if (clientSettings instanceof ConnectedClientSettings) {
                    ProjectorServer.access$checkHandshakeVersion(this.this$0, wrapper, (ConnectedClientSettings)clientSettings, message2);
                } else if (clientSettings instanceof SupportedHandshakeClientSettings) {
                    ProjectorServer.access$setUpClient(this.this$0, wrapper, (SupportedHandshakeClientSettings)clientSettings, message2);
                } else if (clientSettings instanceof SetUpClientSettings) {
                    Object p0;
                    wrapper.setSettings(new ReadyClientSettings(clientSettings.getConnectionMillis(), clientSettings.getAddress(), ((SetUpClientSettings)clientSettings).getSetUpClientData(), new WindowDrawInterestManagerImpl(), ProjectorServer.Companion.getENABLE_BIG_COLLECTIONS_CHECKS() ? Integer.valueOf(ProjectorServer.Companion.getBIG_COLLECTIONS_CHECKS_START_SIZE()) : null));
                    Iterable $this$forEach$iv = PVolatileImage.Companion.getImages();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        p0 = (PVolatileImage)element$iv;
                        boolean bl = false;
                        ((PVolatileImage)p0).invalidate();
                    }
                    $this$forEach$iv = PWindow.Companion.getWindows();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        p0 = (PWindow)element$iv;
                        boolean bl = false;
                        ((PWindow)p0).repaint();
                    }
                    ProjectorServer.access$setPreviousWindowEvents$p(this.this$0, SetsKt.emptySet());
                    ProjectorServer.access$getCaretInfoUpdater$p(this.this$0).createCaretInfoEvent();
                    PanelUpdater.INSTANCE.updateAll();
                } else if (clientSettings instanceof ReadyClientSettings) {
                    void $this$forEach$iv;
                    SetUpClientData $this$handleMessage_u24lambda_u2d1 = ((ReadyClientSettings)clientSettings).getSetUpClientData();
                    boolean bl = false;
                    String decompressed = $this$handleMessage_u24lambda_u2d1.getToServerMessageDecompressor().decompress(message2);
                    List events = (List)$this$handleMessage_u24lambda_u2d1.getToServerMessageDecoder().decode(decompressed);
                    Iterable $i$f$forEach = events;
                    ProjectorServer projectorServer = this.this$0;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        ClientEvent it = (ClientEvent)element$iv;
                        boolean bl2 = false;
                        ProjectorServer.access$processMessage(projectorServer, (ReadyClientSettings)clientSettings, it);
                    }
                } else if (!(clientSettings instanceof ClosedClientSettings)) {
                    throw new NoWhenBranchMatchedException();
                }
                clientSettings = Unit.INSTANCE;
                boolean $i$f$exhaustive = false;
            }

            /*
             * WARNING - void declaration
             */
            public void updateClientsCount() {
                Iterable iterable = ProjectorServer.access$getTransports$p(this.this$0);
                int n = 0;
                for (T t : iterable) {
                    void it;
                    ServerTransport serverTransport = (ServerTransport)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = it.getClientCount();
                    n = n2 + n3;
                }
                int count = n;
                ProjectorServer.access$notifyObservers(this.this$0, ServerMessagesKt.clientsCountMessage(this, count));
            }
        };
        this.observers = Collections.synchronizedList(new ArrayList());
        this.previousWindowEvents = SetsKt.emptySet();
    }

    public final boolean getWasStarted() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.transports;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ServerTransport it = (ServerTransport)element$iv;
                    boolean bl2 = false;
                    if (!it.getWasStarted()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final ClientEventHandler getClientEventHandler() {
        return this.clientEventHandler;
    }

    public static /* synthetic */ void getClientEventHandler$annotations() {
    }

    public final boolean addObserver(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.observers.add(listener2);
    }

    public final boolean removeObserver(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        return this.observers.remove(listener2);
    }

    private final void notifyObservers(PropertyChangeEvent event) {
        List<PropertyChangeListener> list = this.observers;
        Intrinsics.checkNotNullExpressionValue(list, (String)"observers");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyChangeListener it = (PropertyChangeListener)element$iv;
            boolean bl = false;
            it.propertyChange(event);
        }
    }

    private final void sendMacLocalConnectionWarning(InetAddress address) {
        this.notifyObservers(ServerMessagesKt.macLocalConnectionMessage(this, address));
    }

    private final Thread createUpdateThread() {
        return ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProjectorServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Logger.DefaultImpls.debug$default(ProjectorServer.access$getLogger$cp(), null, createUpdateThread.1.INSTANCE, 1, null);
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        List<E> list;
                        List<E> list2;
                        void $this$mapTo$iv$iv;
                        List dataToSend = ProjectorServer.access$createDataToSend(this.this$0);
                        ProjectorServer.access$sendPictures(this.this$0, dataToSend);
                        Iterable $this$map$iv = DistinctUpdatedOnscreenSurfacesKt.distinctUpdatedOnscreenSurfaces(dataToSend);
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ServerDrawCommandsEvent.Target.Onscreen onscreen = (ServerDrawCommandsEvent.Target.Onscreen)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)Flush.INSTANCE)));
                        }
                        List<E> it = list2 = (List<E>)destination$iv$iv;
                        boolean bl = false;
                        List<E> list3 = list = !((Collection)it).isEmpty() ? list2 : null;
                        if (list != null) {
                            it = list;
                            boolean bl2 = false;
                            SwingUtilities.invokeLater(() -> createUpdateThread.1.invoke$lambda-3$lambda-2(it));
                        }
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable t) {
                        ProjectorServer.access$getLogger$cp().error(t, (Function0<String>)((Function0)createUpdateThread.5.INSTANCE));
                    }
                }
                Logger.DefaultImpls.debug$default(ProjectorServer.access$getLogger$cp(), null, createUpdateThread.6.INSTANCE, 1, null);
            }

            private static final void invoke$lambda-3$lambda-2(List $it) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                ProjectorDrawEventQueue.Companion.getCommands().addAll($it);
            }
        }), (int)29, null);
    }

    private final boolean isClipboardChanged(ServerClipboardEvent current) {
        return !Intrinsics.areEqual((Object)this.lastClipboardEvent, (Object)current);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServerEvent> createDataToSend() {
        List list;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Object p0;
        Object clipboardEvent;
        List list2;
        boolean bl = this.isAgent;
        if (!bl) {
            Transferable transferable2 = PClipboard.INSTANCE.extractLastContents();
            ServerClipboardEvent p02 = transferable2 == null ? null : ProjectorServer.Companion.toServerClipboardEvent(transferable2);
            boolean bl2 = false;
            list2 = CollectionsKt.listOfNotNull((Object)p02);
        } else if (bl) {
            Transferable transferable3;
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                transferable3 = systemClipboard.getContents(null);
            }
            catch (IllegalStateException e) {
                transferable3 = null;
            }
            Transferable bl2 = transferable3;
            Object object = clipboardEvent = bl2 == null ? null : ProjectorServer.Companion.toServerClipboardEvent(bl2);
            if (this.isClipboardChanged((ServerClipboardEvent)clipboardEvent)) {
                this.lastClipboardEvent = clipboardEvent;
                p0 = clipboardEvent;
                boolean bl3 = false;
                list2 = CollectionsKt.listOfNotNull((Object)p0);
            } else {
                list2 = CollectionsKt.emptyList();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List clipboardEvent2 = list2;
        ProjectorServer.Companion.calculateMainWindowShift();
        List<ServerDrawCommandsEvent> drawCommands = TransformKt.shrinkEvents(TransformKt.extractData((Iterable)ProjectorDrawEventQueue.Companion.getCommands()));
        clipboardEvent = PWindow.Companion.getWindows();
        boolean $i$f$mapIndexed = false;
        p0 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            CursorType cursorType;
            Object object;
            boolean bl4;
            Iterable iterable;
            List list3;
            void window;
            int n = index$iv$iv;
            index$iv$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PWindow pWindow = (PWindow)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            int n3 = window.getId();
            String string = window.getTitle();
            List<Object> list4 = window.getIcons();
            if (list4 == null) {
                list3 = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list4;
                boolean $i$f$map = false;
                iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                bl4 = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv2;
                    object = item$iv$iv2 = iterator.next();
                    Collection collection2 = destination$iv$iv2;
                    boolean bl6 = false;
                    collection2.add((ImageId)it);
                }
                list3 = (List)destination$iv$iv2;
            }
            List list5 = list3;
            boolean bl7 = window.getTarget().isShowing();
            CommonRectangle commonRectangle = ShiftKt.shiftBounds(window.getTarget(), PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift());
            Integer n4 = window.getHeaderHeight();
            Cursor cursor = window.getCursor();
            if (cursor == null) {
                cursorType = null;
            } else {
                bl4 = cursor.getType();
                cursorType = org.jetbrains.projector.server.core.convert.toClient.ConvertKt.toCursorType(bl4 ? 1 : 0);
            }
            iterable = cursorType;
            boolean bl8 = window.getResizable();
            bl4 = window.getModal();
            boolean bl9 = window.getUndecorated();
            WindowType windowType = ConvertKt.getWindowType((PWindow)window);
            object = ConvertKt.getWindowClass((PWindow)window);
            boolean bl10 = window.isAutoRequestFocus();
            boolean bl11 = window.isAlwaysOnTop();
            PWindow pWindow2 = window.getParentWindow();
            Integer n5 = pWindow2 == null ? null : Integer.valueOf(pWindow2.getId());
            float f = window.getRenderingScale();
            collection.add(new WindowData(n3, string, list5, bl7, (int)i, commonRectangle, (CursorType)((Object)iterable), bl8, bl4, bl9, windowType, n4, (WindowClass)((Object)object), bl10, bl11, n5, f));
        }
        List windows = (List)destination$iv$iv;
        List windowSetChangedEvent = this.areChangedWindows(windows) ? CollectionsKt.listOf((Object)new ServerWindowSetChangedEvent(windows)) : CollectionsKt.emptyList();
        List newImagesCopy = TransformKt.extractData((Iterable)ProjectorImageCacher.INSTANCE.getNewImages());
        List commonEvents = TransformKt.extractData((Iterable)this.commonQueue);
        int commandsCount = commonEvents.size() + newImagesCopy.size() + clipboardEvent2.size() + drawCommands.size() + windowSetChangedEvent.size() + 1;
        List $this$createDataToSend_u24lambda_u2d6 = list = CollectionsKt.createListBuilder((int)commandsCount);
        boolean bl12 = false;
        $this$createDataToSend_u24lambda_u2d6.addAll(commonEvents);
        $this$createDataToSend_u24lambda_u2d6.addAll(newImagesCopy);
        $this$createDataToSend_u24lambda_u2d6.addAll(clipboardEvent2);
        $this$createDataToSend_u24lambda_u2d6.addAll((Collection)drawCommands);
        $this$createDataToSend_u24lambda_u2d6.addAll(windowSetChangedEvent);
        ServerWindowColorsEvent serverWindowColorsEvent = this.windowColorsEvent;
        if (serverWindowColorsEvent != null) {
            ServerWindowColorsEvent it = serverWindowColorsEvent;
            boolean bl13 = false;
            $this$createDataToSend_u24lambda_u2d6.add(it);
            this.windowColorsEvent = null;
        }
        List allEvents = CollectionsKt.build((List)list);
        ProjectorImageCacher.INSTANCE.collectGarbage();
        return allEvents;
    }

    private final void processMessage(ReadyClientSettings clientSettings, ClientEvent message2) {
        Object pingReply;
        Object object;
        if (!(clientSettings.getSetUpClientData().getHasWriteAccess() || message2 instanceof ClientRequestImageDataEvent || message2 instanceof ClientRequestPingEvent)) {
            return;
        }
        Do do_ = Do.INSTANCE;
        ClientEvent clientEvent = message2;
        if (clientEvent instanceof ClientResizeEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-7(message2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientDisplaySetChangeEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-9(message2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientMouseEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-10(message2, clientSettings, this));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWheelEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-11(message2, clientSettings, this));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientKeyEvent) {
            KeyEvent it = KeyKt.toAwtKeyEvent((ClientKeyEvent)message2, clientSettings.getConnectionMillis(), AwtKt.focusOwnerOrTarget(((PWindow)CollectionsKt.last(PWindow.Companion.getWindows())).getTarget()));
            boolean bl = false;
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-13$lambda-12(this, it));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientKeyPressEvent) {
            KeyEvent it = KeyKt.toAwtKeyEvent((ClientKeyPressEvent)message2, clientSettings.getConnectionMillis(), AwtKt.focusOwnerOrTarget(((PWindow)CollectionsKt.last(PWindow.Companion.getWindows())).getTarget()));
            boolean bl = false;
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-15$lambda-14(this, it));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientRawKeyEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-16(this, message2, clientSettings));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientRequestImageDataEvent) {
            ImageData imageData = ProjectorImageCacher.INSTANCE.getImage(((ClientRequestImageDataEvent)message2).getImageId());
            if (imageData == null) {
                imageData = ImageData.Empty.INSTANCE;
            }
            ImageData imageData2 = imageData;
            ServerImageDataReplyEvent resource = new ServerImageDataReplyEvent(((ClientRequestImageDataEvent)message2).getImageId(), imageData2);
            object = clientSettings.getRequestedData().add(resource);
        } else if (clientEvent instanceof ClientClipboardEvent) {
            Transferable transferable2 = new Transferable(message2){
                final /* synthetic */ ClientEvent $message;
                {
                    this.$message = $message;
                }

                @NotNull
                public Object getTransferData(@Nullable DataFlavor flavor) {
                    if (!this.isDataFlavorSupported(flavor)) {
                        throw new UnsupportedFlavorException(flavor);
                    }
                    return ((ClientClipboardEvent)this.$message).getStringContent();
                }

                public boolean isDataFlavorSupported(@Nullable DataFlavor flavor) {
                    return ArraysKt.contains((Object[])this.getTransferDataFlavors(), (Object)flavor);
                }

                @NotNull
                public DataFlavor[] getTransferDataFlavors() {
                    DataFlavor[] dataFlavorArray = new DataFlavor[1];
                    DataFlavor dataFlavor = DataFlavor.stringFlavor;
                    Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"stringFlavor");
                    dataFlavorArray[0] = dataFlavor;
                    return dataFlavorArray;
                }
            };
            boolean resource = this.isAgent;
            if (resource) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable2, null);
            } else if (!resource) {
                PClipboard.INSTANCE.putContentsWithoutLastContentsUpdate(transferable2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientRequestPingEvent) {
            pingReply = new ServerPingReplyEvent(((ClientRequestPingEvent)message2).getClientTimeStamp(), (int)(System.currentTimeMillis() - clientSettings.getConnectionMillis()));
            object = clientSettings.getRequestedData().add((ServerEvent)pingReply);
        } else if (clientEvent instanceof ClientOpenLinkEvent) {
            PanelUpdater.INSTANCE.openInExternalBrowser(((ClientOpenLinkEvent)message2).getLink());
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientSetKeymapEvent) {
            pingReply = Do.INSTANCE;
            if (this.isAgent) {
                Logger.DefaultImpls.info$default(logger, null, processMessage.8.INSTANCE, 1, null);
            } else if (Boolean.parseBoolean(OptionKt.getOption(ENABLE_AUTO_KEYMAP_SETTING, "true"))) {
                KeymapSetter.INSTANCE.setKeymap(((ClientSetKeymapEvent)message2).getKeymap());
            } else {
                Logger.DefaultImpls.info$default(logger, null, processMessage.9.INSTANCE, 1, null);
            }
            Unit resource = Unit.INSTANCE;
            boolean $i$f$exhaustive2 = false;
            Do this_$iv = Do.INSTANCE;
            if (this.isAgent) {
                Logger.DefaultImpls.info$default(logger, null, processMessage.10.INSTANCE, 1, null);
            } else if (OptionKt.getOption(MAC_KEYBOARD_MODIFIERS_MODE) != null) {
                String string = OptionKt.getOption(MAC_KEYBOARD_MODIFIERS_MODE);
                Intrinsics.checkNotNull((Object)string);
                boolean mode = Boolean.parseBoolean(string);
                Logger.DefaultImpls.info$default(logger, null, (Function0)new Function0<String>(mode){
                    final /* synthetic */ boolean $mode;
                    {
                        this.$mode = $mode;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Force keyboard modifiers to " + this.$mode + " (property specified)";
                    }
                }, 1, null);
                Do $i$f$exhaustive2 = Do.INSTANCE;
                boolean bl = mode;
                if (bl) {
                    ProjectorServer.Companion.updateToolkitKeyboardModifiersMode(UserKeymap.MAC);
                } else if (!bl) {
                    ProjectorServer.Companion.updateToolkitKeyboardModifiersMode(UserKeymap.LINUX);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                Unit unit = Unit.INSTANCE;
                boolean $i$f$exhaustive3 = false;
            } else {
                ProjectorServer.Companion.updateToolkitKeyboardModifiersMode(((ClientSetKeymapEvent)message2).getKeymap());
            }
            Unit mode = Unit.INSTANCE;
            boolean $i$f$exhaustive4 = false;
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowMoveEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-18(message2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowResizeEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-20(message2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowSetBoundsEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-23(message2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowCloseEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-24(message2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowInterestEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-25(clientSettings, message2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowsActivationEvent) {
            this.updateWindowsState(((ClientWindowsActivationEvent)message2).getWindowIds(), 205);
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowsDeactivationEvent) {
            this.updateWindowsState(((ClientWindowsDeactivationEvent)message2).getWindowIds(), 206);
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientNotificationEvent) {
            NotificationType notificationType;
            if (!IdeState.Companion.isIdeAttached()) {
                return;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((ClientNotificationEvent)message2).getNotificationType().ordinal()]) {
                case 1: {
                    notificationType = NotificationType.INFORMATION;
                    break;
                }
                case 2: {
                    notificationType = NotificationType.WARNING;
                    break;
                }
                case 3: {
                    notificationType = NotificationType.ERROR;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            NotificationType intellijNotificationType = notificationType;
            Notification notification = new Notification("ProjectorClient", ((ClientNotificationEvent)message2).getTitle(), ((ClientNotificationEvent)message2).getMessage(), intellijNotificationType);
            Notifications.Bus.notify((Notification)notification);
            object = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        clientEvent = object;
        boolean $i$f$exhaustive = false;
    }

    private final void updateWindowsState(List<Integer> windowIds, int windowEventId) {
        EventQueue $this$updateWindowsState_u24lambda_u2d26 = Toolkit.getDefaultToolkit().getSystemEventQueue();
        boolean bl = false;
        Iterator<Integer> iterator = windowIds.iterator();
        while (iterator.hasNext()) {
            Window window;
            int windowId = ((Number)iterator.next()).intValue();
            PWindow pWindow = PWindow.Companion.getWindow(windowId);
            Component component = pWindow == null ? null : pWindow.getTarget();
            if ((component instanceof Window ? (Window)component : null) == null) continue;
            window = window;
            $this$updateWindowsState_u24lambda_u2d26.postEvent(new WindowEvent(window, windowEventId));
        }
    }

    private final void checkHandshakeVersion(ClientWrapper conn, ConnectedClientSettings connectedClientSettings, String message2) {
        String[] stringArray = new String[]{";"};
        List list = StringsKt.split$default((CharSequence)message2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String handshakeVersion = (String)list.get(0);
        String handshakeVersionId = (String)list.get(1);
        if (!Intrinsics.areEqual((Object)handshakeVersion, (Object)String.valueOf(ConstantKt.getHANDSHAKE_VERSION()))) {
            String reason = "Incompatible handshake versions: server - " + ConstantKt.getHANDSHAKE_VERSION() + " (#" + ConstantKt.getHandshakeVersionList().indexOf(ConstantKt.getHANDSHAKE_VERSION()) + "), client - " + handshakeVersion + " (#" + handshakeVersionId + ")";
            conn.disconnect(reason);
            return;
        }
        conn.setSettings(new SupportedHandshakeClientSettings(connectedClientSettings.getConnectionMillis(), connectedClientSettings.getAddress()));
    }

    /*
     * WARNING - void declaration
     */
    private final void setUpClient(ClientWrapper conn, SupportedHandshakeClientSettings supportedHandshakeClientSettings, String message2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        String string;
        boolean bl;
        ToServerHandshakeEvent toServerHandshakeEvent = KotlinxJsonToServerHandshakeDecoder.INSTANCE.decode(message2);
        String string2 = toServerHandshakeEvent.getToken();
        if (Intrinsics.areEqual((Object)string2, (Object)OptionKt.getOption(TOKEN_ENV_NAME))) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)string2, (Object)OptionKt.getOption(RO_TOKEN_ENV_NAME))) {
            bl = false;
        } else {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Bad handshake token");
            return;
        }
        boolean hasWriteAccess = bl;
        if (toServerHandshakeEvent.getCommonVersion() != ConstantKt.getCOMMON_VERSION()) {
            String reason = "Incompatible common protocol versions: server - " + ConstantKt.getCOMMON_VERSION() + " (#" + ConstantKt.getCommonVersionList().indexOf(ConstantKt.getCOMMON_VERSION()) + "), client - " + toServerHandshakeEvent.getCommonVersion() + " (#" + toServerHandshakeEvent.getCommonVersionId() + ")";
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, reason);
            return;
        }
        MessageCompressor<byte[]> toClientCompressor = HandshakeTypesSelector.INSTANCE.selectToClientCompressor(toServerHandshakeEvent.getSupportedToClientCompressions());
        if (toClientCompressor == null) {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Server doesn't support any of the following to-client compressions: " + toServerHandshakeEvent.getSupportedToClientCompressions());
            return;
        }
        ToClientMessageEncoder toClientEncoder = HandshakeTypesSelector.INSTANCE.selectToClientEncoder(toServerHandshakeEvent.getSupportedToClientProtocols());
        if (toClientEncoder == null) {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Server doesn't support any of the following to-client protocols: " + toServerHandshakeEvent.getSupportedToClientProtocols());
            return;
        }
        MessageDecompressor<String> toServerDecompressor = HandshakeTypesSelector.INSTANCE.selectToServerDecompressor(toServerHandshakeEvent.getSupportedToServerCompressions());
        if (toServerDecompressor == null) {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Server doesn't support any of the following to-server compressions: " + toServerHandshakeEvent.getSupportedToServerCompressions());
            return;
        }
        ToServerMessageDecoder toServerDecoder = HandshakeTypesSelector.INSTANCE.selectToServerDecoder(toServerHandshakeEvent.getSupportedToServerProtocols());
        if (toServerDecoder == null) {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Server doesn't support any of the following to-server protocols: " + toServerHandshakeEvent.getSupportedToServerProtocols());
            return;
        }
        if (this.isAgent && conn.getRequiresConfirmation() && !((string = OptionKt.getOption(ENABLE_CONNECTION_CONFIRMATION)) == null ? false : !Boolean.parseBoolean(string))) {
            Logger.DefaultImpls.info$default(logger, null, setUpClient.1.INSTANCE, 1, null);
            Ref.BooleanRef resp = new Ref.BooleanRef();
            SwingUtilities.invokeAndWait(() -> ProjectorServer.setUpClient$lambda-28(hasWriteAccess, resp, conn));
            if (!resp.element) {
                Logger.DefaultImpls.info$default(logger, null, setUpClient.3.INSTANCE, 1, null);
                ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Other user has disallowed this connection.");
                return;
            }
            Logger.DefaultImpls.info$default(logger, null, setUpClient.4.INSTANCE, 1, null);
        }
        if (this.isAgent) {
            InetAddress remoteIp = conn.getConfirmationRemoteIp();
            if (ProjectorServer.Companion.isMac() && remoteIp != null && Companion.isLocalAddress(remoteIp)) {
                this.sendMacLocalConnectionWarning(remoteIp);
            }
        }
        Font[] fontArray = PFontManager.INSTANCE.getAllInstalledFonts();
        ProtocolType protocolType = toServerDecoder.getProtocolType();
        CompressionType compressionType = toServerDecompressor.getCompressionType();
        ProtocolType protocolType2 = toClientEncoder.getProtocolType();
        CompressionType compressionType2 = toClientCompressor.getCompressionType();
        boolean $i$f$mapNotNull = false;
        void var13_17 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        for (void element$iv$iv$iv : $this$forEach$iv$iv$iv) {
            Short it$iv$iv;
            void element$iv$iv = element$iv$iv$iv;
            boolean bl2 = false;
            void font = element$iv$iv;
            boolean bl3 = false;
            if (FontCacher.INSTANCE.getId((Font)font) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection<FontDataHolder> collection = (List)destination$iv$iv;
        $this$mapNotNull$iv = collection;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fontId;
            short s = ((Number)item$iv$iv).shortValue();
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(FontCacher.INSTANCE.getFontData((short)fontId));
        }
        collection = (List)destination$iv$iv;
        ServerWindowColorsEvent.ColorsStorage colorsStorage = this.ideaColors.getColors();
        Collection<FontDataHolder> collection2 = collection;
        ProtocolType protocolType3 = protocolType;
        CompressionType compressionType3 = compressionType;
        ProtocolType protocolType4 = protocolType2;
        CompressionType compressionType4 = compressionType2;
        ToClientHandshakeSuccessEvent successEvent = new ToClientHandshakeSuccessEvent(compressionType4, protocolType4, compressionType3, protocolType3, (List<FontDataHolder>)collection2, colorsStorage);
        conn.send(KotlinxJsonToClientHandshakeEncoder.INSTANCE.encode(successEvent));
        conn.setSettings(new SetUpClientSettings(supportedHandshakeClientSettings.getConnectionMillis(), supportedHandshakeClientSettings.getAddress(), new SetUpClientData(hasWriteAccess, toClientEncoder, toClientCompressor, toServerDecoder, toServerDecompressor)));
        if (hasWriteAccess) {
            PGraphicsEnvironment.Companion.setClientDoesWindowManagement(toServerHandshakeEvent.getClientDoesWindowManagement());
            SwingUtilities.invokeAndWait(() -> ProjectorServer.setUpClient$lambda-33(toServerHandshakeEvent));
        }
        this.clientEventHandler.updateClientsCount();
    }

    private final void sendPictures(List<? extends ServerEvent> dataToSend) {
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport transport = (ServerTransport)element$iv;
            boolean bl = false;
            transport.forEachOpenedConnection((Function1<? super ClientWrapper, Unit>)((Function1)new Function1<ClientWrapper, Unit>(dataToSend){
                final /* synthetic */ List<ServerEvent> $dataToSend;
                {
                    this.$dataToSend = $dataToSend;
                    super(1);
                }

                public final void invoke(@NotNull ClientWrapper client) {
                    Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                    Object object = client.getSettings();
                    ReadyClientSettings readyClientSettings = object instanceof ReadyClientSettings ? (ReadyClientSettings)object : null;
                    if (readyClientSettings == null) {
                        return;
                    }
                    ReadyClientSettings readyClientSettings2 = readyClientSettings;
                    object = readyClientSettings2.getSetUpClientData();
                    List<ServerEvent> list = this.$dataToSend;
                    Object $this$invoke_u24lambda_u2d0 = object;
                    boolean bl = false;
                    List<E> requestedData = TransformKt.extractData((Iterable)readyClientSettings2.getRequestedData());
                    List message2 = SequencesKt.toList(readyClientSettings2.getInterestManager().filterEvents((Sequence<? extends ServerEvent>)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)requestedData), (Sequence)CollectionsKt.asSequence((Iterable)list))));
                    if (message2.isEmpty()) {
                        return;
                    }
                    byte[] encoded = (byte[])((SetUpClientData)$this$invoke_u24lambda_u2d0).getToClientMessageEncoder().encode(message2);
                    byte[] compressed = ((SetUpClientData)$this$invoke_u24lambda_u2d0).getToClientMessageCompressor().compress(encoded);
                    client.send(compressed);
                }
            }));
        }
    }

    private final boolean areChangedWindows(List<WindowData> windowEvents) {
        boolean hasDifferentWindowEvents;
        Set set = CollectionsKt.toSet((Iterable)windowEvents);
        boolean bl = hasDifferentWindowEvents = !Intrinsics.areEqual((Object)set, this.previousWindowEvents);
        if (hasDifferentWindowEvents) {
            this.previousWindowEvents = set;
        }
        return hasDifferentWindowEvents;
    }

    public final void start() {
        this.updateThread = this.createUpdateThread();
        this.caretInfoUpdater.start();
        Iterable $this$forEach$iv = WebsocketServer.INSTANCE.createTransportBuilders$projector_server_common();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WsTransportBuilder it = (WsTransportBuilder)element$iv;
            boolean bl = false;
            this.addTransport(it.attachDefaultServerEventHandlers(this.getClientEventHandler()).build());
        }
    }

    public final void addTransport(@NotNull ServerTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        this.transports.add(transport);
        transport.start();
    }

    public final boolean removeTransport(@NotNull ServerTransport transport, int timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        boolean removed = this.transports.remove(transport);
        if (removed) {
            transport.stop(timeoutMs);
        }
        return removed;
    }

    public static /* synthetic */ boolean removeTransport$default(ProjectorServer projectorServer, ServerTransport serverTransport, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return projectorServer.removeTransport(serverTransport, n);
    }

    @JvmOverloads
    public final void stop(int timeout) {
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport it = (ServerTransport)element$iv;
            boolean bl = false;
            it.stop(timeout);
        }
        this.transports.clear();
        this.caretInfoUpdater.stop();
        if (this.updateThread != null) {
            Thread thread = this.updateThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"updateThread");
                thread = null;
            }
            thread.interrupt();
        }
    }

    public static /* synthetic */ void stop$default(ProjectorServer projectorServer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        projectorServer.stop(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isStopped() {
        if (this.updateThread == null) return true;
        Thread thread = this.updateThread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateThread");
            thread = null;
        }
        if (thread.getState() != Thread.State.TERMINATED) return false;
        return true;
    }

    @NotNull
    public final String[][] getClientList() {
        ArrayList<String[]> s = new ArrayList<String[]>();
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport transport = (ServerTransport)element$iv;
            boolean bl = false;
            transport.forEachOpenedConnection((Function1<? super ClientWrapper, Unit>)((Function1)new Function1<ClientWrapper, Unit>(s){
                final /* synthetic */ ArrayList<String[]> $s;
                {
                    this.$s = $s;
                    super(1);
                }

                public final void invoke(@NotNull ClientWrapper it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    InetAddress remoteAddress = it.getConfirmationRemoteIp();
                    if (remoteAddress != null) {
                        String[] stringArray = new String[]{remoteAddress.getHostAddress(), "resolving ..."};
                        this.$s.add(stringArray);
                    } else {
                        String name = it.getConfirmationRemoteName();
                        String[] stringArray = new String[]{name, name};
                        this.$s.add(stringArray);
                    }
                }
            }));
        }
        Iterable $this$distinctBy$iv = s;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String[] it = (String[])e$iv;
            boolean bl = false;
            String key$iv = it[0];
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Collection $this$toTypedArray$iv = list$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv.toArray((T[])new String[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return (String[][])TArray;
    }

    public final void disconnectAll() {
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport transport = (ServerTransport)element$iv;
            boolean bl = false;
            transport.forEachOpenedConnection((Function1<? super ClientWrapper, Unit>)((Function1)disconnectAll.1.1.INSTANCE));
        }
    }

    public final void disconnectByIp(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport transport = (ServerTransport)element$iv;
            boolean bl = false;
            transport.forEachOpenedConnection((Function1<? super ClientWrapper, Unit>)((Function1)new Function1<ClientWrapper, Unit>(ip){
                final /* synthetic */ String $ip;
                {
                    this.$ip = $ip;
                    super(1);
                }

                public final void invoke(@NotNull ClientWrapper it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    InetAddress inetAddress = it.getConfirmationRemoteIp();
                    if (Intrinsics.areEqual((Object)(inetAddress == null ? null : inetAddress.getHostAddress()), (Object)this.$ip)) {
                        it.disconnect("The host has disconnected the address: " + this.$ip + ".");
                    }
                }
            }));
        }
    }

    @JvmOverloads
    public final void stop() {
        ProjectorServer.stop$default(this, 0, 1, null);
    }

    private static final void processMessage$lambda-7(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        ProjectorServer.Companion.resize(((ClientResizeEvent)$message).getSize().getWidth(), ((ClientResizeEvent)$message).getSize().getHeight());
    }

    /*
     * WARNING - void declaration
     */
    private static final void processMessage$lambda-9(ClientEvent $message) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Iterable iterable = ((ClientDisplaySetChangeEvent)$message).getNewDisplays();
        PGraphicsEnvironment.Companion companion = PGraphicsEnvironment.Companion;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DisplayDescription displayDescription = (DisplayDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)new Rectangle(it.getX(), it.getY(), it.getWidth(), it.getHeight()), (Object)it.getScaleFactor()));
        }
        companion.setupDisplays((List)destination$iv$iv);
    }

    private static final void processMessage$lambda-10(ClientEvent $message, ReadyClientSettings $clientSettings, ProjectorServer this$0) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$clientSettings, (String)"$clientSettings");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ClientMouseEvent shiftedMessage = ClientEventExtensionsKt.shift((ClientMouseEvent)$message, PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift());
        PMouseInfoPeer.INSTANCE.getLastMouseCoords().setLocation(shiftedMessage.getX(), shiftedMessage.getY());
        PWindow pWindow = PWindow.Companion.getWindow(((ClientMouseEvent)$message).getWindowId());
        Component window = pWindow == null ? null : pWindow.getTarget();
        PMouseInfoPeer.INSTANCE.setLastWindowUnderMouse(window);
        if (window == null) {
            return;
        }
        ReadyClientSettings.TouchState touchState = MouseKt.calculateNewTouchState(shiftedMessage, (ClientMouseEvent)$message, $clientSettings.getTouchState());
        if (touchState == null) {
            return;
        }
        ReadyClientSettings.TouchState newTouchState = touchState;
        if (!window.isShowing()) {
            return;
        }
        MouseEvent mouseEvent = MouseKt.createMouseEvent(window, shiftedMessage, $clientSettings.getTouchState(), newTouchState, $clientSettings.getConnectionMillis());
        $clientSettings.setTouchState(newTouchState);
        this$0.laterInvokator.invoke(mouseEvent);
    }

    private static final void processMessage$lambda-11(ClientEvent $message, ReadyClientSettings $clientSettings, ProjectorServer this$0) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$clientSettings, (String)"$clientSettings");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ClientWheelEvent shiftedMessage = ClientEventExtensionsKt.shift((ClientWheelEvent)$message, PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift());
        PMouseInfoPeer.INSTANCE.getLastMouseCoords().setLocation(shiftedMessage.getX(), shiftedMessage.getY());
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWheelEvent)$message).getWindowId());
        Component window = pWindow == null ? null : pWindow.getTarget();
        PMouseInfoPeer.INSTANCE.setLastWindowUnderMouse(window);
        if (window == null) {
            return;
        }
        MouseWheelEvent mouseWheelEvent = MouseKt.createMouseWheelEvent(window, shiftedMessage, $clientSettings.getConnectionMillis());
        this$0.laterInvokator.invoke(mouseWheelEvent);
    }

    private static final void processMessage$lambda-13$lambda-12(ProjectorServer this$0, KeyEvent $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        this$0.laterInvokator.invoke($it);
    }

    private static final void processMessage$lambda-15$lambda-14(ProjectorServer this$0, KeyEvent $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        this$0.laterInvokator.invoke($it);
    }

    private static final void processMessage$lambda-16(ProjectorServer this$0, ClientEvent $message, ReadyClientSettings $clientSettings) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$clientSettings, (String)"$clientSettings");
        this$0.laterInvokator.invoke(KeyKt.toAwtKeyEvent((ClientRawKeyEvent)$message, $clientSettings.getConnectionMillis(), AwtKt.focusOwnerOrTarget(((PWindow)CollectionsKt.last(PWindow.Companion.getWindows())).getTarget())));
    }

    private static final void processMessage$lambda-18(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowMoveEvent)$message).getWindowId());
        if (pWindow != null) {
            PWindow pWindow2;
            PWindow $this$processMessage_u24lambda_u2d18_u24lambda_u2d17 = pWindow2 = pWindow;
            boolean bl = false;
            $this$processMessage_u24lambda_u2d18_u24lambda_u2d17.move(((ClientWindowMoveEvent)$message).getDeltaX(), ((ClientWindowMoveEvent)$message).getDeltaY());
        }
    }

    private static final void processMessage$lambda-20(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowResizeEvent)$message).getWindowId());
        if (pWindow != null) {
            PWindow pWindow2;
            PWindow $this$processMessage_u24lambda_u2d20_u24lambda_u2d19 = pWindow2 = pWindow;
            boolean bl = false;
            $this$processMessage_u24lambda_u2d20_u24lambda_u2d19.resize(((ClientWindowResizeEvent)$message).getDeltaX(), ((ClientWindowResizeEvent)$message).getDeltaY(), ConvertKt.toDirection(((ClientWindowResizeEvent)$message).getDirection()));
        }
    }

    private static final void processMessage$lambda-23(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowSetBoundsEvent)$message).getWindowId());
        if (pWindow != null) {
            PWindow pWindow2;
            PWindow $this$processMessage_u24lambda_u2d23_u24lambda_u2d22 = pWindow2 = pWindow;
            boolean bl = false;
            CommonIntRectangle $this$processMessage_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21 = ((ClientWindowSetBoundsEvent)$message).getBounds();
            boolean bl2 = false;
            $this$processMessage_u24lambda_u2d23_u24lambda_u2d22.setBounds($this$processMessage_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.getX(), $this$processMessage_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.getY(), $this$processMessage_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.getWidth(), $this$processMessage_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.getHeight());
        }
    }

    private static final void processMessage$lambda-24(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowCloseEvent)$message).getWindowId());
        if (pWindow != null) {
            pWindow.close();
        }
    }

    private static final void processMessage$lambda-25(ReadyClientSettings $clientSettings, ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$clientSettings, (String)"$clientSettings");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        $clientSettings.getInterestManager().processClientEvent((ClientWindowInterestEvent)$message);
    }

    private static final void setUpClient$sendHandshakeFailureEvent(ClientWrapper $conn, String reason) {
        ToClientHandshakeFailureEvent failureEvent = new ToClientHandshakeFailureEvent(reason);
        $conn.send(KotlinxJsonToClientHandshakeEncoder.INSTANCE.encode(failureEvent));
    }

    /*
     * WARNING - void declaration
     */
    private static final void setUpClient$lambda-28(boolean $hasWriteAccess, Ref.BooleanRef $resp, ClientWrapper $conn) {
        Boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)$resp, (String)"$resp");
        Intrinsics.checkNotNullParameter((Object)$conn, (String)"$conn");
        boolean bl2 = $hasWriteAccess;
        if (bl2) {
            string = "read-write";
        } else if (!bl2) {
            string = "read-only";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String accessType = string;
        Ref.BooleanRef booleanRef = $resp;
        InetAddress inetAddress = $conn.getConfirmationRemoteIp();
        if (inetAddress == null) {
            bl = null;
        } else {
            void it;
            InetAddress inetAddress2 = inetAddress;
            Ref.BooleanRef booleanRef2 = booleanRef;
            boolean bl3 = false;
            bl = ConfirmConnection.Companion.confirm((InetAddress)it, accessType);
            booleanRef = booleanRef2;
        }
        booleanRef.element = bl == null ? ConfirmConnection.Companion.confirm($conn.getConfirmationRemoteName(), accessType) : bl.booleanValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final void setUpClient$lambda-33(ToServerHandshakeEvent $toServerHandshakeEvent) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$toServerHandshakeEvent, (String)"$toServerHandshakeEvent");
        Iterable iterable = $toServerHandshakeEvent.getDisplays();
        PGraphicsEnvironment.Companion companion = PGraphicsEnvironment.Companion;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DisplayDescription displayDescription = (DisplayDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)new Rectangle(it.getX(), it.getY(), it.getWidth(), it.getHeight()), (Object)it.getScaleFactor()));
        }
        companion.setupDisplays((List)destination$iv$iv);
        DisplayDescription $this$setUpClient_u24lambda_u2d33_u24lambda_u2d32 = $toServerHandshakeEvent.getDisplays().get(0);
        boolean bl = false;
        ProjectorServer.Companion.resize($this$setUpClient_u24lambda_u2d33_u24lambda_u2d32.getWidth(), $this$setUpClient_u24lambda_u2d33_u24lambda_u2d32.getHeight());
    }

    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @NotNull
    public static final ProjectorServer startServer(boolean isAgent, @NotNull Function1<? super String, ? extends Logger> logFactory, @NotNull Runnable generalInitializer, @NotNull Runnable fullInitializer) {
        return Companion.startServer(isAgent, logFactory, generalInitializer, fullInitializer);
    }

    public static final /* synthetic */ List access$createDataToSend(ProjectorServer $this) {
        return $this.createDataToSend();
    }

    public static final /* synthetic */ void access$sendPictures(ProjectorServer $this, List dataToSend) {
        $this.sendPictures(dataToSend);
    }

    public /* synthetic */ ProjectorServer(LaterInvokator laterInvokator, boolean isAgent, DefaultConstructorMarker $constructor_marker) {
        this(laterInvokator, isAgent);
    }

    public static final /* synthetic */ void access$setWindowColorsEvent$p(ProjectorServer $this, ServerWindowColorsEvent serverWindowColorsEvent) {
        $this.windowColorsEvent = serverWindowColorsEvent;
    }

    public static final /* synthetic */ void access$checkHandshakeVersion(ProjectorServer $this, ClientWrapper conn, ConnectedClientSettings connectedClientSettings, String message2) {
        $this.checkHandshakeVersion(conn, connectedClientSettings, message2);
    }

    public static final /* synthetic */ void access$setUpClient(ProjectorServer $this, ClientWrapper conn, SupportedHandshakeClientSettings supportedHandshakeClientSettings, String message2) {
        $this.setUpClient(conn, supportedHandshakeClientSettings, message2);
    }

    public static final /* synthetic */ void access$setPreviousWindowEvents$p(ProjectorServer $this, Set set) {
        $this.previousWindowEvents = set;
    }

    public static final /* synthetic */ CaretInfoUpdater access$getCaretInfoUpdater$p(ProjectorServer $this) {
        return $this.caretInfoUpdater;
    }

    public static final /* synthetic */ Set access$getTransports$p(ProjectorServer $this) {
        return $this.transports;
    }

    public static final /* synthetic */ void access$notifyObservers(ProjectorServer $this, PropertyChangeEvent event) {
        $this.notifyObservers(event);
    }

    public static final /* synthetic */ void access$processMessage(ProjectorServer $this, ReadyClientSettings clientSettings, ClientEvent message2) {
        $this.processMessage(clientSettings, message2);
    }

    static {
        Integer n;
        Companion = new Companion(null);
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ProjectorServer.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
        ENABLE_BIG_COLLECTIONS_CHECKS = Intrinsics.areEqual((Object)System.getProperty("org.jetbrains.projector.server.debug.collections.checks"), (Object)"true");
        String string2 = System.getProperty("org.jetbrains.projector.server.debug.collections.checks.size");
        BIG_COLLECTIONS_CHECKS_START_SIZE = string2 == null ? 10000 : ((n = StringsKt.toIntOrNull((String)string2)) == null ? 10000 : n);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010.\u001a\u00020/H\u0002J\r\u00100\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b1J\u0006\u00102\u001a\u00020\u0004J\u0013\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0019H\u0000\u00a2\u0006\u0002\b5J\u000e\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u001aJ\u0018\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u0004H\u0002JC\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020\u000f2!\u0010=\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b(A\u0012\u0004\u0012\u00020-0>2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CH\u0007J\u0010\u0010E\u001a\u00020/2\u0006\u0010F\u001a\u00020GH\u0002J\u000e\u0010H\u001a\u0004\u0018\u00010I*\u00020JH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010\u0002\u001a\u0004\b#\u0010\u0011R\u0014\u0010%\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R(\u0010(\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010\u0002\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lorg/jetbrains/projector/server/ProjectorServer$Companion;", "", "()V", "BIG_COLLECTIONS_CHECKS_START_SIZE", "", "getBIG_COLLECTIONS_CHECKS_START_SIZE", "()I", "setBIG_COLLECTIONS_CHECKS_START_SIZE", "(I)V", "DEFAULT_BIG_COLLECTIONS_CHECKS_SIZE", "DEFAULT_PORT", "", "DISABLE_IDEA_UPDATES_PROPERTY_NAME", "ENABLE_AUTO_KEYMAP_SETTING", "ENABLE_BIG_COLLECTIONS_CHECKS", "", "getENABLE_BIG_COLLECTIONS_CHECKS", "()Z", "setENABLE_BIG_COLLECTIONS_CHECKS", "(Z)V", "ENABLE_CONNECTION_CONFIRMATION", "ENABLE_PROPERTY_NAME", "HOST_PROPERTY_NAME", "HOST_PROPERTY_NAME_OLD", "LOCAL_ADDRESSES", "", "Ljava/net/InetAddress;", "kotlin.jvm.PlatformType", "getLOCAL_ADDRESSES", "()Ljava/util/List;", "MAC_KEYBOARD_MODIFIERS_MODE", "PORT_PROPERTY_NAME", "PORT_PROPERTY_NAME_OLD", "RO_TOKEN_ENV_NAME", "TOKEN_ENV_NAME", "isEnabled", "isEnabled$annotations", "isMac", "<set-?>", "Lorg/jetbrains/projector/server/ProjectorServer;", "lastStartedServer", "getLastStartedServer$annotations", "getLastStartedServer", "()Lorg/jetbrains/projector/server/ProjectorServer;", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "calculateMainWindowShift", "", "getEnvHost", "getEnvHost$projector_server_common", "getEnvPort", "getMainWindows", "Lorg/jetbrains/projector/awt/PWindow;", "getMainWindows$projector_server_common", "isLocalAddress", "address", "resize", "width", "height", "startServer", "isAgent", "logFactory", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tag", "generalInitializer", "Ljava/lang/Runnable;", "fullInitializer", "updateToolkitKeyboardModifiersMode", "keymap", "Lorg/jetbrains/projector/common/protocol/data/UserKeymap;", "toServerClipboardEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerClipboardEvent;", "Ljava/awt/datatransfer/Transferable;", "projector-server-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled() {
            boolean bl;
            String string = System.getProperty(ProjectorServer.ENABLE_PROPERTY_NAME);
            return string == null ? false : (bl = Boolean.parseBoolean(string));
        }

        @JvmStatic
        public static /* synthetic */ void isEnabled$annotations() {
        }

        private final ServerClipboardEvent toServerClipboardEvent(Transferable $this$toServerClipboardEvent) {
            ServerClipboardEvent serverClipboardEvent;
            boolean bl = $this$toServerClipboardEvent.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (!bl) {
                serverClipboardEvent = null;
            } else if (bl) {
                Object object = $this$toServerClipboardEvent.getTransferData(DataFlavor.stringFlavor);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                serverClipboardEvent = new ServerClipboardEvent((String)object);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return serverClipboardEvent;
        }

        private final void updateToolkitKeyboardModifiersMode(UserKeymap keymap) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[keymap.ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            PToolkitBase.Companion.setMacKeyboardModifiersMode(bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PWindow> getMainWindows$projector_server_common() {
            List list;
            List list2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PWindow.Companion.getWindows();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PWindow it = (PWindow)element$iv$iv;
                boolean bl = false;
                if (!(ConvertKt.getWindowType(it) == WindowType.IDEA_WINDOW)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List ideWindows = (List)destination$iv$iv;
            if (!((Collection)ideWindows).isEmpty()) {
                return ideWindows;
            }
            PWindow pWindow = (PWindow)CollectionsKt.firstOrNull(PWindow.Companion.getWindows());
            if (pWindow == null) {
                list2 = null;
            } else {
                PWindow p0 = pWindow;
                boolean bl = false;
                list2 = list = CollectionsKt.listOf((Object)p0);
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void calculateMainWindowShift() {
            if (PGraphicsEnvironment.Companion.getClientDoesWindowManagement()) {
                PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift().setLocation(0, 0);
                return;
            }
            PWindow pWindow = (PWindow)CollectionsKt.firstOrNull(this.getMainWindows$projector_server_common());
            if (pWindow != null) {
                Component component = pWindow.getTarget();
                if (component != null) {
                    Component window = component;
                    boolean bl = false;
                    Object object = window.getTreeLock();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"window.treeLock");
                    synchronized (object) {
                        Cloneable it;
                        boolean bl2 = false;
                        double x = 0.0;
                        double y = 0.0;
                        if (window instanceof Frame) {
                            Insets insets = ((Frame)window).getInsets();
                            if (insets != null) {
                                it = insets;
                                boolean bl3 = false;
                                x += (double)((Insets)it).left;
                                y += (double)((Insets)it).top;
                            }
                        }
                        Rectangle rectangle = window.getBounds();
                        if (rectangle != null) {
                            it = rectangle;
                            boolean bl4 = false;
                            x += (double)it.x;
                            y += (double)it.y;
                        }
                        PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift().setLocation(x, y);
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void resize(int width, int height) {
            void $this$mapTo$iv$iv;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge instanceof PGraphicsEnvironment) {
                ((PGraphicsEnvironment)ge).setDefaultDeviceSize(width, height);
            }
            this.calculateMainWindowShift();
            if (PGraphicsEnvironment.Companion.getClientDoesWindowManagement()) {
                return;
            }
            Iterable $this$map$iv = this.getMainWindows$projector_server_common();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PWindow pWindow = (PWindow)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getTarget());
            }
            List mainWindows = (List)destination$iv$iv;
            boolean bl = false;
            SwingUtilities.invokeLater(() -> Companion.resize$lambda-9$lambda-8(mainWindows, width, height));
        }

        @JvmStatic
        @NotNull
        public final ProjectorServer startServer(boolean isAgent, @NotNull Function1<? super String, ? extends Logger> logFactory, @NotNull Runnable generalInitializer, @NotNull Runnable fullInitializer) {
            ProjectorServer projectorServer;
            Intrinsics.checkNotNullParameter(logFactory, (String)"logFactory");
            Intrinsics.checkNotNullParameter((Object)generalInitializer, (String)"generalInitializer");
            Intrinsics.checkNotNullParameter((Object)fullInitializer, (String)"fullInitializer");
            LoggerKt.setLoggerFactory(logFactory);
            ProjectorAwtInitializer.INSTANCE.initProjectorAwt();
            generalInitializer.run();
            if (IdeState.Companion.isIdeAttached()) {
                IjInjectorAgentInitializer.INSTANCE.init(isAgent, IdeState.Companion.isIdeAttached());
            } else {
                Logger.DefaultImpls.info$default(logger, null, startServer.1.INSTANCE, 1, null);
            }
            fullInitializer.run();
            ProjectorAwtInitializer.INSTANCE.initDefaults();
            SettingsInitializer.INSTANCE.addTaskToInitializeIdea(PGraphics2D.Companion.getDefaultAa());
            if (!isAgent && Boolean.parseBoolean(OptionKt.getOption(ProjectorServer.DISABLE_IDEA_UPDATES_PROPERTY_NAME, "true"))) {
                UpdatesConfigKt.forbidUpdates();
            }
            if (this.getENABLE_BIG_COLLECTIONS_CHECKS()) {
                Logger.DefaultImpls.info$default(logger, null, startServer.2.INSTANCE, 1, null);
            }
            ProjectorServer it = projectorServer = new ProjectorServer(LaterInvokator.Companion.getDefaultLaterInvokator(), isAgent, null);
            boolean bl = false;
            lastStartedServer = it;
            it.start();
            return projectorServer;
        }

        @Nullable
        public final ProjectorServer getLastStartedServer() {
            return lastStartedServer;
        }

        public static /* synthetic */ void getLastStartedServer$annotations() {
        }

        public final boolean getENABLE_BIG_COLLECTIONS_CHECKS() {
            return ENABLE_BIG_COLLECTIONS_CHECKS;
        }

        public final void setENABLE_BIG_COLLECTIONS_CHECKS(boolean bl) {
            ENABLE_BIG_COLLECTIONS_CHECKS = bl;
        }

        public final int getBIG_COLLECTIONS_CHECKS_START_SIZE() {
            return BIG_COLLECTIONS_CHECKS_START_SIZE;
        }

        public final void setBIG_COLLECTIONS_CHECKS_START_SIZE(int n) {
            BIG_COLLECTIONS_CHECKS_START_SIZE = n;
        }

        @NotNull
        public final InetAddress getEnvHost$projector_server_common() {
            InetAddress inetAddress;
            String host;
            String string = OptionKt.getOption(ProjectorServer.HOST_PROPERTY_NAME);
            if (string == null) {
                string = OptionKt.getOption(ProjectorServer.HOST_PROPERTY_NAME_OLD);
            }
            if ((host = string) != null) {
                InetAddress inetAddress2 = InetAddress.getByName(host);
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getByName(host)");
                inetAddress = inetAddress2;
            } else {
                inetAddress = HostAddressKt.getWildcardHostAddress();
            }
            return inetAddress;
        }

        public final int getEnvPort() {
            String string = OptionKt.getOption(ProjectorServer.PORT_PROPERTY_NAME);
            if (string == null) {
                string = OptionKt.getOption(ProjectorServer.PORT_PROPERTY_NAME_OLD, ProjectorServer.DEFAULT_PORT);
            }
            return Integer.parseInt(string);
        }

        /*
         * WARNING - void declaration
         */
        private final List<InetAddress> getLOCAL_ADDRESSES() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = NetworkKt.getLocalAddresses(true);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InterfaceAddress interfaceAddress = (InterfaceAddress)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAddress());
            }
            return (List)destination$iv$iv;
        }

        public final boolean isLocalAddress(@NotNull InetAddress address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            return this.getLOCAL_ADDRESSES().contains(address);
        }

        private final boolean isMac() {
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
            return StringsKt.startsWith$default((String)string, (String)"Mac OS", (boolean)false, (int)2, null);
        }

        private static final void resize$lambda-9$lambda-8(List $mainWindows, int $width, int $height) {
            Intrinsics.checkNotNullParameter((Object)$mainWindows, (String)"$mainWindows");
            Iterable $this$forEach$iv = $mainWindows;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                Point point = new Point(PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift());
                int widthWithInsets = 0;
                widthWithInsets = $width;
                int heightWithInsets = 0;
                heightWithInsets = $height;
                if (it instanceof Frame) {
                    if (((Frame)it).getInsets() != null) {
                        Insets i;
                        boolean bl2 = false;
                        point.x -= i.left;
                        point.y -= i.top;
                        widthWithInsets += i.left + i.right;
                        heightWithInsets += i.top + i.bottom;
                    }
                    ((Frame)it).setExtendedState(0);
                }
                it.setBounds(point.x, point.y, widthWithInsets, heightWithInsets);
                it.revalidate();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[UserKeymap.values().length];
                nArray[UserKeymap.WINDOWS.ordinal()] = 1;
                nArray[UserKeymap.LINUX.ordinal()] = 2;
                nArray[UserKeymap.MAC.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientNotificationType.values().length];
            nArray[ClientNotificationType.INFORMATION.ordinal()] = 1;
            nArray[ClientNotificationType.WARNING.ordinal()] = 2;
            nArray[ClientNotificationType.ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

