/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.util.loading;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.util.loading.ProjectorClassLoader;
import org.jetbrains.projector.util.loading.ReflectKt;
import org.jetbrains.projector.util.loading.UseProjectorLoader;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 ;2\u00020\u0001:\u0002:;B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0001J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J2\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010%0$H\u0002J+\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'2\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u0001H'0$H\u0002\u00a2\u0006\u0002\u0010)J\u000e\u0010\u0004\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0006J\u0012\u0010,\u001a\u0004\u0018\u00010\u00012\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0014\u0010-\u001a\u0004\u0018\u00010.2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0016J\u0014\u0010/\u001a\u0004\u0018\u00010%2\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020.012\b\u0010 \u001a\u0004\u0018\u00010\u0006H\u0016J\u001c\u00102\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0014J\u001c\u00103\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u00104\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u00105\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0010\u00106\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u001c\u00107\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\u001e\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001f2\u0006\u0010*\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J \u00102\u001a\u0006\u0012\u0002\b\u00030\u001f*\u00020\u00012\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0002J\f\u00109\u001a\u00020\u0006*\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0003R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/projector/util/loading/ProjectorClassLoader;", "Ljava/lang/ClassLoader;", "parent", "(Ljava/lang/ClassLoader;)V", "forceLoadByIdea", "", "", "forceLoadByOurselves", "forceLoadByPlatform", "ideaClassLoader", "getIdeaClassLoader$annotations", "()V", "getIdeaClassLoader", "()Ljava/lang/ClassLoader;", "setIdeaClassLoader", "jarFiles", "loadMethod", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "myIdeaLoader", "getMyIdeaLoader", "pluginClassLoaders", "", "addJarSource", "", "jarPath", "addPluginLoader", "classNamePrefix", "classLoader", "appendToClassPathForInstrumentation", "defineClass", "Ljava/lang/Class;", "name", "resolve", "", "inputStreamProvider", "Lkotlin/Function1;", "Ljava/io/InputStream;", "findInClassloaders", "T", "transform", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "className", "forceLoadByProjectorClassLoader", "getPluginClassLoader", "getResource", "Ljava/net/URL;", "getResourceAsStream", "getResources", "Ljava/util/Enumeration;", "loadClass", "loadProjectorAgentClass", "mustBeLoadedByIdea", "mustBeLoadedByOurselves", "mustBeLoadedByPlatform", "redefineClassIfNeeded", "tryLoadViaPluginClassLoader", "toClassFileName", "ActualLoader", "Companion", "projector-util-loading"})
public final class ProjectorClassLoader
extends ClassLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ClassLoader ideaClassLoader;
    private final Method loadMethod;
    @NotNull
    private final Set<String> forceLoadByPlatform;
    @NotNull
    private final Set<String> forceLoadByOurselves;
    @NotNull
    private final Set<String> forceLoadByIdea;
    @NotNull
    private final Set<String> jarFiles;
    @NotNull
    private final Map<String, ClassLoader> pluginClassLoaders;
    @NotNull
    private static final String INTELLIJ_PACKAGE_PREFIX = "com.intellij.";
    @NotNull
    private static final String JETBRAINS_PACKAGE_PREFIX = "org.jetbrains.";
    @NotNull
    private static final String PROJECTOR_PACKAGE_PREFIX = "org.jetbrains.projector.";
    @NotNull
    private static final String PROJECTOR_AGENT_PACKAGE_PREFIX = "org.jetbrains.projector.agent.";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy<ClassLoader> myAppClassLoader$delegate;
    @Nullable
    private static ProjectorClassLoader myInstance;

    /*
     * WARNING - void declaration
     */
    public ProjectorClassLoader(@Nullable ClassLoader parent) {
        super(parent);
        void p0;
        Object object = new Class[]{String.class, Boolean.TYPE};
        Object object2 = object = ClassLoader.class.getDeclaredMethod("loadClass", (Class<?>)object);
        ProjectorClassLoader projectorClassLoader = this;
        boolean bl = false;
        ReflectKt.unprotect((Method)p0);
        projectorClassLoader.loadMethod = object;
        this.forceLoadByPlatform = new LinkedHashSet();
        this.forceLoadByOurselves = new LinkedHashSet();
        this.forceLoadByIdea = new LinkedHashSet();
        this.jarFiles = new LinkedHashSet();
        this.pluginClassLoaders = new LinkedHashMap();
        if (myInstance == null) {
            myInstance = this;
        }
    }

    public /* synthetic */ ProjectorClassLoader(ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            classLoader = null;
        }
        this(classLoader);
    }

    @Nullable
    public final ClassLoader getIdeaClassLoader() {
        return this.ideaClassLoader;
    }

    public final void setIdeaClassLoader(@Nullable ClassLoader classLoader) {
        this.ideaClassLoader = classLoader;
    }

    public static /* synthetic */ void getIdeaClassLoader$annotations() {
    }

    private final ClassLoader getMyIdeaLoader() {
        ClassLoader classLoader = this.ideaClassLoader;
        if (classLoader == null) {
            classLoader = ProjectorClassLoader.Companion.getMyAppClassLoader();
        }
        return classLoader;
    }

    public final void forceLoadByPlatform(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        ((Collection)this.forceLoadByPlatform).add(className);
    }

    public final void forceLoadByProjectorClassLoader(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        ((Collection)this.forceLoadByOurselves).add(className);
    }

    public final void forceLoadByIdea(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        ((Collection)this.forceLoadByIdea).add(className);
    }

    public final void addPluginLoader(@NotNull String classNamePrefix, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classNamePrefix, (String)"classNamePrefix");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Map<String, ClassLoader> map = this.pluginClassLoaders;
        Pair pair = TuplesKt.to((Object)classNamePrefix, (Object)classLoader);
        map.put((String)pair.getFirst(), (ClassLoader)pair.getSecond());
    }

    private final boolean mustBeLoadedByPlatform(String name) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.forceLoadByPlatform;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean mustBeLoadedByOurselves(String name) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.forceLoadByOurselves;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean mustBeLoadedByIdea(String name) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.forceLoadByIdea;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Class<?> loadClass(@NotNull String name, boolean resolve) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.getClassLoadingLock(name);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getClassLoadingLock(name)");
        synchronized (object) {
            Class<?> clazz;
            block11: {
                boolean bl = false;
                Class<?> found = this.findLoadedClass(name);
                if (found == null) break block11;
                Class<?> clazz2 = found;
                return clazz2;
            }
            if (this.mustBeLoadedByOurselves(name)) {
                clazz = this.defineClass(name, resolve, (Function1<? super String, ? extends InputStream>)((Function1)new Function1<String, InputStream>((Object)this){

                    @Nullable
                    public final InputStream invoke(@Nullable String p0) {
                        return ((ProjectorClassLoader)this.receiver).getResourceAsStream(p0);
                    }
                }));
            } else if (this.mustBeLoadedByPlatform(name)) {
                clazz = this.loadClass(ProjectorClassLoader.Companion.getMyAppClassLoader(), name, resolve);
            } else if (ProjectorClassLoader.Companion.isIntellijClass(name) || this.mustBeLoadedByIdea(name)) {
                clazz = this.loadClass(this.getMyIdeaLoader(), name, resolve);
            } else {
                clazz = this.tryLoadViaPluginClassLoader(name, resolve);
                if (clazz == null) {
                    clazz = this.redefineClassIfNeeded(name, resolve);
                }
            }
            Class<?> clazz3 = clazz;
            return clazz3;
        }
    }

    private final Class<?> loadClass(ClassLoader $this$loadClass, String name, boolean resolve) {
        Class clazz;
        try {
            Object[] objectArray = new Object[]{name, resolve};
            Object object = this.loadMethod.invoke((Object)$this$loadClass, objectArray);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            clazz = (Class)object;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"e.targetException");
            throw throwable;
        }
        return clazz;
    }

    private final String toClassFileName(String $this$toClassFileName) {
        return StringsKt.replace$default((String)$this$toClassFileName, (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class";
    }

    private final Class<?> loadProjectorAgentClass(String name, boolean resolve) {
        return this.defineClass(name, resolve, (Function1<? super String, ? extends InputStream>)((Function1)new Function1<String, InputStream>(this){
            final /* synthetic */ ProjectorClassLoader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final InputStream invoke(@NotNull String classFileName) {
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)classFileName, (String)"classFileName");
                Iterable $this$mapNotNull$iv = ProjectorClassLoader.access$getJarFiles$p(this.this$0);
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    InputStream it$iv$iv;
                    JarEntry entry;
                    JarFile jarFile;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String jarPath = (String)element$iv$iv;
                    boolean bl2 = false;
                    File file = new File(jarPath);
                    if ((!file.exists() ? null : ((jarFile = new JarFile(file)).getJarEntry(classFileName) == null ? null : jarFile.getInputStream(entry))) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (InputStream)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            }
        }));
    }

    private final Class<?> tryLoadViaPluginClassLoader(String className, boolean resolve) {
        Class clazz;
        try {
            ClassLoader classLoader = this.getPluginClassLoader(className);
            clazz = classLoader == null ? null : this.loadClass(classLoader, className, resolve);
        }
        catch (Throwable throwable) {
            clazz = null;
        }
        Class classFromPlugin = clazz;
        return classFromPlugin;
    }

    private final ClassLoader getPluginClassLoader(String className) {
        Object classLoader = null;
        int longestSequenceLength = 0;
        Iterable $this$forEach$iv = this.pluginClassLoaders.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            if (((String)it.getKey()).length() <= longestSequenceLength || !StringsKt.startsWith$default((String)className, (String)((String)it.getKey()), (boolean)false, (int)2, null)) continue;
            classLoader = it.getValue();
            longestSequenceLength = ((String)it.getKey()).length();
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Class<?> defineClass(String name, boolean resolve, Function1<? super String, ? extends InputStream> inputStreamProvider) {
        byte[] byArray;
        InputStream inputStream = (InputStream)inputStreamProvider.invoke((Object)this.toClassFileName(name));
        if (inputStream == null) {
            byArray = null;
        } else {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray2 = it.readAllBytes();
                byArray = byArray2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        if (byArray == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] bytes = byArray;
        Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
        if (resolve) {
            this.resolveClass(clazz);
        }
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"clazz");
        return clazz;
    }

    private final Class<?> redefineClassIfNeeded(String name, boolean resolve) {
        Class<?> clazz;
        Class<?> appClass = this.loadClass(ProjectorClassLoader.Companion.getMyAppClassLoader(), name, resolve);
        UseProjectorLoader useProjectorLoader = appClass.getAnnotation(UseProjectorLoader.class);
        if (useProjectorLoader == null) {
            return appClass;
        }
        UseProjectorLoader loadingSetup = useProjectorLoader;
        Object scope = loadingSetup.attachPackage() ? appClass.getPackageName() + "." : appClass.getName();
        switch (WhenMappings.$EnumSwitchMapping$0[loadingSetup.loader().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"scope");
                this.forceLoadByPlatform((String)scope);
                clazz = this.loadClass(ProjectorClassLoader.Companion.getMyAppClassLoader(), name, resolve);
                break;
            }
            case 2: {
                Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"scope");
                this.forceLoadByIdea((String)scope);
                clazz = this.loadClass(this.getMyIdeaLoader(), name, resolve);
                break;
            }
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"scope");
                this.forceLoadByProjectorClassLoader((String)scope);
                clazz = this.defineClass(name, resolve, (Function1<? super String, ? extends InputStream>)((Function1)new Function1<String, InputStream>((Object)this){

                    @Nullable
                    public final InputStream invoke(@Nullable String p0) {
                        return ((ProjectorClassLoader)this.receiver).getResourceAsStream(p0);
                    }
                }));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T findInClassloaders(Function1<? super ClassLoader, ? extends T> transform) {
        void $this$fold$iv;
        Object object = new ClassLoader[]{ProjectorClassLoader.Companion.getMyAppClassLoader(), this.ideaClassLoader};
        object = CollectionsKt.listOf((Object[])object);
        Object initial$iv = null;
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void var11_11;
            void loader;
            ClassLoader classLoader = (ClassLoader)element$iv;
            Object value = accumulator$iv;
            boolean bl = false;
            accumulator$iv = value == null ? (loader == null ? null : transform.invoke((Object)var11_11)) : value;
        }
        return (T)accumulator$iv;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(@Nullable String name) {
        InputStream inputStream = (InputStream)this.findInClassloaders((Function1)new Function1<ClassLoader, InputStream>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @Nullable
            public final InputStream invoke(@NotNull ClassLoader it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getResourceAsStream(this.$name);
            }
        });
        if (inputStream == null) {
            inputStream = super.getResourceAsStream(name);
        }
        return inputStream;
    }

    @Override
    @Nullable
    public URL getResource(@Nullable String name) {
        URL uRL = (URL)this.findInClassloaders((Function1)new Function1<ClassLoader, URL>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @Nullable
            public final URL invoke(@NotNull ClassLoader it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getResource(this.$name);
            }
        });
        if (uRL == null) {
            uRL = super.getResource(name);
        }
        return uRL;
    }

    @Override
    @NotNull
    public Enumeration<URL> getResources(@Nullable String name) {
        Enumeration<URL> enumeration = (Enumeration<URL>)this.findInClassloaders((Function1)new Function1<ClassLoader, Enumeration<URL>>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @Nullable
            public final Enumeration<URL> invoke(@NotNull ClassLoader it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getResources(this.$name);
            }
        });
        if (enumeration == null) {
            Enumeration<URL> enumeration2 = super.getResources(name);
            Intrinsics.checkNotNullExpressionValue(enumeration2, (String)"super.getResources(name)");
            enumeration = enumeration2;
        }
        return enumeration;
    }

    public final void addJarSource(@NotNull String jarPath) {
        Intrinsics.checkNotNullParameter((Object)jarPath, (String)"jarPath");
        ((Collection)this.jarFiles).add(jarPath);
    }

    private final void appendToClassPathForInstrumentation(String jarPath) {
        this.addJarSource(jarPath);
    }

    public ProjectorClassLoader() {
        this(null, 1, null);
    }

    @NotNull
    public static final ProjectorClassLoader getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Set access$getJarFiles$p(ProjectorClassLoader $this) {
        return $this.jarFiles;
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ProjectorClassLoader.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger(string);
        myAppClassLoader$delegate = LazyKt.lazy((Function0)Companion.myAppClassLoader.2.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/projector/util/loading/ProjectorClassLoader$Companion;", "", "()V", "INTELLIJ_PACKAGE_PREFIX", "", "JETBRAINS_PACKAGE_PREFIX", "PROJECTOR_AGENT_PACKAGE_PREFIX", "PROJECTOR_PACKAGE_PREFIX", "instance", "Lorg/jetbrains/projector/util/loading/ProjectorClassLoader;", "getInstance$annotations", "getInstance", "()Lorg/jetbrains/projector/util/loading/ProjectorClassLoader;", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "myAppClassLoader", "Ljava/lang/ClassLoader;", "getMyAppClassLoader", "()Ljava/lang/ClassLoader;", "myAppClassLoader$delegate", "Lkotlin/Lazy;", "myInstance", "isIntellijClass", "", "name", "isProjectorClass", "projector-util-loading"})
    public static final class Companion {
        private Companion() {
        }

        private final ClassLoader getMyAppClassLoader() {
            Lazy lazy = myAppClassLoader$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-myAppClassLoader>(...)");
            return (ClassLoader)object;
        }

        @NotNull
        public final ProjectorClassLoader getInstance() {
            ProjectorClassLoader projectorClassLoader = myInstance;
            if (projectorClassLoader == null) {
                projectorClassLoader = new ProjectorClassLoader(null, 1, null);
            }
            return projectorClassLoader;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        private final boolean isProjectorClass(String name) {
            return StringsKt.startsWith$default((String)name, (String)ProjectorClassLoader.PROJECTOR_PACKAGE_PREFIX, (boolean)false, (int)2, null);
        }

        private final boolean isIntellijClass(String name) {
            return StringsKt.startsWith$default((String)name, (String)ProjectorClassLoader.INTELLIJ_PACKAGE_PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)ProjectorClassLoader.JETBRAINS_PACKAGE_PREFIX, (boolean)false, (int)2, null) && !this.isProjectorClass(name);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/projector/util/loading/ProjectorClassLoader$ActualLoader;", "", "(Ljava/lang/String;I)V", "PLATFORM", "IDE", "PROJECTOR", "projector-util-loading"})
    public static final class ActualLoader
    extends Enum<ActualLoader> {
        public static final /* enum */ ActualLoader PLATFORM = new ActualLoader();
        public static final /* enum */ ActualLoader IDE = new ActualLoader();
        public static final /* enum */ ActualLoader PROJECTOR = new ActualLoader();
        private static final /* synthetic */ ActualLoader[] $VALUES;

        public static ActualLoader[] values() {
            return (ActualLoader[])$VALUES.clone();
        }

        public static ActualLoader valueOf(String value) {
            return Enum.valueOf(ActualLoader.class, value);
        }

        static {
            $VALUES = actualLoaderArray = new ActualLoader[]{ActualLoader.PLATFORM, ActualLoader.IDE, ActualLoader.PROJECTOR};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActualLoader.values().length];
            nArray[ActualLoader.PLATFORM.ordinal()] = 1;
            nArray[ActualLoader.IDE.ordinal()] = 2;
            nArray[ActualLoader.PROJECTOR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

