/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.InstructionsUtil;
import com.intellij.rt.coverage.instrumentation.CoverageTransformer;
import com.intellij.rt.coverage.instrumentation.dataAccess.EmptyCoverageDataAccess;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.StringsPool;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.InputStream;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class UnloadedUtil {
    public static final MethodVisitor EMPTY_METHOD_VISITOR = new MethodVisitor(589824){};
    public static final ClassVisitor EMPTY_CLASS_VISITOR = new ClassVisitor(589824){

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return EMPTY_METHOD_VISITOR;
        }
    };

    public static void appendUnloaded(final ProjectData projectData, ClassFinder classFinder, final boolean calculateSource, final boolean branchCoverage) {
        classFinder.iterateMatchedClasses(new ClassEntry.Consumer(){

            public void consume(ClassEntry classEntry) {
                ClassData cd = projectData.getClassData(StringsPool.getFromPool(classEntry.getClassName()));
                if (cd != null && cd.getLines() != null && cd.isFullyAnalysed()) {
                    return;
                }
                try {
                    InputStream is = classEntry.getClassInputStream();
                    if (is == null) {
                        return;
                    }
                    UnloadedUtil.appendUnloadedClass(projectData, classEntry.getClassName(), new ClassReader(is), branchCoverage, calculateSource, false);
                }
                catch (Throwable e) {
                    ErrorReporter.reportError("Failed to process unloaded class: " + classEntry.getClassName() + ", error: " + e.getMessage(), e);
                }
            }
        });
    }

    public static void appendUnloadedClass(ProjectData projectData, String className, ClassReader reader, boolean branchCoverage, boolean calculateSource) {
        UnloadedUtil.appendUnloadedClass(projectData, className, reader, branchCoverage, calculateSource, true);
    }

    private static void appendUnloadedClass(ProjectData projectData, String className, ClassReader reader, boolean branchCoverage, boolean calculateSource, boolean checkLineMappings) {
        LineData[] lines;
        ClassVisitor visitor = CoverageTransformer.createInstrumenter(projectData, className, reader, EMPTY_CLASS_VISITOR, null, branchCoverage, calculateSource, EmptyCoverageDataAccess.INSTANCE);
        if (visitor == null) {
            return;
        }
        reader.accept(visitor, 4);
        ClassData classData = projectData.getClassData(className);
        if (classData == null || classData.getLines() == null) {
            return;
        }
        classData.dropIgnoredLines();
        for (LineData line : lines = (LineData[])classData.getLines()) {
            if (line == null) continue;
            classData.registerMethodSignature(line);
        }
        if (!checkLineMappings) {
            return;
        }
        Map<String, FileMapData[]> linesMap = projectData.getLinesMap();
        if (linesMap == null) {
            return;
        }
        FileMapData[] mappings = linesMap.remove(className);
        if (mappings == null) {
            return;
        }
        classData.dropMappedLines(mappings);
        InstructionsUtil.dropMappedLines(projectData, classData.getName(), mappings);
    }
}

