/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.publisher;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.publisher.CloudClient;
import org.jetbrains.qodana.publisher.PublisherException;
import org.jetbrains.qodana.publisher.schemas.FinishRequest;
import org.jetbrains.qodana.publisher.schemas.FinishResponse;
import org.jetbrains.qodana.publisher.schemas.PublishRequest;
import org.jetbrains.qodana.publisher.schemas.PublishResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c*\b\u0012\u0004\u0012\u00020\u00030\u001cH\u0002J*\u0010\u001d\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e\"\u0006\b\u0000\u0010\u001e\u0018\u0001*\u00020\u000e2\u0006\u0010\u001f\u001a\u0002H\u001eH\u0082\b\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lorg/jetbrains/qodana/publisher/CloudClient;", "", "token", "", "endpoint", "client", "Ljava/net/http/HttpClient;", "(Ljava/lang/String;Ljava/lang/String;Ljava/net/http/HttpClient;)V", "Ljava/net/URI;", "(Ljava/lang/String;Ljava/net/URI;Ljava/net/http/HttpClient;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "requestBuilder", "Ljava/net/http/HttpRequest$Builder;", "getRequestBuilder", "()Ljava/net/http/HttpRequest$Builder;", "finishUpload", "Lorg/jetbrains/qodana/publisher/schemas/FinishResponse;", "reportId", "requestBody", "Lorg/jetbrains/qodana/publisher/schemas/FinishRequest;", "(Ljava/lang/String;Lorg/jetbrains/qodana/publisher/schemas/FinishRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startUpload", "Lorg/jetbrains/qodana/publisher/schemas/PublishResponse;", "Lorg/jetbrains/qodana/publisher/schemas/PublishRequest;", "(Lorg/jetbrains/qodana/publisher/schemas/PublishRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleFailure", "Ljava/net/http/HttpResponse;", "post", "T", "body", "(Ljava/net/http/HttpRequest$Builder;Ljava/lang/Object;)Ljava/net/http/HttpRequest$Builder;", "publisher"})
public final class CloudClient {
    @NotNull
    private final String token;
    @NotNull
    private final URI endpoint;
    @NotNull
    private final HttpClient client;
    private final Logger logger;

    public CloudClient(@NotNull String token, @NotNull URI endpoint, @NotNull HttpClient client) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.token = token;
        this.endpoint = endpoint;
        this.client = client;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public CloudClient(@NotNull String token, @NotNull String endpoint, @NotNull HttpClient client) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this(token, new URI(endpoint), client);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startUpload(@NotNull PublishRequest var1_1, @NotNull Continuation<? super PublishResponse> var2_2) {
        if (!(var2_2 instanceof startUpload.1)) ** GOTO lbl-1000
        var16_3 = var2_2;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ CloudClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startUpload(null, (Continuation<? super PublishResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.logger.debug("Initiating uploading of report with body " + (PublishRequest)requestBody);
                v0 = this.getRequestBuilder().uri(this.endpoint.resolve("/v1/reports/"));
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"requestBuilder\n         \u2026.resolve(\"/v1/reports/\"))");
                $this$post$iv = v0;
                $i$f$post = false;
                v1 = $this$post$iv.header("Content-Type", "application/json");
                $this$encodeToString$iv$iv = (StringFormat)Json.Default;
                $i$f$encodeToString = false;
                $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
                $i$f$serializer = false;
                $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(PublishRequest.class));
                $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                request = v1.POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, (Object)requestBody))).build();
                var14_20 = this;
                $this$post$iv = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
                Intrinsics.checkNotNullExpressionValue((Object)$this$post$iv, (String)"client\n            .send\u2026.BodyHandlers.ofString())");
                $continuation.L$0 = this;
                $continuation.L$1 = var14_20;
                $continuation.label = 1;
                v2 = FutureKt.await((CompletionStage)((CompletionStage)$this$post$iv), (Continuation)$continuation);
                if (v2 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl43
            }
            case 1: {
                var14_20 = (CloudClient)$continuation.L$1;
                this = (CloudClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl43:
                // 2 sources

                var4_21 = v2;
                Intrinsics.checkNotNullExpressionValue((Object)var4_21, (String)"client\n            .send\u2026g())\n            .await()");
                it = var14_20.handleFailure((HttpResponse)var4_21).body();
                $i$a$-let-CloudClient$startUpload$2 = false;
                $this$encodeToString$iv$iv = (StringFormat)Json.Default;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                string$iv = it;
                $i$f$decodeFromString = false;
                $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                $i$f$serializer = false;
                $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(PublishResponse.class));
                $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                it = var4_21 = (PublishResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
                $i$a$-also-CloudClient$startUpload$3 = false;
                this.logger.debug("Initiated uploading of report with response " + (PublishResponse)it);
                return var4_21;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object finishUpload(@NotNull String var1_1, @NotNull FinishRequest var2_2, @NotNull Continuation<? super FinishResponse> var3_3) {
        if (!(var3_3 instanceof finishUpload.1)) ** GOTO lbl-1000
        var17_4 = var3_3;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ CloudClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.finishUpload(null, null, (Continuation<? super FinishResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.logger.debug("Finishing uploading of report (" + reportId + ") with body " + (FinishRequest)requestBody);
                v0 = this.getRequestBuilder().uri(this.endpoint.resolve("/v1/reports/" + reportId + "/finish/"));
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"requestBuilder\n         \u2026orts/$reportId/finish/\"))");
                $this$post$iv = v0;
                $i$f$post = false;
                v1 = $this$post$iv.header("Content-Type", "application/json");
                $this$encodeToString$iv$iv = (StringFormat)Json.Default;
                $i$f$encodeToString = false;
                $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
                $i$f$serializer = false;
                $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(FinishRequest.class));
                $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                request = v1.POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, (Object)requestBody))).build();
                var15_21 = this;
                $this$post$iv = this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
                Intrinsics.checkNotNullExpressionValue((Object)$this$post$iv, (String)"client\n            .send\u2026.BodyHandlers.ofString())");
                $continuation.L$0 = this;
                $continuation.L$1 = reportId;
                $continuation.L$2 = var15_21;
                $continuation.label = 1;
                v2 = FutureKt.await((CompletionStage)((CompletionStage)$this$post$iv), (Continuation)$continuation);
                if (v2 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl45
            }
            case 1: {
                var15_21 = (CloudClient)$continuation.L$2;
                reportId = (String)$continuation.L$1;
                this = (CloudClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl45:
                // 2 sources

                var5_22 = v2;
                Intrinsics.checkNotNullExpressionValue((Object)var5_22, (String)"client\n            .send\u2026g())\n            .await()");
                it = var15_21.handleFailure((HttpResponse)var5_22).body();
                $i$a$-let-CloudClient$finishUpload$2 = false;
                $this$encodeToString$iv$iv = (StringFormat)Json.Default;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                string$iv = it;
                $i$f$decodeFromString = false;
                $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                $i$f$serializer = false;
                $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(FinishResponse.class));
                $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                it = var5_22 = (FinishResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
                $i$a$-also-CloudClient$finishUpload$3 = false;
                this.logger.debug("Finishing uploading of report (" + reportId + ") with response " + (FinishResponse)it);
                return var5_22;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final HttpRequest.Builder getRequestBuilder() {
        return HttpRequest.newBuilder().timeout(Duration.ofSeconds(20L)).uri(this.endpoint).header("Accept", "application/json").header("Authorization", "Bearer " + this.token);
    }

    private final /* synthetic */ <T> HttpRequest.Builder post(HttpRequest.Builder $this$post, T body) {
        boolean $i$f$post = false;
        HttpRequest.Builder builder = $this$post.header("Content-Type", "application/json");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, null);
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        return builder.POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, body)));
    }

    private final HttpResponse<String> handleFailure(HttpResponse<String> $this$handleFailure) {
        int n = $this$handleFailure.statusCode();
        if (n == 401) {
            throw PublisherException.Companion.from401();
        }
        boolean bl = 400 <= n ? n < 500 : false;
        if (bl) {
            throw PublisherException.Companion.from4XX($this$handleFailure);
        }
        boolean bl2 = 500 <= n ? n < 600 : false;
        if (bl2) {
            throw PublisherException.Companion.from5XX($this$handleFailure);
        }
        return $this$handleFailure;
    }
}

