/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.config;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.extensions.VcsIgnoredFilesProvider;
import org.jetbrains.qodana.license.QodanaLicenseType;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FixesStrategy;
import org.jetbrains.qodana.staticAnalysis.inspections.config.InspectScope;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfigKt;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaProfileConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaScriptConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaYamlConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.DefaultSeverityIncludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.ExcludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.GlobalExcludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.IncludeScopeModifier;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormat;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.OutputFormatKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifier;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b4\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u00b9\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0011\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0018\u001a\u00020\t\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0002\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010]\u001a\u00020\u00112\u0006\u0010^\u001a\u00020_J\t\u0010`\u001a\u00020\u0003H\u00c6\u0003J\t\u0010a\u001a\u00020\u0011H\u00c6\u0003J\t\u0010b\u001a\u00020\u0013H\u00c6\u0003J\u0010\u0010c\u001a\u0004\u0018\u00010\u0011H\u00c6\u0003\u00a2\u0006\u0002\u0010VJ\t\u0010d\u001a\u00020\u0016H\u00c6\u0003J\t\u0010e\u001a\u00020\u0011H\u00c6\u0003J\t\u0010f\u001a\u00020\tH\u00c6\u0003J\t\u0010g\u001a\u00020\u001aH\u00c6\u0003J\t\u0010h\u001a\u00020\u001cH\u00c6\u0003J\t\u0010i\u001a\u00020\u0003H\u00c6\u0003J\t\u0010j\u001a\u00020\u0003H\u00c6\u0003J\t\u0010k\u001a\u00020\u0003H\u00c6\u0003J\t\u0010l\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010m\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010n\u001a\u00020\u000bH\u00c6\u0003J\t\u0010o\u001a\u00020\tH\u00c6\u0003J\t\u0010p\u001a\u00020\u000eH\u00c6\u0003J\t\u0010q\u001a\u00020\u000eH\u00c6\u0003J\u00c6\u0001\u0010r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00112\b\b\u0002\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010sJ\u0013\u0010t\u001a\u00020\u00112\b\u0010u\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001c\u0010v\u001a\b\u0012\u0004\u0012\u00020w0(2\u0006\u0010x\u001a\u00020\u00112\u0006\u0010y\u001a\u00020zJ\f\u0010{\u001a\b\u0012\u0004\u0012\u00020w0(J\t\u0010|\u001a\u00020\u000eH\u00d6\u0001J\u000e\u0010}\u001a\u00020\u00112\u0006\u0010~\u001a\u00020\u000eJ\u0010\u0010\u007f\u001a\u00020\u00112\u0006\u0010y\u001a\u00020zH\u0002J\n\u0010\u0080\u0001\u001a\u00020\tH\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001d\u0010!\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b$\u0010 *\u0004\b\"\u0010#R\u0011\u0010\u001d\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R%\u0010'\u001a\f\u0012\u0004\u0012\u00020)0(j\u0002`*8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b,\u0010-*\u0004\b+\u0010#R\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010 R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R%\u00101\u001a\f\u0012\u0004\u0012\u00020)0(j\u0002`*8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b3\u0010-*\u0004\b2\u0010#R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001b\u00106\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b8\u00105*\u0004\b7\u0010#R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R%\u0010;\u001a\f\u0012\u0004\u0012\u00020)0(j\u0002`*8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b=\u0010-*\u0004\b<\u0010#R%\u0010>\u001a\f\u0012\u0004\u0012\u00020)0(j\u0002`*8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b@\u0010-*\u0004\b?\u0010#R\u0011\u0010\u0017\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u00100R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR%\u0010D\u001a\f\u0012\u0004\u0012\u00020)0(j\u0002`*8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\bF\u0010-*\u0004\bE\u0010#R\u001b\u0010G\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\bI\u00105*\u0004\bH\u0010#R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010&R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0011\u0010\u0018\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010OR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010&R\u001b\u0010Q\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\bS\u00105*\u0004\bR\u0010#R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010&R\u0015\u0010\u0014\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\n\n\u0002\u0010W\u001a\u0004\bU\u0010VR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\bX\u0010YR\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bZ\u00105R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\\u00a8\u0006\u0081\u0001"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "", "projectPath", "Ljava/nio/file/Path;", "outPath", "resultsStorage", "yaml", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;", "baseline", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;", "defaultProfileName", "failThreshold", "", "stopThreshold", "disableSanityInspections", "", "fixesStrategy", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "runPromoInspections", "script", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "includeAbsent", "outputInspectFormat", "outputFormat", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "licenseType", "Lorg/jetbrains/qodana/license/QodanaLicenseType;", "coveragePath", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;Ljava/lang/String;IIZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;Ljava/lang/Boolean;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;ZLjava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;Lorg/jetbrains/qodana/license/QodanaLicenseType;Ljava/nio/file/Path;)V", "getBaseline", "()Ljava/lang/String;", "bootstrap", "getBootstrap$delegate", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;)Ljava/lang/Object;", "getBootstrap", "getCoveragePath", "()Ljava/nio/file/Path;", "criticalSeverity", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScopes;", "getCriticalSeverity$delegate", "getCriticalSeverity", "()Ljava/util/List;", "getDefaultProfileName", "getDisableSanityInspections", "()Z", "exclude", "getExclude$delegate", "getExclude", "getFailThreshold", "()I", "fileSuspendThreshold", "getFileSuspendThreshold$delegate", "getFileSuspendThreshold", "getFixesStrategy", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;", "highSeverity", "getHighSeverity$delegate", "getHighSeverity", "include", "getInclude$delegate", "getInclude", "getIncludeAbsent", "getLicenseType", "()Lorg/jetbrains/qodana/license/QodanaLicenseType;", "moderateSeverity", "getModerateSeverity$delegate", "getModerateSeverity", "moduleSuspendThreshold", "getModuleSuspendThreshold$delegate", "getModuleSuspendThreshold", "getOutPath", "getOutputFormat", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;", "getOutputInspectFormat", "getProfile", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;", "getProjectPath", "projectSuspendThreshold", "getProjectSuspendThreshold$delegate", "getProjectSuspendThreshold", "getResultsStorage", "getRunPromoInspections", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getScript", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;", "getStopThreshold", "getYaml", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;", "checkRunPromo", "inspectionProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaYamlConfig;Ljava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaProfileConfig;Ljava/lang/String;IIZLorg/jetbrains/qodana/staticAnalysis/inspections/config/FixesStrategy;Ljava/lang/Boolean;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaScriptConfig;ZLjava/lang/String;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/OutputFormat;Lorg/jetbrains/qodana/license/QodanaLicenseType;Ljava/nio/file/Path;)Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "equals", "other", "getExcludeModifiers", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaScopeModifier;", "addDefaultExclude", "project", "Lcom/intellij/openapi/project/Project;", "getIncludeModifiers", "hashCode", "isAboveStopThreshold", "count", "supportsGitIgnore", "toString", "intellij.qodana"})
public final class QodanaConfig {
    @NotNull
    private final Path projectPath;
    @NotNull
    private final Path outPath;
    @NotNull
    private final Path resultsStorage;
    @NotNull
    private final QodanaYamlConfig yaml;
    @Nullable
    private final String baseline;
    @NotNull
    private final QodanaProfileConfig profile;
    @NotNull
    private final String defaultProfileName;
    private final int failThreshold;
    private final int stopThreshold;
    private final boolean disableSanityInspections;
    @NotNull
    private final FixesStrategy fixesStrategy;
    @Nullable
    private final Boolean runPromoInspections;
    @NotNull
    private final QodanaScriptConfig script;
    private final boolean includeAbsent;
    @NotNull
    private final String outputInspectFormat;
    @NotNull
    private final OutputFormat outputFormat;
    @NotNull
    private final QodanaLicenseType licenseType;
    @NotNull
    private final Path coveragePath;

    public QodanaConfig(@NotNull Path projectPath, @NotNull Path outPath, @NotNull Path resultsStorage, @NotNull QodanaYamlConfig yaml, @Nullable String baseline, @NotNull QodanaProfileConfig profile2, @NotNull String defaultProfileName, int failThreshold, int stopThreshold, boolean disableSanityInspections, @NotNull FixesStrategy fixesStrategy, @Nullable Boolean runPromoInspections, @NotNull QodanaScriptConfig script, boolean includeAbsent, @NotNull String outputInspectFormat, @NotNull OutputFormat outputFormat, @NotNull QodanaLicenseType licenseType, @NotNull Path coveragePath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        Intrinsics.checkNotNullParameter((Object)resultsStorage, (String)"resultsStorage");
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)defaultProfileName, (String)"defaultProfileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fixesStrategy), (String)"fixesStrategy");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)outputInspectFormat, (String)"outputInspectFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)licenseType), (String)"licenseType");
        Intrinsics.checkNotNullParameter((Object)coveragePath, (String)"coveragePath");
        this.projectPath = projectPath;
        this.outPath = outPath;
        this.resultsStorage = resultsStorage;
        this.yaml = yaml;
        this.baseline = baseline;
        this.profile = profile2;
        this.defaultProfileName = defaultProfileName;
        this.failThreshold = failThreshold;
        this.stopThreshold = stopThreshold;
        this.disableSanityInspections = disableSanityInspections;
        this.fixesStrategy = fixesStrategy;
        this.runPromoInspections = runPromoInspections;
        this.script = script;
        this.includeAbsent = includeAbsent;
        this.outputInspectFormat = outputInspectFormat;
        this.outputFormat = outputFormat;
        this.licenseType = licenseType;
        this.coveragePath = coveragePath;
        if (!Intrinsics.areEqual((Object)this.yaml.getVersion(), (Object)"1.0")) {
            throw new QodanaException("Property \"version\" in qodana.yaml must be \"1.0\", not \"" + this.yaml.getVersion() + "\"");
        }
        if (!this.projectPath.isAbsolute()) {
            throw new QodanaException("Project path \"" + this.projectPath + "\" must be absolute");
        }
    }

    public /* synthetic */ QodanaConfig(Path path, Path path2, Path path3, QodanaYamlConfig qodanaYamlConfig, String string, QodanaProfileConfig qodanaProfileConfig, String string2, int n, int n2, boolean bl, FixesStrategy fixesStrategy, Boolean bl2, QodanaScriptConfig qodanaScriptConfig, boolean bl3, String string3, OutputFormat outputFormat, QodanaLicenseType qodanaLicenseType, Path path4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            path3 = QodanaConfigKt.getResultsStorage(path2, OutputFormatKt.getOutputFormat());
        }
        if ((n3 & 8) != 0) {
            qodanaYamlConfig = QodanaYamlConfig.Companion.getEMPTY();
        }
        if ((n3 & 0x10) != 0) {
            string = null;
        }
        if ((n3 & 0x20) != 0) {
            qodanaProfileConfig = qodanaYamlConfig.getProfile();
        }
        if ((n3 & 0x40) != 0) {
            string2 = QodanaConfigKt.access$getDefaultProfileName();
        }
        if ((n3 & 0x80) != 0) {
            n = qodanaYamlConfig.getFailThreshold();
        }
        if ((n3 & 0x100) != 0) {
            n2 = qodanaYamlConfig.getStopThreshold();
        }
        if ((n3 & 0x200) != 0) {
            bl = qodanaYamlConfig.getDisableSanityInspections();
        }
        if ((n3 & 0x400) != 0) {
            fixesStrategy = FixesStrategy.Companion.fromString(qodanaYamlConfig.getFixesStrategy());
        }
        if ((n3 & 0x800) != 0) {
            bl2 = qodanaYamlConfig.getRunPromoInspections();
        }
        if ((n3 & 0x1000) != 0) {
            qodanaScriptConfig = qodanaYamlConfig.getScript();
        }
        if ((n3 & 0x2000) != 0) {
            bl3 = qodanaYamlConfig.getIncludeAbsent();
        }
        if ((n3 & 0x4000) != 0) {
            string3 = "json";
        }
        if ((n3 & 0x8000) != 0) {
            outputFormat = OutputFormatKt.getOutputFormat();
        }
        if ((n3 & 0x10000) != 0) {
            qodanaLicenseType = QodanaLicenseType.ULTIMATE_PLUS;
        }
        if ((n3 & 0x20000) != 0) {
            Path path5 = path2.resolve("coverage/");
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"outPath.resolve(\"$COVERAGE_OUTPUT_DIR/\")");
            path4 = path5;
        }
        this(path, path2, path3, qodanaYamlConfig, string, qodanaProfileConfig, string2, n, n2, bl, fixesStrategy, bl2, qodanaScriptConfig, bl3, string3, outputFormat, qodanaLicenseType, path4);
    }

    @NotNull
    public final Path getProjectPath() {
        return this.projectPath;
    }

    @NotNull
    public final Path getOutPath() {
        return this.outPath;
    }

    @NotNull
    public final Path getResultsStorage() {
        return this.resultsStorage;
    }

    @NotNull
    public final QodanaYamlConfig getYaml() {
        return this.yaml;
    }

    @Nullable
    public final String getBaseline() {
        return this.baseline;
    }

    @NotNull
    public final QodanaProfileConfig getProfile() {
        return this.profile;
    }

    @NotNull
    public final String getDefaultProfileName() {
        return this.defaultProfileName;
    }

    public final int getFailThreshold() {
        return this.failThreshold;
    }

    public final int getStopThreshold() {
        return this.stopThreshold;
    }

    public final boolean getDisableSanityInspections() {
        return this.disableSanityInspections;
    }

    @NotNull
    public final FixesStrategy getFixesStrategy() {
        return this.fixesStrategy;
    }

    @Nullable
    public final Boolean getRunPromoInspections() {
        return this.runPromoInspections;
    }

    @NotNull
    public final QodanaScriptConfig getScript() {
        return this.script;
    }

    public final boolean getIncludeAbsent() {
        return this.includeAbsent;
    }

    @NotNull
    public final String getOutputInspectFormat() {
        return this.outputInspectFormat;
    }

    @NotNull
    public final OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    @NotNull
    public final QodanaLicenseType getLicenseType() {
        return this.licenseType;
    }

    @NotNull
    public final Path getCoveragePath() {
        return this.coveragePath;
    }

    @NotNull
    public final List<InspectScope> getExclude() {
        return this.yaml.getExclude();
    }

    private static Object getExclude$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "exclude", "getExclude()Ljava/util/List;", 0)));
    }

    @NotNull
    public final List<InspectScope> getInclude() {
        return this.yaml.getInclude();
    }

    private static Object getInclude$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "include", "getInclude()Ljava/util/List;", 0)));
    }

    @Nullable
    public final String getBootstrap() {
        return this.yaml.getBootstrap();
    }

    private static Object getBootstrap$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "bootstrap", "getBootstrap()Ljava/lang/String;", 0)));
    }

    private final List<InspectScope> getCriticalSeverity() {
        return this.yaml.getCriticalSeverity();
    }

    private static Object getCriticalSeverity$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "criticalSeverity", "getCriticalSeverity()Ljava/util/List;", 0)));
    }

    private final List<InspectScope> getHighSeverity() {
        return this.yaml.getHighSeverity();
    }

    private static Object getHighSeverity$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "highSeverity", "getHighSeverity()Ljava/util/List;", 0)));
    }

    private final List<InspectScope> getModerateSeverity() {
        return this.yaml.getModerateSeverity();
    }

    private static Object getModerateSeverity$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "moderateSeverity", "getModerateSeverity()Ljava/util/List;", 0)));
    }

    public final int getFileSuspendThreshold() {
        return this.yaml.getFileSuspendThreshold();
    }

    private static Object getFileSuspendThreshold$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "fileSuspendThreshold", "getFileSuspendThreshold()I", 0)));
    }

    public final int getModuleSuspendThreshold() {
        return this.yaml.getModuleSuspendThreshold();
    }

    private static Object getModuleSuspendThreshold$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "moduleSuspendThreshold", "getModuleSuspendThreshold()I", 0)));
    }

    public final int getProjectSuspendThreshold() {
        return this.yaml.getProjectSuspendThreshold();
    }

    private static Object getProjectSuspendThreshold$delegate(QodanaConfig qodanaConfig) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)qodanaConfig.yaml, QodanaYamlConfig.class, "projectSuspendThreshold", "getProjectSuspendThreshold()I", 0)));
    }

    public final boolean checkRunPromo(@NotNull QodanaInspectionProfile inspectionProfile) {
        Intrinsics.checkNotNullParameter((Object)((Object)inspectionProfile), (String)"inspectionProfile");
        return Intrinsics.areEqual((Object)this.runPromoInspections, (Object)true) || this.runPromoInspections == null && Intrinsics.areEqual((Object)inspectionProfile.getName(), (Object)this.defaultProfileName);
    }

    @NotNull
    public final List<QodanaScopeModifier> getIncludeModifiers() {
        Collection collection;
        List modifiers = new ArrayList();
        for (InspectScope scope : this.getCriticalSeverity()) {
            collection = modifiers;
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"ERROR");
            collection.add(new IncludeScopeModifier(scope, highlightDisplayLevel, "critical"));
        }
        for (InspectScope scope : this.getHighSeverity()) {
            collection = modifiers;
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"WARNING");
            collection.add(new IncludeScopeModifier(scope, highlightDisplayLevel, "high"));
        }
        for (InspectScope scope : this.getModerateSeverity()) {
            collection = modifiers;
            HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"WEAK_WARNING");
            collection.add(new IncludeScopeModifier(scope, highlightDisplayLevel, "moderate"));
        }
        for (InspectScope scope : this.getInclude()) {
            ((Collection)modifiers).add(new DefaultSeverityIncludeScopeModifier(scope));
        }
        return modifiers;
    }

    private final boolean supportsGitIgnore(Project project2) {
        List<FilePath> ignored = VcsIgnoredFilesProvider.Companion.getVcsRepositoriesIgnoredFiles(project2);
        return !((Collection)ignored).isEmpty();
    }

    @NotNull
    public final List<QodanaScopeModifier> getExcludeModifiers(boolean addDefaultExclude, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        List modifiers = new ArrayList();
        for (InspectScope scope : this.getExclude()) {
            if (Intrinsics.areEqual((Object)scope.getName(), (Object)"All")) {
                ((Collection)modifiers).add(new GlobalExcludeScopeModifier(scope));
                continue;
            }
            ((Collection)modifiers).add(new ExcludeScopeModifier(scope));
        }
        if (addDefaultExclude) {
            ((Collection)modifiers).add(QodanaConfigKt.getDEFAULT_EXCLUDE_SCOPE_MODIFIER());
        }
        if (addDefaultExclude && this.supportsGitIgnore(project2)) {
            ((Collection)modifiers).add(QodanaConfigKt.getGIT_IGNORE_SCOPE_MODIFIER());
        }
        return modifiers;
    }

    public final boolean isAboveStopThreshold(int count) {
        int n = this.stopThreshold;
        return 0 <= n ? n < count : false;
    }

    @NotNull
    public final Path component1() {
        return this.projectPath;
    }

    @NotNull
    public final Path component2() {
        return this.outPath;
    }

    @NotNull
    public final Path component3() {
        return this.resultsStorage;
    }

    @NotNull
    public final QodanaYamlConfig component4() {
        return this.yaml;
    }

    @Nullable
    public final String component5() {
        return this.baseline;
    }

    @NotNull
    public final QodanaProfileConfig component6() {
        return this.profile;
    }

    @NotNull
    public final String component7() {
        return this.defaultProfileName;
    }

    public final int component8() {
        return this.failThreshold;
    }

    public final int component9() {
        return this.stopThreshold;
    }

    public final boolean component10() {
        return this.disableSanityInspections;
    }

    @NotNull
    public final FixesStrategy component11() {
        return this.fixesStrategy;
    }

    @Nullable
    public final Boolean component12() {
        return this.runPromoInspections;
    }

    @NotNull
    public final QodanaScriptConfig component13() {
        return this.script;
    }

    public final boolean component14() {
        return this.includeAbsent;
    }

    @NotNull
    public final String component15() {
        return this.outputInspectFormat;
    }

    @NotNull
    public final OutputFormat component16() {
        return this.outputFormat;
    }

    @NotNull
    public final QodanaLicenseType component17() {
        return this.licenseType;
    }

    @NotNull
    public final Path component18() {
        return this.coveragePath;
    }

    @NotNull
    public final QodanaConfig copy(@NotNull Path projectPath, @NotNull Path outPath, @NotNull Path resultsStorage, @NotNull QodanaYamlConfig yaml, @Nullable String baseline, @NotNull QodanaProfileConfig profile2, @NotNull String defaultProfileName, int failThreshold, int stopThreshold, boolean disableSanityInspections, @NotNull FixesStrategy fixesStrategy, @Nullable Boolean runPromoInspections, @NotNull QodanaScriptConfig script, boolean includeAbsent, @NotNull String outputInspectFormat, @NotNull OutputFormat outputFormat, @NotNull QodanaLicenseType licenseType, @NotNull Path coveragePath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
        Intrinsics.checkNotNullParameter((Object)resultsStorage, (String)"resultsStorage");
        Intrinsics.checkNotNullParameter((Object)yaml, (String)"yaml");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)defaultProfileName, (String)"defaultProfileName");
        Intrinsics.checkNotNullParameter((Object)((Object)fixesStrategy), (String)"fixesStrategy");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)outputInspectFormat, (String)"outputInspectFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
        Intrinsics.checkNotNullParameter((Object)((Object)licenseType), (String)"licenseType");
        Intrinsics.checkNotNullParameter((Object)coveragePath, (String)"coveragePath");
        return new QodanaConfig(projectPath, outPath, resultsStorage, yaml, baseline, profile2, defaultProfileName, failThreshold, stopThreshold, disableSanityInspections, fixesStrategy, runPromoInspections, script, includeAbsent, outputInspectFormat, outputFormat, licenseType, coveragePath);
    }

    public static /* synthetic */ QodanaConfig copy$default(QodanaConfig qodanaConfig, Path path, Path path2, Path path3, QodanaYamlConfig qodanaYamlConfig, String string, QodanaProfileConfig qodanaProfileConfig, String string2, int n, int n2, boolean bl, FixesStrategy fixesStrategy, Boolean bl2, QodanaScriptConfig qodanaScriptConfig, boolean bl3, String string3, OutputFormat outputFormat, QodanaLicenseType qodanaLicenseType, Path path4, int n3, Object object) {
        if ((n3 & 1) != 0) {
            path = qodanaConfig.projectPath;
        }
        if ((n3 & 2) != 0) {
            path2 = qodanaConfig.outPath;
        }
        if ((n3 & 4) != 0) {
            path3 = qodanaConfig.resultsStorage;
        }
        if ((n3 & 8) != 0) {
            qodanaYamlConfig = qodanaConfig.yaml;
        }
        if ((n3 & 0x10) != 0) {
            string = qodanaConfig.baseline;
        }
        if ((n3 & 0x20) != 0) {
            qodanaProfileConfig = qodanaConfig.profile;
        }
        if ((n3 & 0x40) != 0) {
            string2 = qodanaConfig.defaultProfileName;
        }
        if ((n3 & 0x80) != 0) {
            n = qodanaConfig.failThreshold;
        }
        if ((n3 & 0x100) != 0) {
            n2 = qodanaConfig.stopThreshold;
        }
        if ((n3 & 0x200) != 0) {
            bl = qodanaConfig.disableSanityInspections;
        }
        if ((n3 & 0x400) != 0) {
            fixesStrategy = qodanaConfig.fixesStrategy;
        }
        if ((n3 & 0x800) != 0) {
            bl2 = qodanaConfig.runPromoInspections;
        }
        if ((n3 & 0x1000) != 0) {
            qodanaScriptConfig = qodanaConfig.script;
        }
        if ((n3 & 0x2000) != 0) {
            bl3 = qodanaConfig.includeAbsent;
        }
        if ((n3 & 0x4000) != 0) {
            string3 = qodanaConfig.outputInspectFormat;
        }
        if ((n3 & 0x8000) != 0) {
            outputFormat = qodanaConfig.outputFormat;
        }
        if ((n3 & 0x10000) != 0) {
            qodanaLicenseType = qodanaConfig.licenseType;
        }
        if ((n3 & 0x20000) != 0) {
            path4 = qodanaConfig.coveragePath;
        }
        return qodanaConfig.copy(path, path2, path3, qodanaYamlConfig, string, qodanaProfileConfig, string2, n, n2, bl, fixesStrategy, bl2, qodanaScriptConfig, bl3, string3, outputFormat, qodanaLicenseType, path4);
    }

    @NotNull
    public String toString() {
        return "QodanaConfig(projectPath=" + this.projectPath + ", outPath=" + this.outPath + ", resultsStorage=" + this.resultsStorage + ", yaml=" + this.yaml + ", baseline=" + this.baseline + ", profile=" + this.profile + ", defaultProfileName=" + this.defaultProfileName + ", failThreshold=" + this.failThreshold + ", stopThreshold=" + this.stopThreshold + ", disableSanityInspections=" + this.disableSanityInspections + ", fixesStrategy=" + this.fixesStrategy + ", runPromoInspections=" + this.runPromoInspections + ", script=" + this.script + ", includeAbsent=" + this.includeAbsent + ", outputInspectFormat=" + this.outputInspectFormat + ", outputFormat=" + this.outputFormat + ", licenseType=" + this.licenseType + ", coveragePath=" + this.coveragePath + ")";
    }

    public int hashCode() {
        int result = ((Object)this.projectPath).hashCode();
        result = result * 31 + ((Object)this.outPath).hashCode();
        result = result * 31 + ((Object)this.resultsStorage).hashCode();
        result = result * 31 + this.yaml.hashCode();
        result = result * 31 + (this.baseline == null ? 0 : this.baseline.hashCode());
        result = result * 31 + this.profile.hashCode();
        result = result * 31 + this.defaultProfileName.hashCode();
        result = result * 31 + Integer.hashCode(this.failThreshold);
        result = result * 31 + Integer.hashCode(this.stopThreshold);
        int n = this.disableSanityInspections ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.fixesStrategy.hashCode();
        result = result * 31 + (this.runPromoInspections == null ? 0 : ((Object)this.runPromoInspections).hashCode());
        result = result * 31 + this.script.hashCode();
        int n2 = this.includeAbsent ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        result = result * 31 + this.outputInspectFormat.hashCode();
        result = result * 31 + this.outputFormat.hashCode();
        result = result * 31 + this.licenseType.hashCode();
        result = result * 31 + ((Object)this.coveragePath).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QodanaConfig)) {
            return false;
        }
        QodanaConfig qodanaConfig = (QodanaConfig)other;
        if (!Intrinsics.areEqual((Object)this.projectPath, (Object)qodanaConfig.projectPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outPath, (Object)qodanaConfig.outPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.resultsStorage, (Object)qodanaConfig.resultsStorage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.yaml, (Object)qodanaConfig.yaml)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baseline, (Object)qodanaConfig.baseline)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profile, (Object)qodanaConfig.profile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.defaultProfileName, (Object)qodanaConfig.defaultProfileName)) {
            return false;
        }
        if (this.failThreshold != qodanaConfig.failThreshold) {
            return false;
        }
        if (this.stopThreshold != qodanaConfig.stopThreshold) {
            return false;
        }
        if (this.disableSanityInspections != qodanaConfig.disableSanityInspections) {
            return false;
        }
        if (this.fixesStrategy != qodanaConfig.fixesStrategy) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.runPromoInspections, (Object)qodanaConfig.runPromoInspections)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.script, (Object)qodanaConfig.script)) {
            return false;
        }
        if (this.includeAbsent != qodanaConfig.includeAbsent) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.outputInspectFormat, (Object)qodanaConfig.outputInspectFormat)) {
            return false;
        }
        if (this.outputFormat != qodanaConfig.outputFormat) {
            return false;
        }
        if (this.licenseType != qodanaConfig.licenseType) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.coveragePath, (Object)qodanaConfig.coveragePath);
    }
}

