/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaCancellationException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaScopeModifier;
import org.jetbrains.qodana.staticAnalysis.profile.NamedInspectionGroup;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfileManager;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00060\rR\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "(Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;)V", "applyConfig", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "project", "Lcom/intellij/openapi/project/Project;", "addDefaultExclude", "", "createState", "Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "State", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nMainInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n1855#2,2:45\n1855#2,2:47\n*S KotlinDebug\n*F\n+ 1 MainInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup\n*L\n39#1:45,2\n40#1:47,2\n*E\n"})
public final class MainInspectionGroup
extends NamedInspectionGroup {
    public MainInspectionGroup(@NotNull QodanaInspectionProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)((Object)profile2), (String)"profile");
        super("", profile2);
    }

    @Override
    @NotNull
    public State createState(@NotNull QodanaGlobalInspectionContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new State(context);
    }

    @Override
    @NotNull
    public MainInspectionGroup applyConfig(@NotNull QodanaConfig config, @NotNull Project project2, boolean addDefaultExclude) {
        QodanaScopeModifier it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super.applyConfig(config, project2, addDefaultExclude);
        List<QodanaScopeModifier> excludeModifiers = config.getExcludeModifiers(addDefaultExclude, project2);
        List<QodanaScopeModifier> includeModifiers = config.getIncludeModifiers();
        if (excludeModifiers.isEmpty() && includeModifiers.isEmpty()) {
            return this;
        }
        QodanaInspectionProfileManager profileManager = QodanaInspectionProfileManager.Companion.getInstance(project2);
        QodanaInspectionProfile newProfile = QodanaInspectionProfile.Companion.clone(this.getProfile(), "qodana.main.profile(base:" + this.getProfile().getName() + ")", profileManager);
        Iterable $this$forEach$iv = excludeModifiers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (QodanaScopeModifier)element$iv;
            boolean bl = false;
            it.updateProfileScopes(newProfile, project2, config.getProjectPath());
        }
        $this$forEach$iv = includeModifiers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (QodanaScopeModifier)element$iv;
            boolean bl = false;
            it.updateProfileScopes(newProfile, project2, config.getProjectPath());
        }
        return new MainInspectionGroup(newProfile);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup$State;", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup$State;", "Lorg/jetbrains/qodana/staticAnalysis/profile/NamedInspectionGroup;", "context", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "(Lorg/jetbrains/qodana/staticAnalysis/profile/MainInspectionGroup;Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;)V", "problemsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCount", "", "onConsumeProblem", "", "inspectionId", "", "relativePath", "module", "intellij.qodana"})
    public final class State
    extends NamedInspectionGroup.State {
        @NotNull
        private final AtomicInteger problemsCounter;

        public State(QodanaGlobalInspectionContext context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            super(MainInspectionGroup.this, context);
            this.problemsCounter = new AtomicInteger();
        }

        @Override
        public boolean onConsumeProblem(@NotNull String inspectionId, @Nullable String relativePath, @Nullable String module2) {
            Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
            if (this.getContext().getConfig().isAboveStopThreshold(this.problemsCounter.get())) {
                String errorMessage = "Canceling analysis since stopThreshold " + this.getContext().getConfig().getStopThreshold() + " is surpassed.";
                System.out.println((Object)errorMessage);
                this.getContext().getInspectionJob().cancel((CancellationException)new QodanaCancellationException(errorMessage));
                return false;
            }
            this.problemsCounter.incrementAndGet();
            return super.onConsumeProblem(inspectionId, relativePath, module2);
        }

        public final int getCount() {
            return this.problemsCounter.get();
        }
    }
}

