/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.URLUtil;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import git4idea.GitCommit;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifReportContributor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u0004\u0018\u00010\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/GitReportContributor;", "Lorg/jetbrains/qodana/staticAnalysis/sarif/SarifReportContributor;", "()V", "contribute", "", "run", "Lcom/jetbrains/qodana/sarif/model/Run;", "project", "Lcom/intellij/openapi/project/Project;", "convertScp", "Ljava/net/URI;", "url", "", "getRemoteUrl", "name", "repository", "Lgit4idea/repo/GitRepository;", "Companion", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nGitReportContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitReportContributor.kt\norg/jetbrains/qodana/staticAnalysis/sarif/GitReportContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1#2:126\n10#3:127\n*S KotlinDebug\n*F\n+ 1 GitReportContributor.kt\norg/jetbrains/qodana/staticAnalysis/sarif/GitReportContributor\n*L\n32#1:127\n*E\n"})
public final class GitReportContributor
implements SarifReportContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public void contribute(@NotNull Run run2, @NotNull Project project2) {
        String string;
        String string2;
        String string3;
        Map map2;
        PropertyBag it;
        PropertyBag propertyBag;
        String revision;
        URI remoteUrl;
        String branch;
        GitRepository repository;
        VirtualFile projectDir;
        block19: {
            String string4;
            block18: {
                String string5;
                String string6;
                Intrinsics.checkNotNullParameter((Object)run2, (String)"run");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                VirtualFile virtualFile2 = ProjectUtil.guessProjectDir((Project)project2);
                if (virtualFile2 == null) {
                    return;
                }
                projectDir = virtualFile2;
                repository = (GitRepository)GitRepositoryManager.getInstance((Project)project2).getRepositoryForFileQuick(projectDir);
                if (repository != null) {
                    LOG.debug("Found git repository: " + repository);
                }
                if ((string6 = System.getenv("QODANA_BRANCH")) == null) {
                    GitRepository gitRepository = repository;
                    string6 = gitRepository != null && (gitRepository = gitRepository.getCurrentBranch()) != null ? gitRepository.getName() : null;
                }
                if ((branch = string6) == null) {
                    LOG.warn("Unable to find the branch name, please set the environment variable QODANA_BRANCH");
                    return;
                }
                LOG.debug("Found git branch: " + branch);
                remoteUrl = this.getRemoteUrl(branch, repository);
                if (remoteUrl == null) {
                    LOG.warn("Unable to find the remote url, please set the environment variable QODANA_REMOTE_URL");
                    return;
                }
                LOG.debug("Found git remote url: " + remoteUrl);
                String string7 = System.getenv("QODANA_REVISION");
                if (string7 == null) {
                    GitRepository gitRepository = repository;
                    string7 = gitRepository != null ? gitRepository.getCurrentRevision() : null;
                }
                if ((revision = string7) == null) {
                    LOG.warn("Unable to find the revision, please set the environment variable QODANA_REVISION");
                    return;
                }
                LOG.debug("Found git revision: " + revision);
                it = propertyBag = new PropertyBag();
                boolean bl = false;
                ((Map)it).put("vcsType", "Git");
                it = propertyBag;
                boolean bl2 = false;
                map2 = it;
                string3 = "repoUrl";
                string2 = System.getenv("QODANA_REPO_URL");
                string = string2;
                if (string == null) break block18;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(QODANA_REPO_URL)");
                String url = string5 = string2;
                boolean bl3 = false;
                string = StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null) ? string5 : null;
                if (string != null) break block19;
            }
            String url = string4 = remoteUrl.toString();
            boolean bl = false;
            string = url != null && StringsKt.startsWith$default((String)url, (String)"https://", (boolean)false, (int)2, null) ? string4 : null;
            if (string == null) {
                string = "";
            }
        }
        string2 = string;
        map2.put(string3, string2);
        if (Intrinsics.areEqual((Object)it.get("repoUrl"), (Object)"")) {
            LOG.warn("Unable to parse the repository url, please set the environment variable QODANA_REPO_URL, should start with https://");
        }
        PropertyBag properties = propertyBag;
        VersionControlDetails vcsDetails = new VersionControlDetails().withRepositoryUri(remoteUrl).withBranch(branch).withRevisionId(revision).withProperties(properties);
        try {
            if (repository != null) {
                String[] stringArray = GitHistoryUtils.formHashParameters((Project)project2, (Collection)SetsKt.setOf((Object)repository.getCurrentRevision()));
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"formHashParameters(proje\u2026ository.currentRevision))");
                String[] hashParameters = stringArray;
                List list2 = GitHistoryUtils.history((Project)project2, (VirtualFile)projectDir, (String[])Arrays.copyOf(hashParameters, hashParameters.length));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"history(project, projectDir, *hashParameters)");
                List gitCommits = list2;
                if (gitCommits.size() > 0) {
                    GitCommit commit = (GitCommit)gitCommits.get(0);
                    ((Map)properties).put("lastAuthorName", commit.getAuthor().getName());
                    ((Map)properties).put("lastAuthorEmail", commit.getAuthor().getEmail());
                }
            }
        }
        catch (VcsException e) {
            LOG.info("Unable to obtain the author from VCS", (Throwable)e);
        }
        run2.setVersionControlProvenance(SetsKt.setOf((Object)vcsDetails));
    }

    private final URI getRemoteUrl(String name, GitRepository repository) {
        String url = System.getenv("QODANA_REMOTE_URL");
        if (url == null) {
            if (name == null) {
                return null;
            }
            GitRepository gitRepository = repository;
            if (gitRepository == null || (gitRepository = gitRepository.getBranchTrackInfo(name)) == null) {
                return null;
            }
            GitRepository branchTrackInfo = gitRepository;
            String string = branchTrackInfo.getRemote().getFirstUrl();
            if (string == null) {
                return null;
            }
            url = string;
        }
        try {
            return URLUtil.containsScheme((String)url) ? new URI(url) : this.convertScp(url);
        }
        catch (URISyntaxException e) {
            LOG.warn("Unable to create a URI from the extracted remote URL: " + url, (Throwable)e);
            return null;
        }
    }

    private final URI convertScp(String url) {
        URI uri = new URI("ssh://" + url);
        String string = uri.getAuthority();
        if (string == null) {
            return null;
        }
        String authority = string;
        String[] stringArray = new String[]{":"};
        List fields = StringsKt.split$default((CharSequence)authority, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (fields.size() != 2) {
            LOG.warn("Can't parse authority in git origin uri '" + url + "'");
            return null;
        }
        String authAndHost = (String)fields.get(0);
        Object e = fields.get(1);
        String string2 = uri.getPath();
        if (string2 == null) {
            string2 = "";
        }
        String path = e + string2;
        return new URI("ssh://" + authAndHost + "/" + path);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(GitReportContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/GitReportContributor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

