/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.stat;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.RoundedIntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/UsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.qodana"})
public final class UsageCollector
extends CounterUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("qodana.usage", 3, null, 4, null);
    @NotNull
    private static final List<String> knownSystems;
    @NotNull
    private static final StringEventField systemField;
    @NotNull
    private static final StringEventField versionField;
    @NotNull
    private static final StringEventField buildField;
    @NotNull
    private static final VarargEventId envEvent;
    @NotNull
    private static final List<String> knownProfiles;
    @NotNull
    private static final StringEventField profileField;
    @NotNull
    private static final RoundedIntEventField includeField;
    @NotNull
    private static final RoundedIntEventField excludeField;
    @NotNull
    private static final RoundedIntEventField failThresholdField;
    @NotNull
    private static final RoundedIntEventField stopThresholdField;
    @NotNull
    private static final BooleanEventField bootstrapField;
    @NotNull
    private static final StringEventField scriptField;
    @NotNull
    private static final StringEventField phpMigrationFromLevelField;
    @NotNull
    private static final StringEventField phpMigrationToLevelField;
    @NotNull
    private static final VarargEventId configEvent;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void logEnv(@Nullable String qodanaEnv) {
        Companion.logEnv(qodanaEnv);
    }

    @JvmStatic
    public static final void logConfig(@NotNull QodanaConfig config, @NotNull String profileName, @NotNull String profilePath) {
        Companion.logConfig(config, profileName, profilePath);
    }

    static {
        Object[] objectArray = new String[]{"azure-pipelines", "bamboo", "buddy", "bitrise", "circleci", "codefresh", "codeship", "github-actions", "gitlab", "gocd", "jenkins", "jetbrains-space", "semaphore", "travis-ci", "wercker", "cli", "teamcity", "teamcity-cloud", "gradle", "other"};
        knownSystems = CollectionsKt.listOf((Object[])objectArray);
        systemField = EventFields.String((String)"system", knownSystems);
        versionField = EventFields.StringValidatedByInlineRegexp((String)"version", (String)"(?x) \\d+ (?:\\.\\d+)* (?:_EAP)?");
        buildField = EventFields.StringValidatedByRegexp((String)"build", (String)"integer");
        objectArray = new EventField[]{systemField, versionField, buildField};
        envEvent = GROUP.registerVarargEvent("env", (EventField[])objectArray);
        objectArray = new String[]{"empty", "starter", "recommended", "single", "path", "absent", "other"};
        knownProfiles = CollectionsKt.listOf((Object[])objectArray);
        profileField = EventFields.String((String)"profile", knownProfiles);
        includeField = EventFields.RoundedInt((String)"include");
        excludeField = EventFields.RoundedInt((String)"exclude");
        failThresholdField = EventFields.RoundedInt((String)"failThreshold");
        stopThresholdField = EventFields.RoundedInt((String)"stopThreshold");
        bootstrapField = EventFields.Boolean((String)"bootstrap");
        objectArray = new String[]{"php-migration", "other"};
        scriptField = EventFields.String((String)"script", (List)CollectionsKt.listOf((Object[])objectArray));
        phpMigrationFromLevelField = EventFields.StringValidatedByRegexp((String)"phpMigrationFromLevel", (String)"version");
        phpMigrationToLevelField = EventFields.StringValidatedByRegexp((String)"phpMigrationToLevel", (String)"version");
        objectArray = new EventField[]{profileField, includeField, excludeField, failThresholdField, stopThresholdField, bootstrapField, scriptField, phpMigrationFromLevelField, phpMigrationToLevelField};
        configEvent = GROUP.registerVarargEvent("config", (EventField[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0007J\u0012\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0007J\u0016\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0012J\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/UsageCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "bootstrapField", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "buildField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "configEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "envEvent", "excludeField", "Lcom/intellij/internal/statistic/eventLog/events/RoundedIntEventField;", "failThresholdField", "includeField", "knownProfiles", "", "", "knownSystems", "phpMigrationFromLevelField", "phpMigrationToLevelField", "profileField", "scriptField", "stopThresholdField", "systemField", "versionField", "logConfig", "", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "profileName", "profilePath", "logEnv", "qodanaEnv", "profileForReporting", "name", "path", "splitEnv", "Lorg/jetbrains/qodana/staticAnalysis/stat/UsageCollector$Companion$Environment;", "env", "splitEnv$intellij_qodana", "Environment", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Environment splitEnv$intellij_qodana(@NotNull String env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            String regex = "(?x)\n        ([\\w-]+)                          # system\n        (?: : (\\d+ (?:\\.\\d+)* (?:_EAP)?)  # optional version; keep in sync with versionField\n          (?: : ([1-9]\\d{0,8}) )?         # optional build\n        )?\n      ";
            MatchResult matchResult = new Regex(regex).matchEntire((CharSequence)env);
            if (matchResult != null) {
                MatchResult m = matchResult;
                boolean bl = false;
                MatchResult.Destructured destructured = m.getDestructured();
                String system = (String)destructured.getMatch().getGroupValues().get(1);
                String version = (String)destructured.getMatch().getGroupValues().get(2);
                String build2 = (String)destructured.getMatch().getGroupValues().get(3);
                if (Intrinsics.areEqual((Object)system, (Object)"teamcity") || Intrinsics.areEqual((Object)system, (Object)"teamcity-cloud")) {
                    return new Environment(system, Strings.nullize((String)version), Strings.nullize((String)build2));
                }
                if (knownSystems.contains(system)) {
                    return new Environment(system, Strings.nullize((String)version), null);
                }
            }
            return new Environment("other", null, null);
        }

        @JvmStatic
        public final void logEnv(@Nullable String qodanaEnv) {
            String string = qodanaEnv;
            if (string == null) {
                string = "other";
            }
            Environment env = this.splitEnv$intellij_qodana(string);
            List args = new ArrayList();
            ((Collection)args).add(systemField.with((Object)env.getSystem()));
            if (env.getVersion() != null) {
                ((Collection)args).add(versionField.with((Object)env.getVersion()));
            }
            if (env.getBuild() != null) {
                ((Collection)args).add(buildField.with((Object)env.getBuild()));
            }
            envEvent.log(args);
        }

        @NotNull
        public final String profileForReporting(@NotNull String name, @NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return Intrinsics.areEqual((Object)name, (Object)"empty") ? "empty" : (Intrinsics.areEqual((Object)name, (Object)"qodana.starter") ? "starter" : (Intrinsics.areEqual((Object)name, (Object)"qodana.recommended") ? "recommended" : (StringsKt.startsWith$default((String)name, (String)"qodana.single:", (boolean)false, (int)2, null) ? "single" : (Intrinsics.areEqual((Object)name, (Object)"") && !Intrinsics.areEqual((Object)path, (Object)"") ? "path" : (Intrinsics.areEqual((Object)name, (Object)"") && Intrinsics.areEqual((Object)path, (Object)"") ? "absent" : "other")))));
        }

        @JvmStatic
        public final void logConfig(@NotNull QodanaConfig config, @NotNull String profileName, @NotNull String profilePath) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
            Intrinsics.checkNotNullParameter((Object)profilePath, (String)"profilePath");
            List args = new ArrayList();
            ((Collection)args).add(profileField.with((Object)this.profileForReporting(profileName, profilePath)));
            ((Collection)args).add(includeField.with((Object)config.getInclude().size()));
            ((Collection)args).add(excludeField.with((Object)config.getExclude().size()));
            if (config.getFailThreshold() != -1) {
                ((Collection)args).add(failThresholdField.with((Object)config.getFailThreshold()));
            }
            if (config.getStopThreshold() != -1) {
                ((Collection)args).add(stopThresholdField.with((Object)config.getStopThreshold()));
            }
            ((Collection)args).add(bootstrapField.with((Object)Strings.isNotEmpty((String)config.getBootstrap())));
            String string = config.getScript().getName();
            if (!Intrinsics.areEqual((Object)string, (Object)"default")) {
                if (Intrinsics.areEqual((Object)string, (Object)"php-migration")) {
                    ((Collection)args).add(scriptField.with((Object)"php-migration"));
                    ((Collection)args).add(phpMigrationFromLevelField.with((Object)config.getScript().getParameters().get("fromLevel")));
                    ((Collection)args).add(phpMigrationToLevelField.with((Object)config.getScript().getParameters().get("toLevel")));
                } else {
                    ((Collection)args).add(scriptField.with((Object)"other"));
                }
            }
            configEvent.log(args);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/stat/UsageCollector$Companion$Environment;", "", "system", "", "version", "build", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuild", "()Ljava/lang/String;", "getSystem", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.qodana"})
        public static final class Environment {
            @NotNull
            private final String system;
            @Nullable
            private final String version;
            @Nullable
            private final String build;

            public Environment(@NotNull String system, @Nullable String version, @Nullable String build2) {
                Intrinsics.checkNotNullParameter((Object)system, (String)"system");
                this.system = system;
                this.version = version;
                this.build = build2;
            }

            @NotNull
            public final String getSystem() {
                return this.system;
            }

            @Nullable
            public final String getVersion() {
                return this.version;
            }

            @Nullable
            public final String getBuild() {
                return this.build;
            }

            @NotNull
            public final String component1() {
                return this.system;
            }

            @Nullable
            public final String component2() {
                return this.version;
            }

            @Nullable
            public final String component3() {
                return this.build;
            }

            @NotNull
            public final Environment copy(@NotNull String system, @Nullable String version, @Nullable String build2) {
                Intrinsics.checkNotNullParameter((Object)system, (String)"system");
                return new Environment(system, version, build2);
            }

            public static /* synthetic */ Environment copy$default(Environment environment, String string, String string2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = environment.system;
                }
                if ((n & 2) != 0) {
                    string2 = environment.version;
                }
                if ((n & 4) != 0) {
                    string3 = environment.build;
                }
                return environment.copy(string, string2, string3);
            }

            @NotNull
            public String toString() {
                return "Environment(system=" + this.system + ", version=" + this.version + ", build=" + this.build + ")";
            }

            public int hashCode() {
                int result = this.system.hashCode();
                result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
                result = result * 31 + (this.build == null ? 0 : this.build.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Environment)) {
                    return false;
                }
                Environment environment = (Environment)other;
                if (!Intrinsics.areEqual((Object)this.system, (Object)environment.system)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.version, (Object)environment.version)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.build, (Object)environment.build);
            }
        }
    }
}

