/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.ide.plugins.CannotUnloadPluginException;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.CommandProvider;
import com.jetbrains.performancePlugin.CreateCommand;
import com.jetbrains.performancePlugin.RunCallbackHandler;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlaybackRunnerExtended
extends PlaybackRunner {
    public static final String NOTIFICATION_GROUP = "PerformancePlugin";
    private Project myProject;
    private boolean myStopped;
    private final DynamicPluginListener myDynamicPluginListener;

    public PlaybackRunnerExtended(String script, PlaybackRunner.StatusCallback callback, @NotNull Project project) {
        if (project == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(0);
        }
        super(script, callback, Registry.is((String)"performance.plugin.playback.runner.useDirectActionCall", (boolean)false), false, true);
        this.setProject(project);
        this.myDynamicPluginListener = new DynamicPluginListener(){

            public void checkUnloadPlugin(@NotNull IdeaPluginDescriptor pluginDescriptor) throws CannotUnloadPluginException {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PluginId.getId((String)"com.jetbrains.performancePlugin").equals((Object)pluginDescriptor.getPluginId())) {
                    throw new CannotUnloadPluginException("Cannot unload plugin during playback execution");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/jetbrains/performancePlugin/PlaybackRunnerExtended$1", "checkUnloadPlugin"));
            }
        };
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
        if (project != null && !project.isDefault()) {
            Disposer.register((Disposable)project, () -> {
                if (project == this.myProject) {
                    Disposer.dispose((Disposable)this.onStop);
                }
            });
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    protected void subscribeListeners(MessageBusConnection connection) {
        super.subscribeListeners(connection);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)this.myDynamicPluginListener);
    }

    protected void onStop() {
        super.onStop();
        this.myStopped = true;
    }

    @Nullable
    protected PlaybackCommand createCommand(@NotNull String _command, int line, @NotNull File scriptDir) {
        String commandName;
        CreateCommand createCommand;
        if (_command == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(1);
        }
        if (scriptDir == null) {
            PlaybackRunnerExtended.$$$reportNull$$$0(2);
        }
        String command = _command.replaceAll("[\r\n]+$", "");
        String[] cmdline = command.split("\\s+");
        PlaybackCommand playbackCommand = null;
        if (cmdline.length > 0 && (createCommand = CommandProvider.findCommandCreator(commandName = cmdline[0])) != null && (playbackCommand = createCommand.invoke(command, line)) instanceof AbstractCommand) {
            ((AbstractCommand)playbackCommand).setScriptDir(scriptDir);
        }
        if (playbackCommand == null) {
            playbackCommand = super.createCommand(command, line, scriptDir);
        }
        return playbackCommand;
    }

    public CompletableFuture<?> run() {
        if (this.myStopped) {
            throw new IllegalStateException("PlaybackRunnerExtended can be run only once.");
        }
        CompletableFuture callback = super.run();
        RunCallbackHandler.applyPatchesToCommandCallback(this.myProject, callback);
        return callback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptDir";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/PlaybackRunnerExtended";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

