/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.commands.ExitMetrics;
import com.jetbrains.performancePlugin.commands.MemoryCapture;
import com.jetbrains.performancePlugin.commands.MemoryMetrics;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ExitAppCommand
extends AbstractCallbackBasedCommand {
    @NonNls
    public static final String PREFIX = "%exitApp";

    public ExitAppCommand(@NotNull String text, int line) {
        if (text == null) {
            ExitAppCommand.$$$reportNull$$$0(0);
        }
        super(text, line, true);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback, @NotNull PlaybackContext context) {
        if (callback == null) {
            ExitAppCommand.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ExitAppCommand.$$$reportNull$$$0(2);
        }
        ExitAppCommand.writeExitMetricsIfNeeded();
        String[] arguments = this.getText().split(" ", 2);
        boolean forceExit = true;
        if (arguments.length > 1) {
            forceExit = Boolean.parseBoolean(arguments[1]);
        }
        ApplicationManager.getApplication().exit(forceExit, true, false);
        callback.setDone();
    }

    public static void writeExitMetricsIfNeeded() {
        String exitMetricsPath = System.getProperty("idea.log.exit.metrics.file");
        if (exitMetricsPath != null) {
            ExitAppCommand.writeExitMetrics(exitMetricsPath);
        }
    }

    private static void writeExitMetrics(String path) {
        MemoryCapture capture = MemoryCapture.capture();
        MemoryMetrics memory = new MemoryMetrics(capture.getUsedMb(), capture.getMaxMb(), capture.getMetaspaceMb());
        ExitMetrics metrics = new ExitMetrics(memory);
        try {
            new ObjectMapper().writeValue(new File(path), (Object)metrics);
        }
        catch (IOException e) {
            System.err.println("Unable to write exit metrics from " + ExitAppCommand.class.getSimpleName() + " " + e.getMessage());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/ExitAppCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

