/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonSchemaSpellcheckerClient;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JsonStringLiteral> ourStringLiteralTokenizer = new Tokenizer<JsonStringLiteral>(){

        @Override
        public void tokenize(@NotNull JsonStringLiteral element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                1.$$$reportNull$$$0(1);
            }
            PlainTextSplitter textSplitter = PlainTextSplitter.getInstance();
            if (element.textContains('\\')) {
                List<Pair<TextRange, String>> fragments = element.getTextFragments();
                for (Pair<TextRange, String> fragment2 : fragments) {
                    TextRange fragmentRange = (TextRange)fragment2.getFirst();
                    String escaped = (String)fragment2.getSecond();
                    if (escaped.length() != fragmentRange.getLength() || escaped.startsWith("\\")) continue;
                    consumer.consumeToken(element, escaped, false, fragmentRange.getStartOffset(), TextRange.allOf((String)escaped), textSplitter);
                }
            } else {
                consumer.consumeToken(element, textSplitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/json/JsonSpellcheckerStrategy$1";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @Override
    @NotNull
    public Tokenizer<?> getTokenizer(PsiElement element) {
        if (element instanceof JsonStringLiteral) {
            if (JsonSpellcheckerStrategy.isInjectedLanguageFragment(element)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JsonSpellcheckerStrategy.$$$reportNull$$$0(0);
                }
                return tokenizer;
            }
            Tokenizer<JsonStringLiteral> tokenizer = new JsonSchemaSpellcheckerClientForJson((JsonStringLiteral)element).matchesNameFromSchema() ? EMPTY_TOKENIZER : this.ourStringLiteralTokenizer;
            if (tokenizer == null) {
                JsonSpellcheckerStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            JsonSpellcheckerStrategy.$$$reportNull$$$0(2);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/JsonSpellcheckerStrategy", "getTokenizer"));
    }

    private static class JsonSchemaSpellcheckerClientForJson
    extends JsonSchemaSpellcheckerClient {
        @NotNull
        private final JsonStringLiteral element;

        protected JsonSchemaSpellcheckerClientForJson(@NotNull JsonStringLiteral element) {
            if (element == null) {
                JsonSchemaSpellcheckerClientForJson.$$$reportNull$$$0(0);
            }
            this.element = element;
        }

        @Override
        @NotNull
        protected JsonStringLiteral getElement() {
            JsonStringLiteral jsonStringLiteral = this.element;
            if (jsonStringLiteral == null) {
                JsonSchemaSpellcheckerClientForJson.$$$reportNull$$$0(1);
            }
            return jsonStringLiteral;
        }

        @Override
        @NotNull
        protected String getValue() {
            String string2 = this.element.getValue();
            if (string2 == null) {
                JsonSchemaSpellcheckerClientForJson.$$$reportNull$$$0(2);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/json/JsonSpellcheckerStrategy$JsonSchemaSpellcheckerClientForJson";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/json/JsonSpellcheckerStrategy$JsonSchemaSpellcheckerClientForJson";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2 -> new IllegalStateException(string2);
            };
        }
    }
}

