/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.breadcrumbs;

import com.intellij.json.JsonBundle;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonUtil;
import com.intellij.json.navigation.JsonQualifiedNameKind;
import com.intellij.json.navigation.JsonQualifiedNameProvider;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.Language;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBreadcrumbsProvider
implements BreadcrumbsProvider {
    private static final Language[] LANGUAGES = new Language[]{JsonLanguage.INSTANCE};

    public Language[] getLanguages() {
        return LANGUAGES;
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        if (e == null) {
            JsonBreadcrumbsProvider.$$$reportNull$$$0(0);
        }
        return e instanceof JsonProperty || JsonUtil.isArrayElement(e);
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        int i;
        if (e == null) {
            JsonBreadcrumbsProvider.$$$reportNull$$$0(1);
        }
        if (e instanceof JsonProperty) {
            String string2 = ((JsonProperty)e).getName();
            if (string2 == null) {
                JsonBreadcrumbsProvider.$$$reportNull$$$0(2);
            }
            return string2;
        }
        if (JsonUtil.isArrayElement(e) && (i = JsonUtil.getArrayIndexOfItem(e)) != -1) {
            String string3 = String.valueOf(i);
            if (string3 == null) {
                JsonBreadcrumbsProvider.$$$reportNull$$$0(3);
            }
            return string3;
        }
        throw new AssertionError((Object)"Breadcrumbs can be extracted only from JsonProperty elements or JsonArray child items");
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        if (e == null) {
            JsonBreadcrumbsProvider.$$$reportNull$$$0(4);
        }
        return JsonSchemaDocumentationProvider.findSchemaAndGenerateDoc(e, null, true, null);
    }

    @NotNull
    public List<? extends Action> getContextActions(final @NotNull PsiElement element) {
        if (element == null) {
            JsonBreadcrumbsProvider.$$$reportNull$$$0(5);
        }
        JsonQualifiedNameKind[] values2 = JsonQualifiedNameKind.values();
        ArrayList<1> actions2 = new ArrayList<1>(values2.length);
        for (final JsonQualifiedNameKind kind : values2) {
            actions2.add(new AbstractAction(JsonBundle.message("json.copy.to.clipboard", kind.toString())){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(JsonQualifiedNameProvider.generateQualifiedName(element, kind)));
                }
            });
        }
        ArrayList<1> arrayList = actions2;
        if (arrayList == null) {
            JsonBreadcrumbsProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/breadcrumbs/JsonBreadcrumbsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/breadcrumbs/JsonBreadcrumbsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementTooltip";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContextActions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 6 -> new IllegalStateException(string2);
        };
    }
}

