/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.utils.lang;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001f\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000b\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter;", "", "color", "Lcom/intellij/openapi/util/text/HtmlChunk;", "language", "", "rawContent", "Lcom/intellij/openapi/util/NlsSafe;", "Companion", "intellij.platform.markdown.utils"})
public interface HtmlSyntaxHighlighter {
    @NotNull
    public static final Companion Companion = com.intellij.markdown.utils.lang.HtmlSyntaxHighlighter$Companion.$$INSTANCE;

    @NotNull
    public HtmlChunk color(@Nullable String var1, @NotNull String var2);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bJB\u0010\f\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2 \u0010\u000f\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\r0\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/markdown/utils/lang/HtmlSyntaxHighlighter$Companion;", "", "()V", "colorHtmlChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "rawContent", "", "Lcom/intellij/openapi/util/NlsSafe;", "parseContent", "", "text", "collector", "Lkotlin/Function3;", "Lkotlin/ranges/IntRange;", "Ljava/awt/Color;", "intellij.platform.markdown.utils"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        public final void parseContent(@Nullable Project project2, @NotNull Language language, @NotNull String text2, @NotNull Function3<? super String, ? super IntRange, ? super Color, Unit> collector) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(collector, (String)"collector");
            LightVirtualFile file = new LightVirtualFile("markdown_temp", (CharSequence)text2);
            SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)((VirtualFile)file));
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getInstance().globalScheme");
            EditorColorsScheme colorScheme = editorColorsScheme;
            Lexer lexer = highlighter.getHighlightingLexer();
            Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"highlighter.highlightingLexer");
            Lexer lexer2 = lexer;
            lexer2.start((CharSequence)text2);
            while (lexer2.getTokenType() != null) {
                Object object;
                block5: {
                    TextAttributesKey textAttributesKey;
                    TextAttributesKey highlights;
                    block4: {
                        IElementType type2 = lexer2.getTokenType();
                        TextAttributesKey[] textAttributesKeyArray = highlighter.getTokenHighlights(type2);
                        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKeyArray, (String)"highlighter.getTokenHighlights(type)");
                        highlights = (TextAttributesKey)ArraysKt.lastOrNull((Object[])textAttributesKeyArray);
                        object = highlights;
                        if (object == null) break block4;
                        TextAttributesKey it = object;
                        boolean bl = false;
                        TextAttributes textAttributes = colorScheme.getAttributes(it);
                        Color color = textAttributes != null ? textAttributes.getForegroundColor() : null;
                        object = color;
                        if (color != null) break block5;
                    }
                    object = (textAttributesKey = highlights) != null && (textAttributesKey = textAttributesKey.getDefaultAttributes()) != null ? textAttributesKey.getForegroundColor() : null;
                }
                TextAttributesKey color = object;
                String string2 = lexer2.getTokenText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lexer.tokenText");
                collector.invoke((Object)string2, (Object)new IntRange(lexer2.getTokenStart(), lexer2.getTokenEnd()), (Object)color);
                lexer2.advance();
            }
        }

        @NotNull
        public final HtmlChunk colorHtmlChunk(@Nullable Project project2, @NotNull Language language, @NotNull String rawContent) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)rawContent, (String)"rawContent");
            HtmlBuilder html = new HtmlBuilder();
            this.parseContent(project2, language, rawContent, (Function3<? super String, ? super IntRange, ? super Color, Unit>)((Function3)new Function3<String, IntRange, Color, Unit>(html){
                final /* synthetic */ HtmlBuilder $html;
                {
                    this.$html = $html;
                    super(3);
                }

                public final void invoke(@NotNull String content, @NotNull IntRange intRange, @Nullable Color color) {
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    Intrinsics.checkNotNullParameter((Object)intRange, (String)"<anonymous parameter 1>");
                    String string2 = StringUtil.escapeXmlEntities((String)content);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeXmlEntities(content)");
                    String escapedContent = string2;
                    Color color2 = color;
                    this.$html.append(color2 != null ? (HtmlChunk)HtmlChunk.span((String)("color:" + ColorUtil.toHtmlColor((Color)color2))).addRaw(escapedContent) : HtmlChunk.raw((String)escapedContent));
                }
            }));
            HtmlChunk htmlChunk = html.toFragment();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"html.toFragment()");
            return htmlChunk;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

