/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.BeforeAfter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListsIndexes {
    private static final Logger LOG = Logger.getInstance(ChangeListsIndexes.class);
    private Map<FilePath, Data> myMap = new HashMap<FilePath, Data>();
    private Set<Change> myChanges = new HashSet<Change>();

    public void copyFrom(@NotNull ChangeListsIndexes idx) {
        if (idx == null) {
            ChangeListsIndexes.$$$reportNull$$$0(0);
        }
        this.myMap = new HashMap<FilePath, Data>(idx.myMap);
        this.myChanges = new HashSet<Change>(idx.myChanges);
    }

    public void clear() {
        this.myMap = new HashMap<FilePath, Data>();
        this.myChanges = new HashSet<Change>();
    }

    private void add(@NotNull FilePath file, @NotNull Change change, @NotNull FileStatus status, @Nullable AbstractVcs key2, @NotNull VcsRevisionNumber number) {
        if (file == null) {
            ChangeListsIndexes.$$$reportNull$$$0(1);
        }
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(2);
        }
        if (status == null) {
            ChangeListsIndexes.$$$reportNull$$$0(3);
        }
        if (number == null) {
            ChangeListsIndexes.$$$reportNull$$$0(4);
        }
        this.myMap.put(file, new Data(status, change, key2, number));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set status " + status + " for " + file);
        }
    }

    private void remove(@NotNull FilePath file) {
        if (file == null) {
            ChangeListsIndexes.$$$reportNull$$$0(5);
        }
        this.myMap.remove(file);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clear status for " + file);
        }
    }

    @Nullable
    public Change getChange(@NotNull FilePath file) {
        Data data2;
        if (file == null) {
            ChangeListsIndexes.$$$reportNull$$$0(6);
        }
        return (data2 = this.myMap.get(file)) != null ? data2.change : null;
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file) {
        Data data2;
        if (file == null) {
            ChangeListsIndexes.$$$reportNull$$$0(7);
        }
        return (data2 = this.myMap.get(file)) != null ? data2.status : null;
    }

    public void changeAdded(@NotNull Change change, @Nullable AbstractVcs key2) {
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(8);
        }
        this.myChanges.add(change);
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (beforeRevision != null && afterRevision != null) {
            this.add(afterRevision.getFile(), change, change.getFileStatus(), key2, beforeRevision.getRevisionNumber());
            if (!Objects.equals(beforeRevision.getFile(), afterRevision.getFile())) {
                this.add(beforeRevision.getFile(), change, FileStatus.DELETED, key2, beforeRevision.getRevisionNumber());
            }
        } else if (afterRevision != null) {
            this.add(afterRevision.getFile(), change, change.getFileStatus(), key2, VcsRevisionNumber.NULL);
        } else if (beforeRevision != null) {
            this.add(beforeRevision.getFile(), change, change.getFileStatus(), key2, beforeRevision.getRevisionNumber());
        }
    }

    public void changeRemoved(@NotNull Change change) {
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(9);
        }
        this.myChanges.remove(change);
        ContentRevision afterRevision = change.getAfterRevision();
        ContentRevision beforeRevision = change.getBeforeRevision();
        if (afterRevision != null) {
            this.remove(afterRevision.getFile());
        }
        if (beforeRevision != null) {
            this.remove(beforeRevision.getFile());
        }
    }

    @NotNull
    public Set<Change> getChanges() {
        Set<Change> set = this.myChanges;
        if (set == null) {
            ChangeListsIndexes.$$$reportNull$$$0(10);
        }
        return set;
    }

    @Nullable
    public AbstractVcs getVcsFor(@NotNull Change change) {
        AbstractVcs vcs;
        if (change == null) {
            ChangeListsIndexes.$$$reportNull$$$0(11);
        }
        if ((vcs = this.getVcsForRevision(change.getAfterRevision())) != null) {
            return vcs;
        }
        return this.getVcsForRevision(change.getBeforeRevision());
    }

    @Nullable
    private AbstractVcs getVcsForRevision(@Nullable ContentRevision revision) {
        if (revision != null) {
            Data data2 = this.myMap.get(revision.getFile());
            return data2 != null ? data2.vcs : null;
        }
        return null;
    }

    public void getDelta(ChangeListsIndexes newIndexes, Set<? super BaseRevision> toRemove, Set<? super BaseRevision> toAdd, Set<? super BeforeAfter<BaseRevision>> toModify) {
        FilePath s;
        Map<FilePath, Data> oldMap = this.myMap;
        Map<FilePath, Data> newMap = newIndexes.myMap;
        for (Map.Entry<FilePath, Data> entry2 : oldMap.entrySet()) {
            s = entry2.getKey();
            Data oldData = entry2.getValue();
            Data newData = newMap.get(s);
            if (newData != null) {
                if (oldData.sameRevisions(newData)) continue;
                toModify.add((BeforeAfter<BaseRevision>)new BeforeAfter((Object)ChangeListsIndexes.createBaseRevision(s, oldData), (Object)ChangeListsIndexes.createBaseRevision(s, newData)));
                continue;
            }
            toRemove.add(ChangeListsIndexes.createBaseRevision(s, oldData));
        }
        for (Map.Entry<FilePath, Data> entry2 : newMap.entrySet()) {
            s = entry2.getKey();
            Data newData = entry2.getValue();
            if (oldMap.containsKey(s)) continue;
            toAdd.add(ChangeListsIndexes.createBaseRevision(s, newData));
        }
    }

    private static BaseRevision createBaseRevision(@NotNull FilePath path2, @NotNull Data data2) {
        if (path2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(12);
        }
        if (data2 == null) {
            ChangeListsIndexes.$$$reportNull$$$0(13);
        }
        return new BaseRevision(data2.vcs, data2.revision, path2);
    }

    @NotNull
    public Set<FilePath> getAffectedPaths() {
        Set<FilePath> set = this.myMap.keySet();
        if (set == null) {
            ChangeListsIndexes.$$$reportNull$$$0(14);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idx";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeAdded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeRemoved";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createBaseRevision";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 14 -> new IllegalStateException(string2);
        };
    }

    private static class Data {
        @NotNull
        public final FileStatus status;
        @NotNull
        public final Change change;
        @Nullable
        public final AbstractVcs vcs;
        @NotNull
        public final VcsRevisionNumber revision;

        Data(@NotNull FileStatus status, @NotNull Change change, @Nullable AbstractVcs vcs, @NotNull VcsRevisionNumber revision) {
            if (status == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (change == null) {
                Data.$$$reportNull$$$0(1);
            }
            if (revision == null) {
                Data.$$$reportNull$$$0(2);
            }
            this.status = status;
            this.change = change;
            this.vcs = vcs;
            this.revision = revision;
        }

        public boolean sameRevisions(@NotNull Data data2) {
            if (data2 == null) {
                Data.$$$reportNull$$$0(3);
            }
            return Comparing.equal((Object)this.vcs, (Object)data2.vcs) && Comparing.equal((Object)this.revision, (Object)data2.revision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListsIndexes$Data";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sameRevisions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

