/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.CommonBundle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"askMaxCount", "", "project", "Lcom/intellij/openapi/project/Project;", "getChangeBrowserSettings", "Lcom/intellij/openapi/vcs/versionBrowser/ChangeBrowserSettings;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "showCommittedChanges", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "intellij.platform.vcs.impl"})
public final class BrowseCommittedChangesActionKt {
    private static final ChangeBrowserSettings getChangeBrowserSettings(AbstractVcs vcs) {
        ChangeBrowserSettings changeBrowserSettings = vcs.getConfiguration().changeBrowserSettings.computeIfAbsent(vcs.getName(), arg_0 -> BrowseCommittedChangesActionKt.getChangeBrowserSettings$lambda$0((Function1)new Function1<String, ChangeBrowserSettings>(vcs){
            final /* synthetic */ AbstractVcs $vcs;
            {
                this.$vcs = $vcs;
                super(1);
            }

            public final ChangeBrowserSettings invoke(String vcsName) {
                CommittedChangesProvider<CommittedChangeList, ?> committedChangesProvider = this.$vcs.getCommittedChangesProvider();
                Intrinsics.checkNotNull(committedChangesProvider);
                ? obj = committedChangesProvider.createDefaultSettings();
                AbstractVcs abstractVcs = this.$vcs;
                ? it = obj;
                boolean bl = false;
                Project project2 = abstractVcs.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"vcs.project");
                IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)project2));
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                iComponentStore.initPersistencePlainComponent(it, "VcsManager.ChangeBrowser." + vcsName);
                return obj;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)changeBrowserSettings, (String)"vcs: AbstractVcs): Chang\u2026wser.$vcsName\")\n    }\n  }");
        return changeBrowserSettings;
    }

    private static final void showCommittedChanges(AbstractVcs vcs, VirtualFile file, ChangeBrowserSettings settings) {
        int maxCount;
        if (!settings.isAnyFilterSpecified()) {
            Project project2 = vcs.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"vcs.project");
            v1 = BrowseCommittedChangesActionKt.askMaxCount(project2);
        } else {
            v1 = maxCount = 0;
        }
        if (maxCount < 0) {
            return;
        }
        RepositoryLocation repositoryLocation = CommittedChangesCache.getInstance(vcs.getProject()).getLocationCache().getLocation(vcs, VcsUtil.getFilePath(file), false);
        if (repositoryLocation == null) {
            Object[] objectArray = new Object[]{file.getPresentableUrl()};
            VcsBalloonProblemNotifier.showOverVersionControlView(vcs.getProject(), VcsBundle.message("changes.notification.content.repository.location.not.found.for", objectArray), MessageType.ERROR);
            return;
        }
        AbstractVcsHelper abstractVcsHelper = AbstractVcsHelper.getInstance(vcs.getProject());
        CommittedChangesProvider<? extends CommittedChangeList, ?> committedChangesProvider = vcs.getCommittedChangesProvider();
        Intrinsics.checkNotNull(committedChangesProvider);
        abstractVcsHelper.openCommittedChangesTab(committedChangesProvider, repositoryLocation, settings, maxCount, null);
    }

    private static final int askMaxCount(Project project2) {
        return switch (Messages.showYesNoCancelDialog((Project)project2, (String)VcsBundle.message("browse.changes.no.filter.prompt", new Object[0]), (String)VcsBundle.message("browse.changes.title", new Object[0]), (String)VcsBundle.message("browse.changes.show.recent.button", new Object[0]), (String)VcsBundle.message("browse.changes.show.all.button", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) {
            case 2 -> -1;
            case 0 -> 50;
            default -> 0;
        };
    }

    private static final ChangeBrowserSettings getChangeBrowserSettings$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChangeBrowserSettings)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ChangeBrowserSettings access$getChangeBrowserSettings(AbstractVcs vcs) {
        return BrowseCommittedChangesActionKt.getChangeBrowserSettings(vcs);
    }

    public static final /* synthetic */ void access$showCommittedChanges(AbstractVcs vcs, VirtualFile file, ChangeBrowserSettings settings) {
        BrowseCommittedChangesActionKt.showCommittedChanges(vcs, file, settings);
    }
}

