/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangeListDecorator;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.ReceivedChangeList;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Container;
import java.awt.FontMetrics;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CommittedChangeListRenderer
extends ColoredTreeCellRenderer {
    private final IssueLinkRenderer myRenderer;
    private final List<? extends CommittedChangeListDecorator> myDecorators;
    private final Project myProject;
    private int myDateWidth;
    private int myFontSize;

    public CommittedChangeListRenderer(Project project2, List<? extends CommittedChangeListDecorator> decorators) {
        this.myProject = project2;
        this.myRenderer = new IssueLinkRenderer(project2, (SimpleColoredComponent)this);
        this.myDecorators = decorators;
        this.myDateWidth = 0;
        this.myFontSize = -1;
    }

    @NotNull
    public static String getDescriptionOfChangeList(@NotNull String text2) {
        if (text2 == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(0);
        }
        String string2 = text2.replaceAll("\n", " // ");
        if (string2 == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String truncateDescription(@NotNull String initDescription, @NotNull FontMetrics fontMetrics, int maxWidth) {
        if (initDescription == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(2);
        }
        if (fontMetrics == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(3);
        }
        int low = 0;
        int high = initDescription.length() - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            String iteration = initDescription.substring(0, mid);
            int stringWidth = fontMetrics.stringWidth(iteration);
            if (stringWidth > maxWidth) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        int lastSpaceIndex = initDescription.lastIndexOf(" ", low - 1);
        String string2 = lastSpaceIndex == -1 ? initDescription : initDescription.substring(0, lastSpaceIndex);
        if (string2 == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public void customizeCellRenderer(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        if (tree2 == null) {
            CommittedChangeListRenderer.$$$reportNull$$$0(5);
        }
        this.customize(tree2, value2, selected, expanded, leaf, row2, hasFocus);
    }

    public void customize(JComponent tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
        if (userObject instanceof CommittedChangeList) {
            CommittedChangeList changeList = (CommittedChangeList)userObject;
            this.renderChangeList(tree2, changeList);
        } else if (userObject instanceof String) {
            this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
    }

    public void renderChangeList(JComponent tree2, CommittedChangeList changeList) {
        CachingCommittedChangesProvider<CommittedChangeList, ?> provider;
        Container parent = tree2.getParent();
        int rowX = CommittedChangeListRenderer.getRowX(this.myTree, 2);
        int availableWidth = parent == null ? 100 : parent.getWidth() - rowX;
        FontMetrics fontMetrics = tree2.getFontMetrics(tree2.getFont());
        FontMetrics boldMetrics = tree2.getFontMetrics(tree2.getFont().deriveFont(1));
        FontMetrics italicMetrics = tree2.getFontMetrics(tree2.getFont().deriveFont(2));
        if (this.myDateWidth <= 0 || fontMetrics.getFont().getSize() != this.myFontSize) {
            this.myDateWidth = Math.max(fontMetrics.stringWidth(", Yesterday 00:00 PM "), fontMetrics.stringWidth(", 00/00/00 00:00 PM "));
            this.myDateWidth = Math.max(this.myDateWidth, fontMetrics.stringWidth(DateFormatUtil.formatPrettyDateTime((Date)DateFormatUtil.getSampleDateTime())));
            this.myFontSize = fontMetrics.getFont().getSize();
        }
        int dateCommitterSize = this.myDateWidth + boldMetrics.stringWidth(changeList.getCommitterName());
        String description2 = CommittedChangeListRenderer.getDescriptionOfChangeList(changeList.getName().trim());
        for (CommittedChangeListDecorator committedChangeListDecorator : this.myDecorators) {
            Icon icon2 = committedChangeListDecorator.decorate(changeList);
            if (icon2 == null) continue;
            this.setIcon(icon2);
        }
        int descMaxWidth = availableWidth - dateCommitterSize - 8;
        boolean bl = changeList instanceof ReceivedChangeList && ((ReceivedChangeList)changeList).isPartial();
        int descWidth = 0;
        int partialMarkerWidth = 0;
        if (bl) {
            String partialMarker = VcsBundle.message("committed.changes.partial.list", new Object[0]) + " ";
            this.append(partialMarker, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            partialMarkerWidth = boldMetrics.stringWidth(partialMarker);
            descWidth += partialMarkerWidth;
        }
        descWidth += fontMetrics.stringWidth(description2);
        int numberWidth = 0;
        AbstractVcs vcs = changeList.getVcs();
        if (vcs != null && (provider = vcs.getCachingCommittedChangesProvider()) != null && provider.getChangelistTitle() != null) {
            String number = "#" + changeList.getNumber() + "  ";
            numberWidth = fontMetrics.stringWidth(number);
            descWidth += numberWidth;
            this.append(number, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        int branchWidth = 0;
        Object branch = changeList.getBranch();
        if (branch != null) {
            branch = (String)branch + " ";
            branchWidth = italicMetrics.stringWidth((String)branch);
            descWidth += branchWidth;
            this.append((String)branch, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
        if (description2.isEmpty()) {
            this.append(VcsBundle.message("committed.changes.empty.comment", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.appendTextPadding(descMaxWidth);
        } else if (descMaxWidth < 0) {
            this.myRenderer.appendTextWithLinks(description2);
        } else if (descWidth < descMaxWidth) {
            this.myRenderer.appendTextWithLinks(description2);
            this.appendTextPadding(descMaxWidth);
        } else {
            String moreMarker = VcsBundle.message("changes.browser.details.marker", new Object[0]);
            int moreWidth = fontMetrics.stringWidth(moreMarker);
            int remainingWidth = descMaxWidth - moreWidth - numberWidth - branchWidth - partialMarkerWidth;
            description2 = CommittedChangeListRenderer.truncateDescription(description2, fontMetrics, remainingWidth);
            this.myRenderer.appendTextWithLinks(description2);
            if (!StringUtil.isEmpty((String)description2)) {
                this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.append(moreMarker, SimpleTextAttributes.LINK_ATTRIBUTES, new CommittedChangesTreeBrowser.MoreLauncher(this.myProject, changeList));
            } else if (remainingWidth > 0) {
                this.append(moreMarker, SimpleTextAttributes.LINK_ATTRIBUTES, new CommittedChangesTreeBrowser.MoreLauncher(this.myProject, changeList));
            }
            this.appendTextPadding(descMaxWidth);
        }
        this.append(changeList.getCommitterName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (changeList.getCommitDate() != null) {
            this.append(", " + DateFormatUtil.formatPrettyDateTime((Date)changeList.getCommitDate()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    public static int getRowX(JTree tree2, int depth) {
        if (tree2 == null) {
            return 0;
        }
        TreeUI ui2 = tree2.getUI();
        if (ui2 instanceof BasicTreeUI) {
            BasicTreeUI treeUI = (BasicTreeUI)ui2;
            return (treeUI.getLeftChildIndent() + treeUI.getRightChildIndent()) * depth;
        }
        int leftIndent = UIUtil.getTreeLeftChildIndent();
        int rightIndent = UIUtil.getTreeRightChildIndent();
        return (leftIndent + rightIndent) * depth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/committed/CommittedChangeListRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initDescription";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/CommittedChangeListRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionOfChangeList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionOfChangeList";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "truncateDescription";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 4 -> new IllegalStateException(string2);
        };
    }
}

