/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InclusionListener;
import com.intellij.openapi.vcs.changes.InclusionModel;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeCopyProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeCellRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeHandlers;
import com.intellij.openapi.vcs.changes.ui.DefaultInclusionModel;
import com.intellij.openapi.vcs.changes.ui.FixedHeightSampleChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.NullInclusionModel;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.commit.CommitSessionCollector;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangesTree
extends Tree
implements DataProvider {
    @ApiStatus.Internal
    @NonNls
    public static final String LOG_COMMIT_SESSION_EVENTS = "LogCommitSessionEvents";
    @NotNull
    public static final TreeStateStrategy<?> DO_NOTHING = new DoNothingTreeStateStrategy();
    @NotNull
    public static final TreeStateStrategy<?> ALWAYS_RESET = new AlwaysResetTreeStateStrategy();
    @NotNull
    public static final TreeStateStrategy<?> ALWAYS_KEEP = new AlwaysKeepTreeStateStrategy();
    @NotNull
    public static final TreeStateStrategy<?> KEEP_NON_EMPTY = new KeepNonEmptyTreeStateStrategy();
    @NotNull
    public static final TreeStateStrategy<?> KEEP_SELECTED_OBJECTS = new KeepSelectedObjectsStrategy();
    @NotNull
    protected final Project myProject;
    private boolean myShowCheckboxes;
    private final boolean myHighlightProblems;
    private final int myCheckboxWidth;
    @NotNull
    private final ChangesGroupingSupport myGroupingSupport;
    private boolean myIsModelFlat;
    @NotNull
    private InclusionModel myInclusionModel;
    @NotNull
    private final InclusionListener myInclusionModelListener;
    @Nullable
    private Runnable myTreeInclusionListener;
    @NotNull
    private final ChangesTreeHandlers myHandlers;
    @NotNull
    private TreeStateStrategy<?> myTreeStateStrategy;
    private boolean myScrollToSelection;
    @Deprecated
    @NonNls
    private static final String FLATTEN_OPTION_KEY = "ChangesBrowser.SHOW_FLATTEN";
    @NonNls
    protected static final String GROUPING_KEYS = "ChangesTree.GroupingKeys";
    public static final List<String> DEFAULT_GROUPING_KEYS = List.of("directory", "module");
    @NonNls
    public static final String GROUP_BY_ACTION_GROUP = "ChangesView.GroupBy";
    @NotNull
    private final CopyProvider myTreeCopyProvider;
    @NotNull
    private TreeExpander myTreeExpander;
    private boolean myModelUpdateInProgress;
    private AWTEvent myEventProcessingInProgress;

    public ChangesTree(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems) {
        if (project2 == null) {
            ChangesTree.$$$reportNull$$$0(0);
        }
        this(project2, showCheckboxes, highlightProblems, true);
    }

    protected ChangesTree(@NotNull Project project2, boolean showCheckboxes, boolean highlightProblems, boolean withSpeedSearch) {
        if (project2 == null) {
            ChangesTree.$$$reportNull$$$0(1);
        }
        super(ChangesBrowserNode.createRoot());
        this.myInclusionModel = new DefaultInclusionModel();
        this.myInclusionModelListener = () -> {
            this.notifyInclusionListener();
            this.repaint();
        };
        this.myTreeStateStrategy = ALWAYS_RESET;
        this.myScrollToSelection = true;
        this.myTreeExpander = new MyTreeExpander();
        this.myProject = project2;
        this.myShowCheckboxes = showCheckboxes;
        this.myHighlightProblems = highlightProblems;
        this.myCheckboxWidth = new JCheckBox().getPreferredSize().width;
        this.myInclusionModel.addInclusionListener(this.myInclusionModelListener);
        this.myHandlers = new ChangesTreeHandlers(this);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        if (withSpeedSearch) {
            TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)false, ChangesBrowserNode.TO_TEXT_CONVERTER);
        }
        ChangesBrowserNodeRenderer nodeRenderer = new ChangesBrowserNodeRenderer(this.myProject, this::isShowFlatten, highlightProblems);
        this.setCellRenderer(new ChangesTreeCellRenderer(nodeRenderer));
        new MyToggleSelectionAction().registerCustomShortcutSet((JComponent)((Object)this), null);
        this.installCheckBoxClickHandler();
        this.installTreeLinkHandler(nodeRenderer);
        SmartExpander.installOn((JTree)((Object)this));
        this.myGroupingSupport = this.installGroupingSupport();
        this.setEmptyText(DiffBundle.message((String)"diff.count.differences.status.text", (Object[])new Object[]{0}));
        this.myTreeCopyProvider = new ChangesBrowserNodeCopyProvider((JTree)((Object)this));
        this.installCommitSessionEventsListeners();
        if (Registry.is((String)"vcs.changes.tree.use.fixed.height.renderer")) {
            this.putClientProperty(DefaultTreeUI.LARGE_MODEL_ALLOWED, true);
            this.setLargeModel(true);
            this.updateFixedRowHeight();
        }
    }

    private void updateFixedRowHeight() {
        if (!this.isLargeModel()) {
            return;
        }
        int fixedRowHeight = UIManager.getInt(JBUI.CurrentTheme.Tree.rowHeightKey());
        if (fixedRowHeight > 0) {
            return;
        }
        TreeCellRenderer renderer = this.getCellRenderer();
        if (renderer == null) {
            return;
        }
        FixedHeightSampleChangesBrowserNode sampleNode = new FixedHeightSampleChangesBrowserNode();
        Component component2 = renderer.getTreeCellRendererComponent((JTree)((Object)this), sampleNode, true, true, true, 0, true);
        int rendererHeight = component2.getPreferredSize().height;
        if (rendererHeight <= 0) {
            return;
        }
        this.setRowHeight(rendererHeight);
    }

    public void setUI(TreeUI ui2) {
        super.setUI(ui2);
        this.updateFixedRowHeight();
    }

    private void installCheckBoxClickHandler() {
        ClickListener handler2 = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                TreePath path2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((path2 = ChangesTree.this.getPathIfCheckBoxClicked(event.getPoint())) != null) {
                    ChangesTree.this.setSelectionPath(path2);
                    List<Object> selected = ChangesTree.this.getIncludableUserObjects(VcsTreeModelData.selected((JTree)((Object)ChangesTree.this)));
                    boolean exclude2 = ChangesTree.this.toggleChanges(selected);
                    ChangesTree.this.logInclusionToggleEvents(exclude2, event);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/ui/ChangesTree$1", "onClick"));
            }
        };
        handler2.installOn((Component)((Object)this));
    }

    @Nullable
    TreePath getPathIfCheckBoxClicked(@NotNull Point p) {
        if (p == null) {
            ChangesTree.$$$reportNull$$$0(2);
        }
        if (!this.myShowCheckboxes || !this.isEnabled()) {
            return null;
        }
        TreePath path2 = this.getPathForLocation(p.x, p.y);
        if (path2 == null) {
            return null;
        }
        if (!this.isIncludable(path2)) {
            return null;
        }
        Rectangle pathBounds = this.getPathBounds(path2);
        if (pathBounds == null) {
            return null;
        }
        Rectangle checkBoxBounds = pathBounds.getBounds();
        checkBoxBounds.setSize(this.myCheckboxWidth, checkBoxBounds.height);
        if (!checkBoxBounds.contains(p)) {
            return null;
        }
        return path2;
    }

    protected void installTreeLinkHandler(@NotNull ChangesBrowserNodeRenderer nodeRenderer) {
        if (nodeRenderer == null) {
            ChangesTree.$$$reportNull$$$0(3);
        }
        new TreeLinkMouseListener(nodeRenderer){

            protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree2, @NotNull TreePath path2) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (tree2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (path2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                int x = super.getRendererRelativeX(e, tree2, path2);
                if (ChangesTree.this.myShowCheckboxes && ChangesTree.this.isIncludable(path2)) {
                    x -= ChangesTree.this.myCheckboxWidth;
                }
                return x;
            }

            public void mouseMoved(MouseEvent e) {
                if (!ChangesTree.this.isEmpty()) {
                    super.mouseMoved(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tree";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$2";
                objectArray[2] = "getRendererRelativeX";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.installOn((Component)((Object)this));
    }

    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        ChangesGroupingSupport result2 = new ChangesGroupingSupport(this.myProject, (Object)this, false);
        this.migrateShowFlattenSetting();
        ChangesTree.installGroupingSupport(this, result2, GROUPING_KEYS, DEFAULT_GROUPING_KEYS);
        ChangesGroupingSupport changesGroupingSupport = result2;
        if (changesGroupingSupport == null) {
            ChangesTree.$$$reportNull$$$0(4);
        }
        return changesGroupingSupport;
    }

    protected static void installGroupingSupport(@NotNull ChangesTree tree2, @NotNull ChangesGroupingSupport groupingSupport, @NotNull @NonNls String propertyName, @NonNls List<String> defaultGroupingKeys) {
        if (tree2 == null) {
            ChangesTree.$$$reportNull$$$0(5);
        }
        if (groupingSupport == null) {
            ChangesTree.$$$reportNull$$$0(6);
        }
        if (propertyName == null) {
            ChangesTree.$$$reportNull$$$0(7);
        }
        ChangesTree.installGroupingSupport(tree2, groupingSupport, () -> {
            List storedList = PropertiesComponent.getInstance((Project)tree2.getProject()).getList(propertyName);
            return Objects.requireNonNullElse(storedList, defaultGroupingKeys);
        }, (? super Collection<String> newValue) -> PropertiesComponent.getInstance((Project)tree2.getProject()).setList(propertyName, newValue));
    }

    protected static void installGroupingSupport(@NotNull ChangesTree tree2, @NotNull ChangesGroupingSupport groupingSupport, @NotNull Supplier<? extends Collection<String>> settingsGetter, @NotNull Consumer<? super Collection<String>> settingsSetter) {
        if (tree2 == null) {
            ChangesTree.$$$reportNull$$$0(8);
        }
        if (groupingSupport == null) {
            ChangesTree.$$$reportNull$$$0(9);
        }
        if (settingsGetter == null) {
            ChangesTree.$$$reportNull$$$0(10);
        }
        if (settingsSetter == null) {
            ChangesTree.$$$reportNull$$$0(11);
        }
        ChangesTree.installGroupingSupport(groupingSupport, settingsGetter, settingsSetter, () -> tree2.onGroupingChanged());
    }

    public static void installGroupingSupport(@NotNull ChangesGroupingSupport groupingSupport, @NotNull Supplier<? extends Collection<String>> settingsGetter, @NotNull Consumer<? super Collection<String>> settingsSetter, @NotNull Runnable refresh2) {
        if (groupingSupport == null) {
            ChangesTree.$$$reportNull$$$0(12);
        }
        if (settingsGetter == null) {
            ChangesTree.$$$reportNull$$$0(13);
        }
        if (settingsSetter == null) {
            ChangesTree.$$$reportNull$$$0(14);
        }
        if (refresh2 == null) {
            ChangesTree.$$$reportNull$$$0(15);
        }
        groupingSupport.setGroupingKeysOrSkip(settingsGetter.get());
        groupingSupport.addPropertyChangeListener(e -> {
            settingsSetter.accept(ContainerUtil.sorted(groupingSupport.getGroupingKeys()));
            refresh2.run();
        });
    }

    private void migrateShowFlattenSetting() {
        PropertiesComponent properties2 = PropertiesComponent.getInstance((Project)this.myProject);
        if (properties2.isValueSet(FLATTEN_OPTION_KEY)) {
            properties2.setList(GROUPING_KEYS, properties2.isTrueValue(FLATTEN_OPTION_KEY) ? Collections.emptyList() : DEFAULT_GROUPING_KEYS);
            properties2.unsetValue(FLATTEN_OPTION_KEY);
        }
    }

    public void setEmptyText(@Nls @NotNull String emptyText) {
        if (emptyText == null) {
            ChangesTree.$$$reportNull$$$0(16);
        }
        this.getEmptyText().setText(emptyText);
    }

    public void addSelectionListener(@NotNull Runnable runnable) {
        if (runnable == null) {
            ChangesTree.$$$reportNull$$$0(17);
        }
        this.addSelectionListener(runnable, null);
    }

    public void addSelectionListener(final @NotNull Runnable runnable, @Nullable Disposable parent) {
        if (runnable == null) {
            ChangesTree.$$$reportNull$$$0(18);
        }
        TreeSelectionListener listener2 = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                runnable.run();
            }
        };
        this.addTreeSelectionListener(listener2);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> this.removeTreeSelectionListener(listener2));
        }
    }

    public void setDoubleClickAndEnterKeyHandler(@NotNull Runnable handler2) {
        if (handler2 == null) {
            ChangesTree.$$$reportNull$$$0(19);
        }
        this.setDoubleClickHandler((Processor<? super MouseEvent>)((Processor)e -> {
            handler2.run();
            return true;
        }));
        this.setEnterKeyHandler((Processor<? super KeyEvent>)((Processor)e -> {
            handler2.run();
            return true;
        }));
    }

    @Nullable
    public Processor<? super MouseEvent> getDoubleClickHandler() {
        return this.myHandlers.getDoubleClickHandler();
    }

    public void setDoubleClickHandler(@Nullable Processor<? super MouseEvent> handler2) {
        this.myHandlers.setDoubleClickHandler(handler2);
    }

    @Nullable
    public Processor<? super KeyEvent> getEnterKeyHandler() {
        return this.myHandlers.getEnterKeyHandler();
    }

    public void setEnterKeyHandler(@Nullable Processor<? super KeyEvent> handler2) {
        this.myHandlers.setEnterKeyHandler(handler2);
    }

    public void installPopupHandler(ActionGroup group2) {
        PopupHandler.installPopupMenu((JComponent)((Object)this), (ActionGroup)group2, (String)"ChangesTreePopup");
    }

    public JComponent getPreferredFocusedComponent() {
        return this;
    }

    public void addGroupingChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            ChangesTree.$$$reportNull$$$0(20);
        }
        this.myGroupingSupport.addPropertyChangeListener(listener2);
    }

    public void removeGroupingChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            ChangesTree.$$$reportNull$$$0(21);
        }
        this.myGroupingSupport.removePropertyChangeListener(listener2);
    }

    @NotNull
    public ChangesGroupingSupport getGroupingSupport() {
        ChangesGroupingSupport changesGroupingSupport = this.myGroupingSupport;
        if (changesGroupingSupport == null) {
            ChangesTree.$$$reportNull$$$0(22);
        }
        return changesGroupingSupport;
    }

    @NotNull
    public ChangesGroupingPolicyFactory getGrouping() {
        ChangesGroupingPolicyFactory changesGroupingPolicyFactory = this.getGroupingSupport().getGrouping();
        if (changesGroupingPolicyFactory == null) {
            ChangesTree.$$$reportNull$$$0(23);
        }
        return changesGroupingPolicyFactory;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ChangesTree.$$$reportNull$$$0(24);
        }
        return project2;
    }

    public boolean isShowFlatten() {
        return !this.myGroupingSupport.isDirectory();
    }

    public boolean isShowCheckboxes() {
        return this.myShowCheckboxes;
    }

    public void setShowCheckboxes(boolean value2) {
        boolean oldValue = this.myShowCheckboxes;
        this.myShowCheckboxes = value2;
        if (oldValue != value2) {
            this.updateFixedRowHeight();
            this.repaint();
        }
    }

    public boolean isHighlightProblems() {
        return this.myHighlightProblems;
    }

    private boolean isCurrentModelFlat() {
        boolean isFlat = true;
        Enumeration<TreeNode> enumeration = this.getRoot().depthFirstEnumeration();
        while (isFlat && enumeration.hasMoreElements()) {
            isFlat = ((ChangesBrowserNode)enumeration.nextElement()).getLevel() <= 1;
        }
        return isFlat;
    }

    public void onGroupingChanged() {
        this.rebuildTree(KEEP_SELECTED_OBJECTS);
    }

    public abstract void rebuildTree();

    public void rebuildTree(@NotNull TreeStateStrategy<?> treeStateStrategy) {
        if (treeStateStrategy == null) {
            ChangesTree.$$$reportNull$$$0(25);
        }
        TreeStateStrategy<?> oldTreeStateStrategy = this.myTreeStateStrategy;
        this.myTreeStateStrategy = treeStateStrategy;
        try {
            this.rebuildTree();
        }
        finally {
            this.myTreeStateStrategy = oldTreeStateStrategy;
        }
    }

    protected void updateTreeModel(@NotNull DefaultTreeModel model2) {
        if (model2 == null) {
            ChangesTree.$$$reportNull$$$0(26);
        }
        this.updateTreeModel(model2, this.myTreeStateStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTreeModel(@NotNull DefaultTreeModel model2, @NotNull TreeStateStrategy treeStateStrategy) {
        if (model2 == null) {
            ChangesTree.$$$reportNull$$$0(27);
        }
        if (treeStateStrategy == null) {
            ChangesTree.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myModelUpdateInProgress = true;
        try {
            Object state = treeStateStrategy.saveState(this);
            this.setModel(model2);
            this.myIsModelFlat = this.isCurrentModelFlat();
            this.setShowsRootHandles(!this.myGroupingSupport.isNone() || !this.myIsModelFlat);
            treeStateStrategy.restoreState(this, state, this.myScrollToSelection);
        }
        finally {
            this.myModelUpdateInProgress = false;
        }
    }

    public boolean isModelUpdateInProgress() {
        return this.myModelUpdateInProgress;
    }

    public void resetTreeState() {
        if (TreeUtil.hasManyNodes((Tree)this, (int)30000)) {
            TreeUtil.collapseAll((JTree)((Object)this), (int)1);
            return;
        }
        this.expandDefaults();
        int selectedTreeRow = -1;
        if (this.myShowCheckboxes && !this.getIncludedSet().isEmpty()) {
            ChangesBrowserNode node;
            ChangesBrowserNode<?> root = this.getRoot();
            Enumeration<TreeNode> enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (node == root || this.getNodeStatus(node) != ThreeStateCheckBox.State.NOT_SELECTED) continue;
                this.collapsePath(new TreePath(node.getPath()));
            }
            enumeration = root.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                node = (ChangesBrowserNode)enumeration.nextElement();
                if (!node.isLeaf() || this.getNodeStatus(node) != ThreeStateCheckBox.State.SELECTED) continue;
                selectedTreeRow = this.getRowForPath(new TreePath(node.getPath()));
                break;
            }
        }
        if (selectedTreeRow >= 0) {
            this.setSelectionRow(selectedTreeRow);
        }
        TreeUtil.showRowCentered((JTree)((Object)this), (int)selectedTreeRow, (boolean)false);
    }

    public void selectFile(@Nullable VirtualFile toSelect) {
        if (toSelect == null) {
            return;
        }
        this.selectFile(VcsUtil.getFilePath(toSelect));
    }

    public void selectFile(@Nullable FilePath toSelect) {
        if (toSelect == null) {
            return;
        }
        int rowInTree = this.findRowContainingFile(this.getRoot(), toSelect);
        if (rowInTree == -1) {
            return;
        }
        this.setSelectionRow(rowInTree);
        TreeUtil.showRowCentered((JTree)((Object)this), (int)rowInTree, (boolean)false);
    }

    private int findRowContainingFile(@NotNull TreeNode root, @NotNull FilePath toSelect) {
        TreeNode targetNode;
        if (root == null) {
            ChangesTree.$$$reportNull$$$0(29);
        }
        if (toSelect == null) {
            ChangesTree.$$$reportNull$$$0(30);
        }
        if ((targetNode = (TreeNode)TreeUtil.treeNodeTraverser((TreeNode)root).traverse(TreeTraversal.POST_ORDER_DFS).find(node -> {
            Object userObject;
            if (node instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Change) {
                return ChangesTree.matches((Change)userObject, toSelect);
            }
            return false;
        })) != null) {
            return TreeUtil.getRowForNode((JTree)((Object)this), (DefaultMutableTreeNode)((DefaultMutableTreeNode)targetNode));
        }
        return -1;
    }

    private static boolean matches(@NotNull Change change, @NotNull FilePath toSelect) {
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(31);
        }
        if (toSelect == null) {
            ChangesTree.$$$reportNull$$$0(32);
        }
        return toSelect.equals(ChangesUtil.getAfterPath(change)) || toSelect.equals(ChangesUtil.getBeforePath(change));
    }

    @NotNull
    public ChangesBrowserNode<?> getRoot() {
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)this.getModel().getRoot();
        if (changesBrowserNode == null) {
            ChangesTree.$$$reportNull$$$0(33);
        }
        return changesBrowserNode;
    }

    @NotNull
    public InclusionModel getInclusionModel() {
        InclusionModel inclusionModel = this.myInclusionModel;
        if (inclusionModel == null) {
            ChangesTree.$$$reportNull$$$0(34);
        }
        return inclusionModel;
    }

    public void setInclusionModel(@Nullable InclusionModel inclusionModel) {
        this.myInclusionModel.removeInclusionListener(this.myInclusionModelListener);
        this.myInclusionModel = inclusionModel != null ? inclusionModel : NullInclusionModel.INSTANCE;
        this.myInclusionModel.addInclusionListener(this.myInclusionModelListener);
    }

    public void setInclusionListener(@Nullable Runnable runnable) {
        this.myTreeInclusionListener = runnable;
    }

    private void notifyInclusionListener() {
        if (this.myTreeInclusionListener != null) {
            this.myTreeInclusionListener.run();
        }
    }

    public void setIncludedChanges(@NotNull Collection<?> changes) {
        if (changes == null) {
            ChangesTree.$$$reportNull$$$0(35);
        }
        this.getInclusionModel().setInclusion(changes);
    }

    public void includeChange(@NotNull Object change) {
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(36);
        }
        this.includeChanges(Collections.singleton(change));
    }

    public void includeChanges(@NotNull Collection<?> changes) {
        if (changes == null) {
            ChangesTree.$$$reportNull$$$0(37);
        }
        this.getInclusionModel().addInclusion(changes);
    }

    public void excludeChange(@NotNull Object change) {
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(38);
        }
        this.excludeChanges(Collections.singleton(change));
    }

    public void excludeChanges(@NotNull Collection<?> changes) {
        if (changes == null) {
            ChangesTree.$$$reportNull$$$0(39);
        }
        this.getInclusionModel().removeInclusion(changes);
    }

    protected boolean toggleChanges(@NotNull Collection<?> changes) {
        if (changes == null) {
            ChangesTree.$$$reportNull$$$0(40);
        }
        boolean hasExcluded = false;
        for (Object item2 : changes) {
            if (this.getInclusionModel().getInclusionState(item2) == ThreeStateCheckBox.State.SELECTED) continue;
            hasExcluded = true;
            break;
        }
        if (hasExcluded) {
            this.includeChanges(changes);
            return false;
        }
        this.excludeChanges(changes);
        return true;
    }

    public boolean isIncluded(@NotNull Object change) {
        if (change == null) {
            ChangesTree.$$$reportNull$$$0(41);
        }
        return this.getInclusionModel().getInclusionState(change) != ThreeStateCheckBox.State.NOT_SELECTED;
    }

    @NotNull
    public Set<Object> getIncludedSet() {
        Set<Object> set = this.getInclusionModel().getInclusion();
        if (set == null) {
            ChangesTree.$$$reportNull$$$0(42);
        }
        return set;
    }

    public void expandAll() {
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void expandDefaults() {
        if (TreeUtil.hasManyNodes((Tree)this, (int)30000)) {
            return;
        }
        TreeUtil.promiseExpand((JTree)((Object)this), path2 -> {
            Object node = path2.getLastPathComponent();
            if (node instanceof ChangesBrowserNode && !((ChangesBrowserNode)node).shouldExpandByDefault()) {
                return TreeVisitor.Action.SKIP_CHILDREN;
            }
            return TreeVisitor.Action.CONTINUE;
        });
    }

    @NotNull
    public TreeExpander getTreeExpander() {
        TreeExpander treeExpander = this.myTreeExpander;
        if (treeExpander == null) {
            ChangesTree.$$$reportNull$$$0(43);
        }
        return treeExpander;
    }

    public void setTreeExpander(@NotNull TreeExpander expander) {
        if (expander == null) {
            ChangesTree.$$$reportNull$$$0(44);
        }
        this.myTreeExpander = expander;
    }

    @NotNull
    public AnAction createExpandAllAction(boolean headerAction) {
        if (headerAction) {
            AnAction anAction = CommonActionsManager.getInstance().createExpandAllHeaderAction(this.myTreeExpander, (JComponent)((Object)this));
            if (anAction == null) {
                ChangesTree.$$$reportNull$$$0(45);
            }
            return anAction;
        }
        AnAction anAction = CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this));
        if (anAction == null) {
            ChangesTree.$$$reportNull$$$0(46);
        }
        return anAction;
    }

    @NotNull
    public AnAction createCollapseAllAction(boolean headerAction) {
        if (headerAction) {
            AnAction anAction = CommonActionsManager.getInstance().createCollapseAllHeaderAction(this.myTreeExpander, (JComponent)((Object)this));
            if (anAction == null) {
                ChangesTree.$$$reportNull$$$0(47);
            }
            return anAction;
        }
        AnAction anAction = CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this));
        if (anAction == null) {
            ChangesTree.$$$reportNull$$$0(48);
        }
        return anAction;
    }

    public void setSelectionMode(@JdkConstants.TreeSelectionMode int mode) {
        this.getSelectionModel().setSelectionMode(mode);
    }

    @NotNull
    protected ThreeStateCheckBox.State getNodeStatus(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(49);
        }
        if (this.getInclusionModel().isInclusionEmpty()) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
            if (state == null) {
                ChangesTree.$$$reportNull$$$0(50);
            }
            return state;
        }
        boolean hasIncluded = false;
        boolean hasExcluded = false;
        for (Object item2 : VcsTreeModelData.allUnder(node).userObjects()) {
            ThreeStateCheckBox.State state = this.getInclusionModel().getInclusionState(item2);
            if (state == ThreeStateCheckBox.State.SELECTED) {
                hasIncluded = true;
            } else if (state == ThreeStateCheckBox.State.NOT_SELECTED) {
                hasExcluded = true;
            } else {
                hasIncluded = true;
                hasExcluded = true;
            }
            if (!hasIncluded || !hasExcluded) continue;
            break;
        }
        if (hasIncluded && hasExcluded) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.DONT_CARE;
            if (state == null) {
                ChangesTree.$$$reportNull$$$0(51);
            }
            return state;
        }
        if (hasIncluded) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.SELECTED;
            if (state == null) {
                ChangesTree.$$$reportNull$$$0(52);
            }
            return state;
        }
        ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
        if (state == null) {
            ChangesTree.$$$reportNull$$$0(53);
        }
        return state;
    }

    protected boolean isInclusionEnabled(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(54);
        }
        return true;
    }

    protected boolean isInclusionVisible(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(55);
        }
        return true;
    }

    private boolean isIncludable(@NotNull TreePath path2) {
        Object lastComponent;
        if (path2 == null) {
            ChangesTree.$$$reportNull$$$0(56);
        }
        if (!((lastComponent = path2.getLastPathComponent()) instanceof ChangesBrowserNode)) {
            return false;
        }
        return this.isIncludable((ChangesBrowserNode)lastComponent);
    }

    protected boolean isIncludable(@NotNull ChangesBrowserNode<?> node) {
        if (node == null) {
            ChangesTree.$$$reportNull$$$0(57);
        }
        return this.isInclusionVisible(node) && this.isInclusionEnabled(node);
    }

    @NotNull
    protected List<Object> getIncludableUserObjects(@NotNull VcsTreeModelData treeModelData) {
        if (treeModelData == null) {
            ChangesTree.$$$reportNull$$$0(58);
        }
        List list = treeModelData.iterateNodes().filter(node -> this.isIncludable((ChangesBrowserNode<?>)node)).map(node -> node.getUserObject()).toList();
        if (list == null) {
            ChangesTree.$$$reportNull$$$0(59);
        }
        return list;
    }

    public void setSelectedChanges(@NotNull Collection<?> changes) {
        if (changes == null) {
            ChangesTree.$$$reportNull$$$0(60);
        }
        HashSet changesSet = new HashSet(changes);
        ArrayList treeSelection = new ArrayList(changes.size());
        TreeUtil.treeNodeTraverser(this.getRoot()).forEach(node -> {
            DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)node;
            if (changesSet.contains(mutableNode.getUserObject())) {
                treeSelection.add(new TreePath(mutableNode.getPath()));
            }
        });
        this.setSelectionPaths(TreePathUtil.toTreePathArray(treeSelection));
        if (treeSelection.size() == 1) {
            this.scrollPathToVisible((TreePath)treeSelection.get(0));
        }
    }

    @NotNull
    public TreeStateStrategy<?> getTreeStateStrategy() {
        TreeStateStrategy<?> treeStateStrategy = this.myTreeStateStrategy;
        if (treeStateStrategy == null) {
            ChangesTree.$$$reportNull$$$0(61);
        }
        return treeStateStrategy;
    }

    public void setTreeStateStrategy(@NotNull TreeStateStrategy<?> keepTreeState) {
        if (keepTreeState == null) {
            ChangesTree.$$$reportNull$$$0(62);
        }
        this.myTreeStateStrategy = keepTreeState;
    }

    public boolean isKeepTreeState() {
        return this.myTreeStateStrategy != DO_NOTHING && this.myTreeStateStrategy != ALWAYS_RESET;
    }

    public void setKeepTreeState(boolean keepTreeState) {
        this.setTreeStateStrategy(keepTreeState ? ALWAYS_KEEP : ALWAYS_RESET);
    }

    public boolean isScrollToSelection() {
        return this.myScrollToSelection;
    }

    public void setScrollToSelection(boolean scrollToSelection) {
        this.myScrollToSelection = scrollToSelection;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ChangesTree.$$$reportNull$$$0(63);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myTreeCopyProvider;
        }
        if (ChangesGroupingSupport.KEY.is(dataId)) {
            return this.myGroupingSupport;
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.myTreeExpander;
        }
        return null;
    }

    public boolean isFileColorsEnabled() {
        return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path2) {
        Object component2;
        if (path2 == null) {
            ChangesTree.$$$reportNull$$$0(64);
        }
        if ((component2 = path2.getLastPathComponent()) instanceof ChangesBrowserNode) {
            return ((ChangesBrowserNode)component2).getBackgroundColorCached(this.myProject);
        }
        return null;
    }

    public int getToggleClickCount() {
        return -1;
    }

    protected void processEvent(AWTEvent e) {
        this.myEventProcessingInProgress = e;
        try {
            super.processEvent(e);
        }
        finally {
            this.myEventProcessingInProgress = null;
        }
    }

    private void installCommitSessionEventsListeners() {
        this.addSelectionListener(() -> {
            if (this.myEventProcessingInProgress instanceof MouseEvent && this.shouldLogCommitSessionEvents()) {
                CommitSessionCollector.getInstance(this.myProject).logFileSelected((MouseEvent)this.myEventProcessingInProgress);
            }
        });
    }

    @ApiStatus.Internal
    public void logInclusionToggleEvents(boolean exclude2, @NonNls MouseEvent event) {
        if (this.shouldLogCommitSessionEvents()) {
            CommitSessionCollector.getInstance(this.myProject).logInclusionToggle(exclude2, event);
        }
    }

    @ApiStatus.Internal
    public void logInclusionToggleEvents(boolean exclude2, @NotNull AnActionEvent event) {
        if (event == null) {
            ChangesTree.$$$reportNull$$$0(65);
        }
        if (this.shouldLogCommitSessionEvents()) {
            CommitSessionCollector.getInstance(this.myProject).logInclusionToggle(exclude2, event);
        }
    }

    private boolean shouldLogCommitSessionEvents() {
        return Boolean.TRUE.equals(this.getClientProperty(LOG_COMMIT_SESSION_EVENTS));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 22, 23, 24, 33, 34, 42, 43, 45, 46, 47, 48, 50, 51, 52, 53, 59, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeRenderer";
                break;
            }
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesTree";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingSupport";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsGetter";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsSetter";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresh";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStateStrategy";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 31: 
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expander";
                break;
            }
            case 49: 
            case 54: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 56: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModelData";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keepTreeState";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "installGroupingSupport";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupingSupport";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getInclusionModel";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedSet";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeExpander";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpandAllAction";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapseAllAction";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeStatus";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludableUserObjects";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeStateStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPathIfCheckBoxClicked";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installTreeLinkHandler";
                break;
            }
            case 4: 
            case 22: 
            case 23: 
            case 24: 
            case 33: 
            case 34: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 59: 
            case 61: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "installGroupingSupport";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setEmptyText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setDoubleClickAndEnterKeyHandler";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addGroupingChangeListener";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeGroupingChangeListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "rebuildTree";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateTreeModel";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findRowContainingFile";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedChanges";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "includeChange";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "includeChanges";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "excludeChange";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "excludeChanges";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "toggleChanges";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isIncluded";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setTreeExpander";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getNodeStatus";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionEnabled";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isInclusionVisible";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isIncludable";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getIncludableUserObjects";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedChanges";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setTreeStateStrategy";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getFileColorForPath";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "logInclusionToggleEvents";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 22, 23, 24, 33, 34, 42, 43, 45, 46, 47, 48, 50, 51, 52, 53, 59, 61 -> new IllegalStateException(string2);
        };
    }

    public static interface TreeStateStrategy<T> {
        public T saveState(@NotNull ChangesTree var1);

        public void restoreState(@NotNull ChangesTree var1, T var2, boolean var3);
    }

    private class MyTreeExpander
    extends DefaultTreeExpander {
        MyTreeExpander() {
            super((JTree)((Object)ChangesTree.this));
        }

        public boolean isExpandAllVisible() {
            return !ChangesTree.this.myGroupingSupport.isNone() || !ChangesTree.this.myIsModelFlat;
        }

        public boolean isCollapseAllVisible() {
            return this.isExpandAllVisible();
        }
    }

    private class MyToggleSelectionAction
    extends AnAction
    implements DumbAware {
        private MyToggleSelectionAction() {
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyToggleSelectionAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleSelectionAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(ChangesTree.this.isShowCheckboxes());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List<Object> changes;
            if (e == null) {
                MyToggleSelectionAction.$$$reportNull$$$0(2);
            }
            if ((changes = ChangesTree.this.getIncludableUserObjects(!ChangesTree.this.isSelectionEmpty() ? VcsTreeModelData.selected((JTree)((Object)ChangesTree.this)) : VcsTreeModelData.all((JTree)((Object)ChangesTree.this)))).isEmpty()) {
                return;
            }
            boolean exclude2 = ChangesTree.this.toggleChanges(changes);
            ChangesTree.this.logInclusionToggleEvents(exclude2, e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$MyToggleSelectionAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$MyToggleSelectionAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }

    private static class DoNothingTreeStateStrategy
    implements TreeStateStrategy<Object> {
        private DoNothingTreeStateStrategy() {
        }

        @Override
        public Object saveState(@NotNull ChangesTree tree2) {
            if (tree2 == null) {
                DoNothingTreeStateStrategy.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public void restoreState(@NotNull ChangesTree tree2, Object state, boolean scrollToSelection) {
            if (tree2 == null) {
                DoNothingTreeStateStrategy.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$DoNothingTreeStateStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AlwaysResetTreeStateStrategy
    implements TreeStateStrategy<Object> {
        private AlwaysResetTreeStateStrategy() {
        }

        @Override
        public Object saveState(@NotNull ChangesTree tree2) {
            if (tree2 == null) {
                AlwaysResetTreeStateStrategy.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public void restoreState(@NotNull ChangesTree tree2, Object state, boolean scrollToSelection) {
            if (tree2 == null) {
                AlwaysResetTreeStateStrategy.$$$reportNull$$$0(1);
            }
            tree2.resetTreeState();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$AlwaysResetTreeStateStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AlwaysKeepTreeStateStrategy
    implements TreeStateStrategy<TreeState> {
        private AlwaysKeepTreeStateStrategy() {
        }

        @Override
        public TreeState saveState(@NotNull ChangesTree tree2) {
            if (tree2 == null) {
                AlwaysKeepTreeStateStrategy.$$$reportNull$$$0(0);
            }
            return TreeState.createOn((JTree)((Object)tree2), (boolean)true, (boolean)true);
        }

        @Override
        public void restoreState(@NotNull ChangesTree tree2, TreeState state, boolean scrollToSelection) {
            if (tree2 == null) {
                AlwaysKeepTreeStateStrategy.$$$reportNull$$$0(1);
            }
            if (state != null) {
                state.setScrollToSelection(scrollToSelection);
                state.applyTo((JTree)((Object)tree2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$AlwaysKeepTreeStateStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KeepNonEmptyTreeStateStrategy
    implements TreeStateStrategy<TreeState> {
        private KeepNonEmptyTreeStateStrategy() {
        }

        @Override
        public TreeState saveState(@NotNull ChangesTree tree2) {
            if (tree2 == null) {
                KeepNonEmptyTreeStateStrategy.$$$reportNull$$$0(0);
            }
            return TreeState.createOn((JTree)((Object)tree2), (boolean)true, (boolean)true);
        }

        @Override
        public void restoreState(@NotNull ChangesTree tree2, TreeState state, boolean scrollToSelection) {
            if (tree2 == null) {
                KeepNonEmptyTreeStateStrategy.$$$reportNull$$$0(1);
            }
            if (state != null && !state.isEmpty()) {
                state.setScrollToSelection(scrollToSelection);
                state.applyTo((JTree)((Object)tree2));
            } else {
                tree2.resetTreeState();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$KeepNonEmptyTreeStateStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class KeepSelectedObjectsStrategy
    implements TreeStateStrategy<List<Object>> {
        private KeepSelectedObjectsStrategy() {
        }

        @Override
        public List<Object> saveState(@NotNull ChangesTree tree2) {
            if (tree2 == null) {
                KeepSelectedObjectsStrategy.$$$reportNull$$$0(0);
            }
            return VcsTreeModelData.selected((JTree)((Object)tree2)).userObjects();
        }

        @Override
        public void restoreState(@NotNull ChangesTree tree2, List<Object> state, boolean scrollToSelection) {
            if (tree2 == null) {
                KeepSelectedObjectsStrategy.$$$reportNull$$$0(1);
            }
            if (state != null) {
                tree2.setSelectedChanges(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "tree";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesTree$KeepSelectedObjectsStrategy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restoreState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

