/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ModuleChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/BaseChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "getModel", "()Ljavax/swing/tree/DefaultTreeModel;", "myIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getParentNodeFor", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "subtreeRoot", "Companion", "Factory", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nModuleChangesGroupingPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleChangesGroupingPolicy.kt\ncom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class ModuleChangesGroupingPolicy
extends BaseChangesGroupingPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultTreeModel model;
    @NotNull
    private final ProjectFileIndex myIndex;
    @NotNull
    private static final NotNullLazyKey<Map<Module, ChangesBrowserNode<?>>, ChangesBrowserNode<?>> MODULE_CACHE;
    private static final boolean HIDE_EXCLUDED_FILES;

    public ModuleChangesGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.project = project2;
        this.model = model2;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(project)");
        this.myIndex = projectFileIndex;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DefaultTreeModel getModel() {
        return this.model;
    }

    @Nullable
    public ChangesBrowserNode<?> getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        ChangesBrowserNode<?> nextPolicyParent;
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(subtreeRoot, (String)"subtreeRoot");
        VirtualFile file = this.resolveVirtualFile(nodePath);
        ChangesGroupingPolicy changesGroupingPolicy = this.getNextPolicy();
        ChangesBrowserNode<?> changesBrowserNode = nextPolicyParent = changesGroupingPolicy != null ? changesGroupingPolicy.getParentNodeFor(nodePath, subtreeRoot) : null;
        if (file != null) {
            VirtualFile it = file;
            boolean bl = false;
            Module module = this.myIndex.getModuleForFile(file, HIDE_EXCLUDED_FILES);
            if (module != null) {
                Module module2 = module;
                boolean bl2 = false;
                if (ModuleType.isInternal((Module)module2)) {
                    return nextPolicyParent;
                }
                ChangesBrowserNode<?> changesBrowserNode2 = nextPolicyParent;
                if (changesBrowserNode2 == null) {
                    changesBrowserNode2 = subtreeRoot;
                }
                ChangesBrowserNode<?> grandParent = changesBrowserNode2;
                ChangesBrowserNode<?> cachingRoot = BaseChangesGroupingPolicy.Companion.getCachingRoot(grandParent, subtreeRoot);
                ChangesBrowserNode changesBrowserNode3 = (ChangesBrowserNode)((Map)MODULE_CACHE.getValue((UserDataHolder)cachingRoot)).get(module2);
                if (changesBrowserNode3 != null) {
                    ChangesBrowserNode it2 = changesBrowserNode3;
                    boolean bl3 = false;
                    return it2;
                }
                ChangesBrowserModuleNode moduleNode = ChangesBrowserModuleNode.create(module2);
                if (moduleNode == null) {
                    return nextPolicyParent;
                }
                ChangesBrowserModuleNode it3 = moduleNode;
                boolean bl4 = false;
                it3.markAsHelperNode();
                this.model.insertNodeInto(it3, grandParent, grandParent.getChildCount());
                Object object = MODULE_CACHE.getValue((UserDataHolder)cachingRoot);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"MODULE_CACHE.getValue(cachingRoot)");
                ((Map)object).put(module2, it3);
                Object object2 = TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)cachingRoot);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"DIRECTORY_CACHE.getValue(cachingRoot)");
                Map map2 = (Map)object2;
                map2.put(TreeModelBuilder.staticFrom(it3.getModuleRoot()).getKey(), it3);
                TreeModelBuilder.IS_CACHING_ROOT.set((UserDataHolder)it3, (Object)true);
                Object object3 = MODULE_CACHE.getValue((UserDataHolder)it3);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"MODULE_CACHE.getValue(it)");
                ((Map)object3).put(module2, it3);
                Object object4 = TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)it3);
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"DIRECTORY_CACHE.getValue(it)");
                map2 = (Map)object4;
                map2.put(TreeModelBuilder.staticFrom(it3.getModuleRoot()).getKey(), it3);
                return it3;
            }
        }
        return nextPolicyParent;
    }

    private static final Map MODULE_CACHE$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    static {
        NotNullLazyKey notNullLazyKey = NotNullLazyKey.createLazyKey((String)"ChangesTree.ModuleCache", arg_0 -> ModuleChangesGroupingPolicy.MODULE_CACHE$lambda$4(Companion.MODULE_CACHE.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)notNullLazyKey, (String)"createLazyKey(\"ChangesTr\u2026ache\") { mutableMapOf() }");
        MODULE_CACHE = notNullLazyKey;
        HIDE_EXCLUDED_FILES = Registry.is((String)"ide.hide.excluded.files");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0005\u001a$\u0012\u0016\u0012\u0014\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy$Companion;", "", "()V", "HIDE_EXCLUDED_FILES", "", "MODULE_CACHE", "Lcom/intellij/openapi/util/NotNullLazyKey;", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "()V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @Override
        @NotNull
        public ModuleChangesGroupingPolicy createGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            return new ModuleChangesGroupingPolicy(project2, model2);
        }
    }
}

