/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import com.intellij.openapi.vcs.checkin.TextCommitProblem;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \f2\u00020\u0001:\u0001\fJ\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "", "text", "", "getText", "()Ljava/lang/String;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "project", "Lcom/intellij/openapi/project/Project;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "Companion", "intellij.platform.vcs"})
@ApiStatus.Experimental
public interface CommitProblem {
    @NotNull
    public static final Companion Companion = com.intellij.openapi.vcs.checkin.CommitProblem$Companion.$$INSTANCE;

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText();

    @RequiresEdt
    @NotNull
    default public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project2, @NotNull CommitInfo commitInfo) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
        if (this instanceof CommitProblemWithDetails) {
            String string2 = VcsBundle.message("checkin.commit.checks.failed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"checkin.commit.checks.failed\")");
            MessageDialogBuilder.YesNoCancel yesNoCancel = MessageDialogBuilder.Companion.yesNoCancel(string2, this.getText());
            String string3 = StringUtil.toTitleCase((String)((CommitProblemWithDetails)this).getShowDetailsAction());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toTitleCase(showDetailsAction)");
            MessageDialogBuilder.YesNoCancel yesNoCancel2 = (MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)yesNoCancel.yesText(string3)).noText(commitInfo.getCommitActionText());
            String string4 = VcsBundle.message("checkin.commit.checks.failed.cancel.button", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"checkin.commit.\u2026ks.failed.cancel.button\")");
            int commit2 = yesNoCancel2.cancelText(string4).show(project2);
            switch (commit2) {
                case 0: {
                    ((CommitProblemWithDetails)this).showDetails(project2);
                    return CheckinHandler.ReturnResult.CLOSE_WINDOW;
                }
                case 1: {
                    return CheckinHandler.ReturnResult.COMMIT;
                }
            }
            return CheckinHandler.ReturnResult.CANCEL;
        }
        String string5 = VcsBundle.message("checkin.commit.checks.failed", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"checkin.commit.checks.failed\")");
        MessageDialogBuilder.YesNo yesNo = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string5, this.getText()).yesText(commitInfo.getCommitActionText());
        String string6 = VcsBundle.message("checkin.commit.checks.failed.cancel.button", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(\"checkin.commit.\u2026ks.failed.cancel.button\")");
        boolean commit3 = ((MessageDialogBuilder.YesNo)yesNo.noText(string6)).ask(project2);
        if (commit3) {
            return CheckinHandler.ReturnResult.COMMIT;
        }
        return CheckinHandler.ReturnResult.CANCEL;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/checkin/CommitProblem$Companion;", "", "()V", "createError", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "e", "", "intellij.platform.vcs"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final CommitProblem createError(@NotNull Throwable e) {
            String string2;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String err = e.getMessage();
            Object[] objectArray = (Object[])err;
            if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray)) {
                string2 = VcsBundle.message("before.checkin.error.unknown", new Object[0]);
            } else {
                objectArray = new Object[]{err};
                string2 = VcsBundle.message("before.checkin.error.unknown.details", objectArray);
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when {\n        err.isNul\u2026wn.details\", err)\n      }");
            String message2 = string2;
            return new TextCommitProblem(message2);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

