/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.Side;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.DocumentTracker;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.LineStatusTrackerKt;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RollbackLineStatusAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0003678B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020(H\u0015J\u0018\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u000200H'J \u00101\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020&\u0018\u000103H\u0014J\u0018\u00104\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00022\u0006\u0010,\u001a\u00020-H\u0016J\b\u00105\u001a\u00020&H\u0017R\u0018\u0010\f\u001a\f0\rR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001e*\u00020 X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00069"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl;", "R", "Lcom/intellij/openapi/vcs/ex/Range;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;)V", "innerRangesHandler", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$MyInnerRangesDocumentTrackerHandler;", "value", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "mode", "getMode", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "setMode", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "renderer", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalLineStatusMarkerRenderer;", "getRenderer", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalLineStatusMarkerRenderer;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "innerRanges", "", "Lcom/intellij/openapi/vcs/ex/Range$InnerRange;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Ljava/util/List;", "setInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "freeze", "", "isClearLineModificationFlagOnRollback", "", "isDetectWhitespaceChangedLines", "scrollAndShowHint", "range", "editor", "Lcom/intellij/openapi/editor/Editor;", "setBaseRevision", "vcsContent", "", "setBaseRevisionContent", "beforeUnfreeze", "Lkotlin/Function0;", "showHint", "unfreeze", "LocalDocumentTrackerHandler", "LocalLineStatusMarkerRenderer", "MyInnerRangesDocumentTrackerHandler", "intellij.platform.vcs.impl"})
public abstract class LocalLineStatusTrackerImpl<R extends Range>
extends LineStatusTrackerBase<R>
implements LocalLineStatusTracker<R> {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final MyInnerRangesDocumentTrackerHandler innerRangesHandler;
    @NotNull
    private LocalLineStatusTracker.Mode mode;

    public LocalLineStatusTrackerImpl(@NotNull Project project2, @NotNull Document document2, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        super(project2, document2);
        this.project = project2;
        this.virtualFile = virtualFile;
        this.innerRangesHandler = new MyInnerRangesDocumentTrackerHandler();
        this.mode = new LocalLineStatusTracker.Mode(true, true, false);
        this.getDocumentTracker().addHandler((DocumentTracker.Handler)new LocalDocumentTrackerHandler());
        this.getDocumentTracker().addHandler((DocumentTracker.Handler)this.innerRangesHandler);
    }

    @Override
    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    protected abstract LocalLineStatusMarkerRenderer getRenderer();

    @Override
    @NotNull
    public LocalLineStatusTracker.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(@NotNull LocalLineStatusTracker.Mode value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (Intrinsics.areEqual((Object)value2, (Object)this.getMode())) {
            return;
        }
        this.mode = value2;
        this.innerRangesHandler.resetInnerRanges();
        this.updateHighlighters();
    }

    @RequiresEdt
    protected boolean isDetectWhitespaceChangedLines() {
        return this.getMode().isVisible() && this.getMode().getDetectWhitespaceChangedLines();
    }

    protected boolean isClearLineModificationFlagOnRollback() {
        return true;
    }

    @Nullable
    protected abstract List<Range.InnerRange> getInnerRanges(@NotNull DocumentTracker.Block var1);

    protected abstract void setInnerRanges(@NotNull DocumentTracker.Block var1, @Nullable List<Range.InnerRange> var2);

    @RequiresEdt
    public abstract void setBaseRevision(@NotNull CharSequence var1);

    protected void setBaseRevisionContent(@NotNull CharSequence vcsContent, @Nullable Function0<Unit> beforeUnfreeze) {
        Intrinsics.checkNotNullParameter((Object)vcsContent, (String)"vcsContent");
        super.setBaseRevisionContent(vcsContent, beforeUnfreeze);
        if (this.getBlocks().isEmpty() && this.isOperational()) {
            LineStatusTrackerKt.saveDocumentWhenUnchanged(this.project, this.getDocument());
        }
    }

    @Override
    public void scrollAndShowHint(@NotNull Range range, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.getRenderer().scrollAndShow(editor, range);
    }

    @Override
    public void showHint(@NotNull Range range, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.getRenderer().showAfterScroll(editor, range);
    }

    @Override
    public void freeze() {
        this.getDocumentTracker().freeze(Side.LEFT);
        this.getDocumentTracker().freeze(Side.RIGHT);
    }

    @Override
    @RequiresEdt
    public void unfreeze() {
        this.getDocumentTracker().unfreeze(Side.LEFT);
        this.getDocumentTracker().unfreeze(Side.RIGHT);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Handler;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl;)V", "afterBulkRangeChange", "", "isDirty", "", "intellij.platform.vcs.impl"})
    private final class LocalDocumentTrackerHandler
    implements DocumentTracker.Handler {
        public void afterBulkRangeChange(boolean isDirty) {
            if (LocalLineStatusTrackerImpl.this.getBlocks().isEmpty() && LocalLineStatusTrackerImpl.this.isOperational()) {
                LineStatusTrackerKt.saveDocumentWhenUnchanged(LocalLineStatusTrackerImpl.this.getProject(), LocalLineStatusTrackerImpl.this.getDocument());
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0014\u0018\u00002\u00020\u0001:\u0001\u0015B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0014R\u0018\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalLineStatusMarkerRenderer;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer;", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl;", "createToolbarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "mousePosition", "Ljava/awt/Point;", "getEditorFilter", "Lcom/intellij/openapi/editor/markup/MarkupEditorFilter;", "shouldPaintErrorStripeMarkers", "", "shouldPaintGutter", "RollbackLineStatusRangeAction", "intellij.platform.vcs.impl"})
    protected static class LocalLineStatusMarkerRenderer
    extends LineStatusMarkerPopupRenderer {
        @NotNull
        private final LocalLineStatusTrackerImpl<?> tracker;

        public LocalLineStatusMarkerRenderer(@NotNull LocalLineStatusTrackerImpl<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            super((LineStatusTrackerBase)tracker);
            this.tracker = tracker;
        }

        @NotNull
        public LocalLineStatusTrackerImpl<?> getTracker() {
            return this.tracker;
        }

        @Nullable
        protected MarkupEditorFilter getEditorFilter() {
            return MarkupEditorFilterFactory.createIsNotDiffFilter();
        }

        protected boolean shouldPaintGutter() {
            return this.getTracker().getMode().isVisible();
        }

        protected boolean shouldPaintErrorStripeMarkers() {
            return this.getTracker().getMode().isVisible() && this.getTracker().getMode().getShowErrorStripeMarkers();
        }

        @NotNull
        protected List<AnAction> createToolbarActions(@NotNull Editor editor, @NotNull Range range, @Nullable Point mousePosition) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            ArrayList<Object> actions2 = new ArrayList<Object>();
            actions2.add(new LineStatusMarkerPopupRenderer.ShowPrevChangeMarkerAction((LineStatusMarkerPopupRenderer)this, editor, range));
            actions2.add(new LineStatusMarkerPopupRenderer.ShowNextChangeMarkerAction((LineStatusMarkerPopupRenderer)this, editor, range));
            actions2.add((Object)new RollbackLineStatusRangeAction(editor, range));
            actions2.add(new LineStatusMarkerPopupRenderer.ShowLineStatusRangeDiffAction((LineStatusMarkerPopupRenderer)this, editor, range));
            actions2.add(new LineStatusMarkerPopupRenderer.CopyLineStatusRangeAction((LineStatusMarkerPopupRenderer)this, editor, range));
            actions2.add(new LineStatusMarkerPopupRenderer.ToggleByWordDiffAction((LineStatusMarkerPopupRenderer)this, editor, range, mousePosition));
            return actions2;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalLineStatusMarkerRenderer$RollbackLineStatusRangeAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$RangeMarkerAction;", "Lcom/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer;", "Lcom/intellij/ide/lightEdit/LightEditCompatible;", "editor", "Lcom/intellij/openapi/editor/Editor;", "range", "Lcom/intellij/openapi/vcs/ex/Range;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$LocalLineStatusMarkerRenderer;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/ex/Range;)V", "actionPerformed", "", "isEnabled", "", "intellij.platform.vcs.impl"})
        private final class RollbackLineStatusRangeAction
        extends LineStatusMarkerPopupRenderer.RangeMarkerAction
        implements LightEditCompatible {
            public RollbackLineStatusRangeAction(@NotNull Editor editor, Range range) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                super((LineStatusMarkerPopupRenderer)LocalLineStatusMarkerRenderer.this, editor, range, "Vcs.RollbackChangedLines");
            }

            protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                return true;
            }

            protected void actionPerformed(@NotNull Editor editor, @NotNull Range range) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                RollbackLineStatusAction.rollback((LineStatusTrackerI)LocalLineStatusMarkerRenderer.this.getTracker(), range, editor);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00028\u00000\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0016R8\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005*\u00020\b2\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$MyInnerRangesDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase$InnerRangesDocumentTrackerHandler;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerBase;", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl;)V", "value", "", "Lcom/intellij/openapi/vcs/ex/Range$InnerRange;", "innerRanges", "Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;", "getInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;)Ljava/util/List;", "setInnerRanges", "(Lcom/intellij/openapi/vcs/ex/DocumentTracker$Block;Ljava/util/List;)V", "isDetectWhitespaceChangedLines", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTracker.kt\ncom/intellij/openapi/vcs/ex/LocalLineStatusTrackerImpl$MyInnerRangesDocumentTrackerHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
    private final class MyInnerRangesDocumentTrackerHandler
    extends LineStatusTrackerBase.InnerRangesDocumentTrackerHandler {
        public MyInnerRangesDocumentTrackerHandler() {
            super((LineStatusTrackerBase)LocalLineStatusTrackerImpl.this);
        }

        public boolean isDetectWhitespaceChangedLines() {
            LocalLineStatusTracker.Mode it = LocalLineStatusTrackerImpl.this.getMode();
            boolean bl = false;
            return it.isVisible() && it.getDetectWhitespaceChangedLines();
        }

        @Nullable
        public List<Range.InnerRange> getInnerRanges(@NotNull DocumentTracker.Block $this$innerRanges) {
            Intrinsics.checkNotNullParameter((Object)$this$innerRanges, (String)"<this>");
            DocumentTracker.Block block = $this$innerRanges;
            LocalLineStatusTrackerImpl $this$_get_innerRanges__u24lambda_u241 = LocalLineStatusTrackerImpl.this;
            boolean bl = false;
            return $this$_get_innerRanges__u24lambda_u241.getInnerRanges(block);
        }

        public void setInnerRanges(@NotNull DocumentTracker.Block $this$innerRanges, @Nullable List<Range.InnerRange> value2) {
            Intrinsics.checkNotNullParameter((Object)$this$innerRanges, (String)"<this>");
            DocumentTracker.Block block = $this$innerRanges;
            LocalLineStatusTrackerImpl $this$_set_innerRanges__u24lambda_u242 = LocalLineStatusTrackerImpl.this;
            boolean bl = false;
            $this$_set_innerRanges__u24lambda_u242.setInnerRanges(block, value2);
        }
    }
}

