/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.FileHistorySessionPartner;
import com.intellij.openapi.vcs.history.VcsCachingHistory;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryRefresher
implements FileHistoryRefresherI {
    @NotNull
    private static final ExecutorService ourExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"File History Refresh");
    @NotNull
    private final FileHistorySessionPartner mySessionPartner;
    @NotNull
    private final VcsHistoryProvider myVcsHistoryProvider;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final AbstractVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myStartingRevisionNumber;
    private boolean myFirstTime;

    public FileHistoryRefresher(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path2, @NotNull AbstractVcs vcs) {
        if (vcsHistoryProvider == null) {
            FileHistoryRefresher.$$$reportNull$$$0(0);
        }
        if (path2 == null) {
            FileHistoryRefresher.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            FileHistoryRefresher.$$$reportNull$$$0(2);
        }
        this(vcsHistoryProvider, path2, null, vcs);
    }

    public FileHistoryRefresher(@NotNull VcsHistoryProviderEx vcsHistoryProvider, @NotNull FilePath path2, @Nullable VcsRevisionNumber startingRevisionNumber, @NotNull AbstractVcs vcs) {
        if (vcsHistoryProvider == null) {
            FileHistoryRefresher.$$$reportNull$$$0(3);
        }
        if (path2 == null) {
            FileHistoryRefresher.$$$reportNull$$$0(4);
        }
        if (vcs == null) {
            FileHistoryRefresher.$$$reportNull$$$0(5);
        }
        this((VcsHistoryProvider)vcsHistoryProvider, path2, startingRevisionNumber, vcs);
    }

    private FileHistoryRefresher(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path2, @Nullable VcsRevisionNumber startingRevisionNumber, @NotNull AbstractVcs vcs) {
        if (vcsHistoryProvider == null) {
            FileHistoryRefresher.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            FileHistoryRefresher.$$$reportNull$$$0(7);
        }
        if (vcs == null) {
            FileHistoryRefresher.$$$reportNull$$$0(8);
        }
        this.myFirstTime = true;
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path2;
        this.myVcs = vcs;
        this.myStartingRevisionNumber = startingRevisionNumber;
        this.mySessionPartner = new FileHistorySessionPartner(vcsHistoryProvider, path2, startingRevisionNumber, vcs, this);
        RefreshRequest request = new RefreshRequest(20000, this.mySessionPartner);
        request.schedule();
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path2, @NotNull AbstractVcs vcs) {
        FileHistoryRefresherI refresher;
        if (vcsHistoryProvider == null) {
            FileHistoryRefresher.$$$reportNull$$$0(9);
        }
        if (path2 == null) {
            FileHistoryRefresher.$$$reportNull$$$0(10);
        }
        if (vcs == null) {
            FileHistoryRefresher.$$$reportNull$$$0(11);
        }
        FileHistoryRefresherI fileHistoryRefresherI = (refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path2, null)) == null ? new FileHistoryRefresher(vcsHistoryProvider, path2, vcs) : refresher;
        if (fileHistoryRefresherI == null) {
            FileHistoryRefresher.$$$reportNull$$$0(12);
        }
        return fileHistoryRefresherI;
    }

    @NotNull
    public static FileHistoryRefresherI findOrCreate(@NotNull VcsHistoryProviderEx vcsHistoryProvider, @NotNull FilePath path2, @NotNull AbstractVcs vcs, @Nullable VcsRevisionNumber startingRevisionNumber) {
        FileHistoryRefresherI refresher;
        if (vcsHistoryProvider == null) {
            FileHistoryRefresher.$$$reportNull$$$0(13);
        }
        if (path2 == null) {
            FileHistoryRefresher.$$$reportNull$$$0(14);
        }
        if (vcs == null) {
            FileHistoryRefresher.$$$reportNull$$$0(15);
        }
        FileHistoryRefresherI fileHistoryRefresherI = (refresher = FileHistorySessionPartner.findExistingHistoryRefresher(vcs.getProject(), path2, startingRevisionNumber)) == null ? new FileHistoryRefresher(vcsHistoryProvider, path2, startingRevisionNumber, vcs) : refresher;
        if (fileHistoryRefresherI == null) {
            FileHistoryRefresher.$$$reportNull$$$0(16);
        }
        return fileHistoryRefresherI;
    }

    @Override
    public void selectContent() {
        this.mySessionPartner.createOrSelectContent();
    }

    @Override
    public boolean isInRefresh() {
        return VcsCachingHistory.getHistoryLock(this.myVcs, VcsBackgroundableActions.CREATE_HISTORY_SESSION, this.myPath, this.myStartingRevisionNumber).isLocked();
    }

    @Override
    public void refresh(boolean canUseCache) {
        this.mySessionPartner.beforeRefresh();
        if (this.myVcsHistoryProvider instanceof VcsHistoryProviderEx && this.myStartingRevisionNumber != null) {
            VcsCachingHistory.collectInBackground(this.myVcs, this.myPath, this.myStartingRevisionNumber, this.mySessionPartner);
        } else {
            boolean collectedFromCache = false;
            if (this.myFirstTime) {
                collectedFromCache = VcsCachingHistory.collectFromCache(this.myVcs, this.myPath, this.mySessionPartner);
            }
            if (!collectedFromCache) {
                VcsCachingHistory.collectInBackground(this.myVcs, this.myPath, this.mySessionPartner, canUseCache);
            }
        }
        this.myFirstTime = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsHistoryProvider";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistoryRefresher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistoryRefresher";
                break;
            }
            case 12: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreate";
                break;
            }
            case 12: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 12, 16 -> new IllegalStateException(string2);
        };
    }

    private class RefreshRequest
    implements Runnable {
        @NotNull
        private final Alarm myUpdateAlarm;
        private final int myDelayMillis;
        @Nullable
        Future<?> myLastTask;

        RefreshRequest(@NotNull int delayMillis, Disposable parent) {
            if (parent == null) {
                RefreshRequest.$$$reportNull$$$0(0);
            }
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parent);
            this.myDelayMillis = delayMillis;
        }

        @Override
        public void run() {
            if (this.myLastTask != null) {
                this.myLastTask.cancel(false);
            }
            if (FileHistoryRefresher.this.myVcs.getProject().isDisposed()) {
                return;
            }
            this.myUpdateAlarm.cancelAllRequests();
            if (this.myUpdateAlarm.isDisposed()) {
                return;
            }
            this.schedule();
            if (!ApplicationManager.getApplication().isActive()) {
                return;
            }
            this.myLastTask = ourExecutor.submit(() -> {
                if (!this.myUpdateAlarm.isDisposed() && FileHistoryRefresher.this.mySessionPartner.shouldBeRefreshed()) {
                    ApplicationManager.getApplication().invokeLater(() -> FileHistoryRefresher.this.refresh(true));
                }
            });
        }

        public void schedule() {
            this.myUpdateAlarm.addRequest((Runnable)this, this.myDelayMillis);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vcs/history/FileHistoryRefresher$RefreshRequest", "<init>"));
        }
    }
}

