/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseModifiableControl;
import com.intellij.util.xml.ui.DomWrapper;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class EditorTextFieldControl<T extends JComponent>
extends BaseModifiableControl<T, String> {
    private static final JTextField J_TEXT_FIELD = new JTextField(){

        @Override
        public void addNotify() {
            throw new UnsupportedOperationException("Shouldn't be shown");
        }

        @Override
        public void setVisible(boolean aFlag) {
            throw new UnsupportedOperationException("Shouldn't be shown");
        }
    };
    private final boolean myCommitOnEveryChange;
    private final DocumentListener myListener = new DocumentListener(){

        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                2.$$$reportNull$$$0(0);
            }
            EditorTextFieldControl.this.setModified();
            if (EditorTextFieldControl.this.myCommitOnEveryChange) {
                EditorTextFieldControl.this.commit();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/xml/ui/EditorTextFieldControl$2", "documentChanged"));
        }
    };

    protected EditorTextFieldControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper);
        this.myCommitOnEveryChange = commitOnEveryChange;
    }

    protected EditorTextFieldControl(DomWrapper<String> domWrapper) {
        this(domWrapper, false);
    }

    protected abstract EditorTextField getEditorTextField(@NotNull T var1);

    @Override
    protected void doReset() {
        EditorTextField textField = this.getEditorTextField(this.getComponent());
        textField.getDocument().removeDocumentListener(this.myListener);
        super.doReset();
        textField.getDocument().addDocumentListener(this.myListener);
    }

    @Override
    protected JComponent getComponentToListenFocusLost(T component2) {
        return this.getEditorTextField(this.getComponent());
    }

    @Override
    protected JComponent getHighlightedComponent(T component2) {
        return J_TEXT_FIELD;
    }

    @Override
    protected T createMainComponent(T boundedComponent) {
        Project project2 = this.getProject();
        boundedComponent = this.createMainComponent(boundedComponent, project2);
        EditorTextField editorTextField = this.getEditorTextField(boundedComponent);
        editorTextField.setSupplementary(true);
        editorTextField.getDocument().addDocumentListener(this.myListener);
        return boundedComponent;
    }

    protected abstract T createMainComponent(T var1, Project var2);

    @Override
    @NotNull
    protected String getValue() {
        String string2 = this.getEditorTextField(this.getComponent()).getText();
        if (string2 == null) {
            EditorTextFieldControl.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    protected void setValue(String value2) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> WriteAction.run(() -> {
            Object component2 = this.getComponent();
            Document document2 = this.getEditorTextField(component2).getDocument();
            document2.replaceString(0, document2.getTextLength(), (CharSequence)(value2 == null ? "" : value2));
        }));
    }

    @Override
    protected void updateComponent() {
        DomElement domElement = this.getDomElement();
        if (domElement == null || !domElement.isValid()) {
            return;
        }
        EditorTextField textField = this.getEditorTextField(this.getComponent());
        Project project2 = this.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!project2.isOpen()) {
                return;
            }
            if (!this.getDomWrapper().isValid()) {
                return;
            }
            DomElement domElement1 = this.getDomElement();
            if (domElement1 == null || !domElement1.isValid()) {
                return;
            }
            DomElementAnnotationsManager manager = DomElementAnnotationsManager.getInstance(project2);
            DomElementsProblemsHolder holder = manager.getCachedProblemHolder(domElement1);
            List<DomElementProblemDescriptor> errorProblems = holder.getProblems(domElement1);
            ArrayList<DomElementProblemDescriptor> warningProblems = new ArrayList<DomElementProblemDescriptor>(holder.getProblems(domElement1, true, HighlightSeverity.WARNING));
            warningProblems.removeAll(errorProblems);
            Color background = this.getDefaultBackground();
            if (errorProblems.size() > 0 && textField.getText().trim().length() == 0) {
                background = this.getErrorBackground();
            } else if (warningProblems.size() > 0) {
                background = this.getWarningBackground();
            }
            Editor editor = textField.getEditor();
            if (editor != null) {
                MarkupModel markupModel = editor.getMarkupModel();
                markupModel.removeAllHighlighters();
                if (!errorProblems.isEmpty() && editor.getDocument().getLineCount() > 0) {
                    markupModel.addLineHighlighter(CodeInsightColors.ERRORS_ATTRIBUTES, 0, 0);
                    editor.getContentComponent().setToolTipText(errorProblems.get(0).getDescriptionTemplate());
                }
            }
            textField.setBackground(background);
        });
    }

    @Override
    public boolean canNavigate(DomElement element) {
        return this.getDomElement().equals(element);
    }

    @Override
    public void navigate(DomElement element) {
        EditorTextField field = this.getEditorTextField(this.getComponent());
        SwingUtilities.invokeLater(() -> {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)field, true));
            field.selectAll();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/EditorTextFieldControl", "getValue"));
    }
}

