/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.BaseInclusionModel;
import com.intellij.openapi.vcs.changes.ui.PartiallyExcludedFilesStateHolder;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.vcs.commit.PartialCommitInclusionModel;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001 B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0016J\u0016\u0010\u001e\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0016J\u0016\u0010\u001f\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0016R0\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/commit/PartialCommitInclusionModel;", "Lcom/intellij/openapi/vcs/changes/ui/BaseInclusionModel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "changeLists", "getChangeLists", "()Ljava/util/Collection;", "setChangeLists", "(Ljava/util/Collection;)V", "stateHolder", "Lcom/intellij/vcs/commit/PartialCommitInclusionModel$StateHolder;", "addInclusion", "", "items", "", "clearInclusion", "dispose", "getInclusion", "", "getInclusionState", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "item", "isInclusionEmpty", "", "removeInclusion", "retainInclusion", "setInclusion", "StateHolder", "intellij.platform.vcs.impl"})
public final class PartialCommitInclusionModel
extends BaseInclusionModel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private Collection<? extends LocalChangeList> changeLists;
    @NotNull
    private final StateHolder stateHolder;

    public PartialCommitInclusionModel(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.changeLists = CollectionsKt.emptyList();
        this.stateHolder = new StateHolder();
        Disposer.register((Disposable)this, (Disposable)this.stateHolder);
    }

    @NotNull
    public final Collection<LocalChangeList> getChangeLists() {
        return this.changeLists;
    }

    public final void setChangeLists(@NotNull Collection<? extends LocalChangeList> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.changeLists = value2;
        this.stateHolder.updateExclusionStates();
    }

    @Override
    @NotNull
    public Set<Object> getInclusion() {
        return this.stateHolder.getIncludedSet();
    }

    @Override
    @NotNull
    public ThreeStateCheckBox.State getInclusionState(@NotNull Object item2) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        return PartialChangesUtil.convertExclusionState(this.stateHolder.getExclusionState(item2));
    }

    @Override
    public boolean isInclusionEmpty() {
        return this.getInclusion().isEmpty();
    }

    @Override
    public void addInclusion(@NotNull Collection<? extends Object> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.stateHolder.includeElements(items2);
    }

    @Override
    public void removeInclusion(@NotNull Collection<? extends Object> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.stateHolder.excludeElements(items2);
    }

    @Override
    public void setInclusion(@NotNull Collection<? extends Object> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.stateHolder.setIncludedElements(items2);
    }

    @Override
    public void retainInclusion(@NotNull Collection<? extends Object> items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        this.stateHolder.retainElements(items2);
    }

    @Override
    public void clearInclusion() {
        if (!((Collection)this.getInclusion()).isEmpty()) {
            this.setInclusion(SetsKt.emptySet());
        }
    }

    public void dispose() {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0017\u0010\u000f\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/commit/PartialCommitInclusionModel$StateHolder;", "Lcom/intellij/openapi/vcs/changes/ui/PartiallyExcludedFilesStateHolder;", "", "(Lcom/intellij/vcs/commit/PartialCommitInclusionModel;)V", "trackableElements", "Lkotlin/sequences/Sequence;", "getTrackableElements", "()Lkotlin/sequences/Sequence;", "findElementFor", "tracker", "Lcom/intellij/openapi/vcs/ex/PartialLocalLineStatusTracker;", "changeListId", "", "findTrackerFor", "element", "getChangeListId", "Lorg/jetbrains/annotations/NonNls;", "updateExclusionStates", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nPartialCommitInclusionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartialCommitInclusionModel.kt\ncom/intellij/vcs/commit/PartialCommitInclusionModel$StateHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
    private final class StateHolder
    extends PartiallyExcludedFilesStateHolder<Object> {
        public StateHolder() {
            super(PartialCommitInclusionModel.this.project, ChangeListChange.HASHING_STRATEGY);
        }

        @Override
        @NotNull
        protected Sequence<Object> getTrackableElements() {
            return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)PartialCommitInclusionModel.this.getChangeLists()), (Function1)trackableElements.1.INSTANCE);
        }

        @Override
        @Nullable
        protected String getChangeListId(@NotNull Object element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            ChangeListChange changeListChange = element instanceof ChangeListChange ? (ChangeListChange)element : null;
            return changeListChange != null ? changeListChange.getChangeListId() : null;
        }

        @Override
        @Nullable
        protected Object findElementFor(@NotNull PartialLocalLineStatusTracker tracker, @NotNull String changeListId) {
            Change change;
            Object object;
            Object v0;
            block4: {
                Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
                Intrinsics.checkNotNullParameter((Object)changeListId, (String)"changeListId");
                Iterable iterable = PartialCommitInclusionModel.this.getChangeLists();
                for (Object object2 : iterable) {
                    LocalChangeList it = (LocalChangeList)object2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)changeListId)) continue;
                    v0 = object2;
                    break block4;
                }
                v0 = null;
            }
            if ((object = (LocalChangeList)v0) != null && (object = ((LocalChangeList)object).getChanges()) != null) {
                Object v3;
                block5: {
                    Object object2;
                    Iterable iterable = (Iterable)object;
                    object2 = iterable.iterator();
                    while (object2.hasNext()) {
                        Object e = object2.next();
                        Change it = (Change)e;
                        boolean bl = false;
                        VirtualFile virtualFile = tracker.getVirtualFile();
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!Intrinsics.areEqual((Object)virtualFile, (Object)PartialChangesUtil.getVirtualFile(it))) continue;
                        v3 = e;
                        break block5;
                    }
                    v3 = null;
                }
                change = v3;
            } else {
                change = null;
            }
            return change;
        }

        @Override
        @Nullable
        protected PartialLocalLineStatusTracker findTrackerFor(@NotNull Object element) {
            PartialLocalLineStatusTracker partialLocalLineStatusTracker;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Change change = element instanceof Change ? (Change)element : null;
            if (change != null) {
                Change change2 = change;
                PartialCommitInclusionModel partialCommitInclusionModel = PartialCommitInclusionModel.this;
                Change it = change2;
                boolean bl = false;
                partialLocalLineStatusTracker = PartialChangesUtil.getPartialTracker(partialCommitInclusionModel.project, it);
            } else {
                partialLocalLineStatusTracker = null;
            }
            return partialLocalLineStatusTracker;
        }

        @Override
        public void updateExclusionStates() {
            super.updateExclusionStates();
            PartialCommitInclusionModel.this.fireInclusionChanged();
        }
    }
}

