/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.ui.TextAccessor;
import com.intellij.vcs.commit.AbstractCommitMessagePolicy;
import com.intellij.vcs.commit.ChangeListCommitState;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/commit/SingleChangeListCommitMessagePolicy;", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "project", "Lcom/intellij/openapi/project/Project;", "initialCommitMessage", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "lastKnownComment", "messagesToSave", "", "init", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "includedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "onAfterCommit", "", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "onChangelistChanged", "oldChangeList", "newChangeList", "currentMessage", "Lcom/intellij/ui/TextAccessor;", "onCommitMessageReset", "text", "onDialogClosed", "onBeforeCommit", "", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nSingleChangeListCommitMessagePolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleChangeListCommitMessagePolicy.kt\ncom/intellij/vcs/commit/SingleChangeListCommitMessagePolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class SingleChangeListCommitMessagePolicy
extends AbstractCommitMessagePolicy {
    @Nullable
    private String lastKnownComment;
    @NotNull
    private final Map<String, String> messagesToSave;

    public SingleChangeListCommitMessagePolicy(@NotNull Project project2, @Nullable String initialCommitMessage) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super(project2);
        this.lastKnownComment = initialCommitMessage;
        this.messagesToSave = new LinkedHashMap();
    }

    @Nullable
    public final String init(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> includedChanges) {
        String commitMessage;
        String string2;
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter(includedChanges, (String)"includedChanges");
        if (this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE) {
            return this.lastKnownComment;
        }
        if (this.lastKnownComment != null) {
            return this.lastKnownComment;
        }
        String string3 = this.getCommitMessageForList(changeList);
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            string2 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
        } else {
            string2 = null;
        }
        String string5 = commitMessage = string2;
        if (string5 != null) {
            return string5;
        }
        this.lastKnownComment = this.getVcsConfiguration().LAST_COMMIT_MESSAGE;
        String string6 = this.getCommitMessageFromVcs(includedChanges);
        if (string6 == null) {
            string6 = this.lastKnownComment;
        }
        return string6;
    }

    public final void onCommitMessageReset(@Nullable String text2) {
        this.lastKnownComment = text2;
    }

    public final void onChangelistChanged(@NotNull LocalChangeList oldChangeList, @NotNull LocalChangeList newChangeList, @NotNull TextAccessor currentMessage) {
        Intrinsics.checkNotNullParameter((Object)oldChangeList, (String)"oldChangeList");
        Intrinsics.checkNotNullParameter((Object)newChangeList, (String)"newChangeList");
        Intrinsics.checkNotNullParameter((Object)currentMessage, (String)"currentMessage");
        if (this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        if (Intrinsics.areEqual((Object)oldChangeList.getName(), (Object)newChangeList.getName())) {
            return;
        }
        Map<String, String> map2 = this.messagesToSave;
        String string2 = oldChangeList.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"oldChangeList.name");
        String string3 = string2;
        String string4 = currentMessage.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"currentMessage.text");
        String string5 = string4;
        map2.put(string3, string5);
        String string6 = this.getCommitMessageForList(newChangeList);
        if (string6 == null) {
            string6 = this.lastKnownComment;
        }
        currentMessage.setText(string6);
    }

    public final void onDialogClosed(@NotNull ChangeListCommitState commitState, boolean onBeforeCommit) {
        Intrinsics.checkNotNullParameter((Object)commitState, (String)"commitState");
        LocalChangeList changeList = commitState.getChangeList();
        String currentMessage = commitState.getCommitMessage();
        Map<String, String> map2 = this.messagesToSave;
        String string2 = changeList.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"changeList.name");
        map2.put(string2, currentMessage);
        if (onBeforeCommit) {
            boolean isChangeListFullyIncluded;
            this.getVcsConfiguration().saveCommitMessage(currentMessage);
            boolean bl = isChangeListFullyIncluded = changeList.getChanges().size() == commitState.getChanges().size();
            if (!isChangeListFullyIncluded) {
                this.messagesToSave.remove(changeList.getName());
            }
        }
        for (Map.Entry entry2 : this.messagesToSave.entrySet()) {
            String changeListName = (String)entry2.getKey();
            String description2 = (String)entry2.getValue();
            this.getChangeListManager().editComment(changeListName, description2);
        }
    }

    public final void onAfterCommit(@NotNull ChangeListCommitState commitState) {
        Intrinsics.checkNotNullParameter((Object)commitState, (String)"commitState");
        LocalChangeList changeList = commitState.getChangeList();
        boolean isChangeListFullyIncluded = changeList.getChanges().size() == commitState.getChanges().size();
        boolean isDefaultNameChangeList = changeList.hasDefaultName();
        if (isDefaultNameChangeList && isChangeListFullyIncluded) {
            ChangeListManager.getInstance(this.getProject()).editComment(changeList.getName(), "");
        }
    }
}

