/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class CompressedRefs {
    private static final Logger LOG = Logger.getInstance(CompressedRefs.class);
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Int2ObjectMap<IntArrayList> myTags;
    @NotNull
    private final Int2ObjectMap<List<VcsRef>> myBranches;

    public CompressedRefs(@NotNull Set<VcsRef> refs, @NotNull VcsLogStorage storage) {
        if (refs == null) {
            CompressedRefs.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            CompressedRefs.$$$reportNull$$$0(1);
        }
        this.myTags = new Int2ObjectOpenHashMap();
        this.myBranches = new Int2ObjectOpenHashMap();
        this.myStorage = storage;
        VirtualFile root = null;
        for (VcsRef ref : refs) {
            assert (root == null || root.equals(ref.getRoot())) : "All references are supposed to be from the single root";
            root = ref.getRoot();
            int index = this.myStorage.getCommitIndex(ref.getCommitHash(), ref.getRoot());
            if (ref.getType().isBranch()) {
                ((List)this.myBranches.computeIfAbsent(index, key2 -> new SmartList())).add(ref);
                continue;
            }
            int refIndex = this.myStorage.getRefIndex(ref);
            if (refIndex == -1) continue;
            ((IntArrayList)this.myTags.computeIfAbsent(index, key2 -> new IntArrayList())).add(refIndex);
        }
        for (IntArrayList list : this.myTags.values()) {
            list.trim();
        }
    }

    boolean contains(int index) {
        return this.myBranches.containsKey(index) || this.myTags.containsKey(index);
    }

    @NotNull
    SmartList<VcsRef> refsToCommit(int index) {
        IntList tags;
        SmartList result2 = new SmartList();
        if (this.myBranches.containsKey(index)) {
            result2.addAll((Collection)this.myBranches.get(index));
        }
        if ((tags = (IntList)this.myTags.get(index)) != null) {
            tags.forEach(tag -> {
                VcsRef ref = this.myStorage.getVcsRef(tag);
                if (ref != null) {
                    result2.add((Object)ref);
                } else {
                    LOG.error("Could not find a tag by id " + tag + " at commit " + this.myStorage.getCommitId(index));
                }
            });
        }
        SmartList smartList = result2;
        if (smartList == null) {
            CompressedRefs.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @NotNull
    public Stream<VcsRef> streamBranches() {
        Stream<VcsRef> stream = this.myBranches.values().stream().flatMap(Collection::stream);
        if (stream == null) {
            CompressedRefs.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @NotNull
    private Stream<VcsRef> streamTags() {
        Stream<VcsRef> stream = this.myTags.values().stream().flatMapToInt(IntCollection::intStream).mapToObj(this.myStorage::getVcsRef);
        if (stream == null) {
            CompressedRefs.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    public Stream<VcsRef> stream() {
        Stream<VcsRef> stream = Stream.concat(this.streamBranches(), this.streamTags());
        if (stream == null) {
            CompressedRefs.$$$reportNull$$$0(5);
        }
        return stream;
    }

    @NotNull
    public Collection<VcsRef> getRefs() {
        return new AbstractCollection<VcsRef>(){
            private final Supplier<Collection<VcsRef>> myLoadedRefs = Suppliers.memoize(() -> CompressedRefs.this.stream().collect(Collectors.toList()));

            @Override
            @NotNull
            public Iterator<VcsRef> iterator() {
                Iterator<VcsRef> iterator = ((Collection)this.myLoadedRefs.get()).iterator();
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            @Override
            public int size() {
                return ((Collection)this.myLoadedRefs.get()).size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/CompressedRefs$1", "iterator"));
            }
        };
    }

    @NotNull
    public Collection<Integer> getCommits() {
        HashSet<Integer> result2 = new HashSet<Integer>();
        this.myBranches.keySet().intStream().forEach(result2::add);
        this.myTags.keySet().intStream().forEach(result2::add);
        HashSet<Integer> hashSet = result2;
        if (hashSet == null) {
            CompressedRefs.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/CompressedRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/CompressedRefs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "refsToCommit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "streamBranches";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "streamTags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommits";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string2);
        };
    }
}

