/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetter;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetterFactory;
import com.intellij.vcs.log.graph.collapsing.BranchFilterController;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.BekBaseController;
import com.intellij.vcs.log.graph.impl.facade.FilteredController;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.ReachableNodes;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.facade.bek.BekIntMap;
import com.intellij.vcs.log.graph.impl.facade.bek.BekSorter;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutBuilder;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphBuilder;
import com.intellij.vcs.log.graph.impl.permanent.PermanentLinearGraphImpl;
import com.intellij.vcs.log.graph.impl.print.GraphColorGetterByHeadFactory;
import com.intellij.vcs.log.graph.linearBek.LinearBekController;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PermanentGraphImpl<CommitId>
implements PermanentGraph<CommitId>,
PermanentGraphInfo<CommitId> {
    @NotNull
    private final PermanentCommitsInfoImpl<CommitId> myPermanentCommitsInfo;
    @NotNull
    private final PermanentLinearGraphImpl myPermanentLinearGraph;
    @NotNull
    private final GraphLayoutImpl myPermanentGraphLayout;
    @NotNull
    private final Set<Integer> myBranchNodeIds;
    @NotNull
    private final Supplier<BekIntMap> myBekIntMap;
    @NotNull
    private final GraphColorGetter myGraphColorGetter;
    @NotNull
    private final ReachableNodes myReachableNodes;

    private PermanentGraphImpl(@NotNull PermanentLinearGraphImpl permanentLinearGraph, @NotNull GraphLayoutImpl permanentGraphLayout, @NotNull PermanentCommitsInfoImpl<CommitId> permanentCommitsInfo, @NotNull GraphColorGetterFactory<CommitId> colorGetterFactory, @NotNull Set<? extends CommitId> branchesCommitId) {
        if (permanentLinearGraph == null) {
            PermanentGraphImpl.$$$reportNull$$$0(0);
        }
        if (permanentGraphLayout == null) {
            PermanentGraphImpl.$$$reportNull$$$0(1);
        }
        if (permanentCommitsInfo == null) {
            PermanentGraphImpl.$$$reportNull$$$0(2);
        }
        if (colorGetterFactory == null) {
            PermanentGraphImpl.$$$reportNull$$$0(3);
        }
        if (branchesCommitId == null) {
            PermanentGraphImpl.$$$reportNull$$$0(4);
        }
        this.myPermanentGraphLayout = permanentGraphLayout;
        this.myPermanentCommitsInfo = permanentCommitsInfo;
        this.myPermanentLinearGraph = permanentLinearGraph;
        this.myGraphColorGetter = colorGetterFactory.createColorGetter(this);
        this.myBranchNodeIds = permanentCommitsInfo.convertToNodeIds(branchesCommitId);
        this.myReachableNodes = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentLinearGraph));
        this.myBekIntMap = Suppliers.memoize(() -> BekSorter.createBekMap(this.myPermanentLinearGraph, this.myPermanentGraphLayout, this.myPermanentCommitsInfo.getTimestampGetter()));
    }

    @NotNull
    private LinearGraphController createBaseController(@NotNull PermanentGraph.SortType sortType) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(5);
        }
        if (sortType == PermanentGraph.SortType.Normal) {
            return new BaseController(this);
        }
        if (sortType == PermanentGraph.SortType.LinearBek) {
            return new LinearBekController(new BekBaseController(this, (BekIntMap)this.myBekIntMap.get()), this);
        }
        return new BekBaseController(this, (BekIntMap)this.myBekIntMap.get());
    }

    @NotNull
    private LinearGraphController createFilteredController(@NotNull LinearGraphController baseController, @NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits) {
        Set<Integer> visibleHeadsIds;
        if (baseController == null) {
            PermanentGraphImpl.$$$reportNull$$$0(6);
        }
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(7);
        }
        Set<Integer> set = visibleHeadsIds = visibleHeads != null ? this.myPermanentCommitsInfo.convertToNodeIds(visibleHeads, true) : null;
        if (matchingCommits != null) {
            return new FilteredController(baseController, this, this.myPermanentCommitsInfo.convertToNodeIds(matchingCommits), visibleHeadsIds);
        }
        if (sortType == PermanentGraph.SortType.LinearBek) {
            if (visibleHeadsIds != null) {
                return new BranchFilterController(baseController, this, visibleHeadsIds);
            }
            LinearGraphController linearGraphController = baseController;
            if (linearGraphController == null) {
                PermanentGraphImpl.$$$reportNull$$$0(8);
            }
            return linearGraphController;
        }
        return new CollapsedController(baseController, this, visibleHeadsIds);
    }

    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits, @NotNull BiConsumer<? super LinearGraphController, ? super PermanentGraphInfo<CommitId>> preprocessor2) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(9);
        }
        if (preprocessor2 == null) {
            PermanentGraphImpl.$$$reportNull$$$0(10);
        }
        LinearGraphController controller = this.createFilteredController(this.createBaseController(sortType), sortType, visibleHeads, matchingCommits);
        preprocessor2.accept(controller, this);
        return new VisibleGraphImpl(controller, this, this.myGraphColorGetter);
    }

    @Override
    @NotNull
    public VisibleGraph<CommitId> createVisibleGraph(@NotNull PermanentGraph.SortType sortType, @Nullable Set<? extends CommitId> visibleHeads, @Nullable Set<? extends CommitId> matchingCommits) {
        if (sortType == null) {
            PermanentGraphImpl.$$$reportNull$$$0(11);
        }
        VisibleGraph<? extends CommitId> visibleGraph = this.createVisibleGraph(sortType, visibleHeads, matchingCommits, (controller, info) -> {});
        if (visibleGraph == null) {
            PermanentGraphImpl.$$$reportNull$$$0(12);
        }
        return visibleGraph;
    }

    @Override
    @NotNull
    public List<GraphCommit<CommitId>> getAllCommits() {
        return new AbstractList<GraphCommit<CommitId>>(){

            @Override
            public GraphCommit<CommitId> get(int index) {
                Object commitId2 = PermanentGraphImpl.this.myPermanentCommitsInfo.getCommitId(index);
                List<Integer> downNodes = LinearGraphUtils.getDownNodesIncludeNotLoad(PermanentGraphImpl.this.myPermanentLinearGraph, index);
                List parentsCommitIds = PermanentGraphImpl.this.myPermanentCommitsInfo.convertToCommitIdList(downNodes);
                return GraphCommitImpl.createCommit(commitId2, parentsCommitIds, PermanentGraphImpl.this.myPermanentCommitsInfo.getTimestamp(index));
            }

            @Override
            public int size() {
                return PermanentGraphImpl.this.myPermanentLinearGraph.nodesCount();
            }
        };
    }

    @Override
    @NotNull
    public List<CommitId> getChildren(@NotNull CommitId commit2) {
        if (commit2 == null) {
            PermanentGraphImpl.$$$reportNull$$$0(13);
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit2);
        List<CommitId> list = this.myPermanentCommitsInfo.convertToCommitIdList(LinearGraphUtils.getUpNodes(this.myPermanentLinearGraph, commitIndex));
        if (list == null) {
            PermanentGraphImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<CommitId> getContainingBranches(@NotNull CommitId commit2) {
        if (commit2 == null) {
            PermanentGraphImpl.$$$reportNull$$$0(15);
        }
        int commitIndex = this.myPermanentCommitsInfo.getNodeId(commit2);
        Set<CommitId> set = this.myPermanentCommitsInfo.convertToCommitIdSet(this.myReachableNodes.getContainingBranches(commitIndex, this.myBranchNodeIds));
        if (set == null) {
            PermanentGraphImpl.$$$reportNull$$$0(16);
        }
        return set;
    }

    @Override
    @NotNull
    public Predicate<CommitId> getContainedInBranchCondition(@NotNull Collection<? extends CommitId> heads) {
        if (heads == null) {
            PermanentGraphImpl.$$$reportNull$$$0(17);
        }
        List headIds = ContainerUtil.map(heads, head -> this.myPermanentCommitsInfo.getNodeId(head));
        if (!heads.isEmpty() && ContainerUtil.getFirstItem(heads) instanceof Integer) {
            IntOpenHashSet branchNodes = new IntOpenHashSet();
            this.myReachableNodes.walkDown(headIds, arg_0 -> this.lambda$getContainedInBranchCondition$3((IntSet)branchNodes, arg_0));
            return new IntContainedInBranchCondition((IntSet)branchNodes);
        }
        HashSet branchNodes = new HashSet();
        this.myReachableNodes.walkDown(headIds, node -> branchNodes.add(this.myPermanentCommitsInfo.getCommitId((int)node)));
        return new ContainedInBranchCondition(branchNodes);
    }

    @Override
    @NotNull
    public PermanentCommitsInfoImpl<CommitId> getPermanentCommitsInfo() {
        PermanentCommitsInfoImpl<CommitId> permanentCommitsInfoImpl = this.myPermanentCommitsInfo;
        if (permanentCommitsInfoImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(18);
        }
        return permanentCommitsInfoImpl;
    }

    @Override
    @NotNull
    public PermanentLinearGraphImpl getLinearGraph() {
        PermanentLinearGraphImpl permanentLinearGraphImpl = this.myPermanentLinearGraph;
        if (permanentLinearGraphImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(19);
        }
        return permanentLinearGraphImpl;
    }

    @Override
    @NotNull
    public GraphLayoutImpl getPermanentGraphLayout() {
        GraphLayoutImpl graphLayoutImpl = this.myPermanentGraphLayout;
        if (graphLayoutImpl == null) {
            PermanentGraphImpl.$$$reportNull$$$0(20);
        }
        return graphLayoutImpl;
    }

    @Override
    @NotNull
    public Set<Integer> getBranchNodeIds() {
        Set<Integer> set = this.myBranchNodeIds;
        if (set == null) {
            PermanentGraphImpl.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull GraphColorGetterFactory<CommitId> colorGetterFactory, @NotNull Comparator<CommitId> headCommitsComparator, @NotNull Set<? extends CommitId> branchesCommitId) {
        if (graphCommits == null) {
            PermanentGraphImpl.$$$reportNull$$$0(22);
        }
        if (colorGetterFactory == null) {
            PermanentGraphImpl.$$$reportNull$$$0(23);
        }
        if (headCommitsComparator == null) {
            PermanentGraphImpl.$$$reportNull$$$0(24);
        }
        if (branchesCommitId == null) {
            PermanentGraphImpl.$$$reportNull$$$0(25);
        }
        PermanentLinearGraphBuilder permanentLinearGraphBuilder = PermanentLinearGraphBuilder.newInstance(graphCommits);
        NotLoadedCommitsIdsGenerator idsGenerator = new NotLoadedCommitsIdsGenerator();
        PermanentLinearGraphImpl linearGraph = permanentLinearGraphBuilder.build(idsGenerator);
        PermanentCommitsInfoImpl permanentCommitsInfo = PermanentCommitsInfoImpl.newInstance(graphCommits, idsGenerator.getNotLoadedCommits());
        GraphLayoutImpl permanentGraphLayout = GraphLayoutBuilder.build(linearGraph, (nodeIndex1, nodeIndex2) -> {
            Object commitId1 = permanentCommitsInfo.getCommitId(nodeIndex1);
            Object commitId2 = permanentCommitsInfo.getCommitId(nodeIndex2);
            return headCommitsComparator.compare(commitId1, commitId2);
        });
        return new PermanentGraphImpl<CommitId>(linearGraph, permanentGraphLayout, permanentCommitsInfo, colorGetterFactory, branchesCommitId);
    }

    @NotNull
    public static <CommitId> PermanentGraphImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull GraphColorManager<CommitId> colorManager, @NotNull Comparator<CommitId> headCommitsComparator, @NotNull Set<? extends CommitId> branchesCommitId) {
        if (graphCommits == null) {
            PermanentGraphImpl.$$$reportNull$$$0(26);
        }
        if (colorManager == null) {
            PermanentGraphImpl.$$$reportNull$$$0(27);
        }
        if (headCommitsComparator == null) {
            PermanentGraphImpl.$$$reportNull$$$0(28);
        }
        if (branchesCommitId == null) {
            PermanentGraphImpl.$$$reportNull$$$0(29);
        }
        return PermanentGraphImpl.newInstance(graphCommits, new GraphColorGetterByHeadFactory<CommitId>(colorManager), headCommitsComparator, branchesCommitId);
    }

    private /* synthetic */ void lambda$getContainedInBranchCondition$3(IntSet branchNodes, Integer node) {
        branchNodes.add(((Integer)this.myPermanentCommitsInfo.getCommitId(node)).intValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12, 14, 16, 18, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentLinearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentGraphLayout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permanentCommitsInfo";
                break;
            }
            case 3: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorGetterFactory";
                break;
            }
            case 4: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchesCommitId";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseController";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessor";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphCommits";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headCommitsComparator";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilteredController";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisibleGraph";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingBranches";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentCommitsInfo";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinearGraph";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPermanentGraphLayout";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNodeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBaseController";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFilteredController";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createVisibleGraph";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContainingBranches";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContainedInBranchCondition";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 12, 14, 16, 18, 19, 20, 21 -> new IllegalStateException(string2);
        };
    }

    private static class IntContainedInBranchCondition<CommitId>
    implements Predicate<CommitId> {
        private final IntSet myBranchNodes;

        IntContainedInBranchCondition(IntSet branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        @Override
        public boolean test(CommitId commitId2) {
            return this.myBranchNodes.contains(((Integer)commitId2).intValue());
        }
    }

    private static class ContainedInBranchCondition<CommitId>
    implements Predicate<CommitId> {
        private final Set<CommitId> myBranchNodes;

        ContainedInBranchCondition(Set<CommitId> branchNodes) {
            this.myBranchNodes = branchNodes;
        }

        @Override
        public boolean test(CommitId commitId2) {
            return this.myBranchNodes.contains(commitId2);
        }
    }

    private static class NotLoadedCommitsIdsGenerator<CommitId>
    implements NotNullFunction<CommitId, Integer> {
        @NotNull
        private final Int2ObjectMap<CommitId> myNotLoadedCommits = new Int2ObjectOpenHashMap();

        private NotLoadedCommitsIdsGenerator() {
        }

        @NotNull
        public Integer fun(CommitId dom) {
            int nodeId = -(this.myNotLoadedCommits.size() + 2);
            this.myNotLoadedCommits.put(nodeId, dom);
            Integer n = nodeId;
            if (n == null) {
                NotLoadedCommitsIdsGenerator.$$$reportNull$$$0(0);
            }
            return n;
        }

        @NotNull
        Int2ObjectMap<CommitId> getNotLoadedCommits() {
            Int2ObjectMap<CommitId> int2ObjectMap = this.myNotLoadedCommits;
            if (int2ObjectMap == null) {
                NotLoadedCommitsIdsGenerator.$$$reportNull$$$0(1);
            }
            return int2ObjectMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl$NotLoadedCommitsIdsGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fun";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotLoadedCommits";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

