/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.history.EdgeData;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="hashes")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0010\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000e\u001a\u00020\bH\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001R\u0016\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/history/Hashes;", "", "()V", "edgeData", "Lcom/intellij/vcs/log/history/EdgeData;", "Lcom/intellij/vcs/log/CommitId;", "(Lcom/intellij/vcs/log/history/EdgeData;)V", "parentHash", "", "childHash", "(Ljava/lang/String;Ljava/lang/String;)V", "getChildHash", "()Ljava/lang/String;", "getParentHash", "component1", "component2", "copy", "equals", "", "other", "getCommitIds", "rootFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hashCode", "", "toString", "intellij.platform.vcs.log.impl"})
public final class Hashes {
    @Attribute(value="parentHash")
    @NotNull
    private final String parentHash;
    @Attribute(value="childHash")
    @NotNull
    private final String childHash;

    public Hashes(@NotNull String parentHash, @NotNull String childHash) {
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        Intrinsics.checkNotNullParameter((Object)childHash, (String)"childHash");
        this.parentHash = parentHash;
        this.childHash = childHash;
    }

    @NotNull
    public final String getParentHash() {
        return this.parentHash;
    }

    @NotNull
    public final String getChildHash() {
        return this.childHash;
    }

    public Hashes() {
        this("", "");
    }

    public Hashes(@NotNull EdgeData<CommitId> edgeData) {
        Intrinsics.checkNotNullParameter(edgeData, (String)"edgeData");
        String string2 = ((CommitId)edgeData.parent).getHash().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"edgeData.parent.hash.asString()");
        String string3 = ((CommitId)edgeData.child).getHash().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"edgeData.child.hash.asString()");
        this(string2, string3);
    }

    @Nullable
    public final EdgeData<CommitId> getCommitIds(@NotNull VirtualFile rootFile2) {
        Intrinsics.checkNotNullParameter((Object)rootFile2, (String)"rootFile");
        if (!VcsLogUtil.HASH_REGEX.matcher(this.parentHash).matches() || !VcsLogUtil.HASH_REGEX.matcher(this.childHash).matches()) {
            return null;
        }
        return new EdgeData<CommitId>(new CommitId(HashImpl.build(this.parentHash), rootFile2), new CommitId(HashImpl.build(this.childHash), rootFile2));
    }

    @NotNull
    public final String component1() {
        return this.parentHash;
    }

    @NotNull
    public final String component2() {
        return this.childHash;
    }

    @NotNull
    public final Hashes copy(@NotNull String parentHash, @NotNull String childHash) {
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        Intrinsics.checkNotNullParameter((Object)childHash, (String)"childHash");
        return new Hashes(parentHash, childHash);
    }

    public static /* synthetic */ Hashes copy$default(Hashes hashes2, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = hashes2.parentHash;
        }
        if ((n & 2) != 0) {
            string3 = hashes2.childHash;
        }
        return hashes2.copy(string2, string3);
    }

    @NotNull
    public String toString() {
        return "Hashes(parentHash=" + this.parentHash + ", childHash=" + this.childHash + ")";
    }

    public int hashCode() {
        int result2 = this.parentHash.hashCode();
        result2 = result2 * 31 + this.childHash.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Hashes)) {
            return false;
        }
        Hashes hashes2 = (Hashes)other;
        if (!Intrinsics.areEqual((Object)this.parentHash, (Object)hashes2.parentHash)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.childHash, (Object)hashes2.childHash);
    }
}

