/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.TabGroupId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.Collection;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider;", "Lcom/intellij/vcs/log/VcsLogFileHistoryProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "tabGroupId", "Lcom/intellij/ui/content/TabGroupId;", "canShowFileHistory", "", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "showFileHistory", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogFileHistoryProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFileHistoryProviderImpl.kt\ncom/intellij/vcs/log/history/VcsLogSingleFileHistoryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1#2:185\n*E\n"})
final class VcsLogSingleFileHistoryProvider
implements VcsLogFileHistoryProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final TabGroupId tabGroupId;

    public VcsLogSingleFileHistoryProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Supplier<String> supplier2 = VcsBundle.messagePointer("file.history.tab.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier2, (String)"messagePointer(\"file.history.tab.name\")");
        this.tabGroupId = new TabGroupId("History", supplier2, false);
    }

    public boolean canShowFileHistory(@NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (!VcsLogFileHistoryProviderImplKt.isNewHistoryEnabled() || paths.size() != 1) {
            return false;
        }
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(this.project, (FilePath)CollectionsKt.single((Iterable)paths));
        if (virtualFile == null) {
            return false;
        }
        VirtualFile root = virtualFile;
        FilePath correctedPath = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(this.project, (FilePath)CollectionsKt.single((Iterable)paths), revisionNumber != null);
        if (correctedPath.isDirectory()) {
            return false;
        }
        VcsLogData vcsLogData = VcsProjectLog.Companion.getInstance(this.project).getDataManager();
        if (vcsLogData == null) {
            return false;
        }
        VcsLogData dataManager = vcsLogData;
        VcsLogProvider vcsLogProvider = dataManager.getLogProviders().get(root);
        if ((vcsLogProvider != null ? vcsLogProvider.getDiffHandler() : null) == null) {
            return false;
        }
        return dataManager.getIndex().isIndexingEnabled(root) || Registry.is((String)"vcs.force.new.history");
    }

    public void showFileHistory(@NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        boolean firstTime;
        Hash hash2;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (paths.size() != 1) {
            return;
        }
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(this.project, (FilePath)CollectionsKt.first((Iterable)paths));
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        FilePath path2 = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(this.project, (FilePath)CollectionsKt.single((Iterable)paths), revisionNumber != null);
        if (path2.isDirectory()) {
            return;
        }
        String string2 = revisionNumber;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            hash2 = HashImpl.build(it);
        } else {
            hash2 = null;
        }
        Hash hash3 = hash2;
        VcsLogFileHistoryProviderImplKt.access$triggerFileHistoryUsage(this.project, paths, hash3);
        VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(this.project).getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        VcsLogManager logManager2 = vcsLogManager;
        FileHistoryUi fileHistoryUi2 = VcsLogTabLocation.Companion.findLogUi(logManager2, VcsLogTabLocation.TOOL_WINDOW, FileHistoryUi.class, true, (Function1)new Function1<FileHistoryUi, Boolean>(path2, hash3){
            final /* synthetic */ FilePath $path;
            final /* synthetic */ Hash $hash;
            {
                this.$path = $path;
                this.$hash = $hash;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull FileHistoryUi ui2) {
                Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
                return ui2.matches(this.$path, this.$hash);
            }
        });
        boolean bl = firstTime = fileHistoryUi2 == null;
        if (firstTime) {
            Hash hash4 = hash3;
            Object suffix = hash4 != null ? " (" + hash4.toShortString() + ")" : "";
            fileHistoryUi2 = VcsLogContentUtil.openLogTab(this.project, logManager2, this.tabGroupId, arg_0 -> VcsLogSingleFileHistoryProvider.showFileHistory$lambda$1(path2, (String)suffix, arg_0), new FileHistoryUiFactory(path2, root, hash3), true);
        }
        FileHistoryUi fileHistoryUi3 = fileHistoryUi2;
        Intrinsics.checkNotNull((Object)fileHistoryUi3);
        VcsLogFileHistoryProviderImplKt.access$selectRowWhenOpen(logManager2, hash3, root, fileHistoryUi3, firstTime);
    }

    private static final String showFileHistory$lambda$1(FilePath $path, String $suffix, FileHistoryUi it) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$suffix, (String)"$suffix");
        return $path.getName() + $suffix;
    }
}

