/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OpenAnotherLogTabAction
extends DumbAwareAction {
    protected OpenAnotherLogTabAction() {
        super(() -> OpenAnotherLogTabAction.getText(VcsLogBundle.message("vcs", new Object[0])), () -> OpenAnotherLogTabAction.getDescription(VcsLogBundle.message("vcs", new Object[0])), AllIcons.Actions.OpenNewTab);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(0);
        }
        if ((project2 = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
        VcsLogManager logManager2 = (VcsLogManager)ObjectUtils.chooseNotNull((Object)((VcsLogManager)e.getData(VcsLogInternalDataKeys.LOG_MANAGER)), (Object)projectLog.getLogManager());
        if (logManager2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(projectLog.getLogManager() == logManager2);
        String vcsName = VcsLogUtil.getVcsDisplayName(project2, logManager2);
        e.getPresentation().setText(OpenAnotherLogTabAction.getText(vcsName));
        e.getPresentation().setDescription(OpenAnotherLogTabAction.getDescription(vcsName));
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private static String getDescription(@Nls @NotNull String vcsName) {
        if (vcsName == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(1);
        }
        String string2 = VcsLogBundle.message("vcs.log.action.description.open.new.tab.with.log", vcsName);
        if (string2 == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Title)
    private static String getText(@Nls @NotNull String vcsName) {
        if (vcsName == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(3);
        }
        String string2 = VcsLogBundle.message("vcs.log.action.open.new.tab.with.log", vcsName);
        if (string2 == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(5);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e, (Object)this);
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLogUi logUi2 = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        VcsLogFilterCollection filters = Registry.is((String)"vcs.log.copy.filters.to.new.tab") && logUi2 != null ? logUi2.getFilterUi().getFilters() : VcsLogFilterObject.collection(new VcsLogFilter[0]);
        VcsLogTabLocation location = VcsLogTabLocation.TOOL_WINDOW;
        if (e.getData(PlatformDataKeys.TOOL_WINDOW) == null && Registry.is((String)"vcs.log.open.editor.tab")) {
            location = VcsLogTabLocation.EDITOR;
        }
        VcsProjectLog.getInstance(project2).openLogTab(filters, location);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenAnotherLogTabAction.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsName";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/actions/OpenAnotherLogTabAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 4, 6 -> new IllegalStateException(string2);
        };
    }
}

