/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.Consumer;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.CannotAddVcsLogWindowException;
import com.intellij.vcs.log.impl.VcsLogEditorUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.editor.DefaultVcsLogFile;
import com.intellij.vcs.log.ui.editor.VcsLogEditorTabNameCache;
import com.intellij.vcs.log.ui.editor.VcsLogFile;
import com.intellij.vcs.log.ui.editor.VcsLogVirtualFileSystem;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u000bH\u0016J\b\u0010\u001f\u001a\u00020\u000bH\u0016J\b\u0010 \u001a\u00020\u000bH\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/log/ui/editor/DefaultVcsLogFile;", "Lcom/intellij/vcs/log/ui/editor/VcsLogFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "pathId", "Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem$VcsLogComplexPath;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "(Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem$VcsLogComplexPath;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "fileSystemInstance", "Lcom/intellij/vcs/log/ui/editor/VcsLogVirtualFileSystem;", "tabId", "", "getTabId$intellij_platform_vcs_log_impl", "()Ljava/lang/String;", "value", "tabName", "getTabName$intellij_platform_vcs_log_impl", "setTabName$intellij_platform_vcs_log_impl", "(Ljava/lang/String;)V", "createMainComponent", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "enforcePresentableName", "", "equals", "other", "", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "getPresentableName", "getPresentablePath", "hashCode", "", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultVcsLogFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultVcsLogFile.kt\ncom/intellij/vcs/log/ui/editor/DefaultVcsLogFile\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n43#2,3:128\n43#2,3:131\n10#3:134\n*S KotlinDebug\n*F\n+ 1 DefaultVcsLogFile.kt\ncom/intellij/vcs/log/ui/editor/DefaultVcsLogFile\n*L\n32#1:128,3\n33#1:131,3\n87#1:134\n*E\n"})
public final class DefaultVcsLogFile
extends VcsLogFile
implements VirtualFilePathWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogVirtualFileSystem.VcsLogComplexPath pathId;
    @Nullable
    private VcsLogFilterCollection filters;
    @NotNull
    private final VcsLogVirtualFileSystem fileSystemInstance;
    @NotNull
    private static final Logger LOG;

    public DefaultVcsLogFile(@NotNull VcsLogVirtualFileSystem.VcsLogComplexPath pathId, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)pathId, (String)"pathId");
        super(VcsLogTabsManager.Companion.getFullName(pathId.getLogId()));
        this.pathId = pathId;
        this.filters = filters;
        this.fileSystemInstance = VcsLogVirtualFileSystem.Companion.getInstance();
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
    }

    public /* synthetic */ DefaultVcsLogFile(VcsLogVirtualFileSystem.VcsLogComplexPath vcsLogComplexPath, VcsLogFilterCollection vcsLogFilterCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            vcsLogFilterCollection = null;
        }
        this(vcsLogComplexPath, vcsLogFilterCollection);
    }

    @NotNull
    public final String getTabId$intellij_platform_vcs_log_impl() {
        return this.pathId.getLogId();
    }

    @NotNull
    public final String getTabName$intellij_platform_vcs_log_impl() {
        boolean $i$f$service = false;
        Class<VcsLogEditorTabNameCache> serviceClass$iv = VcsLogEditorTabNameCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        String string2 = ((VcsLogEditorTabNameCache)((Object)object)).getTabName(this.getPath());
        if (string2 == null) {
            String string3 = this.getName();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
        }
        return string2;
    }

    public final void setTabName$intellij_platform_vcs_log_impl(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        boolean $i$f$service = false;
        Class<VcsLogEditorTabNameCache> serviceClass$iv = VcsLogEditorTabNameCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        ((VcsLogEditorTabNameCache)((Object)object)).putTabName(this.getPath(), value2);
    }

    @Override
    @NotNull
    public JComponent createMainComponent(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText((LayoutManager)new BorderLayout()).withEmptyText(VcsLogBundle.message("vcs.log.is.loading", new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"JBPanelWithEmptyText(Bor\u2026ge(\"vcs.log.is.loading\"))");
        JBPanelWithEmptyText panel2 = jBPanelWithEmptyText;
        VcsLogUtil.runWhenVcsAndLogIsReady(project2, (Consumer<? super VcsLogManager>)((Consumer)arg_0 -> DefaultVcsLogFile.createMainComponent$lambda$0((Function1)new Function1<VcsLogManager, Unit>(project2, this, panel2){
            final /* synthetic */ Project $project;
            final /* synthetic */ DefaultVcsLogFile this$0;
            final /* synthetic */ JBPanelWithEmptyText $panel;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$panel = $panel;
                super(1);
            }

            public final void invoke(VcsLogManager logManager2) {
                VcsProjectLog projectLog = VcsProjectLog.Companion.getInstance(this.$project);
                VcsLogTabsManager vcsLogTabsManager = projectLog.getTabManager();
                if (vcsLogTabsManager == null) {
                    return;
                }
                VcsLogTabsManager tabsManager = vcsLogTabsManager;
                try {
                    VcsLogManager.VcsLogUiFactory<MainVcsLogUi> factory = tabsManager.getPersistentVcsLogUiFactory(this.this$0.getTabId$intellij_platform_vcs_log_impl(), VcsLogTabLocation.EDITOR, DefaultVcsLogFile.access$getFilters$p(this.this$0));
                    MainVcsLogUi mainVcsLogUi = logManager2.createLogUi(factory, VcsLogTabLocation.EDITOR);
                    Intrinsics.checkNotNullExpressionValue((Object)mainVcsLogUi, (String)"logManager.createLogUi(f\u2026VcsLogTabLocation.EDITOR)");
                    MainVcsLogUi ui2 = mainVcsLogUi;
                    this.this$0.setTabName$intellij_platform_vcs_log_impl(VcsLogTabsManager.Companion.generateDisplayName(ui2));
                    ui2.getFilterUi().addFilterListener(() -> createMainComponent.1.invoke$lambda$0(this.this$0, ui2, this.$project));
                    if (DefaultVcsLogFile.access$getFilters$p(this.this$0) != null) {
                        DefaultVcsLogFile.access$setFilters$p(this.this$0, null);
                    }
                    this.$panel.add((Component)((Object)new VcsLogPanel(logManager2, ui2)), (Object)"Center");
                }
                catch (CannotAddVcsLogWindowException e) {
                    DefaultVcsLogFile.access$getLOG$cp().error((Throwable)e);
                    this.$panel.getEmptyText().setText(VcsLogBundle.message("vcs.log.duplicated.tab.id.error", new Object[0]));
                }
            }

            private static final void invoke$lambda$0(DefaultVcsLogFile this$0, MainVcsLogUi $ui, Project $project) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ui, (String)"$ui");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                this$0.setTabName$intellij_platform_vcs_log_impl(VcsLogTabsManager.Companion.generateDisplayName($ui));
                VcsLogEditorUtil.INSTANCE.updateTabName$intellij_platform_vcs_log_impl($project, $ui);
            }
        }, arg_0)));
        return (JComponent)panel2;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return (VirtualFileSystem)this.fileSystemInstance;
    }

    @NotNull
    public String getPath() {
        return this.fileSystemInstance.getPath((ComplexPathVirtualFileSystem.ComplexPath)this.pathId);
    }

    public boolean enforcePresentableName() {
        return true;
    }

    @NotNull
    public String getPresentableName() {
        return this.getTabName$intellij_platform_vcs_log_impl();
    }

    @NotNull
    public String getPresentablePath() {
        return this.getTabName$intellij_platform_vcs_log_impl();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.vcs.log.ui.editor.DefaultVcsLogFile");
        DefaultVcsLogFile cfr_ignored_0 = (DefaultVcsLogFile)((Object)other);
        return Intrinsics.areEqual((Object)this.getTabId$intellij_platform_vcs_log_impl(), (Object)((DefaultVcsLogFile)((Object)other)).getTabId$intellij_platform_vcs_log_impl());
    }

    public int hashCode() {
        return this.getTabId$intellij_platform_vcs_log_impl().hashCode();
    }

    private static final void createMainComponent$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ VcsLogFilterCollection access$getFilters$p(DefaultVcsLogFile $this) {
        return $this.filters;
    }

    public static final /* synthetic */ void access$setFilters$p(DefaultVcsLogFile $this, VcsLogFilterCollection vcsLogFilterCollection) {
        $this.filters = vcsLogFilterCollection;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DefaultVcsLogFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/vcs/log/ui/editor/DefaultVcsLogFile$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

