/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpEquivalenceChecker;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DuplicateAlternationBranchInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateAlternationBranchInspection.$$$reportNull$$$0(0);
        }
        return new DuplicateAlternationBranchVisitor(holder, isOnTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/DuplicateAlternationBranchInspection", "buildVisitor"));
    }

    private static class DuplicateAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        DuplicateAlternationBranchVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern2) {
            RegExpBranch[] branches = pattern2.getBranches();
            if (branches.length < 2) {
                return;
            }
            HashSet<RegExpBranch> reported = new HashSet<RegExpBranch>(2);
            for (int i = 0; i < branches.length - 1; ++i) {
                RegExpBranch branch1 = branches[i];
                if (branch1.getAtoms().length == 0) continue;
                for (int j = i + 1; j < branches.length; ++j) {
                    RegExpBranch branch2 = branches[j];
                    if (!RegExpEquivalenceChecker.areElementsEquivalent(branch1, branch2)) continue;
                    if (reported.add(branch1) && this.myIsOnTheFly) {
                        this.registerProblem(branch1);
                    }
                    if (!reported.add(branch2)) continue;
                    this.registerProblem(branch2);
                }
            }
        }

        private void registerProblem(RegExpBranch branch1) {
            this.myHolder.registerProblem((PsiElement)branch1, RegExpBundle.message("inspection.warning.duplicate.branch.in.alternation", new Object[0]), new LocalQuickFix[]{new DuplicateAlternationBranchFix()});
        }
    }

    private static class DuplicateAlternationBranchFix
    implements LocalQuickFix {
        private DuplicateAlternationBranchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string2 = RegExpBundle.message("inspection.quick.fix.remove.duplicate.branch", new Object[0]);
            if (string2 == null) {
                DuplicateAlternationBranchFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project2 == null) {
                DuplicateAlternationBranchFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DuplicateAlternationBranchFix.$$$reportNull$$$0(2);
            }
            if (!((element = descriptor.getPsiElement()) instanceof RegExpBranch)) {
                return;
            }
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling != null) {
                prevSibling.delete();
            } else {
                PsiElement nextSibling = element.getNextSibling();
                if (nextSibling != null) {
                    nextSibling.delete();
                }
            }
            element.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/DuplicateAlternationBranchInspection$DuplicateAlternationBranchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/DuplicateAlternationBranchInspection$DuplicateAlternationBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }
}

