/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.xdebugger.XDebugSession;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/debugger/RejectErrorReporter;", "Ljava/util/function/Consumer;", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "description", "", "(Lcom/intellij/xdebugger/XDebugSession;Ljava/lang/String;)V", "accept", "", "error", "intellij.platform.scriptDebugger.ui"})
public final class RejectErrorReporter
implements Consumer<Throwable> {
    @NotNull
    private final XDebugSession session;
    @Nullable
    private final String description;

    @JvmOverloads
    public RejectErrorReporter(@NotNull XDebugSession session, @NlsContexts.NotificationContent @Nullable String description2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.description = description2;
    }

    public /* synthetic */ RejectErrorReporter(XDebugSession xDebugSession, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(xDebugSession, string2);
    }

    @Override
    public void accept(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (Promises.errorIfNotMessage((Logger)CommandProcessorKt.getLOG(), (Throwable)error)) {
            this.session.reportError((String)(this.description == null ? "" : this.description + ": ") + error.getMessage());
        }
    }

    @JvmOverloads
    public RejectErrorReporter(@NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this(session, null, 2, null);
    }
}

