/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.Url;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010!\u001a\u00020\u0014H\u0016R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\n\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lorg/jetbrains/debugger/ScriptBase;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lorg/jetbrains/debugger/Script;", "type", "Lorg/jetbrains/debugger/Script$Type;", "url", "Lcom/intellij/util/Url;", "line", "", "column", "endLine", "vm", "Lorg/jetbrains/debugger/Vm;", "(Lorg/jetbrains/debugger/Script$Type;Lcom/intellij/util/Url;IIILorg/jetbrains/debugger/Vm;)V", "getColumn", "()I", "getEndLine", "getLine", "source", "Lorg/jetbrains/concurrency/Promise;", "", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "getSourceMap", "()Lorg/jetbrains/debugger/sourcemap/SourceMap;", "setSourceMap", "(Lorg/jetbrains/debugger/sourcemap/SourceMap;)V", "getType", "()Lorg/jetbrains/debugger/Script$Type;", "getUrl", "()Lcom/intellij/util/Url;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "toString", "intellij.platform.scriptDebugger.backend"})
public abstract class ScriptBase
extends UserDataHolderBase
implements Script {
    @NotNull
    private final Script.Type type;
    @NotNull
    private final Url url;
    private final int column;
    private final int endLine;
    @NotNull
    private final Vm vm;
    private final int line;
    @Nullable
    private volatile Promise<String> source;
    @Nullable
    private SourceMap sourceMap;

    public ScriptBase(@NotNull Script.Type type2, @NotNull Url url, int line, int column, int endLine, @NotNull Vm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        this.type = type2;
        this.url = url;
        this.column = column;
        this.endLine = endLine;
        this.vm = vm;
        this.line = Math.max(line, 0);
    }

    @Override
    @NotNull
    public Script.Type getType() {
        return this.type;
    }

    @Override
    @NotNull
    public Url getUrl() {
        return this.url;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    @NotNull
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    @Nullable
    public SourceMap getSourceMap() {
        return this.sourceMap;
    }

    @Override
    public void setSourceMap(@Nullable SourceMap sourceMap) {
        this.sourceMap = sourceMap;
    }

    @NotNull
    public String toString() {
        return "[url=" + this.getUrl() + ", lineRange=[" + this.getLine() + ";" + this.getEndLine() + "]]";
    }
}

