/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalToolWindowManager;

class TerminalToolWindowPanel
extends SimpleToolWindowPanel
implements UISettingsListener {
    private final PropertiesComponent myPropertiesComponent;
    private final ToolWindow myWindow;

    TerminalToolWindowPanel(@NotNull PropertiesComponent propertiesComponent, @NotNull ToolWindow window) {
        if (propertiesComponent == null) {
            TerminalToolWindowPanel.$$$reportNull$$$0(0);
        }
        if (window == null) {
            TerminalToolWindowPanel.$$$reportNull$$$0(1);
        }
        super(false, true);
        this.myPropertiesComponent = propertiesComponent;
        this.myWindow = window;
        TerminalToolWindowPanel.installDnD(window);
    }

    private static void installDnD(@NotNull ToolWindow window) {
        if (window == null) {
            TerminalToolWindowPanel.$$$reportNull$$$0(2);
        }
        DnDDropHandler handler = new DnDDropHandler(){

            public void drop(DnDEvent event) {
                PsiDirectory dir;
                TransferableWrapper tw = (TransferableWrapper)ObjectUtils.tryCast((Object)event.getAttachedObject(), TransferableWrapper.class);
                if (tw != null && (dir = TerminalToolWindowPanel.getDirectory((PsiElement)ArrayUtil.getFirstElement((Object[])tw.getPsiElements()))) != null && tw.getPsiElements().length == 1) {
                    TerminalToolWindowManager view = TerminalToolWindowManager.getInstance(dir.getProject());
                    TerminalTabState state = new TerminalTabState();
                    state.myWorkingDirectory = dir.getVirtualFile().getPath();
                    view.createNewSession(view.getTerminalRunner(), state);
                }
            }
        };
        DnDSupport.createBuilder((JComponent)window.getComponent()).setDropHandler(handler).install();
    }

    @Nullable
    private static PsiDirectory getDirectory(@Nullable PsiElement item) {
        if (item instanceof PsiFile) {
            return ((PsiFile)item).getParent();
        }
        return (PsiDirectory)ObjectUtils.tryCast((Object)item, PsiDirectory.class);
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            TerminalToolWindowPanel.$$$reportNull$$$0(3);
        }
        this.updateDFState();
    }

    void updateDFState() {
        if (TerminalToolWindowPanel.isDfmSupportEnabled()) {
            this.setDistractionFree(this.shouldMakeDistractionFree());
        }
    }

    private void setDistractionFree(boolean isDistractionFree) {
        boolean isVisible = !isDistractionFree;
        this.setToolbarVisible(isVisible);
        this.setToolWindowHeaderVisible(isVisible);
    }

    private void setToolbarVisible(boolean isVisible) {
        ToggleToolbarAction.setToolbarVisible((ToolWindow)this.myWindow, (PropertiesComponent)this.myPropertiesComponent, (Boolean)isVisible);
    }

    private void setToolWindowHeaderVisible(boolean isVisible) {
        InternalDecorator decorator = ((ToolWindowEx)this.myWindow).getDecorator();
        decorator.setHeaderVisible(isVisible);
    }

    private boolean shouldMakeDistractionFree() {
        return !this.myWindow.getAnchor().isHorizontal() && ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled();
    }

    public void addNotify() {
        super.addNotify();
        this.updateDFState();
    }

    private static boolean isDfmSupportEnabled() {
        return Registry.get((String)"terminal.distraction.free").asBoolean();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalToolWindowPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installDnD";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uiSettingsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

