/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\bH'J\b\u0010\f\u001a\u00020\bH\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionManager;", "", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "(Lorg/jetbrains/plugins/terminal/exp/TerminalSession;)V", "getSession", "()Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "invokeCompletion", "", "command", "", "resetPrompt", "waitForTerminalLock", "Companion", "intellij.terminal"})
public abstract class TerminalCompletionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalSession session;
    @NotNull
    private static final Key<TerminalCompletionManager> KEY;

    public TerminalCompletionManager(@NotNull TerminalSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
    }

    @NotNull
    protected final TerminalSession getSession() {
        return this.session;
    }

    @RequiresBackgroundThread
    public final void waitForTerminalLock() {
        TerminalModel model = this.session.getModel();
        ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)model.getCommandExecutionSemaphore(), (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        model.getCommandExecutionSemaphore().down();
    }

    public abstract void invokeCompletion(@NotNull String var1);

    @RequiresBackgroundThread
    public abstract void resetPrompt();

    static {
        Key key = Key.create((String)"TerminalCompletionManager");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(\"TerminalCompletionManager\")");
        KEY = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionManager$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionManager;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<TerminalCompletionManager> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

