/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalExecutorServiceManagerImpl;
import com.jediterm.core.typeahead.Debouncer;
import com.jediterm.core.typeahead.TerminalTypeAheadManager;
import com.jediterm.core.typeahead.TypeAheadTerminalModel;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalExecutorServiceManager;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyBasedArrayDataStream;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTermDebouncerImpl;
import com.jediterm.terminal.model.JediTermTypeAheadModel;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandManager;
import org.jetbrains.plugins.terminal.exp.TerminalController;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalTextBufferEx;
import org.jetbrains.plugins.terminal.util.ShellIntegration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0001J\b\u0010&\u001a\u00020\"H\u0016J\u000e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "Lcom/intellij/openapi/Disposable;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "commandManager", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandManager;", "controller", "Lorg/jetbrains/plugins/terminal/exp/TerminalController;", "getController", "()Lorg/jetbrains/plugins/terminal/exp/TerminalController;", "executorServiceManager", "Lcom/jediterm/terminal/TerminalExecutorServiceManager;", "model", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "getModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalModel;", "shellIntegration", "Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "getShellIntegration", "()Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "setShellIntegration", "(Lorg/jetbrains/plugins/terminal/util/ShellIntegration;)V", "terminalStarter", "Lcom/jediterm/terminal/TerminalStarter;", "getTerminalStarter", "()Lcom/jediterm/terminal/TerminalStarter;", "setTerminalStarter", "(Lcom/jediterm/terminal/TerminalStarter;)V", "textBuffer", "Lcom/jediterm/terminal/model/TerminalTextBuffer;", "typeAheadManager", "Lcom/jediterm/core/typeahead/TerminalTypeAheadManager;", "addCommandListener", "", "listener", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandListener;", "parentDisposable", "dispose", "executeCommand", "command", "", "postResize", "newSize", "Lcom/jediterm/core/util/TermSize;", "start", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "Companion", "intellij.terminal"})
public final class TerminalSession
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalModel model;
    public TerminalStarter terminalStarter;
    @NotNull
    private final TerminalExecutorServiceManager executorServiceManager;
    @NotNull
    private final TerminalTextBuffer textBuffer;
    @NotNull
    private final TerminalController controller;
    @NotNull
    private final ShellCommandManager commandManager;
    @NotNull
    private final TerminalTypeAheadManager typeAheadManager;
    @Nullable
    private volatile ShellIntegration shellIntegration;
    @NotNull
    private static final Key<TerminalSession> KEY;

    public TerminalSession(@NotNull JBTerminalSystemSettingsProviderBase settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.executorServiceManager = (TerminalExecutorServiceManager)new TerminalExecutorServiceManagerImpl();
        StyleState styleState = new StyleState();
        styleState.setDefaultStyle(settings.getDefaultStyle());
        this.textBuffer = new TerminalTextBufferEx(80, 24, styleState);
        this.model = new TerminalModel(this.textBuffer, styleState);
        this.controller = new TerminalController(this.model, settings);
        this.commandManager = new ShellCommandManager(this.controller);
        JediTermTypeAheadModel typeAheadTerminalModel = new JediTermTypeAheadModel((Terminal)this.controller, this.textBuffer, (SettingsProvider)settings);
        this.typeAheadManager = new TerminalTypeAheadManager((TypeAheadTerminalModel)typeAheadTerminalModel);
        JediTermDebouncerImpl typeAheadDebouncer = new JediTermDebouncerImpl(() -> ((TerminalTypeAheadManager)this.typeAheadManager).debounce(), TerminalTypeAheadManager.MAX_TERMINAL_DELAY, this.executorServiceManager);
        this.typeAheadManager.setClearPredictionsDebouncer((Debouncer)typeAheadDebouncer);
    }

    @NotNull
    public final TerminalModel getModel() {
        return this.model;
    }

    @NotNull
    public final TerminalStarter getTerminalStarter() {
        TerminalStarter terminalStarter = this.terminalStarter;
        if (terminalStarter != null) {
            return terminalStarter;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"terminalStarter");
        return null;
    }

    public final void setTerminalStarter(@NotNull TerminalStarter terminalStarter) {
        Intrinsics.checkNotNullParameter((Object)terminalStarter, (String)"<set-?>");
        this.terminalStarter = terminalStarter;
    }

    @NotNull
    public final TerminalController getController() {
        return this.controller;
    }

    @Nullable
    public final ShellIntegration getShellIntegration() {
        return this.shellIntegration;
    }

    public final void setShellIntegration(@Nullable ShellIntegration shellIntegration) {
        this.shellIntegration = shellIntegration;
    }

    public final void start(@NotNull TtyConnector ttyConnector) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        this.setTerminalStarter(new TerminalStarter((Terminal)this.controller, ttyConnector, (TerminalDataStream)new TtyBasedArrayDataStream(ttyConnector), this.typeAheadManager, this.executorServiceManager));
        this.executorServiceManager.getUnboundedExecutorService().submit(() -> TerminalSession.start$lambda$0(this));
    }

    public final void executeCommand(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        byte[] enterCode = this.getTerminalStarter().getCode(10, 0);
        this.getTerminalStarter().sendString(command, false);
        this.getTerminalStarter().sendBytes(enterCode, false);
    }

    public final void postResize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        if (this.terminalStarter != null && (newSize.getColumns() != this.model.getWidth() || newSize.getRows() != this.model.getHeight())) {
            this.getTerminalStarter().postResize(newSize, RequestOrigin.User);
        }
    }

    public final void addCommandListener(@NotNull ShellCommandListener listener, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.commandManager.addListener(listener, parentDisposable);
    }

    public static /* synthetic */ void addCommandListener$default(TerminalSession terminalSession, ShellCommandListener shellCommandListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalSession.addCommandListener(shellCommandListener, disposable);
    }

    public void dispose() {
        this.executorServiceManager.shutdownWhenAllExecuted();
        if (this.terminalStarter != null) {
            this.getTerminalStarter().close();
        }
    }

    private static final void start$lambda$0(TerminalSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getTerminalStarter().start();
    }

    static {
        Key key = Key.create((String)"TerminalSession");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(\"TerminalSession\")");
        KEY = key;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalSession$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<TerminalSession> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

