/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jediterm.core.util.TermSize;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.concurrent.CompletableFuture;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalUiUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TIMEOUT", "", "awaitComponentLayout", "Ljava/util/concurrent/CompletableFuture;", "", "component", "Ljava/awt/Component;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "calculateTerminalSize", "Lcom/jediterm/core/util/TermSize;", "componentSize", "Ljava/awt/Dimension;", "charSize", "createEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "ensureTermMinimumSize", "size", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/exp/TerminalUiUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n10#2:122\n*S KotlinDebug\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/exp/TerminalUiUtils\n*L\n119#1:122\n*E\n"})
public final class TerminalUiUtils {
    @NotNull
    public static final TerminalUiUtils INSTANCE = new TerminalUiUtils();
    @NotNull
    private static final Logger LOG;
    private static final int TIMEOUT = 2000;

    private TerminalUiUtils() {
    }

    @NotNull
    public final EditorImpl createEditor(@NotNull Document document, @NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        EditorColorsScheme editorColorsScheme;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Editor editor = EditorFactory.getInstance().createEditor(document, project, EditorKind.CONSOLE);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor2 = (EditorImpl)editor;
        editor2.setScrollToCaret(false);
        editor2.setCustomCursor((Object)this, Cursor.getDefaultCursor());
        editor2.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor2.getScrollPane().setHorizontalScrollBarPolicy(31);
        editor2.getGutterComponentEx().setPaintBackground(false);
        EditorColorsScheme $this$createEditor_u24lambda_u240 = editorColorsScheme = editor2.getColorsScheme();
        boolean bl = false;
        $this$createEditor_u24lambda_u240.setEditorFontName(settings.getTerminalFont().getFontName());
        $this$createEditor_u24lambda_u240.setEditorFontSize(settings.getTerminalFont().getSize());
        $this$createEditor_u24lambda_u240.setLineSpacing(settings.getLineSpacing());
        EditorColorsScheme $this$createEditor_u24lambda_u241 = editorColorsScheme = editor2.getSettings();
        boolean bl2 = false;
        $this$createEditor_u24lambda_u241.setShowingSpecialChars(false);
        $this$createEditor_u24lambda_u241.setLineNumbersShown(false);
        $this$createEditor_u24lambda_u241.setGutterIconsShown(false);
        $this$createEditor_u24lambda_u241.setRightMarginShown(false);
        $this$createEditor_u24lambda_u241.setFoldingOutlineShown(false);
        $this$createEditor_u24lambda_u241.setCaretRowShown(false);
        $this$createEditor_u24lambda_u241.setAdditionalLinesCount(0);
        $this$createEditor_u24lambda_u241.setAdditionalColumnsCount(0);
        $this$createEditor_u24lambda_u241.setBlockCursor(true);
        editor2.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(){

            @NotNull
            public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AnAction anAction = ActionManager.getInstance().getAction("Terminal.PopupMenu");
                Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                return (ActionGroup)anAction;
            }
        });
        return editor2;
    }

    @NotNull
    public final TermSize calculateTerminalSize(@NotNull Dimension componentSize, @NotNull Dimension charSize) {
        Intrinsics.checkNotNullParameter((Object)componentSize, (String)"componentSize");
        Intrinsics.checkNotNullParameter((Object)charSize, (String)"charSize");
        int width = componentSize.width / charSize.width;
        int height = componentSize.height / charSize.height;
        return this.ensureTermMinimumSize(new TermSize(width, height));
    }

    private final TermSize ensureTermMinimumSize(TermSize size) {
        return new TermSize(Math.max(5, size.getColumns()), Math.max(2, size.getRows()));
    }

    @RequiresEdt(generateAssertion=false)
    @NotNull
    public final CompletableFuture<Unit> awaitComponentLayout(@NotNull Component component, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Dimension size = component.getSize();
        if (size.width > 0 || size.height > 0) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Unit)");
            return completableFuture;
        }
        if (!UIUtil.isShowing((Component)component, (boolean)false)) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("component should be showing"));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(IllegalStat\u2026nent should be showing\"))");
            return completableFuture;
        }
        CompletableFuture<Unit> result2 = new CompletableFuture<Unit>();
        long startNano = System.nanoTime();
        ComponentAdapter resizeListener2 = new ComponentAdapter(startNano, result2){
            final /* synthetic */ long $startNano;
            final /* synthetic */ CompletableFuture<Unit> $result;
            {
                this.$startNano = $startNano;
                this.$result = $result;
            }

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (TerminalUiUtils.access$getLOG$p().isDebugEnabled()) {
                    TerminalUiUtils.access$getLOG$p().info("Terminal component layout took " + TimeoutUtil.getDurationMillis((long)this.$startNano) + "ms");
                }
                this.$result.complete(Unit.INSTANCE);
            }
        };
        component.addComponentListener(resizeListener2);
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        alarm.addRequest(() -> TerminalUiUtils.awaitComponentLayout$lambda$2(result2), 2000, ModalityState.stateForComponent((Component)component));
        Disposer.register((Disposable)((Disposable)alarm), () -> TerminalUiUtils.awaitComponentLayout$lambda$4(result2, component));
        result2.whenComplete((arg_0, arg_1) -> TerminalUiUtils.awaitComponentLayout$lambda$5((Function2)new Function2<Unit, Throwable, Unit>(alarm, component, resizeListener2){
            final /* synthetic */ Alarm $alarm;
            final /* synthetic */ Component $component;
            final /* synthetic */ ComponentAdapter $resizeListener;
            {
                this.$alarm = $alarm;
                this.$component = $component;
                this.$resizeListener = $resizeListener;
                super(2);
            }

            public final void invoke(Unit unit, Throwable throwable) {
                Disposer.dispose((Disposable)((Disposable)this.$alarm));
                this.$component.removeComponentListener(this.$resizeListener);
            }
        }, arg_0, arg_1));
        return result2;
    }

    private static final void awaitComponentLayout$lambda$2(CompletableFuture $result) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        $result.completeExceptionally(new IllegalStateException("Terminal component layout is timed out (>2000ms)"));
    }

    private static final void awaitComponentLayout$lambda$4$lambda$3(CompletableFuture $result) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        $result.completeExceptionally(new IllegalStateException("parent disposed"));
    }

    private static final void awaitComponentLayout$lambda$4(CompletableFuture $result, Component $component) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        if (!$result.isDone()) {
            ApplicationManager.getApplication().invokeLater(() -> TerminalUiUtils.awaitComponentLayout$lambda$4$lambda$3($result), ModalityState.stateForComponent((Component)$component));
        }
    }

    private static final void awaitComponentLayout$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalUiUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }
}

