/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.search;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.ui.JediTermSearchComponent;
import com.jediterm.terminal.ui.JediTermSearchComponentListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\u0006\u0010\u001f\u001a\u00020 J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/terminal/search/TerminalSearchSession;", "Lcom/intellij/find/SearchSession;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "terminalWidget", "Lcom/intellij/terminal/JBTerminalWidget;", "(Lcom/intellij/terminal/JBTerminalWidget;)V", "findModel", "Lcom/intellij/find/FindModel;", "hasMatches", "", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "searchComponentWrapper", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "terminalSearchComponent", "Lorg/jetbrains/plugins/terminal/search/TerminalSearchSession$MySearchComponent;", "close", "", "createFindModel", "createSearchComponent", "getComponent", "getData", "", "dataId", "", "getFindModel", "getTerminalSearchComponent", "Lcom/jediterm/terminal/ui/JediTermSearchComponent;", "searchBackward", "searchForward", "MySearchComponent", "intellij.terminal"})
public final class TerminalSearchSession
implements SearchSession,
DataProvider {
    @NotNull
    private final JBTerminalWidget terminalWidget;
    @NotNull
    private final SearchReplaceComponent searchComponent;
    @NotNull
    private final FindModel findModel;
    private boolean hasMatches;
    @NotNull
    private final MySearchComponent terminalSearchComponent;
    @NotNull
    private final BorderLayoutPanel searchComponentWrapper;

    public TerminalSearchSession(@NotNull JBTerminalWidget terminalWidget) {
        Intrinsics.checkNotNullParameter((Object)terminalWidget, (String)"terminalWidget");
        this.terminalWidget = terminalWidget;
        this.searchComponent = this.createSearchComponent();
        this.findModel = this.createFindModel();
        this.terminalSearchComponent = new MySearchComponent();
        this.searchComponentWrapper = new BorderLayoutPanel(){

            public void requestFocus() {
                IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)searchComponent.getSearchTextComponent(), false);
            }
        };
        this.searchComponentWrapper.addToCenter((Component)this.searchComponent);
        (this.searchComponentWrapper).setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)0, (int)1, (int)0, (int)1));
        String selectedText = this.terminalWidget.getSelectedText();
        if (selectedText != null) {
            this.searchComponent.getSearchTextComponent().setText(selectedText);
            this.searchComponent.getSearchTextComponent().selectAll();
        }
    }

    private final Project getProject() {
        Project project = this.terminalWidget.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"terminalWidget.project");
        return project;
    }

    @NotNull
    public final JediTermSearchComponent getTerminalSearchComponent() {
        return this.terminalSearchComponent;
    }

    private final FindModel createFindModel() {
        FindModel findModel;
        FindModel findModel2 = findModel = new FindModel();
        boolean bl = false;
        findModel2.copyFrom(FindManager.getInstance((Project)this.getProject()).getFindInFileModel());
        findModel2.addObserver(arg_0 -> TerminalSearchSession.createFindModel$lambda$1$lambda$0(this, findModel2, arg_0));
        return findModel;
    }

    @NotNull
    public FindModel getFindModel() {
        return this.findModel;
    }

    @NotNull
    public SearchReplaceComponent getComponent() {
        return this.searchComponent;
    }

    public boolean hasMatches() {
        return this.hasMatches;
    }

    public void searchForward() {
        this.terminalSearchComponent.getEventMulticaster().selectNextFindResult();
    }

    public void searchBackward() {
        this.terminalSearchComponent.getEventMulticaster().selectPrevFindResult();
    }

    public void close() {
        this.terminalSearchComponent.getEventMulticaster().hideSearchComponent();
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.terminalWidget.getTerminalPanel(), false);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return SearchSession.KEY.is(dataId) ? this : null;
    }

    private final SearchReplaceComponent createSearchComponent() {
        SearchReplaceComponent searchReplaceComponent;
        AnAction[] anActionArray = new AnAction[]{new ToggleMatchCase()};
        SearchReplaceComponent.Builder builder = SearchReplaceComponent.buildFor((Project)this.getProject(), (JComponent)((JComponent)this.terminalWidget.getTerminalPanel())).addExtraSearchActions(anActionArray);
        anActionArray = new AnAction[]{new StatusTextAction(), new PrevOccurrenceAction(), new NextOccurrenceAction()};
        SearchReplaceComponent searchReplaceComponent2 = builder.addPrimarySearchActions(anActionArray).withCloseAction(() -> TerminalSearchSession.createSearchComponent$lambda$2(this)).withDataProvider((DataProvider)this).build();
        Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent2, (String)"buildFor(project, termin\u2026ider(this)\n      .build()");
        SearchReplaceComponent it = searchReplaceComponent = searchReplaceComponent2;
        boolean bl = false;
        it.addListener(new SearchReplaceComponent.Listener(this){
            final /* synthetic */ TerminalSearchSession this$0;
            {
                this.this$0 = $receiver;
            }

            public void searchFieldDocumentChanged() {
                TerminalSearchSession.access$getFindModel$p(this.this$0).setStringToFind(TerminalSearchSession.access$getSearchComponent$p(this.this$0).getSearchTextComponent().getText());
            }

            public void replaceFieldDocumentChanged() {
            }

            public void multilineStateChanged() {
            }
        });
        return searchReplaceComponent;
    }

    private static final void createFindModel$lambda$1$lambda$0(TerminalSearchSession this$0, FindModel $findModel, FindModel it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$findModel, (String)"$findModel");
        this$0.terminalSearchComponent.getEventMulticaster().searchSettingsChanged($findModel.getStringToFind(), !$findModel.isCaseSensitive());
        FindUtil.updateFindInFileModel((Project)this$0.getProject(), (FindModel)$findModel, (boolean)false);
    }

    private static final void createSearchComponent$lambda$2(TerminalSearchSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.close();
    }

    public static final /* synthetic */ void access$setHasMatches$p(TerminalSearchSession $this, boolean bl) {
        $this.hasMatches = bl;
    }

    public static final /* synthetic */ FindModel access$getFindModel$p(TerminalSearchSession $this) {
        return $this.findModel;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/search/TerminalSearchSession$MySearchComponent;", "Lcom/jediterm/terminal/ui/JediTermSearchComponent;", "(Lorg/jetbrains/plugins/terminal/search/TerminalSearchSession;)V", "eventMulticaster", "Lcom/jediterm/terminal/ui/JediTermSearchComponentListener;", "getEventMulticaster", "()Lcom/jediterm/terminal/ui/JediTermSearchComponentListener;", "listeners", "", "addKeyListener", "", "listener", "Ljava/awt/event/KeyListener;", "addListener", "getComponent", "Ljavax/swing/JComponent;", "onResultUpdated", "results", "Lcom/jediterm/terminal/SubstringFinder$FindResult;", "intellij.terminal"})
    private final class MySearchComponent
    implements JediTermSearchComponent {
        @NotNull
        private final List<JediTermSearchComponentListener> listeners = new CopyOnWriteArrayList();
        @NotNull
        private final JediTermSearchComponentListener eventMulticaster = new JediTermSearchComponentListener(this){
            final /* synthetic */ MySearchComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void searchSettingsChanged(@NotNull String textToFind, boolean ignoreCase) {
                Intrinsics.checkNotNullParameter((Object)textToFind, (String)"textToFind");
                for (JediTermSearchComponentListener listener : MySearchComponent.access$getListeners$p(this.this$0)) {
                    listener.searchSettingsChanged(textToFind, ignoreCase);
                }
            }

            public void hideSearchComponent() {
                for (JediTermSearchComponentListener listener : MySearchComponent.access$getListeners$p(this.this$0)) {
                    listener.hideSearchComponent();
                }
            }

            public void selectNextFindResult() {
                for (JediTermSearchComponentListener listener : MySearchComponent.access$getListeners$p(this.this$0)) {
                    listener.selectNextFindResult();
                }
            }

            public void selectPrevFindResult() {
                for (JediTermSearchComponentListener listener : MySearchComponent.access$getListeners$p(this.this$0)) {
                    listener.selectPrevFindResult();
                }
            }
        };

        @NotNull
        public JComponent getComponent() {
            return (JComponent)TerminalSearchSession.this.searchComponentWrapper;
        }

        public void addListener(@NotNull JediTermSearchComponentListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.listeners.add(listener);
        }

        public void addKeyListener(@NotNull KeyListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            TerminalSearchSession.this.searchComponent.getSearchTextComponent().addKeyListener(listener);
        }

        /*
         * Unable to fully structure code
         */
        public void onResultUpdated(@Nullable SubstringFinder.FindResult results) {
            if (results == null) ** GOTO lbl-1000
            v0 = results.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"results.items");
            if (((Collection)v0).isEmpty() == false) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            TerminalSearchSession.access$setHasMatches$p(TerminalSearchSession.this, v1);
            if (results == null) {
                TerminalSearchSession.access$getSearchComponent$p(TerminalSearchSession.this).setRegularBackground();
                TerminalSearchSession.access$getSearchComponent$p(TerminalSearchSession.this).setStatusText("");
            } else if (results.getItems().isEmpty()) {
                TerminalSearchSession.access$getSearchComponent$p(TerminalSearchSession.this).setNotFoundBackground();
                var2_2 = new Object[]{results.getItems().size()};
                TerminalSearchSession.access$getSearchComponent$p(TerminalSearchSession.this).setStatusText(ApplicationBundle.message((String)"editorsearch.matches", (Object[])var2_2));
            } else {
                TerminalSearchSession.access$getSearchComponent$p(TerminalSearchSession.this).setRegularBackground();
                var2_3 = new Object[]{results.selectedItem().getIndex(), results.getItems().size()};
                TerminalSearchSession.access$getSearchComponent$p(TerminalSearchSession.this).setStatusText(ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])var2_3));
            }
        }

        @NotNull
        public final JediTermSearchComponentListener getEventMulticaster() {
            return this.eventMulticaster;
        }

        public static final /* synthetic */ List access$getListeners$p(MySearchComponent $this) {
            return $this.listeners;
        }
    }
}

