/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;

public class XMLWriter {
    private PrintWriter writer;

    public XMLWriter(Writer writer) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public XMLWriter(OutputStream outputStream) {
        this.writer = new PrintWriter(outputStream);
    }

    protected void finalize() throws Throwable {
        this.writer = null;
        super.finalize();
    }

    public void write(IXMLElement iXMLElement) throws IOException {
        this.write(iXMLElement, false, 0, true);
    }

    public void write(IXMLElement iXMLElement, boolean bl) throws IOException {
        this.write(iXMLElement, bl, 0, true);
    }

    public void write(IXMLElement iXMLElement, boolean bl, int n) throws IOException {
        this.write(iXMLElement, bl, n, true);
    }

    public void write(IXMLElement iXMLElement, boolean bl, int n, boolean bl2) throws IOException {
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                this.writer.print(' ');
                ++n2;
            }
        }
        if (iXMLElement.getName() == null) {
            if (iXMLElement.getContent() != null) {
                if (bl) {
                    this.writeEncoded(iXMLElement.getContent().trim());
                    this.writer.println();
                } else {
                    this.writeEncoded(iXMLElement.getContent());
                }
            }
        } else {
            Object object;
            Object object2;
            this.writer.print('<');
            this.writer.print(iXMLElement.getFullName());
            Vector<Object> vector = new Vector<Object>();
            if (iXMLElement.getNamespace() != null) {
                if (iXMLElement.getName().equals(iXMLElement.getFullName())) {
                    this.writer.print(" xmlns=\"" + iXMLElement.getNamespace() + '\"');
                } else {
                    object2 = iXMLElement.getFullName();
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf(58));
                    vector.addElement(object2);
                    this.writer.print(" xmlns:" + (String)object2);
                    this.writer.print("=\"" + iXMLElement.getNamespace() + "\"");
                }
            }
            object2 = iXMLElement.enumerateAttributeNames();
            while (object2.hasMoreElements()) {
                String string2;
                String string3;
                object = (String)object2.nextElement();
                int n3 = ((String)object).indexOf(58);
                if (n3 < 0 || (string3 = iXMLElement.getAttributeNamespace((String)object)) == null || vector.contains(string2 = ((String)object).substring(0, n3))) continue;
                this.writer.print(" xmlns:" + string2);
                this.writer.print("=\"" + string3 + '\"');
                vector.addElement(string2);
            }
            object2 = iXMLElement.enumerateAttributeNames();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                String string4 = iXMLElement.getAttribute((String)object, null);
                this.writer.print(" " + (String)object + "=\"");
                this.writeEncoded(string4);
                this.writer.print('\"');
            }
            if (iXMLElement.getContent() != null && iXMLElement.getContent().length() > 0) {
                this.writer.print('>');
                this.writeEncoded(iXMLElement.getContent());
                this.writer.print("</" + iXMLElement.getFullName() + '>');
                if (bl) {
                    this.writer.println();
                }
            } else if (iXMLElement.hasChildren() || !bl2) {
                this.writer.print('>');
                if (bl) {
                    this.writer.println();
                }
                object2 = iXMLElement.enumerateChildren();
                while (object2.hasMoreElements()) {
                    object = (IXMLElement)object2.nextElement();
                    this.write((IXMLElement)object, bl, n + 4, bl2);
                }
                if (bl) {
                    int n4 = 0;
                    while (n4 < n) {
                        this.writer.print(' ');
                        ++n4;
                    }
                }
                this.writer.print("</" + iXMLElement.getFullName() + ">");
                if (bl) {
                    this.writer.println();
                }
            } else {
                this.writer.print("/>");
                if (bl) {
                    this.writer.println();
                }
            }
        }
        this.writer.flush();
    }

    private void writeEncoded(String string2) {
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            switch (c) {
                case '\n': {
                    this.writer.print(c);
                    break;
                }
                case '<': {
                    this.writer.print("&lt;");
                    break;
                }
                case '>': {
                    this.writer.print("&gt;");
                    break;
                }
                case '&': {
                    this.writer.print("&amp;");
                    break;
                }
                case '\'': {
                    this.writer.print("&apos;");
                    break;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        this.writer.print("&#x");
                        this.writer.print(Integer.toString(c, 16));
                        this.writer.print(';');
                        break;
                    }
                    this.writer.print(c);
                }
            }
            ++n;
        }
    }
}

